/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.reqparser;

import de.uni_freiburg.informatik.ultimate.core.lib.models.ObjectContainer;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.DefaultLocation;
import de.uni_freiburg.informatik.ultimate.core.model.ISource;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.srparse.Durations;
import de.uni_freiburg.informatik.ultimate.lib.srparse.ReqParserResult;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.DeclarationPattern;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternBuilder;
import de.uni_freiburg.informatik.ultimate.lib.srparse.pattern.PatternType;
import de.uni_freiburg.informatik.ultimate.reqparser.Activator;
import de.uni_freiburg.informatik.ultimate.reqparser.ReqParserResultUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class ReqParser
implements ISource {
    private ILogger mLogger;
    private final List<String> mFileNames = new ArrayList<String>();
    private IUltimateServiceProvider mServices;
    private ReqParserResultUtil mReporter;

    public void init() {
    }

    public String getPluginName() {
        return "ReqParser";
    }

    public String getPluginID() {
        return Activator.PLUGIN_ID;
    }

    public File[] parseable(File[] fileArray) {
        List<File> list = Arrays.stream(fileArray).filter(this::parseable).collect(Collectors.toList());
        return list.toArray(new File[list.size()]);
    }

    public boolean parseable(File file) {
        return file.getName().endsWith(".req");
    }

    public IElement parseAST(File[] fileArray) throws Exception {
        Object object;
        ArrayList arrayList = new ArrayList();
        ArrayList<Durations> arrayList2 = new ArrayList<Durations>();
        File[] fileArray2 = fileArray;
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            object = fileArray2[n2];
            String string = ((File)object).getAbsolutePath();
            this.mLogger.info((Object)("Parsing file " + string));
            try {
                ReqParserResult reqParserResult = de.uni_freiburg.informatik.ultimate.lib.srparse.ReqParser.parseFile((ILogger)this.mLogger, (String)string);
                arrayList2.add(reqParserResult.getDurations());
                List list = reqParserResult.getPatterns();
                List list2 = list.stream().filter(Objects::nonNull).collect(Collectors.toList());
                if (list2.size() != list.size()) {
                    int n3 = 0;
                    PatternType patternType = null;
                    StringBuilder stringBuilder = new StringBuilder();
                    for (PatternType patternType2 : list) {
                        if (patternType2 == null) {
                            stringBuilder.append(n3).append(' ');
                            if (patternType == null) {
                                stringBuilder.append("(at the beginning)");
                            } else {
                                stringBuilder.append("(after ").append(patternType.getId()).append("),");
                            }
                        } else {
                            patternType = patternType2;
                        }
                        ++n3;
                    }
                    this.mReporter.unexpectedParserFailure(string, String.format("%s of %s patterns could not be parsed, positions %s", list.size() - list2.size(), list.size(), stringBuilder.deleteCharAt(stringBuilder.length() - 1)));
                }
                arrayList.addAll(list2);
            }
            catch (Exception exception) {
                this.mReporter.unexpectedParserFailure(string, String.format("%s: %s", exception.getClass().getSimpleName(), exception.getMessage()));
                throw exception;
            }
            ++n2;
        }
        if (this.mReporter.isAlreadyAborted()) {
            return null;
        }
        this.logPatternSize(arrayList, "in total");
        object = this.unify(arrayList);
        this.logPatternSize((List<PatternType<?>>)object, "after unification");
        List<PatternType<?>> list = this.normalizeDurations((List<PatternType<?>>)object, new Durations().merge(arrayList2));
        return new ObjectContainer(list);
    }

    private List<PatternType<?>> normalizeDurations(List<PatternType<?>> list, Durations durations) {
        this.mLogger.info("Scaling all durations to integer by multiplying with %s", new Object[]{durations.computeScalingFactor()});
        return list.stream().map(patternType -> PatternBuilder.normalize((PatternType)patternType, (Durations)durations)).collect(Collectors.toList());
    }

    private void logPatternSize(List<PatternType<?>> list, String string) {
        long l = list.stream().filter(patternType -> !(patternType instanceof DeclarationPattern)).count();
        if (string == null) {
            this.mLogger.info((Object)String.format("%s requirements (%s non-initialization)", list.size(), l));
        } else {
            this.mLogger.info((Object)String.format("%s requirements (%s non-initialization) %s", list.size(), l, string));
        }
    }

    private List<PatternType<?>> unify(List<PatternType<?>> list) {
        ArrayList arrayList = new ArrayList();
        List list2 = list.stream().filter(DeclarationPattern.class::isInstance).map(DeclarationPattern.class::cast).collect(Collectors.toList());
        UnionFind unionFind = this.createUnionFind(list2);
        this.checkTypeConflicts(unionFind.getAllRepresentatives());
        arrayList.addAll(this.merge(unionFind));
        List list3 = list.stream().filter(patternType -> patternType != null && !(patternType instanceof DeclarationPattern)).collect(Collectors.toList());
        if (list3.isEmpty()) {
            return arrayList;
        }
        UnionFind unionFind2 = this.createUnionFind(list3);
        arrayList.addAll(this.merge(unionFind2));
        return arrayList;
    }

    private void checkTypeConflicts(Collection<DeclarationPattern> collection) {
        HashMap<String, DeclarationPattern> hashMap = new HashMap<String, DeclarationPattern>();
        for (DeclarationPattern declarationPattern : collection) {
            DeclarationPattern declarationPattern2 = hashMap.put(declarationPattern.getId(), declarationPattern);
            if (declarationPattern2 == null || Objects.equals(declarationPattern.getType(), declarationPattern2.getType())) continue;
            this.mReporter.unsupportedSyntaxError((ILocation)new DummyLocation(), String.format("The initialization patterns %s and %s have conflicting types: %s vs. %s", declarationPattern.getId(), declarationPattern2.getId(), declarationPattern.getType(), declarationPattern2.getType()));
        }
    }

    private List<PatternType<?>> merge(UnionFind<? extends PatternType<?>> unionFind) {
        ArrayList arrayList = new ArrayList();
        for (Set set : unionFind.getAllEquivalenceClasses()) {
            if (set.size() == 1) {
                arrayList.addAll(set);
                continue;
            }
            this.mReporter.mergedRequirements(set);
            arrayList.add(ReqParser.merge(set));
        }
        return arrayList;
    }

    private static PatternType<?> merge(Set<? extends PatternType<?>> set) {
        assert (set != null && set.size() > 1);
        StringBuilder stringBuilder = new StringBuilder();
        Iterator<PatternType<?>> iterator = set.iterator();
        PatternType<?> patternType = iterator.next();
        Class<?> clazz = patternType.getClass();
        stringBuilder.append(patternType.getId());
        while (iterator.hasNext()) {
            patternType = iterator.next();
            if (clazz != patternType.getClass()) {
                throw new AssertionError((Object)"Patterns with different types are assumed to be equivalent");
            }
            stringBuilder.append('_').append(patternType.getId());
        }
        return patternType.rename(stringBuilder.toString());
    }

    private <T extends PatternType<?>> UnionFind<T> createUnionFind(List<T> list) {
        UnionFind unionFind = new UnionFind();
        for (PatternType patternType : list) {
            PatternType patternType2 = (PatternType)unionFind.findAndConstructEquivalenceClassIfNeeded((Object)patternType);
            if (patternType2 == patternType) continue;
            this.mReporter.mergedRequirements(new PatternType[]{patternType, patternType2});
        }
        return unionFind;
    }

    public String[] getFileTypes() {
        return new String[]{".req"};
    }

    public ModelType getOutputDefinition() {
        try {
            return new ModelType(this.getPluginID(), ModelType.Type.OTHER, this.mFileNames);
        }
        catch (Exception exception) {
            this.mLogger.fatal((Object)("syntax error: " + exception.getMessage()));
            return null;
        }
    }

    public void setServices(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iUltimateServiceProvider.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mReporter = new ReqParserResultUtil(this.mLogger, this.mServices);
    }

    public void finish() {
    }

    public IPreferenceInitializer getPreferences() {
        return null;
    }

    private static final class DummyLocation
    extends DefaultLocation {
        private static final long serialVersionUID = 1L;

        public DummyLocation() {
            super("", -1, 0, 0, 0);
        }
    }
}

