/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.rewriteArrays;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class EqualitySupportingInvariantAnalysis {
    private final Set<Doubleton<Term>> mAllDoubletons;
    private final ManagedScript mScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final Set<Doubleton<Term>> mDistinctDoubletons = new HashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mEqualDoubletons = new HashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mUnknownDoubletons = new HashSet<Doubleton<Term>>();
    private final UnmodifiableTransFormula mOriginalStem;
    private final UnmodifiableTransFormula mOriginalLoop;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtStart;
    private final Set<IProgramNonOldVar> mModifiableGlobalsAtHonda;

    public EqualitySupportingInvariantAnalysis(Set<Doubleton<Term>> set, IIcfgSymbolTable iIcfgSymbolTable, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, Set<IProgramNonOldVar> set2) {
        this.mSymbolTable = iIcfgSymbolTable;
        this.mScript = managedScript;
        this.mOriginalStem = unmodifiableTransFormula;
        this.mOriginalLoop = unmodifiableTransFormula2;
        this.mModifiableGlobalsAtStart = Collections.emptySet();
        this.mModifiableGlobalsAtHonda = set2;
        this.mAllDoubletons = set;
        this.mScript.getScript().echo(new QuotedObject("starting equality analysis for array indices of a lasso"));
        for (Doubleton<Term> doubleton : this.mAllDoubletons) {
            boolean bl = this.isInVariant(doubleton, true);
            if (bl) {
                this.addEqualDoubleton(doubleton);
                continue;
            }
            boolean bl2 = this.isInVariant(doubleton, false);
            if (bl2) {
                this.addDistinctDoubleton(doubleton);
                continue;
            }
            this.addUnknownDoubleton(doubleton);
        }
        this.mScript.getScript().echo(new QuotedObject("finished equality analysis for array indices of a lasso"));
    }

    private void addDistinctDoubleton(Doubleton<Term> doubleton) {
        this.mDistinctDoubletons.add(doubleton);
    }

    private void addEqualDoubleton(Doubleton<Term> doubleton) {
        this.mEqualDoubletons.add(doubleton);
    }

    private void addUnknownDoubleton(Doubleton<Term> doubleton) {
        this.mUnknownDoubletons.add(doubleton);
    }

    private boolean isInVariant(Doubleton<Term> doubleton, boolean bl) {
        Term term = bl ? EqualityAnalysisResult.equalTerm((Script)this.mScript.getScript(), doubleton) : EqualityAnalysisResult.notEqualTerm((Script)this.mScript.getScript(), doubleton);
        TermVarsFuns termVarsFuns = TermVarsFuns.computeTermVarsFuns((Term)term, (ManagedScript)this.mScript, (IIcfgSymbolTable)this.mSymbolTable);
        BasicPredicate basicPredicate = new BasicPredicate(0, termVarsFuns.getFormula(), termVarsFuns.getVars(), termVarsFuns.getFuns(), termVarsFuns.getClosedFormula());
        Set set = Collections.emptySet();
        BasicPredicate basicPredicate2 = new BasicPredicate(0, this.mScript.getScript().term("true", new Term[0]), set, Collections.emptySet(), this.mScript.getScript().term("true", new Term[0]));
        Script.LBool lBool = PredicateUtils.isInductiveHelper((Script)this.mScript.getScript(), (IPredicate)basicPredicate2, (IPredicate)basicPredicate, (UnmodifiableTransFormula)this.mOriginalStem, this.mModifiableGlobalsAtStart, this.mModifiableGlobalsAtHonda);
        if (lBool == Script.LBool.UNSAT) {
            Script.LBool lBool2 = PredicateUtils.isInductiveHelper((Script)this.mScript.getScript(), (IPredicate)basicPredicate, (IPredicate)basicPredicate, (UnmodifiableTransFormula)this.mOriginalLoop, this.mModifiableGlobalsAtHonda, this.mModifiableGlobalsAtHonda);
            return lBool2 == Script.LBool.UNSAT;
        }
        return false;
    }

    public EqualityAnalysisResult getEqualityAnalysisResult() {
        return new EqualityAnalysisResult(Collections.unmodifiableSet(this.mEqualDoubletons), Collections.unmodifiableSet(this.mDistinctDoubletons), Collections.unmodifiableSet(this.mUnknownDoubletons));
    }
}

