/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.csv;

import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProvider;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderTransformer;
import de.uni_freiburg.informatik.ultimate.util.csv.SimpleCsvProvider;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;

public class CsvProviderRowFilter<T>
implements ICsvProviderTransformer<T> {
    private final Predicate<Pair<List<T>, List<String>>> mPredicate;

    public CsvProviderRowFilter(Predicate<Pair<List<T>, List<String>>> predicate) {
        this.mPredicate = predicate;
    }

    @Override
    public ICsvProvider<T> transform(ICsvProvider<T> iCsvProvider) {
        List<String> list = iCsvProvider.getColumnTitles();
        SimpleCsvProvider<T> simpleCsvProvider = new SimpleCsvProvider<T>(list);
        int n = 0;
        while (n < iCsvProvider.getRowHeaders().size()) {
            List<T> list2 = iCsvProvider.getRow(n);
            if (this.mPredicate.test(new Pair<List<T>, List<String>>(list2, list))) {
                simpleCsvProvider.addRow(list2);
            }
            ++n;
        }
        return simpleCsvProvider;
    }

    public static class AllEntriesNonNullFilter<T>
    implements Predicate<Pair<List<T>, List<String>>> {
        @Override
        public boolean test(Pair<List<T>, List<String>> pair) {
            List<T> list = pair.getFirst();
            for (T t : list) {
                if (t != null && !"null".equals(t.toString())) continue;
                return false;
            }
            return true;
        }
    }

    public static class AllowedValuesRowFilter<T>
    implements Predicate<Pair<List<T>, List<String>>> {
        private final Map<String, Set<T>> mColumn2allowedValues;

        public AllowedValuesRowFilter(Map<String, Set<T>> map) {
            this.mColumn2allowedValues = map;
        }

        @Override
        public boolean test(Pair<List<T>, List<String>> pair) {
            List<T> list = pair.getFirst();
            int n = pair.getSecond().size();
            Iterator<String> iterator = pair.getSecond().iterator();
            int n2 = 0;
            while (n2 < n) {
                String string = iterator.next();
                Set<T> set = this.mColumn2allowedValues.get(string);
                if (set != null && this.isForbiddenValue(list.get(n2), set)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }

        protected boolean isForbiddenValue(T t, Set<T> set) {
            return !set.contains(t);
        }
    }

    public static class DisallowedValuesRowFilter<T>
    extends AllowedValuesRowFilter<T> {
        public DisallowedValuesRowFilter(Map<String, Set<T>> map) {
            super(map);
        }

        @Override
        protected boolean isForbiddenValue(T t, Set<T> set) {
            return !super.isForbiddenValue(t, set);
        }
    }
}

