/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;
import java.util.Set;
import java.util.function.Predicate;

public class StateBasedTransitionFilterPredicateProvider<LETTER, STATE> {
    protected final Set<STATE> mStates;
    private final Predicate<IncomingInternalTransition<LETTER, STATE>> mInternalPredecessorsPredicate;
    private final Predicate<IncomingCallTransition<LETTER, STATE>> mCallPredecessorPredicate;
    private final Predicate<OutgoingInternalTransition<LETTER, STATE>> mInternalSuccessorPredicate;
    private final Predicate<OutgoingCallTransition<LETTER, STATE>> mCallSuccessorPredicate;
    private final Predicate<IncomingReturnTransition<LETTER, STATE>> mReturnPredecessorPredicate;
    private final Predicate<OutgoingReturnTransition<LETTER, STATE>> mReturnSuccessorPredicate;
    private final Predicate<SummaryReturnTransition<LETTER, STATE>> mReturnSummaryPredicate;

    public StateBasedTransitionFilterPredicateProvider(Set<STATE> set) {
        this.mStates = set;
        this.mInternalPredecessorsPredicate = incomingInternalTransition -> this.mStates.contains(incomingInternalTransition.getPred());
        this.mCallPredecessorPredicate = incomingCallTransition -> this.mStates.contains(incomingCallTransition.getPred());
        this.mInternalSuccessorPredicate = outgoingInternalTransition -> this.mStates.contains(outgoingInternalTransition.getSucc());
        this.mCallSuccessorPredicate = outgoingCallTransition -> this.mStates.contains(outgoingCallTransition.getSucc());
        this.mReturnPredecessorPredicate = incomingReturnTransition -> this.mStates.contains(incomingReturnTransition.getLinPred()) && this.mStates.contains(incomingReturnTransition.getHierPred());
        this.mReturnSuccessorPredicate = outgoingReturnTransition -> this.mStates.contains(outgoingReturnTransition.getHierPred()) && this.mStates.contains(outgoingReturnTransition.getSucc());
        this.mReturnSummaryPredicate = summaryReturnTransition -> this.mStates.contains(summaryReturnTransition.getSucc()) && this.mStates.contains(summaryReturnTransition.getLinPred());
    }

    public Predicate<IncomingInternalTransition<LETTER, STATE>> getInternalPredecessorsPredicate() {
        return this.mInternalPredecessorsPredicate;
    }

    public Predicate<IncomingCallTransition<LETTER, STATE>> getCallPredecessorPredicate() {
        return this.mCallPredecessorPredicate;
    }

    public Predicate<OutgoingInternalTransition<LETTER, STATE>> getInternalSuccessorPredicate() {
        return this.mInternalSuccessorPredicate;
    }

    public Predicate<OutgoingCallTransition<LETTER, STATE>> getCallSuccessorPredicate() {
        return this.mCallSuccessorPredicate;
    }

    public Predicate<IncomingReturnTransition<LETTER, STATE>> getReturnPredecessorPredicate() {
        return this.mReturnPredecessorPredicate;
    }

    public Predicate<OutgoingReturnTransition<LETTER, STATE>> getReturnSuccessorPredicate() {
        return this.mReturnSuccessorPredicate;
    }

    public Predicate<SummaryReturnTransition<LETTER, STATE>> getReturnSummaryPredicate() {
        return this.mReturnSummaryPredicate;
    }
}

