/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.witnessprinter.graphml;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ConditionAnnotation;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IExplicitEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.core.model.models.IMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.AtomicTraceElement;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslatedCFG;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IBacktranslationValueProvider;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessEdge;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessNode;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GeneratedWitnessNodeEdgeFactory;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.GraphMLBaseWitnessGenerator;
import de.uni_freiburg.informatik.ultimate.witnessprinter.graphml.UltimateGraphMLWriter;
import de.uni_freiburg.informatik.ultimate.witnessprinter.preferences.PreferenceInitializer;
import edu.uci.ics.jung.graph.DirectedOrderedSparseMultigraph;
import edu.uci.ics.jung.graph.Hypergraph;
import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringEscapeUtils;

public class GraphMLCorrectnessWitnessGenerator<TTE, TE>
extends GraphMLBaseWitnessGenerator<TTE, TE> {
    private static final String[] ACSL_SUBSTRING = new String[]{"\\old", "\\result", "exists", "forall", "\\at"};
    private final ILogger mLogger;
    private final IBacktranslationValueProvider<TTE, TE> mStringProvider;
    private final IBacktranslatedCFG<?, TTE> mTranslatedCFG;
    private final boolean mIsACSLForbidden;

    public GraphMLCorrectnessWitnessGenerator(IBacktranslatedCFG<?, TTE> iBacktranslatedCFG, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        super(iUltimateServiceProvider);
        this.mLogger = iLogger;
        this.mStringProvider = iBacktranslatedCFG.getBacktranslationValueProvider();
        this.mTranslatedCFG = iBacktranslatedCFG;
        this.mIsACSLForbidden = PreferenceInitializer.getPreferences(iUltimateServiceProvider).getBoolean("Do not use ACSL");
    }

    @Override
    public String makeGraphMLString() {
        UltimateGraphMLWriter ultimateGraphMLWriter = new UltimateGraphMLWriter();
        ultimateGraphMLWriter.setEdgeIDs(generatedWitnessEdge -> generatedWitnessEdge.getName());
        ultimateGraphMLWriter.setVertexIDs(generatedWitnessNode -> generatedWitnessNode.getName());
        this.addCanonicalWitnessGraphData(ultimateGraphMLWriter, "correctness_witness", this.mTranslatedCFG.getFilename());
        this.addEdgeData(ultimateGraphMLWriter, "sourcecode", null, generatedWitnessEdge -> StringEscapeUtils.escapeXml10((String)generatedWitnessEdge.getSourceCode()));
        this.addEdgeData(ultimateGraphMLWriter, "assumption", null, generatedWitnessEdge -> StringEscapeUtils.escapeXml10((String)generatedWitnessEdge.getAssumption()));
        this.addEdgeData(ultimateGraphMLWriter, "tokens", null, generatedWitnessEdge -> null);
        this.addEdgeData(ultimateGraphMLWriter, "startline", null, generatedWitnessEdge -> generatedWitnessEdge.getStartLineNumber());
        this.addEdgeData(ultimateGraphMLWriter, "endline", null, generatedWitnessEdge -> generatedWitnessEdge.getEndLineNumber());
        this.addEdgeData(ultimateGraphMLWriter, "originfile", StringEscapeUtils.escapeXml10((String)this.mTranslatedCFG.getFilename()), generatedWitnessEdge -> null);
        this.addEdgeData(ultimateGraphMLWriter, "enterFunction", null, generatedWitnessEdge -> null);
        this.addEdgeData(ultimateGraphMLWriter, "returnFrom", null, generatedWitnessEdge -> null);
        this.addEdgeData(ultimateGraphMLWriter, "enterLoopHead", "false", generatedWitnessEdge -> generatedWitnessEdge.isEnteringLoopHead());
        this.addVertexData(ultimateGraphMLWriter, "nodetype", "path", generatedWitnessNode -> null);
        this.addVertexData(ultimateGraphMLWriter, "entry", "false", generatedWitnessNode -> generatedWitnessNode.isEntry() ? "true" : null);
        this.addVertexData(ultimateGraphMLWriter, "violation", "false", generatedWitnessNode -> generatedWitnessNode.isError() ? "true" : null);
        this.addVertexData(ultimateGraphMLWriter, "invariant", "true", generatedWitnessNode -> StringEscapeUtils.escapeXml10((String)generatedWitnessNode.getInvariant()));
        Hypergraph<GeneratedWitnessNode, GeneratedWitnessEdge<TTE, TE>> hypergraph = this.getGraph();
        StringWriter stringWriter = new StringWriter();
        try {
            ultimateGraphMLWriter.save(hypergraph, stringWriter);
        }
        catch (IOException iOException) {
            this.mLogger.error((Object)("Could not save witness graph: " + iOException.getMessage()));
        }
        try {
            stringWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (IOException iOException) {
                this.mLogger.error((Object)("Could not close witness writer: " + iOException.getMessage()));
            }
        }
    }

    private Hypergraph<GeneratedWitnessNode, GeneratedWitnessEdge<TTE, TE>> getGraph() {
        List list = this.mTranslatedCFG.getCFGs();
        if (list.size() != 1) {
            throw new UnsupportedOperationException("Cannot generate correctness witnesses in library mode");
        }
        IExplicitEdgesMultigraph iExplicitEdgesMultigraph = (IExplicitEdgesMultigraph)list.get(0);
        ArrayDeque<IExplicitEdgesMultigraph> arrayDeque = new ArrayDeque<IExplicitEdgesMultigraph>();
        HashMap hashMap = new HashMap();
        DirectedOrderedSparseMultigraph directedOrderedSparseMultigraph = new DirectedOrderedSparseMultigraph();
        GeneratedWitnessNodeEdgeFactory<TTE, TE> generatedWitnessNodeEdgeFactory = new GeneratedWitnessNodeEdgeFactory<TTE, TE>(this.mStringProvider);
        hashMap.put(iExplicitEdgesMultigraph, this.annotateInvariant(iExplicitEdgesMultigraph, generatedWitnessNodeEdgeFactory.createInitialWitnessNode()));
        HashSet<IMultigraphEdge> hashSet = new HashSet<IMultigraphEdge>();
        arrayDeque.add(iExplicitEdgesMultigraph);
        while (!arrayDeque.isEmpty()) {
            IExplicitEdgesMultigraph iExplicitEdgesMultigraph2 = (IExplicitEdgesMultigraph)arrayDeque.remove();
            GeneratedWitnessNode generatedWitnessNode = this.getWitnessNode(iExplicitEdgesMultigraph2, this.mStringProvider, generatedWitnessNodeEdgeFactory, hashMap);
            for (IMultigraphEdge iMultigraphEdge : iExplicitEdgesMultigraph2.getOutgoingEdges()) {
                GeneratedWitnessEdge<TTE, TE> generatedWitnessEdge;
                if (!hashSet.add(iMultigraphEdge)) continue;
                Object object = iMultigraphEdge.getLabel();
                GeneratedWitnessNode generatedWitnessNode2 = this.getWitnessNode(iMultigraphEdge.getTarget(), this.mStringProvider, generatedWitnessNodeEdgeFactory, hashMap);
                if (object == null) {
                    generatedWitnessEdge = generatedWitnessNodeEdgeFactory.createDummyWitnessEdge();
                } else {
                    ConditionAnnotation conditionAnnotation = ConditionAnnotation.getAnnotation((IElement)iMultigraphEdge);
                    AtomicTraceElement.StepInfo stepInfo = conditionAnnotation != null ? (conditionAnnotation.isNegated() ? AtomicTraceElement.StepInfo.CONDITION_EVAL_FALSE : AtomicTraceElement.StepInfo.CONDITION_EVAL_TRUE) : AtomicTraceElement.StepInfo.NONE;
                    boolean bl = generatedWitnessNode2.getInvariant() != null;
                    generatedWitnessEdge = generatedWitnessNodeEdgeFactory.createWitnessEdge(new AtomicTraceElement.AtomicTraceElementBuilder().setStepAndElement(object).setStepInfo(new AtomicTraceElement.StepInfo[]{stepInfo}).build(), bl);
                }
                directedOrderedSparseMultigraph.addEdge(generatedWitnessEdge, (Object)generatedWitnessNode, (Object)generatedWitnessNode2);
                arrayDeque.add(iMultigraphEdge.getTarget());
            }
        }
        return directedOrderedSparseMultigraph;
    }

    private GeneratedWitnessNode getWitnessNode(IExplicitEdgesMultigraph<?, ?, ?, TTE, ?> iExplicitEdgesMultigraph, IBacktranslationValueProvider<TTE, TE> iBacktranslationValueProvider, GeneratedWitnessNodeEdgeFactory<TTE, TE> generatedWitnessNodeEdgeFactory, Map<IExplicitEdgesMultigraph<?, ?, ?, TTE, ?>, GeneratedWitnessNode> map) {
        GeneratedWitnessNode generatedWitnessNode = map.get(iExplicitEdgesMultigraph);
        if (generatedWitnessNode != null) {
            return generatedWitnessNode;
        }
        generatedWitnessNode = this.annotateInvariant(iExplicitEdgesMultigraph, generatedWitnessNodeEdgeFactory.createWitnessNode());
        map.put(iExplicitEdgesMultigraph, generatedWitnessNode);
        return generatedWitnessNode;
    }

    private GeneratedWitnessNode annotateInvariant(IExplicitEdgesMultigraph<?, ?, ?, TTE, ?> iExplicitEdgesMultigraph, GeneratedWitnessNode generatedWitnessNode) {
        String string = this.filterInvariant(iExplicitEdgesMultigraph);
        if (string != null) {
            generatedWitnessNode.setInvariant(string);
        }
        return generatedWitnessNode;
    }

    private String filterInvariant(IExplicitEdgesMultigraph<?, ?, ?, TTE, ?> iExplicitEdgesMultigraph) {
        if (iExplicitEdgesMultigraph == null) {
            return null;
        }
        if (iExplicitEdgesMultigraph.getLabel() == null) {
            return null;
        }
        String string = iExplicitEdgesMultigraph.getLabel().toString();
        if (this.mIsACSLForbidden && string != null) {
            if (Arrays.stream(ACSL_SUBSTRING).anyMatch(string::contains)) {
                this.mLogger.warn((Object)("Not writing invariant because ACSL is forbidden: " + string));
                return null;
            }
        }
        return string;
    }
}

