/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.IDoubleDeckerAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.ProductNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.oldapi.IOpWithDelayedDeadEndRemoval;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.proofs.IProofProducer;
import de.uni_freiburg.informatik.ultimate.lib.proofs.PrePostConditionSpecification;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationComposer;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationExtractor;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationFragments;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationPositions;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareProofSettings;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.IFloydHoareAnnotation;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeTracker;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class NwaHoareProofProducer<L extends IAction>
implements IProofProducer<INestedWordAutomaton<L, IPredicate>, IFloydHoareAnnotation<IPredicate>> {
    private final IUltimateServiceProvider mServices;
    private final INestedWordAutomaton<L, IPredicate> mProgram;
    private final PrePostConditionSpecification<IPredicate> mSpecification;
    private final CfgSmtToolkit mCsToolkit;
    private final PredicateFactory mPredicateFactory;
    private final HoareProofSettings mPrefs;
    private final HoareAnnotationFragments<L> mHaf;
    private INestedWordAutomaton<L, IPredicate> mFinalAbstraction;
    private IFloydHoareAnnotation<IPredicate> mProof;
    private final Statistics mStatistics;

    public NwaHoareProofProducer(IUltimateServiceProvider iUltimateServiceProvider, INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory, HoareProofSettings hoareProofSettings, Set<IPredicate> set) {
        this.mServices = iUltimateServiceProvider;
        this.mProgram = iNestedWordAutomaton;
        this.mCsToolkit = cfgSmtToolkit;
        this.mPredicateFactory = predicateFactory;
        this.mPrefs = hoareProofSettings;
        this.mHaf = new HoareAnnotationFragments(set);
        Map<IPredicate, IPredicate> map = NwaHoareProofProducer.computeInitialStatesAndPreconditions(iNestedWordAutomaton, cfgSmtToolkit, predicateFactory);
        this.mSpecification = new PrePostConditionSpecification<IPredicate>(map, arg_0 -> iNestedWordAutomaton.isFinal(arg_0), predicateFactory.or(new IPredicate[0]));
        this.mStatistics = new Statistics();
    }

    private static Map<IPredicate, IPredicate> computeInitialStatesAndPreconditions(INestedWordAutomaton<?, IPredicate> iNestedWordAutomaton, CfgSmtToolkit cfgSmtToolkit, PredicateFactory predicateFactory) {
        HashMap<IPredicate, IPredicate> hashMap = new HashMap<IPredicate, IPredicate>();
        for (IPredicate iPredicate : iNestedWordAutomaton.getInitialStates()) {
            IcfgLocation icfgLocation = PredicateUtils.getSingleLocation((IPredicate)iPredicate);
            IPredicate iPredicate2 = PredicateUtils.computeInitialPredicateForProcedure((ModifiableGlobalsTable)cfgSmtToolkit.getModifiableGlobalsTable(), (Script)cfgSmtToolkit.getManagedScript().getScript(), (String)icfgLocation.getProcedure(), (BasicPredicateFactory)predicateFactory);
            hashMap.put(iPredicate, iPredicate2);
        }
        return hashMap;
    }

    public static Set<IPredicate> computeHoareStates(IIcfg<? extends IcfgLocation> iIcfg, INestedWordAutomaton<?, IPredicate> iNestedWordAutomaton, HoareAnnotationPositions hoareAnnotationPositions) {
        Set<? extends IcfgLocation> set = hoareAnnotationPositions.getLocations(iIcfg);
        return iNestedWordAutomaton.getStates().stream().filter(iPredicate -> PredicateUtils.streamLocations((IPredicate)iPredicate).anyMatch(set::contains)).collect(Collectors.toSet());
    }

    @Override
    public INestedWordAutomaton<L, IPredicate> getProgram() {
        return this.mProgram;
    }

    @Override
    public boolean isReadyToComputeProof() {
        return this.mFinalAbstraction != null;
    }

    @Override
    public IFloydHoareAnnotation<IPredicate> getOrComputeProof() {
        if (this.mProof == null) {
            this.mProof = this.computeProof();
        }
        return this.mProof;
    }

    private IFloydHoareAnnotation<IPredicate> computeProof() {
        return this.mStatistics.measureProofComputation(() -> {
            HoareAnnotationComposer hoareAnnotationComposer = this.computeHoareAnnotationComposer();
            IFloydHoareAnnotation<IPredicate> iFloydHoareAnnotation = hoareAnnotationComposer.extractAnnotation(this.mSpecification);
            this.mStatistics.reportHoareStatistics(hoareAnnotationComposer);
            return iFloydHoareAnnotation;
        });
    }

    private HoareAnnotationComposer computeHoareAnnotationComposer() {
        if (this.mCsToolkit.getManagedScript().isLocked()) {
            throw new AssertionError((Object)"ManagedScript must not be locked at the beginning of Hoare annotation computation");
        }
        new HoareAnnotationExtractor<L>(this.mServices, this.mFinalAbstraction, this.mHaf);
        return new HoareAnnotationComposer(this.mCsToolkit, this.mPredicateFactory, this.mHaf, this.mServices);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public boolean exploitSigmaStarConcatOfIa() {
        return false;
    }

    public void updateOnIntersection(Map<IPredicate, Map<IPredicate, ProductNwa.ProductState>> map, IDoubleDeckerAutomaton<L, IPredicate> iDoubleDeckerAutomaton) {
        this.mHaf.updateOnIntersection(map, (INwaOutgoingLetterAndTransitionProvider<L, IPredicate>)iDoubleDeckerAutomaton);
    }

    public void addDeadEndDoubleDeckers(IOpWithDelayedDeadEndRemoval<L, IPredicate> iOpWithDelayedDeadEndRemoval) {
        this.mHaf.addDeadEndDoubleDeckers(iOpWithDelayedDeadEndRemoval);
    }

    public void updateOnMinimization(Map<IPredicate, IPredicate> map, INwaOutgoingLetterAndTransitionProvider<L, IPredicate> iNwaOutgoingLetterAndTransitionProvider) {
        this.mHaf.updateOnMinimization(map, iNwaOutgoingLetterAndTransitionProvider);
    }

    public void finish(INestedWordAutomaton<L, IPredicate> iNestedWordAutomaton) {
        this.mFinalAbstraction = iNestedWordAutomaton;
    }

    private static final class Statistics
    extends AbstractStatisticsDataProvider {
        private final TimeTracker mProofTime = new TimeTracker();

        public Statistics() {
            this.declare("Hoare annotation time", () -> this.mProofTime, KeyType.TT_TIMER);
        }

        private <T> T measureProofComputation(Supplier<T> supplier) {
            return (T)this.mProofTime.measure(supplier);
        }

        private void reportHoareStatistics(HoareAnnotationComposer hoareAnnotationComposer) {
            this.forward("Hoare annotation statistics", hoareAnnotationComposer::getHoareAnnotationStatisticsGenerator);
        }
    }
}

