/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.cfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.ModernAnnotations;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.IAnnotations;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import java.util.Map;
import java.util.function.IntPredicate;

public final class AtomicBlockInfo
extends ModernAnnotations {
    private static final long serialVersionUID = -8370873908642083605L;
    private static final int START_DELTA = 1;
    private static final int END_DELTA = -1;
    private final int mDelta;

    private AtomicBlockInfo(int n) {
        this.mDelta = n;
    }

    public IAnnotations merge(IAnnotations iAnnotations) {
        return super.merge(iAnnotations);
    }

    public Map<String, Object> getAnnotationsAsMap() {
        return Map.of("delta", this.mDelta);
    }

    public String toString() {
        return AtomicBlockInfo.class.getSimpleName() + "(" + (this.mDelta > 0 ? "+" : "") + this.mDelta + ")";
    }

    public static boolean isStartOfAtomicBlock(IIcfgTransition<?> iIcfgTransition) {
        return AtomicBlockInfo.hasAnnotatedDelta(iIcfgTransition, n -> n > 0);
    }

    public static boolean isEndOfAtomicBlock(IIcfgTransition<?> iIcfgTransition) {
        return AtomicBlockInfo.hasAnnotatedDelta(iIcfgTransition, n -> n < 0);
    }

    public static boolean isCompleteAtomicBlock(IIcfgTransition<?> iIcfgTransition) {
        return AtomicBlockInfo.hasAnnotatedDelta(iIcfgTransition, n -> n == 0);
    }

    public static void addBeginAnnotation(IIcfgTransition<?> iIcfgTransition) {
        AtomicBlockInfo.addAnnotation(iIcfgTransition, 1);
    }

    public static void addEndAnnotation(IIcfgTransition<?> iIcfgTransition) {
        AtomicBlockInfo.addAnnotation(iIcfgTransition, -1);
    }

    public static void addCompleteAnnotation(IIcfgTransition<?> iIcfgTransition) {
        AtomicBlockInfo.addAnnotation(iIcfgTransition, 0);
    }

    public static void removeAnnotation(IIcfgTransition<?> iIcfgTransition) {
        iIcfgTransition.getPayload().getAnnotations().remove(AtomicBlockInfo.class.getName());
    }

    static boolean hasAnnotation(IIcfgTransition<?> iIcfgTransition) {
        return ModelUtils.getAnnotation(iIcfgTransition, AtomicBlockInfo.class) != null;
    }

    static int getAnnotatedDelta(IIcfgTransition<?> iIcfgTransition) {
        AtomicBlockInfo atomicBlockInfo = (AtomicBlockInfo)ModelUtils.getAnnotation(iIcfgTransition, AtomicBlockInfo.class);
        if (atomicBlockInfo != null) {
            return atomicBlockInfo.mDelta;
        }
        return 0;
    }

    static void mergeSequential(IIcfgTransition<?> iIcfgTransition, IIcfgTransition<?> iIcfgTransition2, IIcfgTransition<?> iIcfgTransition3) {
        AtomicBlockInfo atomicBlockInfo = AtomicBlockInfo.mergeSequential((AtomicBlockInfo)ModelUtils.getAnnotation(iIcfgTransition, AtomicBlockInfo.class), (AtomicBlockInfo)ModelUtils.getAnnotation(iIcfgTransition2, AtomicBlockInfo.class));
        if (atomicBlockInfo != null) {
            AtomicBlockInfo.addAnnotation(iIcfgTransition3, atomicBlockInfo);
        }
    }

    private static AtomicBlockInfo mergeSequential(AtomicBlockInfo atomicBlockInfo, AtomicBlockInfo atomicBlockInfo2) {
        if (atomicBlockInfo == null) {
            return atomicBlockInfo2;
        }
        if (atomicBlockInfo2 == null) {
            return atomicBlockInfo;
        }
        return new AtomicBlockInfo(atomicBlockInfo.mDelta + atomicBlockInfo2.mDelta);
    }

    private static boolean hasAnnotatedDelta(IIcfgTransition<?> iIcfgTransition, IntPredicate intPredicate) {
        AtomicBlockInfo atomicBlockInfo = (AtomicBlockInfo)ModelUtils.getAnnotation(iIcfgTransition, AtomicBlockInfo.class);
        if (atomicBlockInfo != null) {
            return intPredicate.test(atomicBlockInfo.mDelta);
        }
        return false;
    }

    static void addAnnotation(IIcfgTransition<?> iIcfgTransition, int n) {
        AtomicBlockInfo.addAnnotation(iIcfgTransition, new AtomicBlockInfo(n));
    }

    private static void addAnnotation(IIcfgTransition<?> iIcfgTransition, AtomicBlockInfo atomicBlockInfo) {
        AtomicBlockInfo atomicBlockInfo2 = (AtomicBlockInfo)ModelUtils.getAnnotation(iIcfgTransition, AtomicBlockInfo.class);
        if (atomicBlockInfo2 != null) {
            throw new UnsupportedOperationException("Incompatible atomic block annotation: " + atomicBlockInfo2.mDelta + " and " + atomicBlockInfo.mDelta);
        }
        iIcfgTransition.getPayload().getAnnotations().put(AtomicBlockInfo.class.getName(), atomicBlockInfo);
    }
}

