/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransitionPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.preprocessors.LassoPreprocessor;
import de.uni_freiburg.informatik.ultimate.lassoranker.variables.LassoUnderConstruction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import java.util.Collection;
import java.util.Collections;

public class StemAndLoopPreprocessor
extends LassoPreprocessor {
    private final ManagedScript mMgdScript;
    private final TransitionPreprocessor mTransitionPreprocessor;

    public StemAndLoopPreprocessor(ManagedScript managedScript, TransitionPreprocessor transitionPreprocessor) {
        this.mMgdScript = managedScript;
        this.mTransitionPreprocessor = transitionPreprocessor;
    }

    @Override
    public String getDescription() {
        return this.mTransitionPreprocessor.getDescription();
    }

    @Override
    public String getName() {
        return this.mTransitionPreprocessor.getClass().getSimpleName();
    }

    @Override
    public Collection<LassoUnderConstruction> process(LassoUnderConstruction lassoUnderConstruction) throws TermException {
        ModifiableTransFormula modifiableTransFormula = this.mTransitionPreprocessor.process(this.mMgdScript, lassoUnderConstruction.getStem());
        assert (this.mTransitionPreprocessor.checkSoundness(this.mMgdScript.getScript(), lassoUnderConstruction.getStem(), modifiableTransFormula)) : "Soundness check failed for preprocessor " + this.getClass().getSimpleName();
        ModifiableTransFormula modifiableTransFormula2 = this.mTransitionPreprocessor.process(this.mMgdScript, lassoUnderConstruction.getLoop());
        LassoUnderConstruction lassoUnderConstruction2 = new LassoUnderConstruction(modifiableTransFormula, modifiableTransFormula2);
        assert (this.mTransitionPreprocessor.checkSoundness(this.mMgdScript.getScript(), lassoUnderConstruction.getLoop(), modifiableTransFormula2)) : "Soundness check failed for preprocessor " + this.getClass().getSimpleName();
        return Collections.singleton(lassoUnderConstruction2);
    }
}

