/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Check;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.LoopEntryAnnotation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.MergedLocation;
import de.uni_freiburg.informatik.ultimate.core.lib.models.annotation.Overapprox;
import de.uni_freiburg.informatik.ultimate.core.lib.results.AnnotationCheckResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Spec;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.BasicInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsFuns;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.AcyclicSubgraphMerger;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class InvariantChecker {
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private final IIcfg<IcfgLocation> mIcfg;
    private final LoopLocations mLoopLocations;
    private IResultWithSeverity mResultForUltimateUser;

    public InvariantChecker(IUltimateServiceProvider iUltimateServiceProvider, IIcfg<IcfgLocation> iIcfg, boolean bl) {
        Object object;
        Object object22;
        Object object3;
        Object object42;
        this.mServices = iUltimateServiceProvider;
        this.mLogger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
        this.mIcfg = iIcfg;
        this.mLoopLocations = InvariantChecker.extractLoopLocations(this.mIcfg);
        if (!bl && !this.mLoopLocations.getLoopLocWithoutInvariant().isEmpty()) {
            ArrayList<AnnotationCheckResult.CategorizedProgramPoint> arrayList = new ArrayList<AnnotationCheckResult.CategorizedProgramPoint>();
            for (IcfgLocation map : this.mLoopLocations.getLoopLocWithoutInvariant()) {
                arrayList.add(this.constructCategorizedProgramPoint(map));
            }
            this.mResultForUltimateUser = new AnnotationCheckResult(Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), arrayList);
            return;
        }
        this.mLogger.info((Object)("Found " + this.mIcfg.getLoopLocations().size() + " loops."));
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        Map map = iIcfg.getProcedureErrorNodes();
        for (Map.Entry object52 : map.entrySet()) {
            for (Object object42 : (Set)object52.getValue()) {
                object3 = this.mLoopLocations.getLoopErrorLoc2errorEdge().get(object42);
                if (object3 != null) {
                    hashSet.add((IcfgLocation)object3.getSource());
                    continue;
                }
                hashSet.add((IcfgLocation)object42);
            }
        }
        List<TwoPointSubgraphDefinition> list = this.findTwoPointSubgraphDefinitions(iIcfg, this.mLoopLocations, hashSet);
        String string = this.message24(list);
        this.mLogger.info((Object)("Will check " + (String)string));
        object42 = new HashSet();
        HashSet hashSet2 = new HashSet();
        object3 = new HashMap();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (Object object22 : list) {
            Object object5;
            AcyclicSubgraphMerger acyclicSubgraphMerger;
            object = ((TwoPointSubgraphDefinition)object22).getStartLocation();
            IcfgLocation icfgLocation = ((TwoPointSubgraphDefinition)object22).getEndLocation();
            IcfgEdge icfgEdge2 = this.mLoopLocations.getLoopLoc2errorEdge().get(object);
            if (!((TwoPointSubgraphDefinition)object22).getSubgraphEdges().contains(icfgEdge2)) {
                icfgEdge2 = null;
            }
            try {
                acyclicSubgraphMerger = new AcyclicSubgraphMerger(this.mServices, this.mIcfg, ((TwoPointSubgraphDefinition)object22).getSubgraphEdges(), ((TwoPointSubgraphDefinition)object22).getStartLocation(), icfgEdge2, Collections.singleton(((TwoPointSubgraphDefinition)object22).getEndLocation()));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (illegalArgumentException.getMessage().equals("Subgraph has a cycle")) {
                    object5 = this.constructCategorizedProgramPoint(((TwoPointSubgraphDefinition)object22).getStartLocation());
                    AnnotationCheckResult.CategorizedProgramPoint categorizedProgramPoint = this.constructCategorizedProgramPoint(((TwoPointSubgraphDefinition)object22).getEndLocation());
                    arrayList.add(new Pair(object5, (Object)categorizedProgramPoint));
                    continue;
                }
                throw new AssertionError();
            }
            UnmodifiableTransFormula illegalArgumentException = acyclicSubgraphMerger.getTransFormula(icfgLocation);
            Objects.requireNonNull(illegalArgumentException);
            object5 = this.doCheck((IcfgLocation)object, illegalArgumentException, icfgLocation);
            switch (((EdgeCheckResult)object5).getValidity()) {
                case INVALID: {
                    if (((TwoPointSubgraphDefinition)object22).getSubgraphEdges().stream().anyMatch(icfgEdge -> Overapprox.getAnnotation((IElement)icfgEdge) != null)) {
                        hashSet2.add(object22);
                        break;
                    }
                    object3.put(object22, object5);
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)"failed to perfrom check");
                }
                case UNKNOWN: {
                    hashSet2.add(object22);
                    break;
                }
                case VALID: {
                    object42.add(object22);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("illegal result: " + String.valueOf(((EdgeCheckResult)object5).getValidity())));
                }
            }
        }
        object22 = this.twoPointSubgraphsToSegments((Set<TwoPointSubgraphDefinition>)object42);
        List<AnnotationCheckResult.LoopFreeSegment<IcfgEdge>> list2 = this.twoPointSubgraphsToSegments(hashSet2);
        object = this.twoPointSubgraphsToSegments((Map<TwoPointSubgraphDefinition, EdgeCheckResult>)object3);
        this.mResultForUltimateUser = new AnnotationCheckResult(Activator.PLUGIN_ID, this.mServices.getBacktranslationService(), (List)object22, (List)list2, (List)object, arrayList, Collections.emptyList());
    }

    private String icfgLocationsToListOfLineNumbers(List<IcfgLocation> list) {
        TreeSet treeSet = list.stream().map(icfgLocation -> this.guessLocation((IcfgLocation)icfgLocation).getStartLine()).collect(Collectors.toCollection(TreeSet::new));
        String string = treeSet.stream().map(n -> "line " + n.toString()).collect(Collectors.joining(", "));
        return string;
    }

    private List<AnnotationCheckResult.LoopFreeSegmentWithStatePair<IcfgEdge, Term>> twoPointSubgraphsToSegments(Map<TwoPointSubgraphDefinition, EdgeCheckResult> map) {
        ArrayList<AnnotationCheckResult.LoopFreeSegmentWithStatePair<IcfgEdge, Term>> arrayList = new ArrayList<AnnotationCheckResult.LoopFreeSegmentWithStatePair<IcfgEdge, Term>>();
        for (Map.Entry<TwoPointSubgraphDefinition, EdgeCheckResult> entry : map.entrySet()) {
            arrayList.add(this.twoPointSubgraphToSegment(entry.getKey(), entry.getValue()));
        }
        return arrayList;
    }

    private AnnotationCheckResult.LoopFreeSegmentWithStatePair<IcfgEdge, Term> twoPointSubgraphToSegment(TwoPointSubgraphDefinition twoPointSubgraphDefinition, EdgeCheckResult edgeCheckResult) {
        AnnotationCheckResult.CategorizedProgramPoint categorizedProgramPoint = this.constructCategorizedProgramPoint(twoPointSubgraphDefinition.getStartLocation());
        AnnotationCheckResult.CategorizedProgramPoint categorizedProgramPoint2 = this.constructCategorizedProgramPoint(twoPointSubgraphDefinition.getEndLocation());
        AnnotationCheckResult.LoopFreeSegmentWithStatePair loopFreeSegmentWithStatePair = new AnnotationCheckResult.LoopFreeSegmentWithStatePair(categorizedProgramPoint, categorizedProgramPoint2, edgeCheckResult.getCtxPre(), edgeCheckResult.getCtxPost());
        return loopFreeSegmentWithStatePair;
    }

    private AnnotationCheckResult.CategorizedProgramPoint constructCategorizedProgramPoint(IcfgLocation icfgLocation) {
        ILocation iLocation = this.guessLocation(icfgLocation);
        ProgramPointType programPointType = this.classify(icfgLocation);
        return switch (programPointType) {
            case ProgramPointType.ENTRY -> new AnnotationCheckResult.ProcedureEntry(iLocation, icfgLocation.getProcedure());
            case ProgramPointType.ERROR_LOC -> {
                Check var5_5 = Check.getAnnotation((IElement)icfgLocation);
                if (var5_5 == null) {
                    throw new AssertionError((Object)("program point " + String.valueOf(icfgLocation) + " is error location but does not have a Check"));
                }
                if (var5_5.getSpec().equals(Collections.singleton(Spec.POST_CONDITION))) {
                    yield new AnnotationCheckResult.ProcedureExit(iLocation, icfgLocation.getProcedure());
                }
                yield new AnnotationCheckResult.CheckPoint(iLocation, Check.getAnnotation((IElement)icfgLocation));
            }
            case ProgramPointType.LOOP_HEAD -> new AnnotationCheckResult.LoopHead(iLocation);
            case ProgramPointType.LOOP_INVARIANT_ERROR_LOC -> new AnnotationCheckResult.LoopHead(iLocation);
            case ProgramPointType.LABEL -> new AnnotationCheckResult.Label(iLocation);
            default -> throw new AssertionError((Object)("unable to categorize program point " + String.valueOf(icfgLocation)));
        };
    }

    private List<AnnotationCheckResult.LoopFreeSegment<IcfgEdge>> twoPointSubgraphsToSegments(Set<TwoPointSubgraphDefinition> set) {
        ArrayList<AnnotationCheckResult.LoopFreeSegment<IcfgEdge>> arrayList = new ArrayList<AnnotationCheckResult.LoopFreeSegment<IcfgEdge>>();
        for (TwoPointSubgraphDefinition twoPointSubgraphDefinition : set) {
            arrayList.add(this.twoPointSubgraphToSegment(twoPointSubgraphDefinition));
        }
        return arrayList;
    }

    private AnnotationCheckResult.LoopFreeSegment<IcfgEdge> twoPointSubgraphToSegment(TwoPointSubgraphDefinition twoPointSubgraphDefinition) {
        AnnotationCheckResult.CategorizedProgramPoint categorizedProgramPoint = this.constructCategorizedProgramPoint(twoPointSubgraphDefinition.getStartLocation());
        AnnotationCheckResult.CategorizedProgramPoint categorizedProgramPoint2 = this.constructCategorizedProgramPoint(twoPointSubgraphDefinition.getEndLocation());
        AnnotationCheckResult.LoopFreeSegment loopFreeSegment = new AnnotationCheckResult.LoopFreeSegment(categorizedProgramPoint, categorizedProgramPoint2);
        return loopFreeSegment;
    }

    private ILocation guessLocation(IcfgLocation icfgLocation) {
        ProgramPointType programPointType = this.classify(icfgLocation);
        IcfgEdge icfgEdge = switch (programPointType) {
            case ProgramPointType.ENTRY, ProgramPointType.LOOP_HEAD, ProgramPointType.LABEL -> (IcfgEdge)icfgLocation.getOutgoingEdges().get(0);
            case ProgramPointType.ERROR_LOC, ProgramPointType.LOOP_INVARIANT_ERROR_LOC -> (IcfgEdge)icfgLocation.getIncomingEdges().get(0);
            case ProgramPointType.UNKNOWN -> throw new AssertionError((Object)"unable to determine type of program point");
            default -> throw new MatchException(null, null);
        };
        ILocation iLocation = ILocation.getAnnotation((IElement)icfgEdge);
        ILocation iLocation2 = iLocation instanceof MergedLocation ? (ILocation)((MergedLocation)iLocation).getOriginLocations().get(0) : iLocation;
        return iLocation2;
    }

    private String message24(List<TwoPointSubgraphDefinition> list) {
        HashRelation hashRelation = new HashRelation();
        for (TwoPointSubgraphDefinition twoPointSubgraphDefinition : list) {
            ProgramPointType programPointType = this.classify(twoPointSubgraphDefinition.getStartLocation());
            ProgramPointType programPointType2 = this.classify(twoPointSubgraphDefinition.getEndLocation());
            hashRelation.addPair((Object)new Pair((Object)programPointType, (Object)programPointType2), (Object)twoPointSubgraphDefinition);
        }
        boolean bl = true;
        StringBuilder stringBuilder = new StringBuilder();
        for (ProgramPointType programPointType : hashRelation.getDomain()) {
            int n = hashRelation.numberOfPairsWithGivenDomainElement((Object)programPointType);
            if (!bl) {
                stringBuilder.append(", ");
            }
            stringBuilder.append(n + " loop-free subgraphs from " + InvariantChecker.getNiceSubgraphPointDescription((ProgramPointType)((Object)programPointType.getFirst())) + " to " + InvariantChecker.getNiceSubgraphPointDescription((ProgramPointType)((Object)programPointType.getSecond())));
            bl = false;
        }
        return stringBuilder.toString();
    }

    private List<TwoPointSubgraphDefinition> findTwoPointSubgraphDefinitions(IIcfg<IcfgLocation> iIcfg, LoopLocations loopLocations, Set<IcfgLocation> set) {
        ArrayList<TwoPointSubgraphDefinition> arrayList = new ArrayList<TwoPointSubgraphDefinition>();
        for (IcfgLocation icfgLocation : set) {
            arrayList.addAll(this.findSubgraphGivenEndLocation(icfgLocation, loopLocations, iIcfg));
        }
        return arrayList;
    }

    private static LoopLocations extractLoopLocations(IIcfg<IcfgLocation> iIcfg) {
        HashMap<IcfgLocation, IcfgEdge> hashMap = new HashMap<IcfgLocation, IcfgEdge>();
        HashMap<IcfgLocation, IcfgEdge> hashMap2 = new HashMap<IcfgLocation, IcfgEdge>();
        ArrayList<IcfgLocation> arrayList = new ArrayList<IcfgLocation>();
        ArrayList arrayList2 = new ArrayList(iIcfg.getLoopLocations());
        arrayList2.addAll(iIcfg.getLocationsOfInterest());
        for (IcfgLocation icfgLocation : arrayList2) {
            IcfgEdge icfgEdge = InvariantChecker.getErrorEdgeForLoopInvariant(icfgLocation);
            if (icfgEdge == null) {
                arrayList.add(icfgLocation);
                continue;
            }
            hashMap.put(icfgLocation, icfgEdge);
            hashMap2.put((IcfgLocation)icfgEdge.getTarget(), icfgEdge);
        }
        return new LoopLocations(hashMap, hashMap2, arrayList);
    }

    private List<TwoPointSubgraphDefinition> findSubgraphGivenEndLocation(IcfgLocation icfgLocation, LoopLocations loopLocations, IIcfg<IcfgLocation> iIcfg) {
        HashSet<IcfgLocation> hashSet = new HashSet<IcfgLocation>();
        HashSet<IcfgEdge> hashSet2 = new HashSet<IcfgEdge>();
        AbstractCollection abstractCollection = new ArrayDeque<IcfgEdge>();
        InvariantChecker.addIncomingEdgesToWorklistIfNotYetSeen(icfgLocation, abstractCollection, hashSet2);
        while (!((ArrayDeque)abstractCollection).isEmpty()) {
            IcfgEdge icfgEdge = ((ArrayDeque)abstractCollection).removeFirst();
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge.getSource();
            if (InvariantChecker.isEntryNode(iIcfg, icfgLocation2) || InvariantChecker.isLoopHead(iIcfg, icfgLocation2) || InvariantChecker.isLocationOfInterestNode(iIcfg, icfgLocation2)) {
                hashSet.add(icfgLocation2);
                continue;
            }
            InvariantChecker.addIncomingEdgesToWorklistIfNotYetSeen(icfgLocation2, abstractCollection, hashSet2);
        }
        abstractCollection = new ArrayList();
        for (IcfgLocation icfgLocation3 : hashSet) {
            TwoPointSubgraphDefinition twoPointSubgraphDefinition = InvariantChecker.extractSubgraphGivenStartAndEnd(icfgLocation3, icfgLocation, Collections.unmodifiableSet(hashSet2), loopLocations, iIcfg);
            if (loopLocations.getLoopLoc2errorEdge().containsKey(icfgLocation)) {
                IcfgEdge icfgEdge = loopLocations.getLoopLoc2errorEdge().get(icfgLocation);
                IcfgLocation icfgLocation4 = (IcfgLocation)icfgEdge.getTarget();
                if (twoPointSubgraphDefinition.getEndLocation() != icfgLocation4) {
                    throw new AssertionError((Object)"wrong error loc");
                }
            } else if (twoPointSubgraphDefinition.getEndLocation() != icfgLocation) {
                throw new AssertionError((Object)"wrong error loc");
            }
            this.mLogger.info((Object)this.message23(twoPointSubgraphDefinition));
            abstractCollection.add((TwoPointSubgraphDefinition)twoPointSubgraphDefinition);
        }
        return abstractCollection;
    }

    private static boolean isEntryNode(IIcfg<IcfgLocation> iIcfg, IcfgLocation icfgLocation) {
        return icfgLocation == iIcfg.getProcedureEntryNodes().get(icfgLocation.getProcedure());
    }

    private static boolean isLoopHead(IIcfg<IcfgLocation> iIcfg, IcfgLocation icfgLocation) {
        return iIcfg.getLoopLocations().contains(icfgLocation);
    }

    private static boolean isLocationOfInterestNode(IIcfg<IcfgLocation> iIcfg, IcfgLocation icfgLocation) {
        return iIcfg.getLocationsOfInterest().contains(icfgLocation);
    }

    private static void addIncomingEdgesToWorklistIfNotYetSeen(IcfgLocation icfgLocation, Deque<IcfgEdge> deque, Set<IcfgEdge> set) {
        for (IcfgEdge icfgEdge : icfgLocation.getIncomingEdges()) {
            InvariantChecker.addToWorklistIfNotYetSeen(icfgEdge, deque, set);
        }
    }

    private static void addToWorklistIfNotYetSeen(IcfgEdge icfgEdge, Deque<IcfgEdge> deque, Set<IcfgEdge> set) {
        if (icfgEdge instanceof IIcfgInternalTransition) {
            if (!set.contains(icfgEdge)) {
                set.add(icfgEdge);
                deque.add(icfgEdge);
            }
        } else if (!(icfgEdge instanceof IIcfgCallTransition) && !(icfgEdge instanceof IIcfgReturnTransition)) {
            throw new UnsupportedOperationException("Unsupported kind of edge " + icfgEdge.getClass().getSimpleName());
        }
    }

    private static TwoPointSubgraphDefinition extractSubgraphGivenStartAndEnd(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, Set<IcfgEdge> set, LoopLocations loopLocations, IIcfg<IcfgLocation> iIcfg) {
        IcfgEdge icfgEdge2;
        ArrayDeque<IcfgEdge> arrayDeque = new ArrayDeque<IcfgEdge>();
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        HashSet<IcfgLocation> hashSet2 = new HashSet<IcfgLocation>();
        for (IcfgEdge icfgEdge2 : icfgLocation.getOutgoingEdges()) {
            if (!set.contains(icfgEdge2)) continue;
            arrayDeque.add(icfgEdge2);
            hashSet.add(icfgEdge2);
        }
        while (!arrayDeque.isEmpty()) {
            icfgEdge2 = (IcfgEdge)arrayDeque.removeFirst();
            IcfgLocation icfgLocation3 = (IcfgLocation)icfgEdge2.getTarget();
            if (icfgLocation3 == icfgLocation2) {
                if (InvariantChecker.isLoopHead(iIcfg, icfgLocation3) || InvariantChecker.isLocationOfInterestNode(iIcfg, icfgLocation3)) {
                    IcfgEdge icfgEdge3 = loopLocations.getLoopLoc2errorEdge().get(icfgLocation3);
                    hashSet.add(icfgEdge3);
                    hashSet2.add((IcfgLocation)icfgEdge3.getTarget());
                    continue;
                }
                if (((Set)iIcfg.getProcedureErrorNodes().get(icfgLocation3.getProcedure())).contains(icfgLocation3)) {
                    hashSet2.add(icfgLocation3);
                    continue;
                }
                throw new AssertionError((Object)"unknown backwardStartLoc");
            }
            for (IcfgEdge icfgEdge3 : icfgLocation3.getOutgoingEdges()) {
                if (!set.contains(icfgEdge3) || hashSet.contains(icfgEdge3)) continue;
                hashSet.add(icfgEdge3);
                arrayDeque.add(icfgEdge3);
            }
        }
        assert (hashSet2.size() == 1);
        icfgEdge2 = (IcfgLocation)hashSet2.iterator().next();
        return new TwoPointSubgraphDefinition(icfgLocation, hashSet, (IcfgLocation)icfgEdge2);
    }

    private String message23(TwoPointSubgraphDefinition twoPointSubgraphDefinition) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Will check inductivity from ");
        stringBuilder.append((Object)this.classify(twoPointSubgraphDefinition.getStartLocation()));
        stringBuilder.append(" ");
        stringBuilder.append(twoPointSubgraphDefinition.getStartLocation());
        stringBuilder.append(" to ");
        stringBuilder.append((Object)this.classify(twoPointSubgraphDefinition.getEndLocation()));
        stringBuilder.append(" ");
        stringBuilder.append(twoPointSubgraphDefinition.getEndLocation());
        stringBuilder.append(". ");
        stringBuilder.append("Corresponding subgraph has " + twoPointSubgraphDefinition.getSubgraphEdges().size() + " edges.");
        return stringBuilder.toString();
    }

    ProgramPointType classify(IcfgLocation icfgLocation) {
        if (this.mIcfg.getLoopLocations().contains(icfgLocation)) {
            return ProgramPointType.LOOP_HEAD;
        }
        if (this.mLoopLocations.getLoopErrorLoc2errorEdge().containsKey(icfgLocation)) {
            return ProgramPointType.LOOP_INVARIANT_ERROR_LOC;
        }
        if (this.mIcfg.getLocationsOfInterest().contains(icfgLocation)) {
            return ProgramPointType.LABEL;
        }
        String string = icfgLocation.getProcedure();
        if (((IcfgLocation)this.mIcfg.getProcedureEntryNodes().get(string)).equals((Object)icfgLocation)) {
            return ProgramPointType.ENTRY;
        }
        if (((Set)this.mIcfg.getProcedureErrorNodes().get(string)).contains(icfgLocation)) {
            return ProgramPointType.ERROR_LOC;
        }
        return ProgramPointType.UNKNOWN;
    }

    private EdgeCheckResult doCheck(IcfgLocation icfgLocation, UnmodifiableTransFormula unmodifiableTransFormula, IcfgLocation icfgLocation2) {
        EdgeCheckResult edgeCheckResult;
        BasicPredicate basicPredicate;
        TermVarsFuns termVarsFuns;
        IncrementalHoareTripleChecker incrementalHoareTripleChecker = new IncrementalHoareTripleChecker(this.mIcfg.getCfgSmtToolkit(), true);
        PredicateFactory predicateFactory = new PredicateFactory(this.mServices, this.mIcfg.getCfgSmtToolkit().getManagedScript(), this.mIcfg.getCfgSmtToolkit().getSymbolTable());
        if (((IcfgLocation)this.mIcfg.getProcedureEntryNodes().get(icfgLocation.getProcedure())).equals((Object)icfgLocation)) {
            termVarsFuns = TraceCheckUtils.getOldVarsEquality((String)icfgLocation.getProcedure(), (ModifiableGlobalsTable)this.mIcfg.getCfgSmtToolkit().getModifiableGlobalsTable(), (ManagedScript)this.mIcfg.getCfgSmtToolkit().getManagedScript());
            basicPredicate = predicateFactory.newPredicate(termVarsFuns.getFormula());
        } else {
            basicPredicate = predicateFactory.newPredicate(this.mIcfg.getCfgSmtToolkit().getManagedScript().getScript().term("true", new Term[0]));
        }
        termVarsFuns = predicateFactory.newPredicate(this.mIcfg.getCfgSmtToolkit().getManagedScript().getScript().term("false", new Term[0]));
        IncrementalPlicationChecker.Validity validity = incrementalHoareTripleChecker.checkInternal((IPredicate)basicPredicate, (IInternalAction)new BasicInternalAction(icfgLocation.getProcedure(), icfgLocation2.getProcedure(), unmodifiableTransFormula), (IPredicate)termVarsFuns);
        switch (validity) {
            case INVALID: {
                IProgramExecution.ProgramState programState = incrementalHoareTripleChecker.getCounterexampleStatePrecond();
                IProgramExecution.ProgramState programState2 = incrementalHoareTripleChecker.getCounterexampleStatePostcond();
                edgeCheckResult = new EdgeCheckResult(validity, (IProgramExecution.ProgramState<Term>)programState, (IProgramExecution.ProgramState<Term>)programState2);
                break;
            }
            case NOT_CHECKED: {
                throw new AssertionError();
            }
            case UNKNOWN: {
                edgeCheckResult = new EdgeCheckResult(validity, null, null);
                this.mLogger.info((Object)"unknown inductivity: todo good error message");
                break;
            }
            case VALID: {
                edgeCheckResult = new EdgeCheckResult(validity, null, null);
                this.mLogger.info((Object)InvariantChecker.generateMessage(icfgLocation, icfgLocation2, true));
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        incrementalHoareTripleChecker.releaseLock();
        return edgeCheckResult;
    }

    private static String generateMessage(IcfgLocation icfgLocation, IcfgLocation icfgLocation2, boolean bl) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The annotation(s) from ");
        stringBuilder.append(InvariantChecker.getType(icfgLocation));
        stringBuilder.append(" ");
        stringBuilder.append(icfgLocation);
        stringBuilder.append(" to ");
        stringBuilder.append(InvariantChecker.getType(icfgLocation2));
        stringBuilder.append(" ");
        stringBuilder.append(icfgLocation2);
        stringBuilder.append(" is");
        if (!bl) {
            stringBuilder.append(" NOT");
        }
        stringBuilder.append(" inductive.");
        return stringBuilder.toString();
    }

    private static String getType(IcfgLocation icfgLocation) {
        if (InvariantChecker.hasInvariantAnnotation(icfgLocation)) {
            return "loop head";
        }
        if (InvariantChecker.isErrorLoc(icfgLocation)) {
            return "error location";
        }
        if (InvariantChecker.isLoopLoc(icfgLocation)) {
            return "loop head";
        }
        return "entry";
    }

    public static <E extends IIcfgTransition<IcfgLocation>> Set<E> collectAdjacentEdges(IIcfg<IcfgLocation> iIcfg, Set<IcfgLocation> set) {
        HashSet<IcfgEdge> hashSet = new HashSet<IcfgEdge>();
        for (IcfgLocation icfgLocation : set) {
            icfgLocation.getOutgoingEdges();
            for (IcfgEdge icfgEdge : icfgLocation.getOutgoingEdges()) {
                if (!set.contains(icfgEdge.getTarget())) continue;
                hashSet.add(icfgEdge);
            }
        }
        return hashSet;
    }

    private static void processForward(ArrayDeque<IcfgLocation> arrayDeque, Set<IcfgLocation> set, Set<IcfgLocation> set2, IcfgLocation icfgLocation, boolean bl) {
        set.add(icfgLocation);
        LoopEntryAnnotation loopEntryAnnotation = LoopEntryAnnotation.getAnnotation((IElement)icfgLocation);
        if (loopEntryAnnotation != null) {
            IcfgLocation icfgLocation2 = (IcfgLocation)InvariantChecker.getErrorEdgeForLoopInvariant(icfgLocation).getTarget();
            set.add(icfgLocation2);
            set2.add(icfgLocation2);
        } else {
            Check check = Check.getAnnotation((IElement)icfgLocation);
            if (bl && check != null) {
                set.add(icfgLocation);
                set2.add(icfgLocation);
            } else {
                set.add(icfgLocation);
                arrayDeque.add(icfgLocation);
            }
        }
    }

    private static IcfgEdge getErrorEdgeForLoopInvariant(IcfgLocation icfgLocation) {
        IcfgEdge icfgEdge = null;
        for (IcfgEdge icfgEdge2 : icfgLocation.getOutgoingEdges()) {
            IcfgLocation icfgLocation2 = (IcfgLocation)icfgEdge2.getTarget();
            if (!InvariantChecker.hasInvariantAnnotation(icfgLocation2)) continue;
            if (icfgEdge == null) {
                icfgEdge = icfgEdge2;
                continue;
            }
            throw new UnsupportedOperationException("several invariants");
        }
        return icfgEdge;
    }

    private static boolean hasInvariantAnnotation(IcfgLocation icfgLocation) {
        Check check = Check.getAnnotation((IElement)icfgLocation);
        if (check != null) {
            Set set = check.getSpec();
            return set.contains(Spec.INVARIANT) || set.contains(Spec.WITNESS_INVARIANT);
        }
        return false;
    }

    private static boolean isErrorLoc(IcfgLocation icfgLocation) {
        Check check = Check.getAnnotation((IElement)icfgLocation);
        return check != null;
    }

    private static boolean isLoopLoc(IcfgLocation icfgLocation) {
        LoopEntryAnnotation loopEntryAnnotation = LoopEntryAnnotation.getAnnotation((IElement)icfgLocation);
        return loopEntryAnnotation != null;
    }

    private static String getNiceSubgraphPointDescription(ProgramPointType programPointType) {
        return switch (programPointType) {
            case ProgramPointType.ENTRY -> "procedure entry";
            case ProgramPointType.ERROR_LOC -> "error location";
            case ProgramPointType.LOOP_HEAD -> "loop head";
            case ProgramPointType.LOOP_INVARIANT_ERROR_LOC -> "loop head";
            case ProgramPointType.LABEL -> "label";
            case ProgramPointType.UNKNOWN -> "unspecified location type";
            default -> throw new MatchException(null, null);
        };
    }

    public IResultWithSeverity getResultForUltimateUser() {
        return this.mResultForUltimateUser;
    }

    private static class EdgeCheckResult {
        private final IncrementalPlicationChecker.Validity mValidity;
        private final IProgramExecution.ProgramState<Term> mCtxPre;
        private final IProgramExecution.ProgramState<Term> mCtxPost;

        public EdgeCheckResult(IncrementalPlicationChecker.Validity validity, IProgramExecution.ProgramState<Term> programState, IProgramExecution.ProgramState<Term> programState2) {
            this.mValidity = validity;
            this.mCtxPre = programState;
            this.mCtxPost = programState2;
        }

        public IncrementalPlicationChecker.Validity getValidity() {
            return this.mValidity;
        }

        public IProgramExecution.ProgramState<Term> getCtxPre() {
            return this.mCtxPre;
        }

        public IProgramExecution.ProgramState<Term> getCtxPost() {
            return this.mCtxPost;
        }
    }

    private static class LoopLocations {
        public final Map<IcfgLocation, IcfgEdge> mLoopLoc2errorEdge;
        public final Map<IcfgLocation, IcfgEdge> mLoopErrorLoc2errorEdge;
        public final List<IcfgLocation> mLoopLocWithoutInvariant;

        public LoopLocations(Map<IcfgLocation, IcfgEdge> map, Map<IcfgLocation, IcfgEdge> map2, List<IcfgLocation> list) {
            this.mLoopLoc2errorEdge = map;
            this.mLoopErrorLoc2errorEdge = map2;
            this.mLoopLocWithoutInvariant = list;
        }

        public Map<IcfgLocation, IcfgEdge> getLoopLoc2errorEdge() {
            return this.mLoopLoc2errorEdge;
        }

        public Map<IcfgLocation, IcfgEdge> getLoopErrorLoc2errorEdge() {
            return this.mLoopErrorLoc2errorEdge;
        }

        public List<IcfgLocation> getLoopLocWithoutInvariant() {
            return this.mLoopLocWithoutInvariant;
        }
    }

    public static enum ProgramPointType {
        ENTRY,
        LOOP_HEAD,
        ERROR_LOC,
        UNKNOWN,
        LOOP_INVARIANT_ERROR_LOC,
        LABEL;

    }

    private static class TwoPointSubgraphDefinition {
        private final IcfgLocation mStartLocation;
        private final Set<IcfgEdge> mSubgraphEdges;
        private final IcfgLocation mEndLocation;

        public TwoPointSubgraphDefinition(IcfgLocation icfgLocation, Set<IcfgEdge> set, IcfgLocation icfgLocation2) {
            this.mStartLocation = icfgLocation;
            this.mSubgraphEdges = set;
            this.mEndLocation = icfgLocation2;
        }

        public IcfgLocation getStartLocation() {
            return this.mStartLocation;
        }

        public Set<IcfgEdge> getSubgraphEdges() {
            return this.mSubgraphEdges;
        }

        public IcfgLocation getEndLocation() {
            return this.mEndLocation;
        }
    }
}

