/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences;

import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmptyHeuristic;
import de.uni_freiburg.informatik.ultimate.automata.petrinet.unfolding.PetriNetUnfolder;
import de.uni_freiburg.informatik.ultimate.core.lib.preferences.UltimatePreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.BaseUltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.PreferenceType;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItem;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItemContainer;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.UltimatePreferenceItemGroup;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.LoopAccelerators;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.proofs.floydhoare.HoareAnnotationPositions;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SMTFeatureExtractionTermClassifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.solverbuilder.SolverBuilder;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderMode;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.PartialOrderReductionFacade;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.IndependenceSettings;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.partialorder.independence.SemanticIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.plugins.generator.rcfgbuilder.preferences.RcfgPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.TraceAbstractionStarter;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.errorabstraction.IErrorAutomatonBuilder;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.preferences.TAPreferences;
import java.util.Map;

public class TraceAbstractionPreferenceInitializer
extends UltimatePreferenceInitializer {
    public static final String LABEL_READ_INITIAL_PROOF_ASSERTIONS_FROM_FILE = "Read initial proof assertions from file if available";
    private static final boolean DEF_READ_INITIAL_PROOF_ASSERTIONS_FROM_FILE = false;
    public static final String LABEL_USERLIMIT_TRACE_HISTOGRAM = "Limit trace histogram size";
    private static final int DEF_USERLIMIT_TRACE_HISTOGRAM = 0;
    private static final String DESC_USERLIMIT_TRACE_HISTOGRAM = "Abort the analysis of either a single error location or the whole program if the trace histogram of the current counterexample is larger than this value. 0 disables this limit.";
    public static final String LABEL_USERLIMIT_TIME = "Limit analysis time";
    private static final int DEF_USERLIMIT_TIME = 0;
    private static final String DESC_USERLIMIT_TIME = "Abort the analysis of either a single error location or the whole program if more time than specified has elapsed. Time is specified in seconds. 0 disables this limit.";
    public static final String LABEL_USERLIMIT_PATH_PROGRAM = "Limit path program analysis attempts";
    private static final int DEF_USERLIMIT_PATH_PROGRAM = 0;
    private static final String DESC_USERLIMIT_PATH_PROGRAM = "Abort the analysis of either a single error location or the whole program if the same path program has been induced by spurious counterexamples more than the specified amount of times. 0 disables this limit.";
    public static final String LABEL_USERLIMIT_ITERATIONS = "Limit iterations";
    private static final int DEF_USERLIMIT_ITERATIONS = 1000000;
    private static final String DESC_USERLIMIT_ITERATIONS = "Abort the analysis of either a single error location or the whole program if more than the specified amount of iterations occured. 0 disables this limit.";
    public static final String LABEL_ORDER_OF_ERROR_LOCATIONS = "Order of the error locations to be checked";
    private static final OrderOfErrorLocations DEF_ORDER_OF_ERROR_LOCATIONS = OrderOfErrorLocations.TOGETHER;
    private static final String DESC_ORDER_OF_ERROR_LOCATIONS = "Order to check the reachability for different types of error locations (for concurrent programs). With " + String.valueOf((Object)OrderOfErrorLocations.INSUFFICIENT_FIRST) + " we first check, if there are enough threads in our translation, before checking for errors in the program. " + String.valueOf((Object)OrderOfErrorLocations.PROGRAM_FIRST) + " and " + String.valueOf((Object)OrderOfErrorLocations.TOGETHER) + " work accordingly.";
    public static final String LABEL_CONCURRENCY = "Automaton type used in concurrency analysis";
    private static final TAPreferences.Concurrency DEF_CONCURRENCY = TAPreferences.Concurrency.FINITE_AUTOMATA;
    public static final String LABEL_MCR_REFINEMENT_STRATEGY = "Trace refinement strategy used in MCR";
    private static final RefinementStrategy DEF_MCR_REFINEMENT_STRATEGY = RefinementStrategy.FIXED_PREFERENCES;
    public static final String LABEL_MCR_INTERPOLANT_METHOD = "Method to provide additional interpolants for the MCR automaton";
    private static final McrInterpolantMethod DEF_MCR_INTERPOLANT_METHOD = McrInterpolantMethod.WP;
    public static final String LABEL_PETRI_LBE_ONESHOT = "Apply one-shot large block encoding in concurrent analysis";
    private static final boolean DEF_PETRI_LBE_ONESHOT = false;
    public static final String LABEL_INDEPENDENCE_PLBE = "Independence relation used for large block encoding in concurrent analysis";
    private static final IndependenceSettings.IndependenceType DEF_INDEPENDENCE_PLBE = IndependenceSettings.IndependenceType.SEMANTIC;
    public static final String LABEL_SEMICOMM_PLBE = "Use semi-commutativity for large block encoding in concurrent analysis";
    private static final boolean DEF_SEMICOMM_PLBE = true;
    public static final String LABEL_POR_ONESHOT = "Apply one-shot Partial Order Reduction to input program";
    private static final boolean DEF_POR_ONESHOT = false;
    public static final String LABEL_POR_MODE = "Partial Order Reduction in concurrent analysis";
    private static final PartialOrderMode DEF_POR_MODE = PartialOrderMode.NONE;
    public static final String LABEL_POR_NUM_INDEPENDENCE = "Number of independence relations to use for POR";
    private static final int DEF_POR_NUM_INDEPENDENCE = 1;
    public static final String LABEL_DUMP_INDEPENDENCE_SCRIPT = "Dump SMT script used for independence checks";
    private static final boolean DEF_DUMP_INDEPENDENCE_SCRIPT = false;
    public static final String LABEL_INDEPENDENCE_SCRIPT_DUMP_PATH = "Dump independence script to the following directory";
    private static final String DEF_INDEPENDENCE_SCRIPT_DUMP_PATH = "";
    public static final String LABEL_INDEPENDENCE_POR = "Independence relation used for POR in concurrent analysis";
    public static final String LABEL_POR_ABSTRACTION = "Abstraction used for commutativity in POR";
    public static final String LABEL_COND_POR = "Use conditional POR in concurrent analysis";
    public static final String LABEL_SEMICOMM_POR = "Use semi-commutativity for POR in concurrent analysis";
    public static final String LABEL_INDEPENDENCE_SOLVER_POR = "SMT solver used for commutativity in POR";
    public static final String LABEL_INDEPENDENCE_SOLVER_TIMEOUT_POR = "SMT solver timeout for commutativity in POR (in ms)";
    public static final String LABEL_POR_DFS_ORDER = "DFS Order used in POR";
    private static final PartialOrderReductionFacade.OrderType DEF_POR_DFS_ORDER = PartialOrderReductionFacade.OrderType.BY_SERIAL_NUMBER;
    public static final String LABEL_POR_DFS_RANDOM_SEED = "Random seed used by POR DFS order";
    private static final int DEF_POR_DFS_RANDOM_SEED = 0;
    public static final String LABEL_POR_COINFLIP_MODE = "Coinflip budget determination mode";
    private static final CoinflipMode DEF_POR_COINFLIP_MODE = CoinflipMode.OFF;
    public static final String LABEL_POR_COINFLIP_PROB = "Coinflip probability value";
    private static final int DEF_POR_COINFLIP_PROB = 25;
    public static final String LABEL_POR_COINFLIP_SEED = "Coinflip random seed";
    private static final int DEF_POR_COINFLIP_SEED = 0;
    public static final String LABEL_POR_COINFLIP_INCREMENT = "Coinflip probability increment";
    private static final int DEF_POR_COINFLIP_INCREMENT = 0;
    public static final String LABEL_COMMUTATIVITY_COND_SYNTHESIS = "Commutativity condition synthesis";
    private static final String DESC_COMMUTATIVITY_COND_SYNTHESIS = "If set to a value other than NONE, GemCutter will generate conditions enabling commutativity (independence) of certain statements and try to prove that these conditions hold at relevant points in the program, to enable more reduction.";
    private static final SemanticIndependenceRelation.IndependenceConditions DEF_COMMUTATIVITY_COND_SYNTHESIS = SemanticIndependenceRelation.IndependenceConditions.NONE;
    public static final String LABEL_COMMUTATIVITY_COND_SYNTHESIS_STRATEGY = "Refinement strategy for commutativity condition synthesis";
    private static final String DESC_COMMUTATIVITY_COND_SYNTHESIS_STRATEGY = "Strategy used to check whether (and prove that) a synthesized commutativity condition holds.";
    private static final RefinementStrategy DEF_COMMUTATIVITY_COND_SYNTHESIS_STRATEGY = RefinementStrategy.SMTINTERPOL;
    public static final String LABEL_COMMUTATIVITY_COND_SYNTHESIS_THRESHOLD = "Path program threshold for commutativity condition synthesis";
    private static final String DESC_COMMUTATIVITY_COND_SYNTHESIS_THRESHOLD = "If commutativity condition synthesis is enabled, it is applied only to traces whose path program has been encountered at least n times (where n is the value of this setting).";
    private static final int DEF_COMMUTATIVITY_COND_SYNTHESIS_THRESHOLD = 2;
    public static final String LABEL_COMMUTATIVITY_COND_SYNTHESIS_RETRIES = "Maximum retries for commutativity condition synthesis";
    private static final String DESC_COMMUTATIVITY_COND_SYNTHESIS_RETRIES = "If commutativity condition synthesis fails due to an imperfect proof, future iterations may retry synthesizing a commutativity condition for the same point of redundancy/non-minimality, up to the given number of attempts.";
    private static final int DEF_COMMUTATIVITY_COND_SYNTHESIS_RETRIES = 0;
    public static final String LABEL_LOOPER_CHECK_PETRI = "Looper check in Petri net analysis";
    private static final TAPreferences.LooperCheck DEF_LOOPER_CHECK_PETRI = TAPreferences.LooperCheck.SYNTACTIC;
    public static final String LABEL_CONFIGURATION_ORDER = "Order on configurations for Petri net unfoldings";
    private static final PetriNetUnfolder.EventOrderEnum DEF_CONFIGURATION_ORDER = PetriNetUnfolder.EventOrderEnum.ERV;
    public static final String LABEL_CUTOFF = "cut-off requires same transition";
    private static final boolean DEF_CUTOFF = false;
    public static final String LABEL_BACKFOLDING = "Use backfolding";
    private static final boolean DEF_BACKFOLDING = false;
    public static final String LABEL_INTERPROCEDURAL = "Interprocedural analysis (Nested Interpolants)";
    private static final boolean DEF_INTERPROCEDURAL = true;
    public static final String LABEL_STOP_AFTER_FIRST_VIOLATION = "Stop after first violation was found";
    private static final boolean DEF_STOP_AFTER_FIRST_VIOLATION = true;
    private static final String DESC_STOP_AFTER_FIRST_VIOLATION = "Stop the analysis after the first violation was found.";
    public static final String LABEL_CEGAR_RESTART_BEHAVIOUR = "CEGAR restart behaviour";
    private static final TraceAbstractionStarter.CegarRestartBehaviour DEF_CEGAR_RESTART_BEHAVIOUR = TraceAbstractionStarter.CegarRestartBehaviour.ONLY_ONE_CEGAR;
    private static final String DESC_CEGAR_RESTART_BEHAVIOUR = "Control how many error locations are analyzed by a single CEGAR loop: all, only one, or other subsets.";
    public static final String LABEL_ERROR_AUTOMATON_MODE = "Error locations removal mode";
    private static final IErrorAutomatonBuilder.ErrorAutomatonType DEF_ERROR_AUTOMATON_MODE = IErrorAutomatonBuilder.ErrorAutomatonType.SIMPLE_ERROR_AUTOMATON;
    private static final String DESC_ERROR_AUTOMATON_MODE = "If \"CEGAR restart behaviour\" is not \"ONE_CEGAR_PER_ERROR_LOCATION\", i.e., if one CEGAR loop analyzes multiple error locations, reachable error locations are removed by refinining the abstraction with an error automaton specified by this mode.";
    public static final String LABEL_FLOYD_HOARE_AUTOMATA_REUSE = "Reuse of Floyd-Hoare automata";
    private static final FloydHoareAutomataReuse DEF_FLOYD_HOARE_AUTOMATA_REUSE = FloydHoareAutomataReuse.NONE;
    private static final String DESC_FLOYD_HOARE_AUTOMATA_REUSE = "Try to re-use interpolant automata from input files and/or previous runs. " + String.valueOf((Object)FloydHoareAutomataReuse.NONE) + " disables the re-use, all other settings enable it. You can specifiy additional .ats files as input and the containing NWAs will be treated as additional interpolant automata. When Stop after first violation was found is false, this setting will additionally try to re-use the automata from previous runs. " + String.valueOf((Object)FloydHoareAutomataReuse.EAGER) + " will compute the difference with the initial abstraction and all additional interpolant automatas before the first iteration of a run. " + String.valueOf((Object)FloydHoareAutomataReuse.LAZY_IN_ORDER) + " tries in each iteration after a potential counterexample is found if one of the re-usable interpolant automata accepts the counterexample. If this is the case, this automaton is substracted from the current abstraction and removed from the set of reusable interpolant automata.";
    public static final String LABEL_FLOYD_HOARE_AUTOMATA_REUSE_ENHANCEMENT = "Enhance during reuse of Floyd-Hoare automata";
    private static final FloydHoareAutomataReuseEnhancement DEF_FLOYD_HOARE_AUTOMATA_REUSE_ENHANCEMENT = FloydHoareAutomataReuseEnhancement.NONE;
    private static final String DESC_FLOYD_HOARE_AUTOMATA_REUSE_ENHANCEMENT = "Specifies how to compute successors on-demand for re-use interpolant automata.";
    public static final String LABEL_ARTIFACT = "Kind of artifact that is visualized";
    public static final String LABEL_WATCHITERATION = "Number of iteration whose artifact is visualized";
    private static final int DEF_WATCHITERATION = 1000000;
    public static final String LABEL_HOARE_POSITIONS = "Positions where we compute the Hoare Annotation";
    private static final HoareAnnotationPositions DEF_HOARE_POSITIONS = HoareAnnotationPositions.None;
    public static final String LABEL_COMPUTE_PROCEDURE_CONTRACTS = "Compute procedure contracts";
    private static final String DESC_COMPUTE_PROCEDURE_CONTRACTS = "Controls whether procedure contracts are computed from the Hoare annotation.Contract computation only works if the Hoare annotation for the relevant locations has been computed.";
    private static final boolean DEF_COMPUTE_PROCEDURE_CONTRACTS = true;
    public static final String LABEL_SEPARATE_SOLVER = "Use separate solver for trace checks";
    private static final boolean DEF_SEPARATE_SOLVER = true;
    public static final String LABEL_SOLVER = "SMT solver";
    private static final SolverBuilder.SolverMode DEF_SOLVER = SolverBuilder.SolverMode.Internal_SMTInterpol;
    public static final String LABEL_ADDITIONAL_SMT_OPTIONS = "Additional SMT options";
    private static final Map<String, String> DEF_ADDITIONAL_SMT_OPTIONS = RcfgPreferenceInitializer.DEF_ADDITIONAL_SMT_OPTIONS;
    public static final String LABEL_USE_MINIMAL_UNSAT_CORE_ENUMERATION_FOR_SMTINTERPOL = "Use minimal unsat core enumeration";
    private static final boolean DEF_USE_MINIMAL_UNSAT_CORE_ENUMERATION_FOR_SMTINTERPOL = false;
    private static final String DESC_USE_MINIMAL_UNSAT_CORE_ENUMERATION_FOR_SMTINTERPOL = "Highly experimental. Enable minimal unsat core enumeration with SMTInterpol. You can specify which heuristics should be used by setting appropriate SMT-LIB options. Contact Jochen Hoenicke or Leonard Fichtner for more information.";
    public static final String LABEL_INTERPOLATED_LOCS = "Compute Interpolants along a Counterexample";
    private static final InterpolationTechnique DEF_INTERPOLANTS = InterpolationTechnique.ForwardPredicates;
    public static final String LABEL_NONLINEAR_CONSTRAINTS_IN_PATHINVARIANTS = "Use nonlinear constraints in PathInvariants";
    public static final String LABEL_UNSAT_CORES_IN_PATHINVARIANTS = "Use unsat cores in PathInvariants";
    public static final String LABEL_WEAKEST_PRECONDITION_IN_PATHINVARIANTS = "Use weakest precondition in PathInvariants";
    public static final String LABEL_ABSTRACT_INTERPRETATION_FOR_PATH_INVARIANTS = "Use abstract interpretation in PathInvariants";
    public static final String LABEL_INTERPOLANTS_CONSOLIDATION = "Interpolants consolidation";
    public static final String LABEL_INTERPOLANT_AUTOMATON = "Interpolant automaton";
    public static final String LABEL_INTERPOLANT_AUTOMATON_ENHANCEMENT = "Interpolant automaton enhancement";
    public static final String LABEL_DUMPAUTOMATA = "Dump automata to files";
    private static final boolean DEF_DUMPAUTOMATA = false;
    public static final String LABEL_AUTOMATAFORMAT = "Output format of dumped automata";
    private static final AutomatonDefinitionPrinter.Format DEF_AUTOMATAFORMAT = AutomatonDefinitionPrinter.Format.ATS_NUMERATE;
    public static final String LABEL_DUMPPATH = "Dump automata to the following directory";
    private static final String DEF_DUMPPATH = ".";
    public static final String LABEL_DUMP_ONLY_REUSE = "Dump only reuse-automata";
    private static final boolean DEF_ONLY_REUSE = false;
    private static final String DESC_DUMP_ONLY_REUSE = "When dumping automata is enabled, we only dump the interpolant automaton and add to that file if it exists s.t. it can be reused by later verification runs.";
    public static final String LABEL_HOARE_TRIPLE_CHECKS = "Hoare triple checks";
    public static final String LABEL_DIFFERENCE_SENWA = "DifferenceSenwa operation instead classical Difference";
    private static final boolean DEF_DIFFERENCE_SENWA = false;
    public static final String LABEL_MINIMIZE = "Minimization of abstraction";
    public static final String LABEL_ASSERT_CODEBLOCKS_INCREMENTALLY = "Assert CodeBlocks";
    public static final String LABEL_UNSAT_CORES = "Use unsat cores";
    public static final String LABEL_LIVE_VARIABLES = "Use live variables";
    public static final String LABEL_LANGUAGE_OPERATION = "LanguageOperation";
    public static final String LABEL_ABSINT_MODE = "Abstract interpretation Mode";
    private static final AbstractInterpretationMode DEF_ABSINT_MODE = AbstractInterpretationMode.NONE;
    public static final String LABEL_ABSINT_ALWAYS_REFINE = "Refine always when using abstract interpretation";
    private static final boolean DEF_ABSINT_ALWAYS_REFINE = false;
    public static final String LABEL_COMPUTE_COUNTEREXAMPLE = "Compute trace for counterexample result";
    private static final boolean DEF_COMPUTE_COUNTEREXAMPLE = true;
    private static final String DESC_COMPUTE_COUNTEREXAMPLE = null;
    public static final String LABEL_COMPUTE_INTERPOLANT_SEQUENCE_STATISTICS = "Compute statistics for interpolant sequences";
    private static final boolean DEF_COMPUTE_INTERPOLANT_SEQUENCE_STATISTICS = true;
    private static final String DESC_COMPUTE_INTERPOLANT_SEQUENCE_STATISTICS = null;
    public static final String LABEL_ERROR_TRACE_RELEVANCE_ANALYSIS_MODE = "Highlight relevant statements in error traces";
    private static final RelevanceAnalysisMode DEF_ERROR_TRACE_RELEVANCE_ANALYSIS_MODE = RelevanceAnalysisMode.NONE;
    private static final String DESC_ERROR_TRACE_RELEVANCE_ANALYSIS_MODE = "Analyse error traces and identify relevant statements. Warning: For programs with floats, arrays, or pointers this analysis may take a significant amount of time.";
    public static final String LABEL_ERROR_TRACE_ANGELIC_VERIFICATION_ACTIVE = "Angelic verification mode";
    private static final boolean DEF_ERROR_TRACE_ANGELIC_VERIFICATION_ACTIVE = false;
    private static final String DESC_ERROR_TRACE_ANGELIC_VERIFICATION_ACTIVE = "Assume that unspecified inputs (e.g., external functions) return \"safe\" values during error trace relevance analysis.";
    public static final String LABEL_SIMPLIFICATION_TECHNIQUE = "Simplification technique";
    private static final SmtUtils.SimplificationTechnique DEF_SIMPLIFICATION_TECHNIQUE = SmtUtils.SimplificationTechnique.SIMPLIFY_DDA2;
    public static final String LABEL_COUNTEREXAMPLE_SEARCH_STRATEGY = "Counterexample search strategy";
    private static final CounterexampleSearchStrategy DEF_COUNTEREXAMPLE_SEARCH_STRATEGY = CounterexampleSearchStrategy.BFS;
    public static final String LABEL_REFINEMENT_STRATEGY = "Trace refinement strategy";
    private static final RefinementStrategy DEF_REFINEMENT_STRATEGY = RefinementStrategy.FIXED_PREFERENCES;
    public static final String LABEL_ACIP_REFINEMENT_STRATEGY = "Trace refinement strategy used in Accelerated Interpolation";
    private static final RefinementStrategy DEF_ACIP_REFINEMENT_STRATEGY = RefinementStrategy.FIXED_PREFERENCES;
    public static final String LABEL_REFINEMENT_STRATEGY_EXCEPTION_BLACKLIST = "Trace refinement exception blacklist";
    private static final TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist DEF_REFINEMENT_STRATEGY_EXCEPTION_BLACKLIST = TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist.DEPENDING;
    private static final String DESC_REFINEMENT_STRATEGY_EXCEPTION_BLACKLIST = "Sets the category of solver result for which the verification is aborted (even if another solver is available). When set to " + String.valueOf(TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist.ALL) + ", every unusable solver result aborts the verification, if set to " + String.valueOf(TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist.NONE) + " none of them do.";
    public static final String LABEL_DUMP_PATH_PROGRAM_IF_NOT_PERFECT = "Dump path programs if interpolant sequence is not perfect";
    public static final String LABEL_DUMP_PATH_PROGRAM_IF_ANALYZED_TOO_OFTEN = "Dump path programs if already analyzed N times";
    public static final String LABEL_DUMP_PATH_PROGRAM_STOP_MODE = "Stop after dumping path program";
    public static final String DEF_EXTERNAL_SOLVER_COMMAND = "z3 SMTLIB2_COMPLIANT=true -memory:1024 -smt2 -in -t:12000";
    public static final String LABEL_USE_PREDICATE_TRIE_BASED_PREDICATE_UNIFIER = "Use predicate trie based predicate unification";
    public static final boolean DEF_USE_PREDICATE_TRIE_BASED_PREDICATE_UNIFIER = false;
    public static final String DESC_USE_PREDICATE_TRIE_BASED_PREDICATE_UNIFIER = "Use the newer predicate-trie based predicate unification algorithm.";
    public static final String LABEL_HEURISTIC_EMPTINESS_CHECK = "Use heuristic emptiness check";
    private static final boolean DEF_HEURISTIC_EMPTINESS_CHECK = false;
    private static final String DESC_HEURISTIC_EMPTINESS_CHECK = "Use heuristics to traverse/explorew a NWA during the check emptiness";
    public static final String LABEL_HEURISTIC_EMPTINESS_CHECK_SCORING_METHOD = "Scoring method to use during heuristic emptiness check";
    private static final SMTFeatureExtractionTermClassifier.ScoringMethod DEF_HEURISTIC_EMPTINESS_CHECK_SCORING_METHOD = SMTFeatureExtractionTermClassifier.ScoringMethod.DAGSIZE;
    private static final String DESC_HEURISTIC_EMPTINESS_CHECK_SCORING_METHOD = "Defines what Scoring method is used to score outgoing transitions of a NWA during the emptiness check.";
    public static final String LABEL_HEURISTIC_EMPTINESS_CHECK_ASTAR_HEURISTIC = "AStar heuristic to use during heuristic emptiness check";
    private static final IsEmptyHeuristic.AStarHeuristic DEF_HEURISTIC_EMPTINESS_CHECK_ASTAR_HEURISTIC = IsEmptyHeuristic.AStarHeuristic.ZERO;
    private static final String DESC_HEURISTIC_EMPTINESS_CHECK_ASTAR_HEURISTIC = "Defines which Heuristic is used by AStar during exploration of a NWA during the emptiness check.";
    public static final String LABEL_HEURISTIC_EMPTINESS_CHECK_ASTAR_RANDOM_HEURISTIC_SEED = "AStar random heuristic seed";
    private static final Integer DEF_HEURISTIC_EMPTINESS_CHECK_ASTAR_RANDOM_HEURISTIC_SEED = 1337;
    private static final String DESC_HEURISTIC_EMPTINESS_CHECK_ASTAR_RANDOM_HEURISTIC_SEED = "Defines which seed is used for RANDOM_HALF and RANDOM_FULL heuristic";
    public static final String LABEL_SMT_FEATURE_EXTRACTION = "Extract SMT features during analysis";
    private static final boolean DEF_SMT_FEATURE_EXTRACTION = false;
    private static final String DESC_SMT_FEATURE_EXTRACTION = "We Extract SMT features during analysis and dump them.";
    public static final String LABEL_SMT_FEATURE_EXTRACTION_DUMP_PATH = "SMT feature Extraction Dump Path.";
    private static final String DEF_SMT_FEATURE_EXTRACTION_DUMP_PATH = ".";
    private static final String DESC_SMT_FEATURE_EXTRACTION_DUMP_PATH = "We Extract SMT features during analysis and dump them to the given path";
    public static final String LABEL_OVERRIDE_INTERPOLANT_AUTOMATON = "Override the interpolant automaton setting of the refinement strategy";
    private static final boolean DEF_OVERRIDE_INTERPOLANT_AUTOMATON = false;
    public static final String LABEL_ASSERT_CODEBLOCKS_HEURISTIC_SCORING_METHOD = "Assert CodeBlocks Term Scoring Heuristic";
    private static final SMTFeatureExtractionTermClassifier.ScoringMethod DEF_ASSERT_CODEBLOCKS_HEURISTIC_SCORING_METHOD = ITraceCheckPreferences.AssertCodeBlockOrder.DEF_SCORING_METHOD;
    private static final String DESC_ASSERT_CODEBLOCKS_HEURISTIC_SCORING_METHOD = "if Assert CodeBlocks is set to SMT_FEATURE_HEURISTIC, each term in a trace is scored. This setting defines which scoring method is used to score traces";
    public static final String LABEL_ASSERT_CODEBLOCKS_HEURISTIC_PARTITIONING_STRATEGY = "Assert CodeBlocks Term Scoring Heuristic Partitioning Strategy";
    private static final ITraceCheckPreferences.SmtFeatureHeuristicPartitioningType DEF_ASSERT_CODEBLOCKS_HEURISTIC_PARTITIONING_STRATEGY = ITraceCheckPreferences.AssertCodeBlockOrder.DEF_PARTITIONING_STRATEGY;
    private static final String DESC_ASSERT_CODEBLOCKS_HEURISTIC_PARTITIONING_STRATEGY = "if Assert CodeBlocks is set to SMT_FEATURE_HEURISTIC, this setting defines which partitioning strategy is used.";
    public static final String LABEL_ACCELINTERPOL_LOOPACCELERATION_TECHNIQUE = "Loop acceleration method that is used by accelerated interpolation";
    private static final LoopAccelerators DEF_LOOPACCELERATION_TECHNIQUE = LoopAccelerators.FAST_UPR;
    private static final String DESC_ACCELINTERPOL_LOOPACCELERATION_TECHNIQUE = "Set the loop acceleration technique.";
    public static final String LABEL_ASSERT_CODEBLOCKS_HEURISTIC_NUM_PARTITIONS = "Assert CodeBlocks Term Scoring Heuristic number of partitions";
    private static final Integer DEF_ASSERT_CODEBLOCKS_HEURISTIC_NUM_PARTITIONS = 4;
    private static final String DESC_ASSERT_CODEBLOCKS_HEURISTIC_NUM_PARTITIONS = "If Assert CodeBlocks is set to SMT_FEATURE_HEURISTIC and partitioning strategy is FIXED_NUM_PARTITIONS, this setting defines the amount of partitions.";
    public static final String LABEL_ASSERT_CODEBLOCKS_HEURISTIC_SCORE_THRESHOLD = "Assert CodeBlocks Term Scoring Heuristic Score Threshold";
    private static final Double DEF_ASSERT_CODEBLOCKS_HEURISTIC_SCORE_THRESHOLD = 0.75;
    private static final String DESC_ASSERT_CODEBLOCKS_HEURISTIC_SCORE_THRESHOLD = "If Assert CodeBlocks is set to SMT_FEATURE_HEURISTIC and partitioning strategy is THRESHOLD, two partitions are created, one partition contains all terms >= threshold  and one all terms < threshold";

    public TraceAbstractionPreferenceInitializer() {
        super(Activator.PLUGIN_ID, "Automizer (Trace Abstraction)");
    }

    protected BaseUltimatePreferenceItem[] initDefaultPreferences() {
        return new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_INTERPROCEDURAL, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_STOP_AFTER_FIRST_VIOLATION, (Object)true, DESC_STOP_AFTER_FIRST_VIOLATION, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_CEGAR_RESTART_BEHAVIOUR, (Object)DEF_CEGAR_RESTART_BEHAVIOUR, DESC_CEGAR_RESTART_BEHAVIOUR, PreferenceType.Combo, (Object[])TraceAbstractionStarter.CegarRestartBehaviour.values()), new UltimatePreferenceItem(LABEL_ERROR_AUTOMATON_MODE, (Object)DEF_ERROR_AUTOMATON_MODE, DESC_ERROR_AUTOMATON_MODE, PreferenceType.Combo, (Object[])IErrorAutomatonBuilder.ErrorAutomatonType.values()), new UltimatePreferenceItem(LABEL_READ_INITIAL_PROOF_ASSERTIONS_FROM_FILE, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_FLOYD_HOARE_AUTOMATA_REUSE, (Object)DEF_FLOYD_HOARE_AUTOMATA_REUSE, DESC_FLOYD_HOARE_AUTOMATA_REUSE, PreferenceType.Combo, (Object[])FloydHoareAutomataReuse.values()), new UltimatePreferenceItem(LABEL_FLOYD_HOARE_AUTOMATA_REUSE_ENHANCEMENT, (Object)DEF_FLOYD_HOARE_AUTOMATA_REUSE_ENHANCEMENT, DESC_FLOYD_HOARE_AUTOMATA_REUSE_ENHANCEMENT, PreferenceType.Combo, (Object[])FloydHoareAutomataReuseEnhancement.values()), new UltimatePreferenceItemGroup("User Limits", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_USERLIMIT_ITERATIONS, (Object)1000000, DESC_USERLIMIT_ITERATIONS, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(0, 1000000)), new UltimatePreferenceItem(LABEL_USERLIMIT_TIME, (Object)0, DESC_USERLIMIT_TIME, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)UltimatePreferenceItem.IUltimatePreferenceItemValidator.ONLY_POSITIVE), new UltimatePreferenceItem(LABEL_USERLIMIT_PATH_PROGRAM, (Object)0, DESC_USERLIMIT_PATH_PROGRAM, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)UltimatePreferenceItem.IUltimatePreferenceItemValidator.ONLY_POSITIVE), new UltimatePreferenceItem(LABEL_USERLIMIT_TRACE_HISTOGRAM, (Object)0, DESC_USERLIMIT_TRACE_HISTOGRAM, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)UltimatePreferenceItem.IUltimatePreferenceItemValidator.ONLY_POSITIVE)}), new UltimatePreferenceItem(LABEL_COMPUTE_COUNTEREXAMPLE, (Object)true, DESC_COMPUTE_COUNTEREXAMPLE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_COMPUTE_INTERPOLANT_SEQUENCE_STATISTICS, (Object)true, DESC_COMPUTE_INTERPOLANT_SEQUENCE_STATISTICS, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_ARTIFACT, (Object)TAPreferences.Artifact.RCFG, PreferenceType.Combo, (Object[])TAPreferences.Artifact.values()), new UltimatePreferenceItem(LABEL_WATCHITERATION, (Object)1000000, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(0, 10000000)), new UltimatePreferenceItem(LABEL_HOARE_POSITIONS, (Object)DEF_HOARE_POSITIONS, PreferenceType.Combo, (Object[])HoareAnnotationPositions.values()), new UltimatePreferenceItem(LABEL_COMPUTE_PROCEDURE_CONTRACTS, (Object)true, DESC_COMPUTE_PROCEDURE_CONTRACTS, UltimatePreferenceItem.Level.EXPERIMENTAL, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_USE_PREDICATE_TRIE_BASED_PREDICATE_UNIFIER, (Object)false, DESC_USE_PREDICATE_TRIE_BASED_PREDICATE_UNIFIER, PreferenceType.Boolean), new UltimatePreferenceItemGroup("Trace Check Solver", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_SEPARATE_SOLVER, (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_SOLVER, (Object)DEF_SOLVER, PreferenceType.Combo, (Object[])SolverBuilder.SolverMode.values()), new UltimatePreferenceItem("Fake non-incremental script", (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem("Command for external solver", (Object)DEF_EXTERNAL_SOLVER_COMMAND, PreferenceType.String), new UltimatePreferenceItem("Logic for external solver", (Object)"ALL", PreferenceType.String), new UltimatePreferenceItem("Dump SMT script to file", (Object)Boolean.FALSE, PreferenceType.Boolean), new UltimatePreferenceItem("To the following directory", (Object)DEF_INDEPENDENCE_SCRIPT_DUMP_PATH, PreferenceType.Directory), new UltimatePreferenceItem("Compress dumped SMT script", (Object)false, "Compress the written .smt2 script with GZip", PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_USE_MINIMAL_UNSAT_CORE_ENUMERATION_FOR_SMTINTERPOL, (Object)false, DESC_USE_MINIMAL_UNSAT_CORE_ENUMERATION_FOR_SMTINTERPOL, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_ADDITIONAL_SMT_OPTIONS, DEF_ADDITIONAL_SMT_OPTIONS, PreferenceType.KeyValue)}), new UltimatePreferenceItem(LABEL_INTERPOLATED_LOCS, (Object)DEF_INTERPOLANTS, PreferenceType.Combo, (Object[])InterpolationTechnique.values()), new UltimatePreferenceItem(LABEL_NONLINEAR_CONSTRAINTS_IN_PATHINVARIANTS, (Object)Boolean.FALSE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_UNSAT_CORES_IN_PATHINVARIANTS, (Object)Boolean.FALSE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_WEAKEST_PRECONDITION_IN_PATHINVARIANTS, (Object)Boolean.FALSE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_ABSTRACT_INTERPRETATION_FOR_PATH_INVARIANTS, (Object)Boolean.FALSE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_INTERPOLANTS_CONSOLIDATION, (Object)Boolean.FALSE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_UNSAT_CORES, (Object)ITraceCheckPreferences.UnsatCores.CONJUNCT_LEVEL, PreferenceType.Combo, (Object[])ITraceCheckPreferences.UnsatCores.values()), new UltimatePreferenceItem(LABEL_LIVE_VARIABLES, (Object)Boolean.TRUE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_ASSERT_CODEBLOCKS_INCREMENTALLY, (Object)ITraceCheckPreferences.AssertCodeBlockOrderType.NOT_INCREMENTALLY, PreferenceType.Combo, (Object[])ITraceCheckPreferences.AssertCodeBlockOrderType.values()), new UltimatePreferenceItem(LABEL_ASSERT_CODEBLOCKS_HEURISTIC_SCORING_METHOD, (Object)DEF_ASSERT_CODEBLOCKS_HEURISTIC_SCORING_METHOD, DESC_ASSERT_CODEBLOCKS_HEURISTIC_SCORING_METHOD, PreferenceType.Combo, (Object[])SMTFeatureExtractionTermClassifier.ScoringMethod.values()), new UltimatePreferenceItem(LABEL_ASSERT_CODEBLOCKS_HEURISTIC_PARTITIONING_STRATEGY, (Object)DEF_ASSERT_CODEBLOCKS_HEURISTIC_PARTITIONING_STRATEGY, DESC_ASSERT_CODEBLOCKS_HEURISTIC_PARTITIONING_STRATEGY, PreferenceType.Combo, (Object[])ITraceCheckPreferences.SmtFeatureHeuristicPartitioningType.values()), new UltimatePreferenceItem(LABEL_ASSERT_CODEBLOCKS_HEURISTIC_NUM_PARTITIONS, (Object)DEF_ASSERT_CODEBLOCKS_HEURISTIC_NUM_PARTITIONS, DESC_ASSERT_CODEBLOCKS_HEURISTIC_NUM_PARTITIONS, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(0, 10000000)), new UltimatePreferenceItem(LABEL_ASSERT_CODEBLOCKS_HEURISTIC_SCORE_THRESHOLD, (Object)DEF_ASSERT_CODEBLOCKS_HEURISTIC_SCORE_THRESHOLD, DESC_ASSERT_CODEBLOCKS_HEURISTIC_SCORE_THRESHOLD, PreferenceType.Double, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.DoubleValidator(0.5, 1.0)), new UltimatePreferenceItem(LABEL_OVERRIDE_INTERPOLANT_AUTOMATON, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_INTERPOLANT_AUTOMATON, (Object)InterpolantAutomaton.STRAIGHT_LINE, PreferenceType.Combo, (Object[])InterpolantAutomaton.values()), new UltimatePreferenceItem(LABEL_INTERPOLANT_AUTOMATON_ENHANCEMENT, (Object)TAPreferences.InterpolantAutomatonEnhancement.PREDICATE_ABSTRACTION, PreferenceType.Combo, (Object[])TAPreferences.InterpolantAutomatonEnhancement.values()), new UltimatePreferenceItem(LABEL_HOARE_TRIPLE_CHECKS, (Object)HoareTripleCheckerUtils.HoareTripleChecks.INCREMENTAL, PreferenceType.Combo, (Object[])HoareTripleCheckerUtils.HoareTripleChecks.values()), new UltimatePreferenceItemGroup("Automata Dumping", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_DUMPAUTOMATA, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_AUTOMATAFORMAT, (Object)DEF_AUTOMATAFORMAT, PreferenceType.Combo, (Object[])AutomatonDefinitionPrinter.Format.values()), new UltimatePreferenceItem(LABEL_DUMPPATH, (Object)".", PreferenceType.Directory), new UltimatePreferenceItem(LABEL_DUMP_ONLY_REUSE, (Object)false, DESC_DUMP_ONLY_REUSE, PreferenceType.Boolean)}), new UltimatePreferenceItem(LABEL_LANGUAGE_OPERATION, (Object)LanguageOperation.DIFFERENCE, PreferenceType.Combo, (Object[])LanguageOperation.values()), new UltimatePreferenceItem(LABEL_DIFFERENCE_SENWA, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_MINIMIZE, (Object)Minimization.MINIMIZE_SEVPA, PreferenceType.Combo, (Object[])Minimization.values()), new UltimatePreferenceItem(LABEL_ABSINT_MODE, (Object)DEF_ABSINT_MODE, PreferenceType.Combo, (Object[])AbstractInterpretationMode.values()), new UltimatePreferenceItem(LABEL_ABSINT_ALWAYS_REFINE, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_ERROR_TRACE_RELEVANCE_ANALYSIS_MODE, (Object)DEF_ERROR_TRACE_RELEVANCE_ANALYSIS_MODE, DESC_ERROR_TRACE_RELEVANCE_ANALYSIS_MODE, PreferenceType.Combo, (Object[])RelevanceAnalysisMode.values()), new UltimatePreferenceItem(LABEL_ERROR_TRACE_ANGELIC_VERIFICATION_ACTIVE, (Object)false, DESC_ERROR_TRACE_ANGELIC_VERIFICATION_ACTIVE, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_SIMPLIFICATION_TECHNIQUE, (Object)DEF_SIMPLIFICATION_TECHNIQUE, PreferenceType.Combo, (Object[])SmtUtils.SimplificationTechnique.values()), new UltimatePreferenceItem(LABEL_COUNTEREXAMPLE_SEARCH_STRATEGY, (Object)DEF_COUNTEREXAMPLE_SEARCH_STRATEGY, PreferenceType.Combo, (Object[])CounterexampleSearchStrategy.values()), new UltimatePreferenceItem(LABEL_REFINEMENT_STRATEGY, (Object)DEF_REFINEMENT_STRATEGY, PreferenceType.Combo, (Object[])RefinementStrategy.values()), new UltimatePreferenceItem(LABEL_ACIP_REFINEMENT_STRATEGY, (Object)DEF_ACIP_REFINEMENT_STRATEGY, PreferenceType.Combo, (Object[])RefinementStrategy.values()), new UltimatePreferenceItem(LABEL_REFINEMENT_STRATEGY_EXCEPTION_BLACKLIST, (Object)DEF_REFINEMENT_STRATEGY_EXCEPTION_BLACKLIST, DESC_REFINEMENT_STRATEGY_EXCEPTION_BLACKLIST, PreferenceType.Combo, (Object[])TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist.values()), new UltimatePreferenceItemGroup("Heuristic Emptiness Check", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_HEURISTIC_EMPTINESS_CHECK, (Object)false, DESC_HEURISTIC_EMPTINESS_CHECK, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_HEURISTIC_EMPTINESS_CHECK_ASTAR_HEURISTIC, (Object)DEF_HEURISTIC_EMPTINESS_CHECK_ASTAR_HEURISTIC, DESC_HEURISTIC_EMPTINESS_CHECK_ASTAR_HEURISTIC, PreferenceType.Combo, (Object[])IsEmptyHeuristic.AStarHeuristic.values()), new UltimatePreferenceItem(LABEL_HEURISTIC_EMPTINESS_CHECK_ASTAR_RANDOM_HEURISTIC_SEED, (Object)DEF_HEURISTIC_EMPTINESS_CHECK_ASTAR_RANDOM_HEURISTIC_SEED, DESC_HEURISTIC_EMPTINESS_CHECK_ASTAR_RANDOM_HEURISTIC_SEED, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(0, 1000000)), new UltimatePreferenceItem(LABEL_HEURISTIC_EMPTINESS_CHECK_SCORING_METHOD, (Object)DEF_HEURISTIC_EMPTINESS_CHECK_SCORING_METHOD, DESC_HEURISTIC_EMPTINESS_CHECK_SCORING_METHOD, PreferenceType.Combo, (Object[])SMTFeatureExtractionTermClassifier.ScoringMethod.values())}), new UltimatePreferenceItem(LABEL_ACCELINTERPOL_LOOPACCELERATION_TECHNIQUE, (Object)DEF_LOOPACCELERATION_TECHNIQUE, DESC_ACCELINTERPOL_LOOPACCELERATION_TECHNIQUE, PreferenceType.Combo, (Object[])LoopAccelerators.values()), new UltimatePreferenceItem(LABEL_SMT_FEATURE_EXTRACTION, (Object)false, DESC_SMT_FEATURE_EXTRACTION, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_SMT_FEATURE_EXTRACTION_DUMP_PATH, (Object)".", DESC_SMT_FEATURE_EXTRACTION_DUMP_PATH, PreferenceType.Directory), new UltimatePreferenceItem(LABEL_DUMP_PATH_PROGRAM_IF_NOT_PERFECT, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_DUMP_PATH_PROGRAM_IF_ANALYZED_TOO_OFTEN, (Object)0, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_DUMP_PATH_PROGRAM_STOP_MODE, (Object)PathProgramDumpStop.AFTER_FIRST_DUMP, PreferenceType.Combo, (Object[])PathProgramDumpStop.values()), TraceAbstractionPreferenceInitializer.getConcurrencySettings()};
    }

    private static UltimatePreferenceItemContainer getConcurrencySettings() {
        return new UltimatePreferenceItemContainer("Concurrent Programs", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_ORDER_OF_ERROR_LOCATIONS, (Object)DEF_ORDER_OF_ERROR_LOCATIONS, DESC_ORDER_OF_ERROR_LOCATIONS, PreferenceType.Combo, (Object[])OrderOfErrorLocations.values()), new UltimatePreferenceItem(LABEL_CONCURRENCY, (Object)DEF_CONCURRENCY, PreferenceType.Combo, (Object[])TAPreferences.Concurrency.values()), new UltimatePreferenceItem(LABEL_MCR_REFINEMENT_STRATEGY, (Object)DEF_MCR_REFINEMENT_STRATEGY, PreferenceType.Combo, (Object[])RefinementStrategy.values()), new UltimatePreferenceItem(LABEL_MCR_INTERPOLANT_METHOD, (Object)DEF_MCR_INTERPOLANT_METHOD, PreferenceType.Combo, (Object[])McrInterpolantMethod.values()), new UltimatePreferenceItemGroup("PetriAutomizer", "These settings are only relevant if \"Automaton type used in concurrency analysis\" is set to \"" + String.valueOf((Object)TAPreferences.Concurrency.PETRI_NET) + "\".", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_CONFIGURATION_ORDER, (Object)DEF_CONFIGURATION_ORDER, PreferenceType.Combo, (Object[])PetriNetUnfolder.EventOrderEnum.values()), new UltimatePreferenceItem(LABEL_CUTOFF, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_BACKFOLDING, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_LOOPER_CHECK_PETRI, (Object)DEF_LOOPER_CHECK_PETRI, PreferenceType.Combo, (Object[])TAPreferences.LooperCheck.values())}), TraceAbstractionPreferenceInitializer.getPORSettings(), TraceAbstractionPreferenceInitializer.getPetriLbeSettings()});
    }

    private static UltimatePreferenceItemContainer getPORSettings() {
        return new UltimatePreferenceItemContainer("Partial Order Reduction (GemCutter)", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_POR_ONESHOT, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_POR_MODE, (Object)DEF_POR_MODE, PreferenceType.Combo, (Object[])PartialOrderMode.values()), new UltimatePreferenceItem(LABEL_POR_DFS_ORDER, (Object)DEF_POR_DFS_ORDER, PreferenceType.Combo, (Object[])PartialOrderReductionFacade.OrderType.values()), new UltimatePreferenceItem(LABEL_POR_DFS_RANDOM_SEED, (Object)0, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_POR_NUM_INDEPENDENCE, (Object)1, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_DUMP_INDEPENDENCE_SCRIPT, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_INDEPENDENCE_SCRIPT_DUMP_PATH, (Object)DEF_INDEPENDENCE_SCRIPT_DUMP_PATH, PreferenceType.Directory), new UltimatePreferenceItem(LABEL_COMMUTATIVITY_COND_SYNTHESIS, (Object)DEF_COMMUTATIVITY_COND_SYNTHESIS, DESC_COMMUTATIVITY_COND_SYNTHESIS, PreferenceType.Combo, (Object[])SemanticIndependenceRelation.IndependenceConditions.values()), new UltimatePreferenceItem(LABEL_COMMUTATIVITY_COND_SYNTHESIS_STRATEGY, (Object)DEF_COMMUTATIVITY_COND_SYNTHESIS_STRATEGY, DESC_COMMUTATIVITY_COND_SYNTHESIS_STRATEGY, PreferenceType.Combo, (Object[])RefinementStrategy.values()), new UltimatePreferenceItem(LABEL_COMMUTATIVITY_COND_SYNTHESIS_THRESHOLD, (Object)2, DESC_COMMUTATIVITY_COND_SYNTHESIS_THRESHOLD, UltimatePreferenceItem.Level.EXPERIMENTAL, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_COMMUTATIVITY_COND_SYNTHESIS_RETRIES, (Object)0, DESC_COMMUTATIVITY_COND_SYNTHESIS_RETRIES, UltimatePreferenceItem.Level.EXPERIMENTAL, PreferenceType.Integer), TraceAbstractionPreferenceInitializer.getIndependenceSettings(0), TraceAbstractionPreferenceInitializer.getIndependenceSettings(1), TraceAbstractionPreferenceInitializer.getIndependenceSettings(2), new UltimatePreferenceItemGroup("Stratified Commutativity: Budget Function", new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_POR_COINFLIP_MODE, (Object)DEF_POR_COINFLIP_MODE, PreferenceType.Combo, (Object[])CoinflipMode.values()), new UltimatePreferenceItem(LABEL_POR_COINFLIP_PROB, (Object)25, PreferenceType.Integer, (UltimatePreferenceItem.IUltimatePreferenceItemValidator)new UltimatePreferenceItem.IUltimatePreferenceItemValidator.IntegerValidator(0, 100)), new UltimatePreferenceItem(LABEL_POR_COINFLIP_INCREMENT, (Object)0, PreferenceType.Integer), new UltimatePreferenceItem(LABEL_POR_COINFLIP_SEED, (Object)0, PreferenceType.Integer)})});
    }

    private static UltimatePreferenceItemContainer getPetriLbeSettings() {
        return new UltimatePreferenceItemContainer("Petri LBE (Lipton Reduction)", (BaseUltimatePreferenceItem[])new UltimatePreferenceItem[]{new UltimatePreferenceItem(LABEL_PETRI_LBE_ONESHOT, (Object)false, PreferenceType.Boolean), new UltimatePreferenceItem(LABEL_INDEPENDENCE_PLBE, (Object)DEF_INDEPENDENCE_PLBE, PreferenceType.Combo, (Object[])IndependenceSettings.IndependenceType.values()), new UltimatePreferenceItem(LABEL_SEMICOMM_PLBE, (Object)true, PreferenceType.Boolean)});
    }

    private static UltimatePreferenceItemGroup getIndependenceSettings(int n) {
        String string = TraceAbstractionPreferenceInitializer.getSuffixedLabel("Independence Relation", n) + (n == 0 ? DEF_INDEPENDENCE_SCRIPT_DUMP_PATH : " (Stratified Commutativity)");
        return new UltimatePreferenceItemGroup(string, new BaseUltimatePreferenceItem[]{new UltimatePreferenceItem(TraceAbstractionPreferenceInitializer.getSuffixedLabel(LABEL_INDEPENDENCE_POR, n), (Object)IndependenceSettings.DEFAULT_INDEPENDENCE_TYPE, PreferenceType.Combo, (Object[])IndependenceSettings.IndependenceType.values()), new UltimatePreferenceItem(TraceAbstractionPreferenceInitializer.getSuffixedLabel(LABEL_POR_ABSTRACTION, n), (Object)IndependenceSettings.DEFAULT_ABSTRACTION_TYPE, PreferenceType.Combo, (Object[])IndependenceSettings.AbstractionType.values()), new UltimatePreferenceItem(TraceAbstractionPreferenceInitializer.getSuffixedLabel(LABEL_COND_POR, n), (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(TraceAbstractionPreferenceInitializer.getSuffixedLabel(LABEL_SEMICOMM_POR, n), (Object)true, PreferenceType.Boolean), new UltimatePreferenceItem(TraceAbstractionPreferenceInitializer.getSuffixedLabel(LABEL_INDEPENDENCE_SOLVER_POR, n), (Object)IndependenceSettings.DEFAULT_SOLVER, PreferenceType.Combo, (Object[])SolverBuilder.ExternalSolver.values()), new UltimatePreferenceItem(TraceAbstractionPreferenceInitializer.getSuffixedLabel(LABEL_INDEPENDENCE_SOLVER_TIMEOUT_POR, n), (Object)1000, PreferenceType.Integer)});
    }

    public static String getSuffixedLabel(String string, int n) {
        if (n == 0) {
            return string;
        }
        return string + " #" + (n + 1);
    }

    public static enum AbstractInterpretationMode {
        NONE,
        USE_PREDICATES,
        USE_PATH_PROGRAM,
        USE_CANONICAL,
        USE_TOTAL;

    }

    public static enum CoinflipMode {
        OFF,
        FALLBACK,
        PURE,
        COARSE;

    }

    public static enum CounterexampleSearchStrategy {
        BFS,
        DFS;

    }

    public static enum FloydHoareAutomataReuse {
        NONE,
        EAGER,
        LAZY_IN_ORDER;

    }

    public static enum FloydHoareAutomataReuseEnhancement {
        NONE,
        AS_USUAL,
        ONLY_NEW_LETTERS,
        ONLY_NEW_LETTERS_SOLVER;

    }

    public static enum InterpolantAutomaton {
        CANONICAL,
        STRAIGHT_LINE,
        TOTALINTERPOLATION,
        TOTALINTERPOLATION2,
        ABSTRACT_INTERPRETATION,
        MCR;

    }

    public static enum LanguageOperation {
        DIFFERENCE,
        INCREMENTAL_INCLUSION_VIA_DIFFERENCE,
        INCREMENTAL_INCLUSION_2,
        INCREMENTAL_INCLUSION_2_DEADEND_REMOVE,
        INCREMENTAL_INCLUSION_2_DEADEND_REMOVE_ANTICHAIN,
        INCREMENTAL_INCLUSION_2_DEADEND_REMOVE_ANTICHAIN_2STACKS,
        INCREMENTAL_INCLUSION_2_DEADEND_REMOVE_ANTICHAIN_2STACKS_MULTIPLECE,
        INCREMENTAL_INCLUSION_3,
        INCREMENTAL_INCLUSION_3_2,
        INCREMENTAL_INCLUSION_4,
        INCREMENTAL_INCLUSION_4_2,
        INCREMENTAL_INCLUSION_5,
        INCREMENTAL_INCLUSION_5_2;

    }

    public static enum McrInterpolantMethod {
        WP,
        SP;

    }

    public static enum Minimization {
        NONE,
        MINIMIZE_SEVPA,
        SHRINK_NWA,
        DFA_HOPCROFT_ARRAYS,
        DFA_HOPCROFT_LISTS,
        NWA_SIZE_BASED_PICKER,
        NWA_MAX_SAT,
        NWA_MAX_SAT2,
        NWA_COMBINATOR_PATTERN,
        NWA_COMBINATOR_EVERY_KTH,
        RAQ_DIRECT_SIMULATION,
        RAQ_DIRECT_SIMULATION_B,
        NWA_OVERAPPROXIMATION,
        NWA_COMBINATOR_MULTI_DEFAULT,
        NWA_COMBINATOR_MULTI_SIMULATION,
        DELAYED_SIMULATION,
        FAIR_SIMULATION_WITH_SCC,
        FAIR_SIMULATION_WITHOUT_SCC,
        FAIR_DIRECT_SIMULATION,
        RAQ_DELAYED_SIMULATION,
        RAQ_DELAYED_SIMULATION_B,
        FULLMULTIPEBBLE_DELAYED_SIMULATION,
        FULLMULTIPEBBLE_DIRECT_SIMULATION;

    }

    public static enum MultiPropertyMode {
        STOP_AFTER_FIRST_VIOLATION,
        CHECK_EACH_PROPERTY_SEPARATELY,
        CHECK_ALL_PROPERTIES_REFINE_WITH_VIOLATIONS;

    }

    public static enum OrderOfErrorLocations {
        INSUFFICIENT_FIRST,
        PROGRAM_FIRST,
        TOGETHER;

    }

    public static enum PathProgramDumpStop {
        NEVER,
        AFTER_FIRST_DUMP,
        BEFORE_FIRST_DUPLICATE;

    }

    public static enum RefinementStrategy {
        FIXED_PREFERENCES,
        TAIPAN,
        RUBBER_TAIPAN,
        LAZY_TAIPAN,
        TOOTHLESS_TAIPAN,
        PENGUIN,
        WALRUS,
        CAMEL,
        CAMEL_NO_AM,
        CAMEL_SMT_AM,
        CAMEL_BP_ONLY,
        LIZARD,
        BADGER,
        WOLF,
        FOX,
        BEAR,
        WARTHOG,
        WARTHOG_NO_AM,
        MAMMOTH,
        MAMMOTH_NO_AM,
        SMTINTERPOL,
        DACHSHUND,
        SIFA_TAIPAN,
        TOOTHLESS_SIFA_TAIPAN,
        MCR,
        ACCELERATED_INTERPOLATION,
        ACCELERATED_TRACE_CHECK;

    }

    public static enum RelevanceAnalysisMode {
        NONE,
        SINGLE_TRACE,
        MULTI_TRACE;

    }
}

