/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.IntvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.Qvasr;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstraction;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractionJoin;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrAbstractor;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.qvasr.QvasrUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IAbstractPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IDomainSpecificOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class QvasrSummarizer {
    private final ILogger mLogger;
    private final ManagedScript mScript;
    private final IUltimateServiceProvider mServices;
    private boolean mIsOverapprox;

    public QvasrSummarizer(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript) {
        this.mLogger = iLogger;
        this.mScript = managedScript;
        this.mServices = iUltimateServiceProvider;
        this.mIsOverapprox = false;
    }

    public UnmodifiableTransFormula summarizeLoop(UnmodifiableTransFormula unmodifiableTransFormula) {
        Term term4;
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        HashMap<IProgramVar, TermVariable> hashMap2 = new HashMap<IProgramVar, TermVariable>();
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getOutVars().keySet()) {
            if (unmodifiableTransFormula.getInVars().containsKey(iProgramVar)) {
                hashMap.put(iProgramVar, (TermVariable)unmodifiableTransFormula.getInVars().get(iProgramVar));
            } else if (unmodifiableTransFormula.getOutVars().containsKey(iProgramVar)) {
                hashMap.put(iProgramVar, (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar));
            }
            if (!unmodifiableTransFormula.getOutVars().containsKey(iProgramVar)) continue;
            hashMap2.put(iProgramVar, (TermVariable)unmodifiableTransFormula.getOutVars().get(iProgramVar));
        }
        int n = unmodifiableTransFormula.getOutVars().size();
        Rational[][] rationalArray = QvasrUtils.getIdentityMatrix(n);
        QvasrAbstraction qvasrAbstraction = new QvasrAbstraction(rationalArray, new Qvasr());
        Term term2 = unmodifiableTransFormula.getFormula();
        Term term3 = SmtUtils.toDnf((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mScript, (Term)term2);
        Set<Term> set = QvasrUtils.splitDisjunction(term3);
        for (Term term4 : set) {
            UnmodifiableTransFormula unmodifiableTransFormula2 = QvasrUtils.buildFormula(unmodifiableTransFormula, term4, this.mScript);
            QvasrAbstraction qvasrAbstraction2 = QvasrAbstractor.computeAbstraction(this.mServices, this.mScript, unmodifiableTransFormula2);
            qvasrAbstraction = (QvasrAbstraction)QvasrAbstractionJoin.join(this.mScript, qvasrAbstraction, qvasrAbstraction2).getThird();
        }
        if (qvasrAbstraction.getVasr().getTransformer().size() > 1) {
            this.mIsOverapprox = true;
        }
        term4 = new PredicateTransformer(this.mScript, (IDomainSpecificOperationProvider)new TermDomainOperationProvider(this.mServices, this.mScript));
        IntvasrAbstraction intvasrAbstraction = QvasrUtils.qvasrAbstractionToInt(qvasrAbstraction);
        return QvasrSummarizer.intVasrAbstractionToFormula(this.mScript, this.mServices, (PredicateTransformer<Term, IPredicate, TransFormula>)term4, unmodifiableTransFormula, intvasrAbstraction, hashMap, hashMap2);
    }

    public static UnmodifiableTransFormula intVasrAbstractionToFormula(ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer, UnmodifiableTransFormula unmodifiableTransFormula, IntvasrAbstraction intvasrAbstraction, Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        TransFormulaBuilder transFormulaBuilder;
        int term7;
        Term term;
        ArrayList<Object> arrayList;
        Term[] termArray2 = map.values().toArray(new Term[map.size()]);
        Term[] termArray3 = map2.values().toArray(new Term[map2.size()]);
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> termArray4 : map.entrySet()) {
            if (unmodifiableTransFormula.getOutVars().containsKey(termArray4.getKey())) {
                hashMap.put(termArray4.getKey().getTermVariable(), (TermVariable)unmodifiableTransFormula.getOutVars().get(termArray4.getKey()));
                continue;
            }
            hashMap.put(termArray4.getKey().getTermVariable(), termArray4.getValue());
        }
        Term[][] termArray = QvasrUtils.matrixVectorMultiplicationWithVariables(managedScript, intvasrAbstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(termArray2));
        Term[][] termArray5 = QvasrUtils.matrixVectorMultiplicationWithVariables(managedScript, intvasrAbstraction.getSimulationMatrix(), QvasrUtils.transposeRowToColumnTermVector(termArray3));
        ArrayList<Term> arrayList2 = new ArrayList<Term>();
        HashMap<Integer, TermVariable> hashMap2 = new HashMap<Integer, TermVariable>();
        int term4 = 0;
        while (term4 < intvasrAbstraction.getVasr().getDimension()) {
            arrayList = new HashSet();
            term = termArray[term4][0];
            boolean bl = false;
            term7 = 0;
            for (Pair<Integer[], Integer[]> pair : intvasrAbstraction.getVasr().getTransformer()) {
                Integer n = ((Integer[])pair.getFirst())[term4];
                Integer n2 = ((Integer[])pair.getSecond())[term4];
                if (n == 0) {
                    var23_36 = SmtUtils.binaryEquality((Script)managedScript.getScript(), (Term)termArray5[term4][0], (Term)managedScript.getScript().numeral(n2.toString()));
                    arrayList.add(var23_36);
                } else {
                    if (hashMap2.containsKey(term7)) {
                        var23_36 = (TermVariable)hashMap2.get(term7);
                    } else {
                        var23_36 = managedScript.constructFreshTermVariable("k", SmtSortUtils.getIntSort((ManagedScript)managedScript));
                        hashMap2.put(term7, var23_36);
                    }
                    Term term2 = SmtUtils.mul((Script)managedScript.getScript(), (String)"*", (Term[])new Term[]{managedScript.getScript().numeral(((Integer[])pair.getSecond())[term4].toString()), var23_36});
                    term = SmtUtils.sum((Script)managedScript.getScript(), (String)"+", (Term[])new Term[]{term, term2});
                    bl = true;
                }
                ++term7;
            }
            if (bl) {
                Term term8 = SmtUtils.binaryEquality((Script)managedScript.getScript(), (Term)termArray5[term4][0], (Term)term);
                arrayList.add(term8);
            }
            arrayList2.add(SmtUtils.or((Script)managedScript.getScript(), arrayList));
            ++term4;
        }
        for (Term unmodifiableTransFormula2 : hashMap2.values()) {
            term = SmtUtils.geq((Script)managedScript.getScript(), (Term)unmodifiableTransFormula2, (Term)managedScript.getScript().numeral("0"));
            arrayList2.add(term);
        }
        UnmodifiableTransFormula unmodifiableTransFormula2 = TransFormulaUtils.computeGuard((UnmodifiableTransFormula)unmodifiableTransFormula, (ManagedScript)managedScript, (IUltimateServiceProvider)iUltimateServiceProvider);
        arrayList = new ArrayList<Object>();
        if (QvasrUtils.isApplicationTerm(unmodifiableTransFormula2.getFormula())) {
            term = (ApplicationTerm)unmodifiableTransFormula2.getFormula();
            transFormulaBuilder = term.getParameters();
            int n = ((Term[])transFormulaBuilder).length;
            term7 = 0;
            while (term7 < n) {
                Term term6 = transFormulaBuilder[term7];
                if (term6 instanceof TermVariable) {
                    arrayList.add((TermVariable)term6);
                }
                ++term7;
            }
        }
        term = new BasicPredicate(0, managedScript.getScript().term("true", new Term[0]), Collections.emptySet(), Collections.emptySet(), managedScript.getScript().term("true", new Term[0]));
        Term term3 = (Term)predicateTransformer.strongestPostcondition((IAbstractPredicate)term, (ITransitionRelation)unmodifiableTransFormula);
        Term term5 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term3);
        arrayList2.add(term5);
        Term term9 = SmtUtils.and((Script)managedScript.getScript(), arrayList2);
        term9 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, hashMap2.values(), (Term)SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term9}));
        term9 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term9, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC);
        transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), true, null, true, null, true);
        transFormulaBuilder.setFormula(term9);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public boolean isOverapprox() {
        return this.mIsOverapprox;
    }
}

