/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.InterpolantComputationStatus;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.ITraceCheckPreferences;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.Counterexample;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolatingTraceCheck;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.InterpolationTechnique;
import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.singletracecheck.TraceCheckUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.InvariantSynthesisSettings;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.pathinvariants.PathInvariantsGenerator;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.SortedMap;

public class InterpolatingTraceCheckPathInvariantsWithFallback<LETTER extends IAction>
extends InterpolatingTraceCheck<LETTER> {
    private final NestedWord<LETTER> mNestedWord;
    private final IIcfg<?> mIcfg;
    private IStatisticsDataProvider mPathInvariantsStats;
    private InterpolantComputationStatus mInterpolantComputationStatus;
    private final InvariantSynthesisSettings mInvariantSynthesisSettings;

    public InterpolatingTraceCheckPathInvariantsWithFallback(IPredicate iPredicate, IPredicate iPredicate2, SortedMap<Integer, IPredicate> sortedMap, Counterexample<LETTER> counterexample, CfgSmtToolkit cfgSmtToolkit, ITraceCheckPreferences.AssertCodeBlockOrder assertCodeBlockOrder, IUltimateServiceProvider iUltimateServiceProvider, boolean bl, PredicateFactory predicateFactory, IPredicateUnifier iPredicateUnifier, InvariantSynthesisSettings invariantSynthesisSettings, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfg<?> iIcfg, boolean bl2) {
        super(iPredicate, iPredicate2, sortedMap, counterexample, iUltimateServiceProvider, cfgSmtToolkit, cfgSmtToolkit.getManagedScript(), predicateFactory, iPredicateUnifier, assertCodeBlockOrder, bl, bl2, simplificationTechnique);
        this.mNestedWord = counterexample.getWord();
        counterexample.requireControlConfigurations();
        this.mInvariantSynthesisSettings = invariantSynthesisSettings;
        this.mIcfg = iIcfg;
        if (super.isCorrect() == Script.LBool.UNSAT) {
            this.mTraceCheckFinished = true;
            this.cleanupAndUnlockSolver();
            this.computeInterpolants(InterpolationTechnique.PathInvariants);
            if (!this.mInterpolantComputationStatus.wasComputationSuccessful()) {
                String string = "trying to synthesize invariant for path program " + String.valueOf(this.mPathInvariantsStats);
                throw new ToolchainCanceledException("invariant synthesis failed", ((Object)((Object)this)).getClass(), string);
            }
        }
    }

    protected void computeInterpolants(InterpolationTechnique interpolationTechnique) {
        PathInvariantsGenerator<LETTER> pathInvariantsGenerator = new PathInvariantsGenerator<LETTER>(this.mServices, this.mNestedWord, this.mControlConfigurationSequence, super.getPrecondition(), super.getPostcondition(), this.mPredicateFactory, this.mPredicateUnifier, this.mIcfg, this.mInvariantSynthesisSettings, this.mSimplificationTechnique);
        this.mInterpolantComputationStatus = pathInvariantsGenerator.getInterpolantComputationStatus();
        IPredicate[] iPredicateArray = pathInvariantsGenerator.getInterpolants();
        if (iPredicateArray == null) {
            assert (!pathInvariantsGenerator.getInterpolantComputationStatus().wasComputationSuccessful()) : "null only allowed if computation was not successful";
        } else {
            if (iPredicateArray.length != this.mTrace.length() - 1) {
                throw new AssertionError((Object)"incorrect number of interpolants. There should be one interpolant between each two successive CodeBlocks");
            }
            assert (TraceCheckUtils.checkInterpolantsInductivityForward(Arrays.asList(iPredicateArray), (NestedWord)this.mTrace, (IPredicate)this.mPrecondition, (IPredicate)this.mPostcondition, (Map)this.mPendingContexts, (String)"invariant map", (CfgSmtToolkit)this.mCsToolkit, (ILogger)this.mLogger)) : "invalid Hoare triple in invariant map";
        }
        this.mInterpolants = iPredicateArray;
        this.mPathInvariantsStats = pathInvariantsGenerator.getStatistics();
    }

    public InterpolantComputationStatus getInterpolantComputationStatus() {
        return this.mInterpolantComputationStatus;
    }

    public IStatisticsDataProvider getPathInvariantsStats() {
        return this.mPathInvariantsStats;
    }
}

