/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library;

import de.uni_freiburg.informatik.ultimate.boogie.ExpressionFactory;
import de.uni_freiburg.informatik.ultimate.boogie.ast.ASTType;
import de.uni_freiburg.informatik.ultimate.boogie.ast.AssumeStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.LocationFactory;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.IDispatcher;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.LocalLValueILocationPair;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryArea;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.MemoryHandler;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler.TypeSizeAndOffsetComputer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.expressiontranslation.ExpressionTranslation;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.FunctionModelHelper;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.library.ILibraryModel;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfo;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.AuxVarInfoBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPointer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultBuilder;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.ExpressionResultTransformer;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.LocalLValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.RValue;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.Result;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.SkipResult;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.SFO;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.eclipse.cdt.core.dom.ast.IASTFunctionCallExpression;
import org.eclipse.cdt.core.dom.ast.IASTInitializerClause;
import org.eclipse.cdt.core.dom.ast.IASTNode;

public class GccBuiltinLibraryModel
implements ILibraryModel {
    private final FunctionModelHelper mHelper;
    private final ExpressionResultTransformer mExprResultTransformer;
    private final ExpressionTranslation mExpressionTranslation;
    private final AuxVarInfoBuilder mAuxVarInfoBuilder;
    private final MemoryHandler mMemoryHandler;
    private final TypeSizeAndOffsetComputer mTypeSizeComputer;

    public GccBuiltinLibraryModel(FunctionModelHelper functionModelHelper, ExpressionResultTransformer expressionResultTransformer, ExpressionTranslation expressionTranslation, AuxVarInfoBuilder auxVarInfoBuilder, MemoryHandler memoryHandler, TypeSizeAndOffsetComputer typeSizeAndOffsetComputer) {
        this.mHelper = functionModelHelper;
        this.mExprResultTransformer = expressionResultTransformer;
        this.mExpressionTranslation = expressionTranslation;
        this.mAuxVarInfoBuilder = auxVarInfoBuilder;
        this.mMemoryHandler = memoryHandler;
        this.mTypeSizeComputer = typeSizeAndOffsetComputer;
    }

    @Override
    public Collection<ILibraryModel.FunctionModel> getFunctionModels() {
        ArrayList<ILibraryModel.FunctionModel> arrayList = new ArrayList<ILibraryModel.FunctionModel>();
        arrayList.add(new ILibraryModel.FunctionModel("alloca", this::handleAlloc));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_alloca", this::handleAlloc));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_return_address", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, CPointer.voidPointer())));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_bswap16", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.USHORT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_bswap32", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_bswap64", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_constant_p", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.BOOL))));
        ILibraryModel.IFunctionModelHandler iFunctionModelHandler = (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.mHelper.handleByOverapproximation(iDispatcher, iASTFunctionCallExpression, iLocation, string, 3, new CPrimitive(CPrimitive.CPrimitives.BOOL));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_sadd_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_saddl_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_saddll_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_uadd_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_uaddl_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_uaddll_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 4, new CPrimitive(CPrimitive.CPrimitives.ULONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_ssub_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 5, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_ssubl_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 5, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_ssubll_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 5, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_usub_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 5, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_usubl_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 5, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_usubll_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 5, new CPrimitive(CPrimitive.CPrimitives.ULONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_smul_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.INT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_smull_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.LONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_smulll_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.LONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_umul_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.UINT))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_umull_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.ULONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_umulll_overflow", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> this.handleBuiltinOverflow(iDispatcher, iASTFunctionCallExpression, iLocation, string, 1, new CPrimitive(CPrimitive.CPrimitives.ULONGLONG))));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_add_overflow_p", iFunctionModelHandler));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_sub_overflow_p", iFunctionModelHandler));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_mul_overflow_p", iFunctionModelHandler));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_prefetch", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> new SkipResult()));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_expect", this::handleBuiltinExpect));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_unreachable", (iDispatcher, iASTFunctionCallExpression, iLocation, string) -> GccBuiltinLibraryModel.handleBuiltinUnreachable(iLocation)));
        arrayList.add(new ILibraryModel.FunctionModel("__builtin_object_size", this::handleBuiltinObjectSize));
        return arrayList;
    }

    @Override
    public Collection<String> getUnsupportedFunctions() {
        return List.of("__builtin_popcount", "__builtin_popcountl", "__builtin_popcountll", "__builtin_add_overflow", "__builtin_mul_overflow", "__builtin_sub_overflow");
    }

    private static Result handleBuiltinUnreachable(ILocation iLocation) {
        return new ExpressionResult(List.of(new AssumeStatement(iLocation, (Expression)ExpressionFactory.createBooleanLiteral((ILocation)iLocation, (boolean)false))), null);
    }

    private Result handleBuiltinExpect(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]);
        return new ExpressionResultBuilder().addAllExceptLrValue(expressionResult, expressionResult2).setLrValue(expressionResult.getLrValue()).build();
    }

    private Result handleBuiltinOverflow(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string, int n, CPrimitive cPrimitive) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 3, string, iASTInitializerClauseArray);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder();
        ExpressionResult expressionResult = this.mExprResultTransformer.convertIfNecessary(iLocation, this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]), cPrimitive);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.convertIfNecessary(iLocation, this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[1]), cPrimitive);
        expressionResultBuilder.addAllExceptLrValue(expressionResult, expressionResult2);
        Pair<Expression, ASTType> pair = this.mExpressionTranslation.constructInfinitePrecisionOperation(iLocation, n, expressionResult.getLrValue().getValue(), expressionResult2.getLrValue().getValue(), cPrimitive);
        Expression expression = (Expression)pair.getFirst();
        ASTType aSTType = (ASTType)pair.getSecond();
        ExpressionResult expressionResult3 = this.mExprResultTransformer.dispatchPointerLValue(iDispatcher, iLocation, (IASTNode)iASTInitializerClauseArray[2]);
        expressionResultBuilder.addAllExceptLrValue(expressionResult3);
        expressionResultBuilder.addAllExceptLrValue(this.mExprResultTransformer.makePointerAssignment(iLocation, expressionResult3.getLrValue(), this.mExpressionTranslation.convertInfinitePrecisionExpression(iLocation, expression, cPrimitive)));
        Expression expression2 = this.mExpressionTranslation.checkInRangeInfinitePrecision(iLocation, expression, aSTType, cPrimitive);
        CPrimitive cPrimitive2 = new CPrimitive(CPrimitive.CPrimitives.BOOL);
        Expression expression3 = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ZERO);
        Expression expression4 = this.mExpressionTranslation.constructLiteralForIntegerType(iLocation, cPrimitive2, BigInteger.ONE);
        Expression expression5 = ExpressionFactory.constructIfThenElseExpression((ILocation)iLocation, (Expression)expression2, (Expression)expression3, (Expression)expression4);
        return expressionResultBuilder.setLrValue(new RValue(expression5, cPrimitive2)).build();
    }

    private Result handleBuiltinObjectSize(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 2, string, iASTInitializerClauseArray);
        return this.mHelper.constructOverapproximationForFunctionCall(iLocation, string, new CPrimitive(CPrimitive.CPrimitives.INT));
    }

    private Result handleAlloc(IDispatcher iDispatcher, IASTFunctionCallExpression iASTFunctionCallExpression, ILocation iLocation, String string) {
        IASTInitializerClause[] iASTInitializerClauseArray = iASTFunctionCallExpression.getArguments();
        this.mHelper.checkArguments(iLocation, 1, string, iASTInitializerClauseArray);
        ExpressionResult expressionResult = this.mExprResultTransformer.transformDispatchDecaySwitchRexBoolToInt(iDispatcher, iLocation, iASTInitializerClauseArray[0]);
        ExpressionResult expressionResult2 = this.mExprResultTransformer.performImplicitConversion(expressionResult, this.mTypeSizeComputer.getSizeT(), iLocation);
        ExpressionResultBuilder expressionResultBuilder = new ExpressionResultBuilder().addAllExceptLrValue(expressionResult2);
        CPointer cPointer = CPointer.voidPointer();
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPointer, SFO.AUXVAR.MALLOC);
        expressionResultBuilder.addAuxVarWithDeclaration(auxVarInfo);
        expressionResultBuilder.addStatement((Statement)this.mMemoryHandler.getUltimateMemAllocCall(expressionResult2.getLrValue().getValue(), auxVarInfo.getLhs(), iLocation, MemoryArea.STACK));
        expressionResultBuilder.setLrValue(new RValue((Expression)auxVarInfo.getExp(), cPointer));
        LocalLValue localLValue = new LocalLValue((LeftHandSide)auxVarInfo.getLhs(), (ICType)cPointer, null);
        this.mMemoryHandler.addVariableToBeFreed(new LocalLValueILocationPair(localLValue, LocationFactory.createIgnoreLocation(iLocation)));
        expressionResultBuilder.clearAuxVars();
        return expressionResultBuilder.build();
    }

    @Override
    public Collection<ILibraryModel.TypeModel> getTypeModels() {
        return List.of(new ILibraryModel.TypeModel("__float128", new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE)));
    }

    private ExpressionResult handleFunction(ILocation iLocation) {
        CPointer cPointer = new CPointer(new CPrimitive(CPrimitive.CPrimitives.CHAR));
        AuxVarInfo auxVarInfo = this.mAuxVarInfoBuilder.constructAuxVarInfo(iLocation, cPointer, SFO.AUXVAR.NONDET);
        RValue rValue = new RValue((Expression)auxVarInfo.getExp(), cPointer);
        return new ExpressionResult(List.of(), rValue, List.of(auxVarInfo.getVarDec()), Set.of(auxVarInfo));
    }

    private ILibraryModel.ConstantModel modelSizeofConstant(String string, ICType iCType) {
        return new ILibraryModel.ConstantModel(string, iLocation -> new ExpressionResult(new RValue(this.mTypeSizeComputer.constructBytesizeExpression(iLocation, iCType), iCType)));
    }

    @Override
    public Collection<ILibraryModel.ConstantModel> getConstantModels() {
        return List.of(new ILibraryModel.ConstantModel("__PRETTY_FUNCTION__", this::handleFunction), new ILibraryModel.ConstantModel("__FUNCTION__", this::handleFunction), new ILibraryModel.ConstantModel("__func__", this::handleFunction), this.modelSizeofConstant("__SIZEOF_INT__", new CPrimitive(CPrimitive.CPrimitives.INT)), this.modelSizeofConstant("__SIZEOF_LONG__", new CPrimitive(CPrimitive.CPrimitives.LONG)), this.modelSizeofConstant("__SIZEOF_LONG_LONG__", new CPrimitive(CPrimitive.CPrimitives.LONGLONG)), this.modelSizeofConstant("__SIZEOF_SHORT__", new CPrimitive(CPrimitive.CPrimitives.SHORT)), this.modelSizeofConstant("__SIZEOF_POINTER__", CPointer.voidPointer()), this.modelSizeofConstant("__SIZEOF_FLOAT__", new CPrimitive(CPrimitive.CPrimitives.FLOAT)), this.modelSizeofConstant("__SIZEOF_DOUBLE__", new CPrimitive(CPrimitive.CPrimitives.DOUBLE)), this.modelSizeofConstant("__SIZEOF_LONG_DOUBLE__", new CPrimitive(CPrimitive.CPrimitives.LONGDOUBLE)), this.modelSizeofConstant("__SIZEOF_SIZE_T__", this.mTypeSizeComputer.getSizeT()), this.modelSizeofConstant("__SIZEOF_INT128__", new CPrimitive(CPrimitive.CPrimitives.INT128)));
    }
}

