/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar;

import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.ExactInfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.Explainer;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.InfinitesimalNumber;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LAReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinArSolve;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LinVar;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.LiteralReason;
import de.uni_freiburg.informatik.ultimate.smtinterpol.theory.linar.MatrixEntry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class SOIPivoter {
    LinArSolve mSolver;
    ArrayList<LiteralReason> mOOBs;
    SortedMap<LinVar, Rational> mSOIVar;
    ExactInfinitesimalNumber mSOIValue;
    FreedomLimiter mBestLimiter;

    public SOIPivoter(LinArSolve linArSolve) {
        this.mSolver = linArSolve;
    }

    public boolean computeSOI() {
        boolean bl = false;
        this.mSOIValue = ExactInfinitesimalNumber.ZERO;
        this.mSOIVar = new TreeMap<LinVar, Rational>();
        this.mOOBs = new ArrayList();
        for (LinVar linVar : this.mSolver.mLinvars) {
            Rational rational;
            LinVar linVar2;
            boolean bl2;
            ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue().isub(linVar.getLowerBound());
            if (exactInfinitesimalNumber.signum() > 0) {
                bl2 = false;
            } else {
                exactInfinitesimalNumber = linVar.getValue().isub(linVar.getUpperBound()).negate();
                if (exactInfinitesimalNumber.signum() <= 0) continue;
                bl2 = true;
            }
            assert (linVar.mBasic);
            bl = true;
            this.mOOBs.add(bl2 ? linVar.mUpperLiteral : linVar.mLowerLiteral);
            this.mSOIValue = this.mSOIValue.add(exactInfinitesimalNumber);
            BigInteger bigInteger = this.mSolver.mTableaux.get(linVar.mMatrixpos).getRawCoeff(0);
            if (bl2) {
                bigInteger = bigInteger.negate();
            }
            boolean bl3 = true;
            for (MatrixEntry matrixEntry : linVar.getTableauxRow(this.mSolver)) {
                Rational rational2;
                LiteralReason literalReason;
                linVar2 = matrixEntry.getColumn();
                rational = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)bigInteger);
                LiteralReason literalReason2 = literalReason = rational.signum() < 0 ? linVar2.mUpperLiteral : linVar2.mLowerLiteral;
                if (literalReason == null || !linVar2.getValue().equals(literalReason.getBound())) {
                    bl3 = false;
                }
                if ((rational2 = (Rational)this.mSOIVar.get(linVar2)) != null) {
                    rational = rational.add(rational2);
                }
                this.mSOIVar.put(linVar2, rational);
            }
            if (!bl3) continue;
            this.mOOBs.clear();
            this.mOOBs.add(bl2 ? linVar.mUpperLiteral : linVar.mLowerLiteral);
            this.mSOIValue = exactInfinitesimalNumber;
            this.mSOIVar.clear();
            for (MatrixEntry matrixEntry : linVar.getTableauxRow(this.mSolver)) {
                linVar2 = matrixEntry.getColumn();
                rational = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)bigInteger);
                this.mSOIVar.put(linVar2, rational);
            }
            return true;
        }
        return bl;
    }

    public boolean checkZeroFreedom() {
        boolean bl = true;
        this.mBestLimiter = null;
        block0: for (Map.Entry<LinVar, Rational> entry : this.mSOIVar.entrySet()) {
            LinVar linVar = entry.getKey();
            Rational rational = entry.getValue();
            if (rational.signum() == 0 || linVar.getValue().equals(rational.signum() < 0 ? linVar.getUpperBound() : linVar.getLowerBound())) continue;
            for (MatrixEntry matrixEntry : linVar.getTableauxColumn(this.mSolver)) {
                LiteralReason literalReason;
                LinVar linVar2 = matrixEntry.getRow();
                Rational rational2 = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)matrixEntry.getHeadCoeff().negate());
                LiteralReason literalReason2 = literalReason = rational2.signum() == rational.signum() ? linVar2.mLowerLiteral : linVar2.mUpperLiteral;
                if (literalReason == null || !linVar2.getValue().equals(new ExactInfinitesimalNumber(literalReason.getBound()))) continue;
                if (bl && (this.mBestLimiter == null || this.mBestLimiter.getRowVar().compareTo(linVar2) > 0)) {
                    this.mBestLimiter = new FreedomLimiter(ExactInfinitesimalNumber.ZERO, rational2, literalReason.getBound(), linVar2, linVar);
                }
                if (rational2.signum() == rational.signum()) {
                    rational2.negate();
                }
                if ((rational = rational.add(rational2)).signum() == -rational2.signum()) continue;
                bl = false;
                continue block0;
            }
            this.mBestLimiter = null;
            return false;
        }
        assert (bl || this.mBestLimiter != null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public boolean findPivot() {
        Comparable<ExactInfinitesimalNumber> comparable = new ExactInfinitesimalNumber(Rational.MONE);
        this.mBestLimiter = null;
        for (Map.Entry<LinVar, Rational> entry : this.mSOIVar.entrySet()) {
            void object2;
            Comparable<LinVar> comparable2;
            InfinitesimalNumber infinitesimalNumber;
            LinVar linVar = entry.getKey();
            Rational rational = entry.getValue();
            if (rational.signum() == 0) continue;
            InfinitesimalNumber infinitesimalNumber2 = infinitesimalNumber = rational.signum() < 0 ? linVar.getUpperBound() : linVar.getLowerBound();
            if (linVar.getValue().equals(infinitesimalNumber)) continue;
            TreeMap<ExactInfinitesimalNumber, FreedomLimiter> treeMap = new TreeMap<ExactInfinitesimalNumber, FreedomLimiter>();
            if (!infinitesimalNumber.isInfinity()) {
                ExactInfinitesimalNumber exactInfinitesimalNumber = linVar.getValue().isub(infinitesimalNumber).abs();
                treeMap.put(exactInfinitesimalNumber, new FreedomLimiter(exactInfinitesimalNumber, Rational.ONE, infinitesimalNumber, linVar, linVar));
            }
            for (MatrixEntry matrixEntry : linVar.getTableauxColumn(this.mSolver)) {
                FreedomLimiter freedomLimiter;
                ExactInfinitesimalNumber exactInfinitesimalNumber;
                ExactInfinitesimalNumber exactInfinitesimalNumber2;
                Object object;
                comparable2 = matrixEntry.getRow();
                Object object3 = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)matrixEntry.getHeadCoeff());
                if (rational.signum() < 0) {
                    object3 = object3.negate();
                }
                if (((LinVar)comparable2).mLowerLiteral != null) {
                    object = ((LinVar)comparable2).mLowerLiteral.getBound();
                    exactInfinitesimalNumber2 = ((LinVar)comparable2).getValue().isub((InfinitesimalNumber)object);
                    if (object3.signum() * (2 * exactInfinitesimalNumber2.signum() - 1) > 0) {
                        exactInfinitesimalNumber = exactInfinitesimalNumber2.div((Rational)object3);
                        assert (exactInfinitesimalNumber.signum() >= 0);
                        freedomLimiter = (FreedomLimiter)treeMap.get(exactInfinitesimalNumber);
                        if (freedomLimiter != null) {
                            freedomLimiter.merge((Rational)object3, (InfinitesimalNumber)object, (LinVar)comparable2);
                        } else {
                            treeMap.put(exactInfinitesimalNumber, new FreedomLimiter(exactInfinitesimalNumber, (Rational)object3, (InfinitesimalNumber)object, (LinVar)comparable2, linVar));
                        }
                    }
                }
                if (((LinVar)comparable2).mUpperLiteral == null) continue;
                object = ((LinVar)comparable2).mUpperLiteral.getBound();
                exactInfinitesimalNumber2 = ((LinVar)comparable2).getValue().isub((InfinitesimalNumber)object);
                if (object3.signum() * (2 * exactInfinitesimalNumber2.signum() + 1) <= 0) continue;
                exactInfinitesimalNumber = exactInfinitesimalNumber2.div((Rational)object3);
                assert (exactInfinitesimalNumber.signum() >= 0);
                freedomLimiter = (FreedomLimiter)treeMap.get(exactInfinitesimalNumber);
                if (freedomLimiter != null) {
                    freedomLimiter.merge((Rational)object3, (InfinitesimalNumber)object, (LinVar)comparable2);
                    continue;
                }
                treeMap.put(exactInfinitesimalNumber, new FreedomLimiter(exactInfinitesimalNumber, (Rational)object3, (InfinitesimalNumber)object, (LinVar)comparable2, linVar));
            }
            Rational rational2 = rational.abs();
            Object object = new ExactInfinitesimalNumber(Rational.ZERO);
            comparable2 = new ExactInfinitesimalNumber(Rational.ZERO);
            for (Object object3 : treeMap.values()) {
                comparable2 = ((ExactInfinitesimalNumber)comparable2).add(((FreedomLimiter)object3).mFreedom.sub((ExactInfinitesimalNumber)object).mul((Rational)object2));
                object = ((FreedomLimiter)object3).mFreedom;
                Rational rational3 = object2.sub(((FreedomLimiter)object3).getWeight());
                if (rational3.signum() > 0) continue;
                if (((ExactInfinitesimalNumber)comparable).compareTo((ExactInfinitesimalNumber)comparable2) >= 0) break;
                comparable = comparable2;
                this.mBestLimiter = object3;
                if (!((ExactInfinitesimalNumber)comparable).equals(this.mSOIValue)) break;
                this.mSolver.getLogger().debug("Solved it!", comparable);
                return true;
            }
            assert (object2.signum() <= 0);
        }
        this.mSolver.getLogger().debug("Best Candidate: (%s)", comparable);
        return this.mBestLimiter != null;
    }

    private boolean isRedundant(LiteralReason literalReason) {
        LinVar linVar = literalReason.getVar();
        BigInteger bigInteger = this.mSolver.mTableaux.get(linVar.mMatrixpos).getRawCoeff(0);
        if (!literalReason.isUpper()) {
            bigInteger = bigInteger.negate();
        }
        for (MatrixEntry matrixEntry : linVar.getTableauxRow(this.mSolver)) {
            InfinitesimalNumber infinitesimalNumber;
            LinVar linVar2 = matrixEntry.getColumn();
            Rational rational = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)bigInteger);
            Rational rational2 = (Rational)this.mSOIVar.get(linVar2);
            if (rational2 != null) {
                rational = rational.add(rational2);
            }
            InfinitesimalNumber infinitesimalNumber2 = infinitesimalNumber = rational.signum() < 0 ? linVar2.getUpperBound() : linVar2.getLowerBound();
            if (linVar2.getValue().equals(infinitesimalNumber)) continue;
            return false;
        }
        return true;
    }

    public Clause computeConflict() {
        Object object;
        Object object3;
        assert (this.mSOIValue.signum() > 0);
        Object object4 = this.mOOBs.iterator();
        while (object4.hasNext()) {
            object3 = object4.next();
            if (this.mOOBs.size() <= 1 || !this.isRedundant((LiteralReason)object3)) continue;
            LinVar object5 = ((LAReason)object3).getVar();
            this.mSOIValue = this.mSOIValue.sub(((LAReason)object3).getBound().sub(object5.getValue()).abs());
            assert (this.mSOIValue.signum() > 0);
            Object object2 = this.mSolver.mTableaux.get(object5.mMatrixpos).getRawCoeff(0);
            if (!((LAReason)object3).isUpper()) {
                object2 = ((BigInteger)object2).negate();
            }
            for (MatrixEntry matrixEntry : object5.getTableauxRow(this.mSolver)) {
                object = matrixEntry.getColumn();
                Rational rational = Rational.valueOf((BigInteger)matrixEntry.getCoeff(), (BigInteger)object2);
                Rational rational2 = (Rational)this.mSOIVar.get(object);
                if (rational2 != null) {
                    rational = rational.add(rational2);
                }
                this.mSOIVar.put((LinVar)object, rational);
            }
            object4.remove();
        }
        object4 = new Explainer(this.mSolver, this.mSolver.getEngine().isProofGenerationEnabled(), null);
        object3 = this.mSOIValue.roundToInfinitesimal();
        for (LiteralReason literalReason : this.mOOBs) {
            Rational rational;
            Rational rational3 = rational = literalReason.isUpper() ? Rational.ONE : Rational.MONE;
            assert (((InfinitesimalNumber)object3).signum() > 0);
            object3 = literalReason.explain((Explainer)object4, (InfinitesimalNumber)object3, rational);
            assert (((InfinitesimalNumber)object3).signum() > 0);
        }
        for (Map.Entry entry : this.mSOIVar.entrySet()) {
            LinVar linVar = (LinVar)entry.getKey();
            Rational rational = (Rational)entry.getValue();
            if (rational.signum() == 0) continue;
            Object object5 = object = rational.signum() < 0 ? linVar.mUpperLiteral : linVar.mLowerLiteral;
            assert (linVar.getValue().equals(((LAReason)object).getBound()));
            object3 = ((InfinitesimalNumber)object3).div(rational.abs());
            assert (((InfinitesimalNumber)object3).signum() > 0);
            object3 = ((LiteralReason)object).explain((Explainer)object4, (InfinitesimalNumber)object3, rational.negate());
            assert (((InfinitesimalNumber)object3).signum() > 0);
            object3 = ((InfinitesimalNumber)object3).mul(rational.abs());
        }
        assert (((Explainer)object4).checkSlack((InfinitesimalNumber)object3));
        return ((Explainer)object4).createClause(this.mSolver.getEngine());
    }

    public Clause fixOobs() {
        this.mSolver.getLogger().debug("=== fixoobs ===");
        while (this.computeSOI()) {
            if (this.mSolver.getLogger().isDebugEnabled()) {
                this.mSolver.getLogger().debug("SOI: %s.%04d", this.mSOIValue.getRealValue().floor(), this.mSOIValue.getRealValue().frac().mul(BigInteger.valueOf(10000L)).floor().numerator().intValue());
            }
            if (!this.findPivot()) {
                return this.computeConflict();
            }
            int n = 0;
            while (this.mBestLimiter.mFreedom.signum() == 0) {
                this.mSolver.pivot(this.mBestLimiter.getRowVar().mMatrixpos, this.mBestLimiter.getColumnVar().mMatrixpos);
                ++this.mSolver.mNumPivotsBland;
                ++n;
                this.computeSOI();
                if (this.checkZeroFreedom()) {
                    if (this.mBestLimiter != null) continue;
                    this.mSolver.getLogger().debug("Conflict after %d Bland pivot steps", n);
                    return this.computeConflict();
                }
                this.mSolver.getLogger().debug("Finished %d Bland pivot steps", n);
                this.findPivot();
                assert (this.mBestLimiter.mFreedom.signum() > 0);
            }
            if (this.mBestLimiter.getRowVar() != this.mBestLimiter.getColumnVar()) {
                this.mSolver.pivot(this.mBestLimiter.getRowVar().mMatrixpos, this.mBestLimiter.getColumnVar().mMatrixpos);
            }
            this.mSolver.updateVariableValue(this.mBestLimiter.getRowVar(), new ExactInfinitesimalNumber(this.mBestLimiter.mBound));
        }
        return null;
    }

    private static class FreedomLimiter {
        ExactInfinitesimalNumber mFreedom;
        Rational mWeight;
        InfinitesimalNumber mBound;
        LinVar mRow;
        LinVar mColumn;

        public FreedomLimiter(ExactInfinitesimalNumber exactInfinitesimalNumber, Rational rational, InfinitesimalNumber infinitesimalNumber, LinVar linVar, LinVar linVar2) {
            assert (exactInfinitesimalNumber.signum() >= 0);
            this.mFreedom = exactInfinitesimalNumber;
            this.mWeight = rational.abs();
            this.mBound = infinitesimalNumber;
            this.mRow = linVar;
            this.mColumn = linVar2;
        }

        public void merge(Rational rational, InfinitesimalNumber infinitesimalNumber, LinVar linVar) {
            this.mWeight = this.mWeight.add(rational.abs());
            if (this.mRow.compareTo(linVar) > 0) {
                this.mRow = linVar;
                this.mBound = infinitesimalNumber;
            }
        }

        public Rational getWeight() {
            return this.mWeight;
        }

        public LinVar getRowVar() {
            return this.mRow;
        }

        public LinVar getColumnVar() {
            return this.mColumn;
        }

        public String toString() {
            return "Freedom[" + String.valueOf(this.mFreedom) + ",(" + String.valueOf(this.getRowVar()) + ")," + String.valueOf(this.mWeight) + "]";
        }
    }
}

