/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.LoopStatement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class LoopForBehavior
extends ACSLNode {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(LoopForBehavior.class);
    String[] behaviorNames;
    LoopStatement[] behaviorStmt;

    public LoopForBehavior(String[] stringArray, LoopStatement[] loopStatementArray) {
        this.behaviorNames = stringArray;
        this.behaviorStmt = loopStatementArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid LoopForBehavior: " + String.valueOf(this);
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("LoopForBehavior").append('[');
        if (this.behaviorNames == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.behaviorNames.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.behaviorNames[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',');
        if (this.behaviorStmt == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.behaviorStmt.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append(this.behaviorStmt[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String[] getBehaviorNames() {
        return this.behaviorNames;
    }

    public LoopStatement[] getBehaviorStmt() {
        return this.behaviorStmt;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        if (this.behaviorStmt != null) {
            list.addAll(Arrays.asList(this.behaviorStmt));
        }
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (aCSLVisitor.visit(this) && this.behaviorStmt != null) {
            LoopStatement[] loopStatementArray = this.behaviorStmt;
            int n = this.behaviorStmt.length;
            int n2 = 0;
            while (n2 < n) {
                LoopStatement loopStatement = loopStatementArray[n2];
                loopStatement.accept(aCSLVisitor);
                ++n2;
            }
        }
    }

    @Override
    public LoopForBehavior accept(ACSLTransformer aCSLTransformer) {
        LoopForBehavior loopForBehavior = aCSLTransformer.transform(this);
        if (loopForBehavior != this) {
            return loopForBehavior;
        }
        boolean bl = false;
        ArrayList<LoopStatement> arrayList = new ArrayList<LoopStatement>();
        if (this.behaviorStmt != null) {
            LoopStatement[] loopStatementArray = this.behaviorStmt;
            int n = this.behaviorStmt.length;
            int n2 = 0;
            while (n2 < n) {
                LoopStatement loopStatement = loopStatementArray[n2];
                LoopStatement loopStatement2 = loopStatement.accept(aCSLTransformer);
                bl = bl || loopStatement2 != loopStatement;
                arrayList.add(loopStatement2);
                ++n2;
            }
        }
        if (bl) {
            return new LoopForBehavior(this.behaviorNames, arrayList.toArray(new LoopStatement[0]));
        }
        return this;
    }
}

