/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers;

import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TransformerPreprocessor;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.Util;

public class RemoveNegation
extends TransformerPreprocessor {
    public static final String DESCRIPTION = "Remove negation before atoms";

    @Override
    public String getDescription() {
        return DESCRIPTION;
    }

    @Override
    public boolean checkSoundness(Script script, ModifiableTransFormula modifiableTransFormula, ModifiableTransFormula modifiableTransFormula2) {
        Term term = modifiableTransFormula.getFormula();
        Term term2 = modifiableTransFormula2.getFormula();
        return Script.LBool.SAT != Util.checkSat((Script)script, (Term)script.term("distinct", new Term[]{term, term2}));
    }

    @Override
    protected TermTransformer getTransformer(ManagedScript managedScript) {
        return new RemoveNegationTransformer(managedScript.getScript());
    }

    private static final class RemoveNegationTransformer
    extends TermTransformer {
        private final Script mScript;

        RemoveNegationTransformer(Script script) {
            assert (script != null);
            this.mScript = script;
        }

        protected void convert(Term term) {
            if (!(term instanceof ApplicationTerm)) {
                super.convert(term);
                return;
            }
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (!"not".equals(applicationTerm.getFunction().getName())) {
                super.convert(term);
                return;
            }
            assert (applicationTerm.getParameters().length == 1);
            Term term2 = applicationTerm.getParameters()[0];
            if (!(term2 instanceof ApplicationTerm)) {
                super.convert(term);
                return;
            }
            ApplicationTerm applicationTerm2 = (ApplicationTerm)term2;
            String string = applicationTerm2.getFunction().getName();
            if ("<=".equals(string)) {
                this.setResult(this.mScript.term(">", applicationTerm2.getParameters()));
            } else if ("<".equals(string)) {
                this.setResult(this.mScript.term(">=", applicationTerm2.getParameters()));
            } else if (">=".equals(string)) {
                this.setResult(this.mScript.term("<", applicationTerm2.getParameters()));
            } else if (">".equals(string)) {
                this.setResult(this.mScript.term("<=", applicationTerm2.getParameters()));
            } else {
                this.setResult(term);
            }
        }
    }
}

