/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import java.util.Arrays;

public class ResolutionNode
extends ProofNode {
    private final Clause mPrimary;
    private final Antecedent[] mAntecedents;

    public ResolutionNode(Clause clause, Antecedent[] antecedentArray) {
        assert (clause != null);
        this.mPrimary = clause;
        this.mAntecedents = antecedentArray;
    }

    @Override
    public boolean isLeaf() {
        return false;
    }

    public Clause getPrimary() {
        return this.mPrimary;
    }

    public Antecedent[] getAntecedents() {
        return this.mAntecedents;
    }

    public String toString() {
        return String.valueOf(this.mPrimary) + " => " + Arrays.toString(this.mAntecedents);
    }

    public static class Antecedent {
        public final Literal mPivot;
        public final Clause mAntecedent;

        public Antecedent(Literal literal, Clause clause) {
            assert (literal != null);
            assert (clause != null);
            assert (clause.contains(literal));
            this.mPivot = literal;
            this.mAntecedent = clause;
        }

        public String toString() {
            return this.mPivot.toString() + " => " + String.valueOf(this.mAntecedent);
        }
    }
}

