/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.tree.operations.minimization.performance;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.tree.TreeAutomatonBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.GetRandomDftaBU;
import de.uni_freiburg.informatik.ultimate.automata.tree.operations.GetRandomNftaBU;
import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;

public final class RandomTaBenchmarkCreator {
    public static final Path DEFAULT_PATH = Paths.get(System.getProperty("user.home"), "Desktop", "randomTaBenchmark");
    public static final int LOG_EVERY = 10;
    private static final int PERC_LOWER_BOUND = 0;
    private static final int PERC_TO_DOUBLE = 100;
    private static final int PERC_UPPER_BOUND = 100;
    private final float mAcceptance;
    private final boolean mCreateDeterministic;
    private String mPostamble;
    private String mPreamble;
    private final int[] mRankToAlphabetSize;
    private final int[] mRankToRulesPerLetter;
    private final AutomataLibraryServices mServices;
    private final int mSize;

    public static void main(String[] stringArray) throws IOException, AutomataOperationCanceledException {
        int[] nArray = new int[]{2, 1, 3, 1};
        int[] nArray2 = new int[]{3, 7, 2, 3};
        RandomTaBenchmarkCreator.createExplicitSet(20, nArray, 20.0f, nArray2, 100, 0, true);
    }

    private static void createExplicitSet(int n, int[] nArray, float f, int[] nArray2, int n2, int n3, boolean bl) throws IOException, AutomataOperationCanceledException {
        String string = switch (n3) {
            case 0 -> "compareTaMinimization(ta);";
            case 1 -> "minimizeNftaHopcroft(ta);";
            case 2 -> "minimize(ta);";
            default -> "";
        };
        String string2 = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date());
        String string3 = "// Random tree automaton dumped by RandomTaBenchmarkCreator at " + string2 + "\n// Author: Daniel Tischner {@literal <zabuza.dev@gmail.com>}\n\n" + string + "\n\nTreeAutomaton ta = ";
        RandomTaBenchmarkCreator randomTaBenchmarkCreator = new RandomTaBenchmarkCreator(n, nArray, f, nArray2, bl);
        randomTaBenchmarkCreator.setPreamble(string3);
        randomTaBenchmarkCreator.setPostamble(";");
        System.out.println("Starting automata generation.");
        String string4 = "#" + n2 + "_n" + n + "_k" + Arrays.toString(nArray) + "_f" + f + "%_r" + Arrays.toString(nArray2) + "_det" + bl;
        randomTaBenchmarkCreator.createAndSaveABenchmark(n2, string4);
        System.out.println("Finished automata generation.");
        System.out.println("Overview label:");
        System.out.println(string4);
    }

    private static float ensureIsPercentage(float f) throws IllegalArgumentException {
        if (f < 0.0f || f > 100.0f) {
            throw new IllegalArgumentException("The given value is no percentage: " + f);
        }
        return f;
    }

    private static double percentageToDouble(float f) {
        return f / 100.0f;
    }

    public RandomTaBenchmarkCreator(int n, int[] nArray, float f, int[] nArray2, boolean bl) throws IllegalArgumentException {
        this.mSize = n;
        this.mRankToAlphabetSize = nArray;
        this.mAcceptance = RandomTaBenchmarkCreator.ensureIsPercentage(f);
        this.mRankToRulesPerLetter = nArray2;
        this.mCreateDeterministic = bl;
        this.mServices = new AutomataLibraryServices((IUltimateServiceProvider)new ToolchainStorage());
        this.mPreamble = "";
    }

    public void createAndSaveABenchmark(int n) throws IOException, AutomataOperationCanceledException {
        this.createAndSaveABenchmark(n, DEFAULT_PATH, 10);
    }

    public void createAndSaveABenchmark(int n, Path path) throws IOException, AutomataOperationCanceledException {
        this.createAndSaveABenchmark(n, path, 10);
    }

    public void createAndSaveABenchmark(int n, Path path, int n2) throws IOException, AutomataOperationCanceledException {
        TreeAutomatonBU treeAutomatonBU = null;
        double d = RandomTaBenchmarkCreator.percentageToDouble(this.mAcceptance);
        String string = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String string2 = "randomTreeAutomata_" + string;
        if (!Files.exists(path, new LinkOption[0])) {
            Files.createDirectories(path, new FileAttribute[0]);
        } else if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new IllegalArgumentException("The provided path exists but is no directory: " + String.valueOf(path));
        }
        int n3 = 1;
        while (n3 <= n) {
            if (n3 % n2 == 0) {
                System.out.println("Created automata: " + n3);
            }
            long l = System.currentTimeMillis();
            treeAutomatonBU = this.mCreateDeterministic ? new GetRandomDftaBU(this.mServices, this.mSize, this.mRankToAlphabetSize, this.mRankToRulesPerLetter, d, l).getResult() : new GetRandomNftaBU(this.mServices, this.mSize, this.mRankToAlphabetSize, this.mRankToRulesPerLetter, d, l).getResult();
            if (n3 == 1) {
                System.out.println("#Rules: " + treeAutomatonBU.getAmountOfRules());
            }
            String string3 = "_" + n3;
            Path path2 = path.resolve(string2 + string3 + ".ats");
            Files.write(path2, Collections.singletonList(this.mPreamble + String.valueOf(treeAutomatonBU) + this.mPostamble), new OpenOption[0]);
            ++n3;
        }
    }

    public void createAndSaveABenchmark(int n, String string) throws IOException, AutomataOperationCanceledException {
        this.createAndSaveABenchmark(n, DEFAULT_PATH.resolve(string), 10);
    }

    public void setPostamble(String string) {
        this.mPostamble = string;
    }

    public void setPreamble(String string) {
        this.mPreamble = string;
    }
}

