/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.base.chandler;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.util.ISOIEC9899TC3;
import de.uni_freiburg.informatik.ultimate.plugins.generator.cacsl2boogietranslator.preferences.CACSLPreferenceInitializer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.math.BigInteger;

public class CCharacterConstant {
    private final String mSourceLiteral;
    private final BigInteger mNumericalValue;
    private final BigInteger mRepresentingValue;
    private final CACSLPreferenceInitializer.Signedness mSignednessOfChar;
    private final CACSLPreferenceInitializer.Signedness mSignednessOfRepresentingType;
    private final CPrimitive mType;

    public CCharacterConstant(String string, CACSLPreferenceInitializer.Signedness signedness) {
        this.mSourceLiteral = string;
        this.mSignednessOfChar = signedness;
        String string2 = switch (string.charAt(0)) {
            case '\'' -> {
                this.mType = new CPrimitive(CPrimitive.CPrimitives.INT);
                this.mSignednessOfRepresentingType = CACSLPreferenceInitializer.Signedness.SIGNED;
                yield string;
            }
            case 'L' -> {
                this.mType = new CPrimitive(CPrimitive.CPrimitives.INT);
                this.mSignednessOfRepresentingType = CACSLPreferenceInitializer.Signedness.SIGNED;
                yield string.substring(1);
            }
            case 'u' -> {
                this.mType = new CPrimitive(CPrimitive.CPrimitives.USHORT);
                this.mSignednessOfRepresentingType = CACSLPreferenceInitializer.Signedness.UNSIGNED;
                yield string.substring(1);
            }
            case 'U' -> {
                this.mType = new CPrimitive(CPrimitive.CPrimitives.UINT);
                this.mSignednessOfRepresentingType = CACSLPreferenceInitializer.Signedness.UNSIGNED;
                yield string.substring(1);
            }
            default -> throw new UnsupportedOperationException(string);
        };
        if (!string2.startsWith("'") || !string2.endsWith("'")) {
            throw new UnsupportedOperationException();
        }
        string2 = string2.substring(1, string2.length() - 1);
        Pair<BigInteger, String> pair = ISOIEC9899TC3.parseCharacterSequenceHelper(string2);
        this.mNumericalValue = (BigInteger)pair.getFirst();
        String string3 = (String)pair.getSecond();
        if (!string3.equals("")) {
            throw new UnsupportedOperationException("integer character constants that consist of several characters are not yet supported.");
        }
        this.mRepresentingValue = CCharacterConstant.computeRepresentingValue(this.mNumericalValue, signedness, this.mSignednessOfRepresentingType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static BigInteger computeRepresentingValue(BigInteger bigInteger, CACSLPreferenceInitializer.Signedness signedness, CACSLPreferenceInitializer.Signedness signedness2) {
        if (signedness != CACSLPreferenceInitializer.Signedness.SIGNED) return bigInteger;
        if (signedness2 != CACSLPreferenceInitializer.Signedness.SIGNED) return bigInteger;
        if (bigInteger.compareTo(BigInteger.valueOf(255L)) > 0) throw new UnsupportedOperationException("multibyte characters are not supported yet");
        return ISOIEC9899TC3.convertNumericalValueToByteValue(signedness, bigInteger);
    }

    public BigInteger getRepresentingValue() {
        return this.mRepresentingValue;
    }

    public CPrimitive getType() {
        return this.mType;
    }
}

