/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util;

import java.math.BigInteger;

public final class ArithmeticUtils {
    private ArithmeticUtils() {
    }

    public static BigInteger euclideanMod(BigInteger bigInteger, BigInteger bigInteger2) {
        return bigInteger.mod(bigInteger2.abs());
    }

    public static BigInteger euclideanDiv(BigInteger bigInteger, BigInteger bigInteger2) {
        BigInteger bigInteger3 = bigInteger.divide(bigInteger2);
        BigInteger bigInteger4 = bigInteger.remainder(bigInteger2);
        BigInteger bigInteger5 = bigInteger4.signum() < 0 ? (bigInteger2.signum() < 0 ? bigInteger3.add(BigInteger.ONE) : bigInteger3.subtract(BigInteger.ONE)) : bigInteger3;
        assert (bigInteger5.multiply(bigInteger2).add(ArithmeticUtils.euclideanMod(bigInteger, bigInteger2)).equals(bigInteger)) : "incorrect euclidean division";
        return bigInteger5;
    }

    public static BigInteger multiplicativeInverse(BigInteger bigInteger, BigInteger bigInteger2) {
        if (bigInteger2.compareTo(BigInteger.ONE) <= 0) {
            throw new IllegalArgumentException(String.format("Modulus must be strictly greater one but is %s", bigInteger2));
        }
        BigInteger bigInteger3 = ArithmeticUtils.euclideanMod(bigInteger, bigInteger2);
        BigInteger bigInteger4 = BigInteger.valueOf(0L);
        BigInteger bigInteger5 = bigInteger2;
        BigInteger bigInteger6 = BigInteger.valueOf(1L);
        BigInteger bigInteger7 = bigInteger3;
        while (!bigInteger7.equals(BigInteger.valueOf(0L))) {
            BigInteger bigInteger8 = bigInteger5.divide(bigInteger7);
            BigInteger bigInteger9 = bigInteger4;
            bigInteger4 = bigInteger6;
            bigInteger6 = bigInteger9.subtract(bigInteger8.multiply(bigInteger6));
            BigInteger bigInteger10 = bigInteger5;
            bigInteger5 = bigInteger7;
            bigInteger7 = bigInteger10.subtract(bigInteger8.multiply(bigInteger7));
        }
        if (bigInteger5.compareTo(BigInteger.valueOf(1L)) > 0) {
            throw new IllegalArgumentException(String.format("Input number %s and modulus %s are not coprime", bigInteger, bigInteger2));
        }
        BigInteger bigInteger11 = ArithmeticUtils.euclideanMod(bigInteger4, bigInteger2);
        assert (bigInteger11.multiply(bigInteger).mod(bigInteger2).equals(BigInteger.valueOf(1L)));
        return bigInteger11;
    }
}

