/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUnification;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TransFormulaUtils {
    public static final String TRANS_FORMULA_OF_RETURN_MUST_NOT_CONTAIN_AUX_VARS = "TransFormula of return must not contain auxVars";
    public static final String OLD_VAR_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS = "oldVarAssignments must not contain auxVars";
    public static final String GLOBAL_VARS_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS = "globalVarsAssignments must not contain auxVars";

    private TransFormulaUtils() {
    }

    public static Set<IProgramVar> computeAssignedVars(Map<IProgramVar, TermVariable> map, Map<IProgramVar, TermVariable> map2) {
        HashSet<IProgramVar> hashSet = new HashSet<IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> object : map2.entrySet()) {
            assert (object.getValue() != null);
            if (object.getValue() == map.get(object.getKey())) continue;
            hashSet.add(object.getKey());
        }
        for (IProgramVar iProgramVar : map.keySet()) {
            if (map2.containsKey(iProgramVar)) continue;
            hashSet.add(iProgramVar);
        }
        return hashSet;
    }

    public static UnmodifiableTransFormula sequentialComposition(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, boolean bl, boolean bl2, boolean bl3, SmtUtils.SimplificationTechnique simplificationTechnique, List<UnmodifiableTransFormula> list) {
        Object object2;
        if (iLogger.isDebugEnabled()) {
            iLogger.debug("sequential composition with%s formula simplification", new Object[]{bl ? "" : "out"});
        }
        Script script = managedScript.getScript();
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        Object object3 = managedScript.getScript().term("true", new Term[0]);
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(null, null, false, null, false, null, false);
        HashSet<IProgramConst> hashSet2 = new HashSet<IProgramConst>();
        HashMap<TermVariable, TermVariable> hashMap = new HashMap<TermVariable, TermVariable>();
        int n = list.size() - 1;
        while (n >= 0) {
            TermVariable termVariable;
            TermVariable termVariable2;
            Object object;
            Object object4;
            object2 = list.get(n);
            for (Map.Entry<IProgramVar, TermVariable> entry : object2.getOutVars().entrySet()) {
                object4 = entry.getKey();
                object = entry.getValue();
                termVariable2 = transFormulaBuilder.containsInVar((IProgramVar)object4) ? transFormulaBuilder.getInVar((IProgramVar)object4) : managedScript.constructFreshTermVariable(object4.getGloballyUniqueId(), object4.getTermVariable().getSort());
                hashMap.put((TermVariable)object, termVariable2);
                if (!transFormulaBuilder.containsOutVar((IProgramVar)object4)) {
                    transFormulaBuilder.addOutVar((IProgramVar)object4, termVariable2);
                }
                if ((termVariable = object2.getInVars().get(object4)) == null) {
                    if (transFormulaBuilder.getOutVar((IProgramVar)object4) != termVariable2) {
                        hashSet.add(termVariable2);
                    }
                    transFormulaBuilder.removeInVar((IProgramVar)object4);
                    continue;
                }
                if (termVariable == object) {
                    transFormulaBuilder.addInVar((IProgramVar)object4, termVariable2);
                    continue;
                }
                TermVariable termVariable3 = managedScript.constructFreshTermVariable(object4.getGloballyUniqueId(), object4.getTermVariable().getSort());
                hashMap.put(termVariable, termVariable3);
                transFormulaBuilder.addInVar((IProgramVar)object4, termVariable3);
                if (transFormulaBuilder.getOutVar((IProgramVar)object4) == termVariable2) continue;
                hashSet.add(termVariable2);
            }
            Map object7 = managedScript.constructFreshCopies(object2.getAuxVars());
            hashMap.putAll(object7);
            hashSet.addAll(object7.values());
            transFormulaBuilder.addBranchEncoders(object2.getBranchEncoders());
            for (Map.Entry entry : object2.getInVars().entrySet()) {
                object = (IProgramVar)entry.getKey();
                if (object2.getOutVars().containsKey(object)) continue;
                termVariable2 = (TermVariable)entry.getValue();
                if (!transFormulaBuilder.containsOutVar((IProgramVar)object)) {
                    termVariable = transFormulaBuilder.containsInVar((IProgramVar)object) ? transFormulaBuilder.getInVar((IProgramVar)object) : managedScript.constructFreshTermVariable(object.getGloballyUniqueId(), object.getTermVariable().getSort());
                    transFormulaBuilder.addOutVar((IProgramVar)object, termVariable);
                } else if (transFormulaBuilder.containsInVar((IProgramVar)object) && transFormulaBuilder.getOutVar((IProgramVar)object) != transFormulaBuilder.getInVar((IProgramVar)object)) {
                    transFormulaBuilder.addAuxVar(transFormulaBuilder.getInVar((IProgramVar)object));
                }
                termVariable = managedScript.constructFreshTermVariable(object.getGloballyUniqueId(), object.getTermVariable().getSort());
                transFormulaBuilder.addInVar((IProgramVar)object, termVariable);
                hashMap.put(termVariable2, termVariable);
            }
            Term term = object2.getFormula();
            object4 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)term);
            hashSet2.addAll(object2.getNonTheoryConsts());
            object3 = SmtUtils.and((Script)script, (Term[])new Term[]{object3, object4});
            --n;
        }
        assert (!new SubtermPropertyChecker(LetTerm.class::isInstance).isSatisfiedBySomeSubterm(object3)) : "formula contains LetTerm";
        if (bl) {
            try {
                object3 = SmtUtils.simplify((ManagedScript)managedScript, (Term)object3, (IUltimateServiceProvider)iUltimateServiceProvider, (SmtUtils.SimplificationTechnique)simplificationTechnique);
            }
            catch (ToolchainCanceledException toolchainCanceledException) {
                String string = "doing sequential composition of " + list.size() + " TransFormulas";
                toolchainCanceledException.addRunningTaskInfo(new RunningTaskInfo(TransFormulaUtils.class, string));
                throw toolchainCanceledException;
            }
        }
        if (bl2) {
            object2 = TransFormulaUtils.tryAuxVarElimination(iUltimateServiceProvider, managedScript, simplificationTechnique, object3, hashSet);
            if (iLogger.isDebugEnabled()) {
                iLogger.debug("DAG size before PQE %s, DAG size after PQE %s", new Object[]{new DagSizePrinter(object3), new DagSizePrinter((Term)object2)});
            }
            object3 = object2;
        } else {
            object2 = new XnfDer(managedScript, iUltimateServiceProvider);
            object3 = SmtUtils.and((Script)script, (Term[])object2.tryToEliminate(0, SmtUtils.getConjuncts((Term)object3), hashSet));
        }
        if (bl) {
            object3 = SmtUtils.simplify((ManagedScript)managedScript, (Term)object3, (IUltimateServiceProvider)iUltimateServiceProvider, (SmtUtils.SimplificationTechnique)simplificationTechnique);
        }
        object2 = object3 == script.term("false", new Term[0]) ? UnmodifiableTransFormula.Infeasibility.INFEASIBLE : UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        if (bl3) {
            Term term;
            object3 = term = SmtUtils.toCnf((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)object3);
        }
        TransFormulaUtils.addConstantsIfInFormula(transFormulaBuilder, object3, hashSet2);
        transFormulaBuilder.setFormula((Term)object3);
        transFormulaBuilder.setInfeasibility((UnmodifiableTransFormula.Infeasibility)((Object)object2));
        for (TermVariable termVariable : hashSet) {
            transFormulaBuilder.addAuxVar(termVariable);
        }
        transFormulaBuilder.ensureInternalNormalForm();
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static Term tryAuxVarElimination(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, SmtUtils.SimplificationTechnique simplificationTechnique, Term term, Set<TermVariable> set) {
        Term term2 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, set, (Term)term);
        set.clear();
        Term term3 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term2, (SmtUtils.SimplificationTechnique)simplificationTechnique);
        Term term4 = new PrenexNormalForm(managedScript).transform(term3);
        if (term4 instanceof QuantifiedFormula && ((QuantifiedFormula)term4).getQuantifier() == 0) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term4;
            set.addAll(Arrays.asList(quantifiedFormula.getVariables()));
            return quantifiedFormula.getSubformula();
        }
        return term4;
    }

    public static Term tryAuxVarEliminationLight(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, Set<TermVariable> set) {
        Term term2 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, set, (Term)term);
        set.clear();
        Term term3 = PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term2);
        Term term4 = new PrenexNormalForm(managedScript).transform(term3);
        if (term4 instanceof QuantifiedFormula && ((QuantifiedFormula)term4).getQuantifier() == 0) {
            QuantifiedFormula quantifiedFormula = (QuantifiedFormula)term4;
            set.addAll(Arrays.asList(quantifiedFormula.getVariables()));
            return quantifiedFormula.getSubformula();
        }
        return term4;
    }

    public static UnmodifiableTransFormula parallelComposition(ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, TermVariable[] termVariableArray, boolean bl, boolean bl2, UnmodifiableTransFormula ... unmodifiableTransFormulaArray) {
        Term term;
        Object object;
        TermVariable termVariable2;
        boolean bl3;
        iLogger.debug((Object)"parallel composition");
        boolean bl4 = bl3 = termVariableArray != null;
        if (bl3 && termVariableArray.length != unmodifiableTransFormulaArray.length) {
            throw new IllegalArgumentException();
        }
        TransFormulaUnification transFormulaUnification = new TransFormulaUnification(managedScript, unmodifiableTransFormulaArray);
        Set<IProgramConst> set = transFormulaUnification.getNonTheoryConsts();
        TransFormulaBuilder transFormulaBuilder = bl3 ? new TransFormulaBuilder(null, null, set.isEmpty(), set, false, Arrays.asList(termVariableArray), false) : new TransFormulaBuilder(null, null, set.isEmpty(), set, true, null, false);
        transFormulaBuilder.addInVars(transFormulaUnification.getInVars());
        transFormulaBuilder.addOutVars(transFormulaUnification.getOutVars());
        for (TermVariable termVariable2 : transFormulaUnification.getAuxVars()) {
            transFormulaBuilder.addAuxVar(termVariable2);
        }
        termVariable2 = new Term[unmodifiableTransFormulaArray.length];
        int n = 0;
        while (n < unmodifiableTransFormulaArray.length) {
            object = unmodifiableTransFormulaArray[n];
            Term term2 = transFormulaUnification.getUnifiedFormula(n);
            if (bl3) {
                transFormulaBuilder.addBranchEncoders(((UnmodifiableTransFormula)object).getBranchEncoders());
                termVariable2[n] = Util.implies((Script)managedScript.getScript(), (Term[])new Term[]{termVariableArray[n], term2});
            } else {
                termVariable2[n] = term2;
            }
            ++n;
        }
        if (bl3) {
            term = SmtUtils.and((Script)managedScript.getScript(), (Term[])termVariable2);
            object = SmtUtils.or((Script)managedScript.getScript(), (Term[])termVariableArray);
            term = SmtUtils.and((Script)managedScript.getScript(), (Term[])new Term[]{term, object});
        } else {
            term = SmtUtils.or((Script)managedScript.getScript(), (Term[])termVariable2);
        }
        if (bl) {
            term = SmtUtils.toCnf((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term);
        }
        object = Arrays.stream(unmodifiableTransFormulaArray).flatMap(unmodifiableTransFormula -> unmodifiableTransFormula.getNonTheoryConsts().stream()).collect(Collectors.toSet());
        TransFormulaUtils.addConstantsIfInFormula(transFormulaBuilder, term, object);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        if (bl2) {
            transFormulaBuilder.ensureInternalNormalForm();
        }
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula sequentialCompositionWithPendingCall(ManagedScript managedScript, boolean bl, boolean bl2, boolean bl3, List<UnmodifiableTransFormula> list, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, UnmodifiableTransFormula unmodifiableTransFormula4, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, Set<IProgramNonOldVar> set, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, String string, String string2, String string3, String string4, ModifiableGlobalsTable modifiableGlobalsTable) {
        boolean bl4;
        Object object;
        assert (string != null) : "proc at start must not be null";
        if (!string.equals(string2)) {
            throw new UnsupportedOperationException("proc change before call");
        }
        iLogger.debug((Object)("sequential composition (pending call) with" + (bl ? "" : "out") + " formula simplification"));
        Serializable serializable2 = new ArrayList<UnmodifiableTransFormula>(list);
        serializable2.add(unmodifiableTransFormula);
        serializable2.add(unmodifiableTransFormula2);
        Serializable serializable3 = TransFormulaUtils.sequentialComposition(iLogger, iUltimateServiceProvider, managedScript, bl, bl2, bl3, simplificationTechnique, serializable2);
        Serializable serializable4 = new ArrayList<IProgramVar>();
        for (IProgramVar iProgramVar : ((TransFormula)((Object)serializable3)).getOutVars().keySet()) {
            boolean bl5 = TransFormulaUtils.isInterfaceVariable(iProgramVar, unmodifiableTransFormula, unmodifiableTransFormula2, string2, string3, true, false);
            if (bl5) continue;
            serializable4.add(iProgramVar);
        }
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        Set<IProgramNonOldVar> set2 = modifiableGlobalsTable.getModifiedBoogieVars(string2);
        for (IProgramNonOldVar iProgramNonOldVar : set2) {
            object = iProgramNonOldVar.getOldVar();
            bl4 = unmodifiableTransFormula2.getAssignedVars().contains(object);
            if (bl4) continue;
            hashMap.put((IProgramVar)object, managedScript.constructFreshCopy(object.getTermVariable()));
        }
        Iterator<IProgramVar> iterator = iIcfgSymbolTable.getLocals(string2);
        object = iterator.iterator();
        while (object.hasNext()) {
            ILocalProgramVar iLocalProgramVar = (ILocalProgramVar)object.next();
            bl4 = unmodifiableTransFormula.getAssignedVars().contains(iLocalProgramVar);
            if (bl4) continue;
            hashMap.put(iLocalProgramVar, managedScript.constructFreshCopy(iLocalProgramVar.getTermVariable()));
        }
        UnmodifiableTransFormula unmodifiableTransFormula5 = TransFormulaBuilder.constructCopy(managedScript, (TransFormula)((Object)serializable3), Collections.emptySet(), serializable4, hashMap);
        serializable3 = new ArrayList<UnmodifiableTransFormula>(Arrays.asList(unmodifiableTransFormula4));
        serializable3.add(0, unmodifiableTransFormula3);
        serializable4 = TransFormulaUtils.sequentialComposition(iLogger, iUltimateServiceProvider, managedScript, bl, bl2, bl3, simplificationTechnique, (List<UnmodifiableTransFormula>)((Object)serializable3));
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        for (IProgramVar iProgramVar : ((TransFormula)((Object)serializable4)).getInVars().keySet()) {
            boolean bl6 = TransFormulaUtils.isInterfaceVariable(iProgramVar, unmodifiableTransFormula, unmodifiableTransFormula2, string2, string3, false, true);
            if (bl6) continue;
            arrayList.add(iProgramVar);
        }
        serializable2 = TransFormulaBuilder.constructCopy(managedScript, (TransFormula)((Object)serializable4), arrayList, Collections.emptySet(), Collections.emptyMap());
        serializable3 = TransFormulaUtils.sequentialComposition(iLogger, iUltimateServiceProvider, managedScript, bl, bl2, bl3, simplificationTechnique, Arrays.asList(unmodifiableTransFormula5, serializable2));
        if (string3.equals(string4)) {
            serializable4 = serializable3;
        } else {
            ArrayList<IProgramVar> arrayList2 = new ArrayList<IProgramVar>();
            for (IProgramVar iProgramVar : ((TransFormula)((Object)serializable3)).getOutVars().keySet()) {
                if (!unmodifiableTransFormula.getAssignedVars().contains(iProgramVar)) continue;
                arrayList2.add(iProgramVar);
            }
            serializable4 = arrayList2.isEmpty() ? serializable3 : TransFormulaBuilder.constructCopy(managedScript, (TransFormula)((Object)serializable3), Collections.emptySet(), arrayList2, Collections.emptyMap());
        }
        assert (!((UnmodifiableTransFormula)serializable4).getBranchEncoders().isEmpty() || TransFormulaUtils.predicateBasedResultCheck(iUltimateServiceProvider, managedScript, list, unmodifiableTransFormula, unmodifiableTransFormula2, unmodifiableTransFormula3, unmodifiableTransFormula4, (UnmodifiableTransFormula)serializable4, iIcfgSymbolTable, set)) : "sequentialCompositionWithPendingCall - incorrect result";
        return serializable4;
    }

    private static boolean isInterfaceVariable(IProgramVar iProgramVar, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, String string, String string2, boolean bl, boolean bl2) {
        boolean bl3;
        if (iProgramVar.isGlobal()) {
            if (iProgramVar.isOldvar()) {
                if (!unmodifiableTransFormula2.getOutVars().containsKey(iProgramVar)) {
                    throw new AssertionError((Object)"oldvars not yet implemented");
                }
                bl3 = true;
            } else {
                bl3 = !unmodifiableTransFormula2.getInVars().containsKey(iProgramVar);
            }
        } else if (iProgramVar.getProcedure().equals(string2)) {
            if (unmodifiableTransFormula.getAssignedVars().contains(iProgramVar)) {
                bl3 = true;
            } else {
                if (!(bl2 || string.equals(string2) && bl)) {
                    throw new AssertionError((Object)("local var of callee is no inparam " + String.valueOf(iProgramVar)));
                }
                bl3 = false;
            }
        } else if (iProgramVar.getProcedure().equals(string)) {
            if (!bl) {
                throw new AssertionError((Object)("local var of caller " + String.valueOf(iProgramVar)));
            }
            bl3 = false;
        } else {
            throw new AssertionError((Object)("local var neither from caller nor callee " + String.valueOf(iProgramVar)));
        }
        return bl3;
    }

    private static boolean predicateBasedResultCheck(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, List<UnmodifiableTransFormula> list, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, UnmodifiableTransFormula unmodifiableTransFormula4, UnmodifiableTransFormula unmodifiableTransFormula5, IIcfgSymbolTable iIcfgSymbolTable, Set<IProgramNonOldVar> set) {
        Term term;
        UnmodifiableTransFormula unmodifiableTransFormula62;
        assert (unmodifiableTransFormula5.getBranchEncoders().isEmpty()) : "result check not applicable with branch encoders";
        PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer = new PredicateTransformer<Term, IPredicate, TransFormula>(managedScript, new TermDomainOperationProvider(iUltimateServiceProvider, managedScript));
        BasicPredicateFactory basicPredicateFactory = new BasicPredicateFactory(iUltimateServiceProvider, managedScript, iIcfgSymbolTable);
        BasicPredicate basicPredicate = basicPredicateFactory.newPredicate(managedScript.getScript().term("true", new Term[0]));
        Term term2 = predicateTransformer.strongestPostcondition(basicPredicate, unmodifiableTransFormula5);
        term2 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term2);
        BasicPredicate basicPredicate2 = basicPredicateFactory.newPredicate(term2);
        BasicPredicate basicPredicate3 = basicPredicate;
        for (UnmodifiableTransFormula unmodifiableTransFormula62 : list) {
            term = predicateTransformer.strongestPostcondition(basicPredicate3, unmodifiableTransFormula62);
            basicPredicate3 = basicPredicateFactory.newPredicate(term);
        }
        unmodifiableTransFormula62 = predicateTransformer.strongestPostconditionCall(basicPredicate3, unmodifiableTransFormula, unmodifiableTransFormula3, unmodifiableTransFormula2, set);
        BasicPredicate basicPredicate4 = basicPredicateFactory.newPredicate((Term)unmodifiableTransFormula62);
        term = predicateTransformer.strongestPostcondition(basicPredicate4, unmodifiableTransFormula4);
        term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term);
        BasicPredicate basicPredicate5 = basicPredicateFactory.newPredicate(term);
        MonolithicImplicationChecker monolithicImplicationChecker = new MonolithicImplicationChecker(iUltimateServiceProvider, managedScript);
        IncrementalPlicationChecker.Validity validity = monolithicImplicationChecker.checkImplication(basicPredicate5, false, basicPredicate2, false);
        IncrementalPlicationChecker.Validity validity2 = monolithicImplicationChecker.checkImplication(basicPredicate2, false, basicPredicate5, false);
        assert (validity != IncrementalPlicationChecker.Validity.INVALID && validity2 != IncrementalPlicationChecker.Validity.INVALID) : "sequentialCompositionWithPendingCall - incorrect result";
        return validity != IncrementalPlicationChecker.Validity.INVALID && validity2 != IncrementalPlicationChecker.Validity.INVALID;
    }

    public static UnmodifiableTransFormula sequentialCompositionWithCallAndReturn(ManagedScript managedScript, boolean bl, boolean bl2, boolean bl3, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, UnmodifiableTransFormula unmodifiableTransFormula4, UnmodifiableTransFormula unmodifiableTransFormula5, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable iIcfgSymbolTable, Set<IProgramNonOldVar> set) {
        boolean bl4;
        if (!unmodifiableTransFormula5.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)TRANS_FORMULA_OF_RETURN_MUST_NOT_CONTAIN_AUX_VARS);
        }
        if (!unmodifiableTransFormula2.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)OLD_VAR_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS);
        }
        if (!unmodifiableTransFormula3.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)GLOBAL_VARS_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS);
        }
        iLogger.debug((Object)("sequential composition (call/return) with" + (bl ? "" : "out") + " formula simplification"));
        UnmodifiableTransFormula unmodifiableTransFormula6 = TransFormulaUtils.sequentialComposition(iLogger, iUltimateServiceProvider, managedScript, bl, bl2, bl3, simplificationTechnique, Arrays.asList(unmodifiableTransFormula, unmodifiableTransFormula2, unmodifiableTransFormula3, unmodifiableTransFormula4, unmodifiableTransFormula5));
        ArrayList<IProgramVar> arrayList = new ArrayList<IProgramVar>();
        for (IProgramVar iProgramVar : unmodifiableTransFormula6.getInVars().keySet()) {
            boolean bl5;
            if (iProgramVar.isGlobal()) {
                if (!iProgramVar.isOldvar() || !(bl5 = unmodifiableTransFormula2.getAssignedVars().contains(iProgramVar)) || (bl4 = unmodifiableTransFormula.getInVars().containsKey(iProgramVar))) continue;
                arrayList.add(iProgramVar);
                continue;
            }
            bl5 = unmodifiableTransFormula.getInVars().containsKey(iProgramVar);
            if (bl5) continue;
            arrayList.add(iProgramVar);
        }
        ArrayList<IProgramVar> arrayList2 = new ArrayList<IProgramVar>();
        for (IProgramVar iProgramVar : unmodifiableTransFormula6.getOutVars().keySet()) {
            if (iProgramVar.isGlobal()) {
                if (!iProgramVar.isOldvar() || !(bl4 = unmodifiableTransFormula2.getAssignedVars().contains(iProgramVar))) continue;
                arrayList2.add(iProgramVar);
                continue;
            }
            if (unmodifiableTransFormula5.getOutVars().containsKey(iProgramVar)) continue;
            arrayList2.add(iProgramVar);
        }
        HashMap<IProgramVar, TermVariable> hashMap = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : unmodifiableTransFormula.getInVars().entrySet()) {
            TermVariable termVariable;
            if (unmodifiableTransFormula6.getOutVars().containsKey(entry.getKey()) && !arrayList2.contains(entry.getKey()) || (termVariable = unmodifiableTransFormula6.getInVars().get(entry.getKey())) == null) continue;
            hashMap.put(entry.getKey(), termVariable);
        }
        UnmodifiableTransFormula unmodifiableTransFormula7 = TransFormulaBuilder.constructCopy(managedScript, unmodifiableTransFormula6, arrayList, arrayList2, hashMap);
        assert (SmtUtils.neitherKeyNorValueIsNull(unmodifiableTransFormula7.getOutVars())) : "sequentialCompositionWithCallAndReturn introduced null entries";
        assert (TransFormulaUtils.isIntraprocedural(unmodifiableTransFormula7));
        assert (!unmodifiableTransFormula7.getBranchEncoders().isEmpty() || TransFormulaUtils.predicateBasedResultCheck(iUltimateServiceProvider, iLogger, managedScript, unmodifiableTransFormula, unmodifiableTransFormula2, unmodifiableTransFormula3, unmodifiableTransFormula4, unmodifiableTransFormula5, unmodifiableTransFormula7, iIcfgSymbolTable, set)) : "sequentialCompositionWithCallAndReturn - incorrect result";
        return unmodifiableTransFormula7;
    }

    private static boolean predicateBasedResultCheck(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, UnmodifiableTransFormula unmodifiableTransFormula3, UnmodifiableTransFormula unmodifiableTransFormula4, UnmodifiableTransFormula unmodifiableTransFormula5, UnmodifiableTransFormula unmodifiableTransFormula6, IIcfgSymbolTable iIcfgSymbolTable, Set<IProgramNonOldVar> set) {
        assert (unmodifiableTransFormula6.getBranchEncoders().isEmpty()) : "result check not applicable with branch encoders";
        PredicateTransformer<Term, IPredicate, TransFormula> predicateTransformer = new PredicateTransformer<Term, IPredicate, TransFormula>(managedScript, new TermDomainOperationProvider(iUltimateServiceProvider, managedScript));
        BasicPredicateFactory basicPredicateFactory = new BasicPredicateFactory(iUltimateServiceProvider, managedScript, iIcfgSymbolTable);
        BasicPredicate basicPredicate = basicPredicateFactory.newPredicate(managedScript.getScript().term("true", new Term[0]));
        Term term = predicateTransformer.strongestPostcondition(basicPredicate, unmodifiableTransFormula6);
        term = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term);
        BasicPredicate basicPredicate2 = basicPredicateFactory.newPredicate(term);
        Term term2 = predicateTransformer.strongestPostconditionCall(basicPredicate, unmodifiableTransFormula, unmodifiableTransFormula3, unmodifiableTransFormula2, set);
        BasicPredicate basicPredicate3 = basicPredicateFactory.newPredicate(term2);
        Term term3 = predicateTransformer.strongestPostcondition(basicPredicate3, unmodifiableTransFormula4);
        BasicPredicate basicPredicate4 = basicPredicateFactory.newPredicate(term3);
        Term term4 = predicateTransformer.strongestPostconditionReturn(basicPredicate4, basicPredicate, unmodifiableTransFormula5, unmodifiableTransFormula, unmodifiableTransFormula2, set);
        term4 = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)term4);
        BasicPredicate basicPredicate5 = basicPredicateFactory.newPredicate(term4);
        MonolithicImplicationChecker monolithicImplicationChecker = new MonolithicImplicationChecker(iUltimateServiceProvider, managedScript);
        IncrementalPlicationChecker.Validity validity = monolithicImplicationChecker.checkImplication(basicPredicate5, false, basicPredicate2, false);
        IncrementalPlicationChecker.Validity validity2 = monolithicImplicationChecker.checkImplication(basicPredicate2, false, basicPredicate5, false);
        assert (validity != IncrementalPlicationChecker.Validity.INVALID && validity2 != IncrementalPlicationChecker.Validity.INVALID) : "sequentialCompositionWithCallAndReturn - incorrect result";
        if (validity == IncrementalPlicationChecker.Validity.UNKNOWN || validity2 == IncrementalPlicationChecker.Validity.UNKNOWN) {
            iLogger.warn((Object)"predicate-based correctness check returned UNKNOWN, hence correctness of interprocedural sequential composition was not checked.");
        }
        return validity != IncrementalPlicationChecker.Validity.INVALID && validity2 != IncrementalPlicationChecker.Validity.INVALID;
    }

    static boolean isIntraprocedural(UnmodifiableTransFormula unmodifiableTransFormula) {
        HashSet<String> hashSet = new HashSet<String>();
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getInVars().keySet()) {
            if (iProgramVar.isGlobal()) continue;
            hashSet.add(iProgramVar.getProcedure());
        }
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getOutVars().keySet()) {
            if (iProgramVar.isGlobal()) continue;
            hashSet.add(iProgramVar.getProcedure());
        }
        return hashSet.size() <= 1;
    }

    public static UnmodifiableTransFormula computeGuard(UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        if (!unmodifiableTransFormula.getBranchEncoders().isEmpty()) {
            throw new AssertionError((Object)"I think this does not make sense with branch encoders");
        }
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty() ? null : unmodifiableTransFormula.getNonTheoryConsts(), true, null, false);
        transFormulaBuilder.setFormula(TransFormulaUtils.computeGuardTermHelper(iUltimateServiceProvider, managedScript, unmodifiableTransFormula, true));
        transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static Term computeGuardTerm(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        Term term = TransFormulaUtils.computeGuardTermHelper(iUltimateServiceProvider, managedScript, unmodifiableTransFormula, bl);
        Map<TermVariable, TermVariable> map = unmodifiableTransFormula.getInVars().entrySet().stream().collect(Collectors.toMap(entry -> (TermVariable)entry.getValue(), entry -> ((IProgramVar)entry.getKey()).getTermVariable()));
        return Substitution.apply((ManagedScript)managedScript, map, (Term)term);
    }

    private static Term computeGuardTermHelper(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, UnmodifiableTransFormula unmodifiableTransFormula, boolean bl) {
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(unmodifiableTransFormula.getAuxVars());
        hashSet.addAll(unmodifiableTransFormula.getBranchEncoders());
        for (IProgramVar iProgramVar : unmodifiableTransFormula.getAssignedVars()) {
            TermVariable termVariable = unmodifiableTransFormula.getOutVars().get(iProgramVar);
            if (!Arrays.asList(unmodifiableTransFormula.getFormula().getFreeVars()).contains(termVariable)) continue;
            hashSet.add(termVariable);
        }
        if (bl) {
            return TransFormulaUtils.quantifyAndTryToEliminateAuxVars(iUltimateServiceProvider, managedScript, unmodifiableTransFormula.getFormula(), hashSet);
        }
        return SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, hashSet, (Term)unmodifiableTransFormula.getFormula());
    }

    public static UnmodifiableTransFormula computeGuardedHavoc(UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider, boolean bl) {
        Object object;
        IProgramVar iProgramVar2;
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>(unmodifiableTransFormula.getAuxVars());
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (IProgramVar iProgramVar2 : unmodifiableTransFormula.getOutVars().keySet()) {
            TermVariable termVariable;
            if (unmodifiableTransFormula.getOutVars().get(iProgramVar2) == unmodifiableTransFormula.getInVars().get(iProgramVar2)) continue;
            if (bl && SmtSortUtils.isArraySort((Sort)iProgramVar2.getTermVariable().getSort())) {
                object = SmtUtils.extractApplicationTerms((String)"store", (Term)unmodifiableTransFormula.getFormula(), (boolean)false);
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    termVariable = (Term)iterator.next();
                    ApplicationTerm applicationTerm = (ApplicationTerm)termVariable;
                    Term term = applicationTerm.getParameters()[2];
                    if (SmtSortUtils.isArraySort((Sort)term.getSort())) continue;
                    TermVariable termVariable2 = managedScript.constructFreshTermVariable("rosehip", term.getSort());
                    Term term2 = applicationTerm.getParameters()[0];
                    Term term3 = applicationTerm.getParameters()[1];
                    Term term4 = SmtUtils.store((Script)managedScript.getScript(), (Term)term2, (Term)term3, (Term)termVariable2);
                    hashMap.put(applicationTerm, term4);
                    hashSet.add(termVariable2);
                }
                continue;
            }
            object = unmodifiableTransFormula.getOutVars().get(iProgramVar2);
            termVariable = managedScript.constructFreshCopy((TermVariable)object);
            hashMap.put(object, termVariable);
            hashSet.add(termVariable);
        }
        if (!unmodifiableTransFormula.getBranchEncoders().isEmpty()) {
            throw new AssertionError((Object)"I think this does not make sense with branch enconders");
        }
        iProgramVar2 = Substitution.apply((ManagedScript)managedScript, hashMap, (Term)unmodifiableTransFormula.getFormula());
        Term term = TransFormulaUtils.quantifyAndTryToEliminateAuxVars(iUltimateServiceProvider, managedScript, (Term)iProgramVar2, hashSet);
        object = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty() ? null : unmodifiableTransFormula.getNonTheoryConsts(), true, null, false);
        ((TransFormulaBuilder)object).setFormula(term);
        ((TransFormulaBuilder)object).setInfeasibility(unmodifiableTransFormula.isInfeasible());
        return ((TransFormulaBuilder)object).finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula negate(UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript, IUltimateServiceProvider iUltimateServiceProvider) {
        if (!unmodifiableTransFormula.getBranchEncoders().isEmpty()) {
            throw new AssertionError((Object)"I think this does not make sense with branch enconders");
        }
        Term term = TransFormulaUtils.quantifyAndTryToEliminateAuxVars(iUltimateServiceProvider, managedScript, unmodifiableTransFormula.getFormula(), unmodifiableTransFormula.getAuxVars());
        Term term2 = SmtUtils.not((Script)managedScript.getScript(), (Term)term);
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty(), unmodifiableTransFormula.getNonTheoryConsts().isEmpty() ? null : unmodifiableTransFormula.getNonTheoryConsts(), false, unmodifiableTransFormula.getBranchEncoders(), true);
        transFormulaBuilder.setFormula(term2);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula intersect(ManagedScript managedScript, UnmodifiableTransFormula ... unmodifiableTransFormulaArray) {
        TransFormulaUnification transFormulaUnification = new TransFormulaUnification(managedScript, unmodifiableTransFormulaArray);
        Set<IProgramConst> set = transFormulaUnification.getNonTheoryConsts();
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(transFormulaUnification.getInVars(), transFormulaUnification.getOutVars(), set.isEmpty(), set, true, null, false);
        transFormulaUnification.getAuxVars().stream().forEach(transFormulaBuilder::addAuxVar);
        Term[] termArray = new Term[unmodifiableTransFormulaArray.length];
        int n = 0;
        while (n < unmodifiableTransFormulaArray.length) {
            termArray[n] = transFormulaUnification.getUnifiedFormula(n);
            ++n;
        }
        transFormulaBuilder.setFormula(SmtUtils.and((Script)managedScript.getScript(), (Term[])termArray));
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    private static Term quantifyAndTryToEliminateAuxVars(IUltimateServiceProvider iUltimateServiceProvider, ManagedScript managedScript, Term term, Set<TermVariable> set) {
        Term term2 = SmtUtils.quantifier((Script)managedScript.getScript(), (int)0, set, (Term)term);
        Term term3 = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)iUltimateServiceProvider, (ManagedScript)managedScript, (Term)term2, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC);
        return term3;
    }

    public static <T extends IProgramConst> void addConstantsIfInFormula(TransFormulaBuilder transFormulaBuilder, Term term, Set<T> set) {
        Set set2 = SmtUtils.extractConstants((Term)term, (boolean)false);
        for (IProgramConst iProgramConst : set) {
            if (!set2.contains(iProgramConst.getDefaultConstant())) continue;
            transFormulaBuilder.addProgramConst(iProgramConst);
        }
    }

    public static <V, K> Map<V, K> constructReverseMapping(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static Map<TermVariable, TermVariable> constructInvarsToDefaultvarsMap(TransFormula transFormula) {
        return transFormula.getInVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((IProgramVar)entry.getKey()).getTermVariable()));
    }

    public static Map<TermVariable, TermVariable> constructDefaultvarsToInvarsMap(TransFormula transFormula) {
        return transFormula.getInVars().entrySet().stream().collect(Collectors.toMap(entry -> ((IProgramVar)entry.getKey()).getTermVariable(), Map.Entry::getValue));
    }

    public static Map<TermVariable, TermVariable> constructOutvarsToDefaultvarsMap(TransFormula transFormula) {
        return transFormula.getOutVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, entry -> ((IProgramVar)entry.getKey()).getTermVariable()));
    }

    public static Map<TermVariable, TermVariable> constructInvarsToOutvarsMap(TransFormula transFormula) {
        return transFormula.getInVars().entrySet().stream().filter(entry -> transFormula.getOutVars().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getValue, entry -> transFormula.getOutVars().get(entry.getKey())));
    }

    public static Map<TermVariable, TermVariable> constructOutvarsToInvarsMap(TransFormula transFormula) {
        return transFormula.getOutVars().entrySet().stream().filter(entry -> transFormula.getInVars().containsKey(entry.getKey())).collect(Collectors.toMap(Map.Entry::getValue, entry -> transFormula.getInVars().get(entry.getKey())));
    }

    public static boolean eachFreeVarIsInvar(TransFormula transFormula, Term term) {
        Set set = transFormula.getInVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        return Arrays.stream(term.getFreeVars()).allMatch(set::contains);
    }

    public static boolean eachFreeVarIsOutvar(TransFormula transFormula, Term term) {
        Set set = transFormula.getOutVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        return Arrays.stream(term.getFreeVars()).allMatch(set::contains);
    }

    public static Term renameInvarsToDefaultVars(TransFormula transFormula, ManagedScript managedScript, Term term) {
        Map<TermVariable, TermVariable> map = TransFormulaUtils.constructInvarsToDefaultvarsMap(transFormula);
        return Substitution.apply((ManagedScript)managedScript, map, (Term)term);
    }

    public static Term renameOutvarsToDefaultVars(TransFormula transFormula, ManagedScript managedScript, Term term) {
        Map<TermVariable, TermVariable> map = TransFormulaUtils.constructOutvarsToDefaultvarsMap(transFormula);
        return Substitution.apply((ManagedScript)managedScript, map, (Term)term);
    }

    public static Term renameInvars(TransFormula transFormula, ManagedScript managedScript, Map<IProgramVar, Term> map) {
        HashMap<Term, Term> hashMap = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : transFormula.getInVars().entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("did not provide mapping for " + String.valueOf(entry.getKey()));
            }
            hashMap.put((Term)entry.getValue(), map.get(entry.getKey()));
        }
        return Substitution.apply((ManagedScript)managedScript, hashMap, (Term)transFormula.getFormula());
    }

    public static UnmodifiableTransFormula constructHavoc(TransFormula transFormula, ManagedScript managedScript) {
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(transFormula.getInVars(), transFormula.getOutVars(), false, transFormula.getNonTheoryConsts(), true, null, false);
        transFormulaBuilder.setFormula(managedScript.getScript().term("true", new Term[0]));
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula constructHavoc(Set<IProgramVar> set, ManagedScript managedScript) {
        Function<IProgramVar, TermVariable> function = iProgramVar -> managedScript.constructFreshCopy(iProgramVar.getTermVariable());
        Map<IProgramVar, TermVariable> map = set.stream().collect(Collectors.toMap(Function.identity(), function));
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(Collections.emptyMap(), map, false, Collections.emptySet(), true, null, false);
        transFormulaBuilder.setFormula(managedScript.getScript().term("true", new Term[0]));
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static UnmodifiableTransFormula substituteTermVars(TransFormula transFormula, ManagedScript managedScript, Map<TermVariable, TermVariable> map) {
        Object object2;
        Map<IProgramVar, TermVariable> map2 = transFormula.getInVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> map.getOrDefault(entry.getValue(), (TermVariable)entry.getValue())));
        Map<IProgramVar, TermVariable> map3 = transFormula.getOutVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> map.getOrDefault(entry.getValue(), (TermVariable)entry.getValue())));
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (Object object2 : transFormula.getAuxVars()) {
            hashSet.add(map.getOrDefault(object2, (TermVariable)object2));
        }
        object2 = new HashMap<TermVariable, TermVariable>(map);
        Term term = Substitution.apply((ManagedScript)managedScript, (Map)object2, (Term)transFormula.getFormula());
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(map2, map3, true, null, true, null, false);
        transFormulaBuilder.setFormula(term);
        transFormulaBuilder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        transFormulaBuilder.addAuxVarsButRenameToFreshCopies(hashSet, managedScript);
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    public static Script.LBool checkImplication(UnmodifiableTransFormula unmodifiableTransFormula, UnmodifiableTransFormula unmodifiableTransFormula2, ManagedScript managedScript) {
        managedScript.lock((Object)unmodifiableTransFormula);
        managedScript.push((Object)unmodifiableTransFormula, 1);
        Script script = managedScript.getScript();
        Term term = TransFormulaUtils.getClosedFormulaWithBranchEncoderConstants(managedScript, unmodifiableTransFormula, unmodifiableTransFormula);
        Term term2 = SmtUtils.quantifier((Script)script, (int)0, (Collection)DataStructureUtils.union(unmodifiableTransFormula2.getAuxVars(), unmodifiableTransFormula2.getBranchEncoders()), (Term)unmodifiableTransFormula2.getFormula());
        Term term3 = UnmodifiableTransFormula.computeClosedFormula(term2, unmodifiableTransFormula2.getInVars(), unmodifiableTransFormula2.getOutVars(), Collections.emptySet(), managedScript);
        Set set = DataStructureUtils.difference(unmodifiableTransFormula2.getAssignedVars(), unmodifiableTransFormula.getAssignedVars());
        Term term4 = TransFormulaUtils.constructExplicitEqualities(script, set);
        Term term5 = SmtUtils.and((Script)script, (Term[])new Term[]{term, term4});
        Set set2 = DataStructureUtils.difference(unmodifiableTransFormula.getAssignedVars(), unmodifiableTransFormula2.getAssignedVars());
        Term term6 = TransFormulaUtils.constructExplicitEqualities(script, set2);
        Term term7 = SmtUtils.and((Script)script, (Term[])new Term[]{term3, term6});
        managedScript.assertTerm((Object)unmodifiableTransFormula, term5);
        managedScript.assertTerm((Object)unmodifiableTransFormula, SmtUtils.not((Script)script, (Term)term7));
        Script.LBool lBool = managedScript.checkSat((Object)unmodifiableTransFormula);
        managedScript.echo((Object)unmodifiableTransFormula, new QuotedObject("Implication check result was " + String.valueOf(lBool)));
        managedScript.pop((Object)unmodifiableTransFormula, 1);
        managedScript.unlock((Object)unmodifiableTransFormula);
        return lBool;
    }

    private static Term getClosedFormulaWithBranchEncoderConstants(ManagedScript managedScript, Object object, UnmodifiableTransFormula unmodifiableTransFormula) {
        if (unmodifiableTransFormula.getBranchEncoders().isEmpty()) {
            return unmodifiableTransFormula.getClosedFormula();
        }
        HashMap<TermVariable, Term> hashMap = new HashMap<TermVariable, Term>();
        int n = 0;
        for (TermVariable termVariable : unmodifiableTransFormula.getBranchEncoders()) {
            String string = termVariable.getName() + "_be_" + n;
            managedScript.declareFun(object, string, new Sort[0], termVariable.getSort());
            hashMap.put(termVariable, managedScript.term(object, string, new Term[0]));
            ++n;
        }
        return Substitution.apply((ManagedScript)managedScript, hashMap, (Term)unmodifiableTransFormula.getClosedFormula());
    }

    private static Term constructExplicitEqualities(Script script, Set<IProgramVar> set) {
        ArrayList<Term> arrayList = new ArrayList<Term>(set.size());
        for (IProgramVar iProgramVar : set) {
            Term term = SmtUtils.binaryEquality((Script)script, (Term)iProgramVar.getDefaultConstant(), (Term)iProgramVar.getPrimedConstant());
            arrayList.add(term);
        }
        return SmtUtils.and((Script)script, arrayList);
    }

    public static IProgramVarOrConst getProgramVarOrConstForTerm(TransFormula transFormula, Term term) {
        if (term instanceof TermVariable) {
            return TransFormulaUtils.getProgramVarForTerm(transFormula, (TermVariable)term);
        }
        if (term instanceof ApplicationTerm) {
            for (IProgramConst iProgramConst : transFormula.getNonTheoryConsts()) {
                if (!iProgramConst.getDefaultConstant().equals(term)) continue;
                return iProgramConst;
            }
        }
        return null;
    }

    public static IProgramVarOrConst getProgramVarForTerm(TransFormula transFormula, TermVariable termVariable) {
        for (Map.Entry<IProgramVar, TermVariable> entry : transFormula.getInVars().entrySet()) {
            if (!entry.getValue().equals(termVariable)) continue;
            return entry.getKey();
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : transFormula.getOutVars().entrySet()) {
            if (!entry.getValue().equals(termVariable)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static String prettyPrint(TransFormula transFormula) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = new SMTPrettyPrinter(transFormula.getFormula()).toString();
        stringBuilder.append(string);
        stringBuilder.append("\n");
        stringBuilder.append("Invars:\n");
        stringBuilder.append(transFormula.getInVars());
        stringBuilder.append("\n");
        stringBuilder.append("Outvars:\n");
        stringBuilder.append(transFormula.getOutVars());
        return stringBuilder.toString();
    }

    public static UnmodifiableTransFormula decoupleArrayValues(UnmodifiableTransFormula unmodifiableTransFormula, ManagedScript managedScript) {
        if (!QuantifierUtils.isQuantifierFree((Term)unmodifiableTransFormula.getFormula())) {
            return unmodifiableTransFormula;
        }
        Map map = managedScript.constructFreshCopies(unmodifiableTransFormula.getAuxVars());
        Term term = Substitution.apply((ManagedScript)managedScript, (Map)map, (Term)unmodifiableTransFormula.getFormula());
        Triple<Term, List<TermVariable>, List<Term>> triple = TransFormulaUtils.decoupleArrayValues(term, managedScript);
        TransFormulaBuilder transFormulaBuilder = new TransFormulaBuilder(unmodifiableTransFormula.getInVars(), unmodifiableTransFormula.getOutVars(), false, unmodifiableTransFormula.getNonTheoryConsts(), false, unmodifiableTransFormula.getBranchEncoders(), false);
        ArrayList<Term> arrayList = new ArrayList<Term>((Collection)triple.getThird());
        arrayList.add((Term)triple.getFirst());
        Term term2 = SmtUtils.and((Script)managedScript.getScript(), arrayList);
        transFormulaBuilder.setFormula(term2);
        for (TermVariable termVariable : map.values()) {
            transFormulaBuilder.addAuxVar(termVariable);
        }
        for (TermVariable termVariable : (List)triple.getSecond()) {
            transFormulaBuilder.addAuxVar(termVariable);
        }
        transFormulaBuilder.setInfeasibility(unmodifiableTransFormula.isInfeasible());
        return transFormulaBuilder.finishConstruction(managedScript);
    }

    private static Triple<Term, List<TermVariable>, List<Term>> decoupleArrayValues(Term term, ManagedScript managedScript) {
        ArrayList<ArrayStore> arrayList = ArrayStore.extractStores((Term)term, (boolean)false);
        if (arrayList.isEmpty()) {
            return new Triple((Object)term, Collections.emptyList(), Collections.emptyList());
        }
        Term term2 = term;
        ArrayList<TermVariable> arrayList2 = new ArrayList<TermVariable>();
        ArrayList<Term> arrayList3 = new ArrayList<Term>();
        while (!arrayList.isEmpty()) {
            Iterator iterator = arrayList.iterator();
            ArrayStore arrayStore = (ArrayStore)iterator.next();
            TermVariable termVariable = managedScript.constructFreshTermVariable("ArrVal", arrayStore.getValue().getSort());
            arrayList2.add(termVariable);
            Term term3 = SmtUtils.binaryEquality((Script)managedScript.getScript(), (Term)termVariable, (Term)arrayStore.getValue());
            arrayList3.add(term3);
            Term term4 = SmtUtils.store((Script)managedScript.getScript(), (Term)arrayStore.getArray(), (Term)arrayStore.getIndex(), (Term)termVariable);
            Map<Term, Term> map = Collections.singletonMap(arrayStore.getTerm(), term4);
            term2 = Substitution.apply((ManagedScript)managedScript, map, (Term)term2);
            arrayList = new ArrayList<ArrayStore>();
            while (iterator.hasNext()) {
                ArrayStore arrayStore2 = (ArrayStore)iterator.next();
                arrayList.add(arrayStore2.applySubstitution(managedScript, map));
            }
        }
        return new Triple((Object)term2, arrayList2, arrayList3);
    }

    public static boolean hasInternalNormalForm(TransFormula transFormula) {
        Set<IProgramVar> set = transFormula.getOutVars().keySet();
        Set set2 = Arrays.stream(transFormula.getFormula().getFreeVars()).collect(Collectors.toSet());
        return transFormula.getInVars().entrySet().stream().allMatch(entry -> set.contains(entry.getKey()) || set2.contains(entry.getValue()));
    }
}

