/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.domain.nonrelational.interval;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.function.Predicate;

public class IntervalNonAbstractabilityDeciderPredicate
implements Predicate<Term> {
    @Override
    public boolean test(Term term) {
        if (term instanceof ApplicationTerm) {
            return this.decide((ApplicationTerm)term);
        }
        if (term instanceof ConstantTerm) {
            return false;
        }
        if (term instanceof TermVariable) {
            return false;
        }
        throw new UnsupportedOperationException(term.toString());
    }

    private boolean decide(ApplicationTerm applicationTerm) {
        String string;
        switch (string = applicationTerm.getFunction().getName()) {
            case "or": 
            case "and": 
            case "not": {
                return Arrays.stream(applicationTerm.getParameters()).anyMatch(term -> this.test((Term)term));
            }
            case "<": 
            case ">": {
                if (!Arrays.stream(applicationTerm.getParameters()).allMatch(term -> SmtSortUtils.isIntSort((Sort)term.getSort().getRealSort()))) {
                    return true;
                }
            }
            case "=": 
            case "<=": 
            case ">=": {
                if (applicationTerm.getParameters().length != 2) {
                    return true;
                }
                return (!(applicationTerm.getParameters()[0] instanceof TermVariable) || !(applicationTerm.getParameters()[1] instanceof ConstantTerm)) && (!(applicationTerm.getParameters()[0] instanceof ConstantTerm) || !(applicationTerm.getParameters()[1] instanceof TermVariable));
            }
            case "select": 
            case "store": {
                return true;
            }
        }
        throw new UnsupportedOperationException(applicationTerm.toString());
    }
}

