/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.pea.modelchecking;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class Formula2NFCompiler {
    protected static final String DEFAULT_LOGGER = "Formula2NFCompiler";
    protected ILogger logger;
    protected Document document;

    public Formula2NFCompiler(String string) {
        this.logger = string.equals("") ? ILogger.getLogger((String)DEFAULT_LOGGER) : ILogger.getLogger((String)string);
    }

    public Formula2NFCompiler() {
        this("");
    }

    protected void buildNF(Node node) {
        if (node.getNodeType() != 1) {
            this.logger.debug((Object)"No element node, returning...");
            return;
        }
        Element element = (Element)node;
        if (this.isFormulaElement(element)) {
            this.logger.debug((Object)"Formula node, normalising children...");
            Element[] elementArray = this.getFormulaOperands(element);
            int n = 0;
            while (n < elementArray.length) {
                this.buildNF(elementArray[n]);
                ++n;
            }
            this.logger.debug((Object)"Formula node, normalising children finished, returning...");
            return;
        }
        if (!this.isTreeElement(element)) {
            this.logger.debug((Object)"No tree, returning...");
            return;
        }
        Element[] elementArray = this.getFormulaOperands(element);
        boolean bl = false;
        while (bl < elementArray.length) {
            this.logger.debug((Object)("Recursion, building NF for child[" + (int)(bl ? 1 : 0) + "]"));
            this.buildNF(elementArray[bl]);
            this.logger.debug((Object)("Recursion, building NF for child[" + (int)(bl ? 1 : 0) + "] finished"));
            bl += 1;
        }
        if (element.getAttribute("operator").equals("OR")) {
            this.logger.debug((Object)"\"OR\"-node, returning...");
            return;
        }
        bl = true;
        while (bl) {
            bl = false;
            elementArray = this.getFormulaOperands(element);
            int n = 0;
            while (n < elementArray.length && !bl) {
                if (this.isBasicElement(elementArray[n])) {
                    this.logger.debug((Object)"No Tree Node, continuing...");
                } else if (element.getAttribute("operator").startsWith("S") && elementArray[n].getAttribute("operator").equals("OR")) {
                    this.logger.debug((Object)"Case 1: Node sync-event, child OR");
                    this.changeNodeSyncChildOr(element, elementArray, n);
                    bl = true;
                } else if (element.getAttribute("operator").startsWith("S") && elementArray[n].getAttribute("operator").equals("AND")) {
                    this.logger.debug((Object)"Case 2: Node sync-event, child AND");
                    this.changeNodeSyncChildAnd(element, elementArray, n);
                    bl = true;
                } else if (element.getAttribute("operator").equals("AND") && elementArray[n].getAttribute("operator").equals("OR")) {
                    this.logger.debug((Object)"Case 3: Node AND, child OR");
                    this.changeNodeAndChildOr(element, elementArray, n);
                    bl = true;
                } else if (element.getAttribute("operator").equals("NOT") && elementArray[n].getAttribute("operator").equals("OR")) {
                    this.logger.debug((Object)"Case 4: Node NOT, child OR");
                    this.changeNodeNotChildOr(element, elementArray[n]);
                    bl = true;
                } else if (element.getAttribute("operator").equals("NOT") && elementArray[n].getAttribute("operator").equals("AND")) {
                    this.logger.debug((Object)"Case 5: Node NOT, child AND");
                    this.changeNodeNotChildAnd(element, elementArray[n]);
                    bl = true;
                }
                ++n;
            }
            this.logger.debug((Object)("Changed = " + bl));
            if (!bl) continue;
            elementArray = this.getFormulaOperands(element);
            n = 0;
            while (n < elementArray.length) {
                this.buildNF(elementArray[n]);
                ++n;
            }
        }
    }

    protected void changeNodeNotChildAnd(Element element, Element element2) {
        element.setAttribute("operator", "OR");
        this.appendGrandChildrenDeMorgan(element, element2);
    }

    protected void changeNodeNotChildOr(Element element, Element element2) {
        element.setAttribute("operator", "AND");
        this.appendGrandChildrenDeMorgan(element, element2);
    }

    protected void appendGrandChildrenDeMorgan(Element element, Element element2) {
        Element[] elementArray = this.getFormulaOperands(element2);
        int n = 0;
        while (n < elementArray.length) {
            Element element3 = this.getNewTreeElement();
            element3.setAttribute("operator", "NOT");
            element3.appendChild(elementArray[n]);
            element.appendChild(element3);
            ++n;
        }
    }

    protected void changeNodeSyncChildOr(Element element, Element[] elementArray, int n) {
        Element[] elementArray2 = this.getFormulaOperands(elementArray[n]);
        String string = element.getAttribute("operator");
        element.setAttribute("operator", "OR");
        elementArray[n].setAttribute("operator", string);
        Element element2 = this.getNewTreeElement();
        element2.setAttribute("operator", string);
        int n2 = n == 0 ? 1 : 0;
        Node node = elementArray[n2].cloneNode(true);
        if (n == 0) {
            elementArray[0].appendChild(node);
            element2.appendChild(elementArray2[1]);
            element2.appendChild(elementArray[1]);
            element.appendChild(element2);
        } else {
            elementArray[1].insertBefore(node, elementArray2[0]);
            element2.appendChild(elementArray[0]);
            element2.appendChild(elementArray2[0]);
            element.insertBefore(element2, elementArray[1]);
        }
    }

    protected abstract void changeNodeSyncChildAnd(Element var1, Element[] var2, int var3);

    protected void changeNodeAndChildOr(Element element, Element[] elementArray, int n) {
        int n2 = n == 0 ? 1 : 0;
        Element[] elementArray2 = this.getFormulaOperands(elementArray[n]);
        Element element2 = this.getNewTreeElement();
        element2.setAttribute("operator", "AND");
        element2.appendChild(elementArray2[1]);
        element2.appendChild(elementArray[n2]);
        Node node = elementArray[n2].cloneNode(true);
        elementArray[n].setAttribute("operator", "AND");
        elementArray[n].appendChild(node);
        element.appendChild(element2);
        element.setAttribute("operator", "OR");
    }

    protected Element[] getFormulaOperands(Element element) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        int n2 = 0;
        while (n2 < n) {
            Node node = nodeList.item(n2);
            if (this.isBasicElement(node) || this.isTreeElement(node)) {
                arrayList.add((Element)node);
            }
            ++n2;
        }
        if (arrayList.isEmpty() && this.isTreeElement(element)) {
            throw new RuntimeException("A formula tree with operand count = 0 is not allowed.");
        }
        if (element.getAttribute("operator").equals("NOT") && arrayList.size() != 1) {
            throw new RuntimeException("A formula with operator NOT has to have exactly one operand");
        }
        return arrayList.toArray(new Element[arrayList.size()]);
    }

    protected void makeBinary(Element element) {
        Element[] elementArray = this.getFormulaOperands(element);
        int n = 0;
        while (n < elementArray.length) {
            this.makeBinary(elementArray[n]);
            ++n;
        }
        if (!this.isTreeElement(element)) {
            this.logger.debug((Object)"No formula tree, returning...");
            return;
        }
        String string = element.getAttribute("operator");
        if (!this.isCorrectOperator(string)) {
            throw new RuntimeException("Operator " + string + " may not be used.");
        }
        Element element2 = element;
        Element element3 = null;
        int n2 = 1;
        while (n2 < elementArray.length - 1) {
            element3 = element2;
            element2 = this.getNewTreeElement();
            element2.setAttribute("operator", string);
            element2.appendChild(elementArray[n2]);
            element3.appendChild(element2);
            ++n2;
        }
        element2.appendChild(elementArray[elementArray.length - 1]);
    }

    protected abstract Element getNewTreeElement();

    protected abstract boolean isTreeElement(Node var1);

    protected abstract boolean isBasicElement(Node var1);

    protected abstract boolean isFormulaElement(Node var1);

    protected abstract boolean isCorrectOperator(String var1);
}

