/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.modsetannotator;

import de.uni_freiburg.informatik.ultimate.boogie.BoogieTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.CallStatement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Declaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.LeftHandSide;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Procedure;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Unit;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VarList;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableDeclaration;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.boogie.preprocessor.Activator;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelType;
import de.uni_freiburg.informatik.ultimate.core.model.observers.IUnmanagedObserver;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ModSetAnalyzer
extends BoogieTransformer
implements IUnmanagedObserver {
    private Map<String, Set<String>> mModifiedGlobals;
    private Set<String> mGlobals;
    private final IUltimateServiceProvider mServices;
    private final ILogger logger;
    private String mCurrentProcedure;
    private Map<String, Set<String>> mCallGraph;

    public ModSetAnalyzer(IUltimateServiceProvider iUltimateServiceProvider) {
        this.mServices = iUltimateServiceProvider;
        this.logger = this.mServices.getLoggingService().getLogger(Activator.PLUGIN_ID);
    }

    protected Map<String, Set<String>> getModifiedGlobals() {
        return this.mModifiedGlobals;
    }

    public boolean process(IElement iElement) throws Throwable {
        if (iElement instanceof Unit) {
            Declaration declaration;
            Unit unit = (Unit)iElement;
            this.mGlobals = new HashSet<String>();
            this.mModifiedGlobals = new HashMap<String, Set<String>>();
            this.mCallGraph = new HashMap<String, Set<String>>();
            Declaration[] declarationArray = unit.getDeclarations();
            int n = declarationArray.length;
            int n2 = 0;
            while (n2 < n) {
                declaration = declarationArray[n2];
                if (declaration instanceof VariableDeclaration) {
                    this.processGlobalVariableDeclaration((VariableDeclaration)declaration);
                }
                ++n2;
            }
            declarationArray = unit.getDeclarations();
            n = declarationArray.length;
            n2 = 0;
            while (n2 < n) {
                declaration = declarationArray[n2];
                this.processDeclaration(declaration);
                ++n2;
            }
            this.propagateModifies();
            return false;
        }
        return true;
    }

    private void propagateModifies() {
        for (Map.Entry<String, Set<String>> entry : this.mCallGraph.entrySet()) {
            for (String string : entry.getValue()) {
                HashSet<String> hashSet = new HashSet<String>();
                hashSet.add(entry.getKey());
                Set<String> set = this.mModifiedGlobals.get(entry.getKey());
                assert (set != null);
                set.addAll(this.getModifiesRecursive(hashSet, string));
            }
        }
    }

    private Set<String> getModifiesRecursive(Set<String> set, String string) {
        Set<String> set2;
        HashSet<String> hashSet = new HashSet<String>();
        if (set.contains(string)) {
            return hashSet;
        }
        set.add(string);
        Set<String> set3 = this.mModifiedGlobals.get(string);
        if (set3 != null) {
            hashSet.addAll(set3);
        }
        if ((set2 = this.mCallGraph.get(string)) != null) {
            for (String string2 : set2) {
                hashSet.addAll(this.getModifiesRecursive(set, string2));
            }
        }
        return hashSet;
    }

    public void init(ModelType modelType, int n, int n2) throws Throwable {
    }

    public void finish() throws Throwable {
    }

    public boolean performedChanges() {
        return false;
    }

    private void processGlobalVariableDeclaration(VariableDeclaration variableDeclaration) {
        VarList[] varListArray = variableDeclaration.getVariables();
        int n = varListArray.length;
        int n2 = 0;
        while (n2 < n) {
            VarList varList = varListArray[n2];
            Collections.addAll(this.mGlobals, varList.getIdentifiers());
            ++n2;
        }
    }

    protected Declaration processDeclaration(Declaration declaration) {
        Procedure procedure;
        this.mCurrentProcedure = null;
        if (declaration instanceof Procedure && (procedure = (Procedure)declaration).getBody() != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Processing procedure " + procedure.getIdentifier()));
            }
            this.mCurrentProcedure = procedure.getIdentifier();
            this.mModifiedGlobals.put(this.mCurrentProcedure, new HashSet());
            this.mCallGraph.put(this.mCurrentProcedure, new HashSet());
        }
        return super.processDeclaration(declaration);
    }

    protected LeftHandSide processLeftHandSide(LeftHandSide leftHandSide) {
        String string = null;
        if (this.mCurrentProcedure != null && leftHandSide instanceof VariableLHS && this.mGlobals.contains(string = ((VariableLHS)leftHandSide).getIdentifier())) {
            this.mModifiedGlobals.get(this.mCurrentProcedure).add(string);
        }
        return super.processLeftHandSide(leftHandSide);
    }

    protected Statement processStatement(Statement statement) {
        CallStatement callStatement;
        String string;
        if (this.mCurrentProcedure != null && statement instanceof CallStatement && !(string = (callStatement = (CallStatement)statement).getMethodName()).equals(this.mCurrentProcedure)) {
            this.mCallGraph.get(this.mCurrentProcedure).add(string);
        }
        return super.processStatement(statement);
    }
}

