/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt;

import de.uni_freiburg.informatik.ultimate.acsl.parser.ACSLSyntaxErrorException;
import de.uni_freiburg.informatik.ultimate.acsl.parser.Parser;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLProblemNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.core.dom.ast.IASTComment;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;

public class CommentParser {
    private final IASTComment[] mCommentList;
    private final HashMap<Integer, Integer> mFunctionLineRange;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;

    public CommentParser(IASTComment[] iASTCommentArray, HashMap<Integer, Integer> hashMap, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) {
        this.mCommentList = iASTCommentArray;
        this.mFunctionLineRange = hashMap;
        this.mLogger = iLogger;
        this.mServices = iUltimateServiceProvider;
    }

    public List<ACSLNode> processComments() {
        ArrayList<ACSLNode> arrayList = new ArrayList<ACSLNode>();
        IASTComment[] iASTCommentArray = this.mCommentList;
        int n = this.mCommentList.length;
        int n2 = 0;
        while (n2 < n) {
            String string;
            IASTComment iASTComment = iASTCommentArray[n2];
            if (iASTComment.isPartOfTranslationUnitFile() && ((string = new String(iASTComment.getComment())).startsWith("//@") || string.startsWith("/*@"))) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(this.determineCodePosition(iASTComment));
                stringBuilder.append('\n');
                stringBuilder.append(string, 2, string.length() - (string.endsWith("*/") ? 2 : 0));
                int n3 = iASTComment.getFileLocation().getStartingLineNumber();
                int n4 = CommentParser.getColumnOffset(iASTComment) + 2;
                try {
                    ACSLNode aCSLNode;
                    block13: {
                        try {
                            aCSLNode = Parser.parseComment((String)stringBuilder.toString(), (int)n3, (int)n4, (ILogger)this.mLogger);
                        }
                        catch (ExceptionInInitializerError exceptionInInitializerError) {
                            aCSLNode = Parser.parseComment((String)stringBuilder.toString(), (int)n3, (int)n4, (ILogger)this.mLogger);
                            break block13;
                        }
                        catch (NoClassDefFoundError noClassDefFoundError) {
                            try {
                                break block13;
                            }
                            catch (Throwable throwable) {
                                throw throwable;
                            }
                            finally {
                                aCSLNode = Parser.parseComment((String)stringBuilder.toString(), (int)n3, (int)n4, (ILogger)this.mLogger);
                            }
                        }
                        aCSLNode = Parser.parseComment((String)stringBuilder.toString(), (int)n3, (int)n4, (ILogger)this.mLogger);
                    }
                    if (aCSLNode != null) {
                        aCSLNode.setFileName(iASTComment.getContainingFilename());
                        arrayList.add(aCSLNode);
                    }
                }
                catch (ACSLSyntaxErrorException aCSLSyntaxErrorException) {
                    ACSLProblemNode aCSLProblemNode = new ACSLProblemNode(aCSLSyntaxErrorException.getMessageText());
                    aCSLProblemNode.setFileName(iASTComment.getContainingFilename());
                    aCSLProblemNode.setLocation(aCSLSyntaxErrorException.getLocation().getLocation());
                    arrayList.add((ACSLNode)aCSLProblemNode);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private static int getColumnOffset(IASTComment iASTComment) {
        IASTFileLocation iASTFileLocation = iASTComment.getFileLocation();
        if (!iASTComment.isPartOfTranslationUnitFile()) {
            return 0;
        }
        String string = iASTComment.getTranslationUnit().getRawSignature();
        int n = iASTFileLocation.getNodeOffset();
        int n2 = n - 1;
        while (n2 >= 0) {
            char c = string.charAt(n2);
            if (c == '\n' || c == '\r') {
                return n - n2 - 1;
            }
            --n2;
        }
        return n;
    }

    private String determineCodePosition(IASTComment iASTComment) {
        int n = iASTComment.getFileLocation().getStartingLineNumber();
        int n2 = iASTComment.getFileLocation().getEndingLineNumber();
        for (Integer n3 : this.mFunctionLineRange.keySet()) {
            if (n < n3 || n2 > this.mFunctionLineRange.get(n3)) continue;
            return "lstart";
        }
        return "gstart";
    }

    private static final class SimpleAcslLocation
    implements ILocation {
        private static final long serialVersionUID = 1L;
        private final ACSLNode mNode;

        private SimpleAcslLocation(ACSLNode aCSLNode) {
            this.mNode = aCSLNode;
        }

        public Map<String, Object> getAnnotationsAsMap() {
            return Collections.emptyMap();
        }

        public int getStartLine() {
            return this.mNode.getStartingLineNumber();
        }

        public int getStartColumn() {
            return this.mNode.getLocation().getStartColumn();
        }

        public String getFileName() {
            return this.mNode.getFileName();
        }

        public int getEndLine() {
            return this.mNode.getEndingLineNumber();
        }

        public int getEndColumn() {
            return this.mNode.getLocation().getEndColumn();
        }

        public String getFunction() {
            return null;
        }
    }
}

