/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.statistics;

import de.uni_freiburg.informatik.ultimate.util.statistics.IKeyedStatisticsElement;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsType;
import java.lang.invoke.LambdaMetafactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Function;

public class SifaStats
extends StatisticsGeneratorWithStopwatches
implements IStatisticsDataProvider {
    private static final StatisticsType<Key> TYPE = new StatisticsType(Key.class);
    private final Map<Key, Integer> mStopwatchNestingLevels = new EnumMap<Key, Integer>(Key.class);
    private final Map<Key, Integer> mIntCounters = new EnumMap<Key, Integer>(Key.class);
    private final Map<Key, MaxTimerData> mMaxTimerData = new EnumMap<Key, MaxTimerData>(Key.class);

    public void start(String string) {
        this.start(Key.valueOf(string));
    }

    public void start(Key key) {
        int n = this.mStopwatchNestingLevels.getOrDefault((Object)key, 0);
        if (n == 0) {
            super.start(key.name());
        } else if (n < 0) {
            throw new IllegalStateException("Negative nesting level for stopwatch " + String.valueOf((Object)key));
        }
        this.mStopwatchNestingLevels.put(key, n + 1);
    }

    public void stop(String string) {
        this.stop(Key.valueOf(string));
    }

    public void stop(Key key) {
        int n = this.mStopwatchNestingLevels.getOrDefault((Object)key, 0);
        if (n == 1) {
            super.stop(key.name());
        } else if (n < 1) {
            throw new IllegalStateException("Called stop() without start() for stopwatch " + String.valueOf((Object)key));
        }
        this.mStopwatchNestingLevels.put(key, n - 1);
    }

    public void startMax(Key key) {
        this.start(key);
    }

    public void stopMax(Key key2) {
        long l;
        this.stop(key2);
        try {
            l = this.getElapsedTime(key2.name());
        }
        catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
            throw new AssertionError((Object)"Clock still runing after it was stopped. Nesting MaxTimers not supported yet.");
        }
        MaxTimerData maxTimerData = this.mMaxTimerData.computeIfAbsent(key2, key -> new MaxTimerData());
        maxTimerData.mMaxTime = Math.max(maxTimerData.mMaxTime, l - maxTimerData.mTotalTime);
        maxTimerData.mTotalTime = l;
    }

    public Object getValue(String string) {
        return this.getValue(Key.valueOf(string));
    }

    public Object getValue(Key key) {
        if (key.isMaxTimer()) {
            return this.mMaxTimerData.computeIfAbsent((Key)key, (Function<Key, MaxTimerData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$1(de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats$Key ), (Lde/uni_freiburg/informatik/ultimate/lib/sifa/statistics/SifaStats$Key;)Lde/uni_freiburg/informatik/ultimate/lib/sifa/statistics/SifaStats$MaxTimerData;)()).mMaxTime;
        }
        if (key.isStopwatch()) {
            return this.valueOfStopwatch(key);
        }
        return this.valueOfIntCounter(key);
    }

    private Long valueOfStopwatch(Key key) {
        try {
            return this.getElapsedTime(key.name());
        }
        catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
            throw new AssertionError((Object)stopwatchStillRunningException);
        }
    }

    private Integer valueOfIntCounter(Key key) {
        return this.mIntCounters.getOrDefault((Object)key, 0);
    }

    public void increment(Key key) {
        this.add(key, 1);
    }

    public void add(Key key, int n) {
        this.mIntCounters.put(key, this.mIntCounters.getOrDefault((Object)key, 0) + n);
    }

    public Collection<String> getKeys() {
        return TYPE.getKeys();
    }

    public IStatisticsType getBenchmarkType() {
        return TYPE;
    }

    public String[] getStopwatches() {
        return (String[])Arrays.stream(Key.values()).filter(IKeyedStatisticsElement::isStopwatch).map(Enum::name).toArray(String[]::new);
    }

    private static /* synthetic */ MaxTimerData lambda$1(Key key) {
        return new MaxTimerData();
    }

    public static enum Key implements IKeyedStatisticsElement
    {
        OVERALL_TIME(KeyType.TIMER),
        ICFG_INTERPRETER_ENTERED_PROCEDURES(KeyType.COUNTER),
        DAG_INTERPRETER_EARLY_EXIT_QUERIES_NONTRIVIAL(KeyType.COUNTER),
        DAG_INTERPRETER_EARLY_EXITS(KeyType.COUNTER),
        TOOLS_POST_APPLICATIONS(KeyType.COUNTER),
        TOOLS_POST_TIME(KeyType.TIMER),
        TOOLS_POST_CALL_APPLICATIONS(KeyType.COUNTER),
        TOOLS_POST_CALL_TIME(KeyType.TIMER),
        TOOLS_POST_RETURN_APPLICATIONS(KeyType.COUNTER),
        TOOLS_POST_RETURN_TIME(KeyType.TIMER),
        TOOLS_QUANTIFIERELIM_APPLICATIONS(KeyType.COUNTER),
        TOOLS_QUANTIFIERELIM_TIME(KeyType.TIMER),
        TOOLS_QUANTIFIERELIM_MAX_TIME(KeyType.MAX_TIMER),
        FLUID_QUERY_TIME(KeyType.TIMER),
        FLUID_QUERIES(KeyType.COUNTER),
        FLUID_YES_ANSWERS(KeyType.COUNTER),
        DOMAIN_JOIN_APPLICATIONS(KeyType.COUNTER),
        DOMAIN_JOIN_TIME(KeyType.TIMER),
        DOMAIN_ALPHA_APPLICATIONS(KeyType.COUNTER),
        DOMAIN_ALPHA_TIME(KeyType.TIMER),
        DOMAIN_WIDEN_APPLICATIONS(KeyType.COUNTER),
        DOMAIN_WIDEN_TIME(KeyType.TIMER),
        DOMAIN_ISSUBSETEQ_APPLICATIONS(KeyType.COUNTER),
        DOMAIN_ISSUBSETEQ_TIME(KeyType.TIMER),
        DOMAIN_ISBOTTOM_APPLICATIONS(KeyType.COUNTER),
        DOMAIN_ISBOTTOM_TIME(KeyType.TIMER),
        LOOP_SUMMARIZER_APPLICATIONS(KeyType.COUNTER),
        LOOP_SUMMARIZER_CACHE_MISSES(KeyType.COUNTER),
        LOOP_SUMMARIZER_OVERALL_TIME(KeyType.TIMER),
        LOOP_SUMMARIZER_NEW_COMPUTATION_TIME(KeyType.TIMER),
        LOOP_SUMMARIZER_FIXPOINT_ITERATIONS(KeyType.COUNTER),
        CALL_SUMMARIZER_APPLICATIONS(KeyType.COUNTER),
        CALL_SUMMARIZER_CACHE_MISSES(KeyType.COUNTER),
        CALL_SUMMARIZER_OVERALL_TIME(KeyType.TIMER),
        CALL_SUMMARIZER_NEW_COMPUTATION_TIME(KeyType.TIMER),
        PROCEDURE_GRAPH_BUILDER_TIME(KeyType.TIMER),
        PATH_EXPR_TIME(KeyType.TIMER),
        REGEX_TO_DAG_TIME(KeyType.TIMER),
        DAG_COMPRESSION_TIME(KeyType.TIMER),
        DAG_COMPRESSION_PROCESSED_NODES(KeyType.COUNTER),
        DAG_COMPRESSION_RETAINED_NODES(KeyType.COUNTER);

        private final KeyType mType;

        private Key(KeyType keyType) {
            this.mType = keyType;
        }

        public KeyType getType() {
            return this.mType;
        }

        public String getName() {
            return this.name();
        }
    }

    private static class MaxTimerData {
        private long mTotalTime;
        private long mMaxTime;

        private MaxTimerData() {
        }
    }
}

