/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector;

import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.AstarAnnotation;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.irsdependencies.loopdetector.ScopedHashMap;
import java.util.Map;

class OpenItem<V, E> {
    private final V mNode;
    private final ScopedHashMap<V, AstarAnnotation<E>> mAnnotations;
    private AstarAnnotation<E> mAnnotation;

    public OpenItem(V v, Map<V, AstarAnnotation<E>> map) {
        this.mNode = v;
        this.mAnnotations = new ScopedHashMap();
        for (Map.Entry<V, AstarAnnotation<E>> entry : map.entrySet()) {
            this.mAnnotations.put((AstarAnnotation<E>)entry.getKey(), entry.getValue());
        }
    }

    public OpenItem(V v, OpenItem<V, E> openItem) {
        this.mNode = v;
        this.mAnnotations = new ScopedHashMap<AstarAnnotation<E>, AstarAnnotation<E>>(openItem.mAnnotations);
    }

    public V getNode() {
        return this.mNode;
    }

    public ScopedHashMap<V, AstarAnnotation<E>> getAnnotations() {
        return this.mAnnotations;
    }

    public AstarAnnotation<E> getAnnotation() {
        if (this.mAnnotation == null) {
            this.mAnnotation = this.mAnnotations.get(this.mNode);
        }
        return this.mAnnotation;
    }

    public int hashCode() {
        return this.getAnnotation().hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!object.getClass().equals(this.getClass())) {
            return false;
        }
        OpenItem openItem = (OpenItem)object;
        return openItem.getAnnotation().equals(this.getAnnotation());
    }
}

