/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.model.acsl.ast;

import de.uni_freiburg.informatik.ultimate.model.acsl.ACSLNode;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLTransformer;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLType;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.ACSLVisitor;
import de.uni_freiburg.informatik.ultimate.model.acsl.ast.Expression;
import java.util.List;
import java.util.function.Predicate;

public final class IntegerLiteral
extends Expression {
    private static final Predicate<ACSLNode> VALIDATOR = ACSLNode.VALIDATORS.get(IntegerLiteral.class);
    String value;

    public IntegerLiteral(String string) {
        this.value = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IntegerLiteral: " + String.valueOf(this);
    }

    public IntegerLiteral(ACSLType aCSLType, String string) {
        super(aCSLType);
        this.value = string;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid IntegerLiteral: " + String.valueOf(this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("IntegerLiteral").append('[');
        stringBuffer.append(this.value);
        return stringBuffer.append(']').toString();
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public List<ACSLNode> getOutgoingNodes() {
        List<ACSLNode> list = super.getOutgoingNodes();
        return list;
    }

    @Override
    public void accept(ACSLVisitor aCSLVisitor) {
        if (!aCSLVisitor.visit((Expression)this)) {
            return;
        }
        if (aCSLVisitor.visit(this) && this.type != null) {
            this.type.accept(aCSLVisitor);
        }
    }

    @Override
    public Expression accept(ACSLTransformer aCSLTransformer) {
        Expression expression = aCSLTransformer.transform(this);
        if (expression != this) {
            return expression;
        }
        ACSLType aCSLType = null;
        if (this.type != null) {
            aCSLType = this.type.accept(aCSLTransformer);
        }
        if (this.type != aCSLType) {
            return new IntegerLiteral(aCSLType, this.value);
        }
        return this;
    }
}

