/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.smtinterpol.proof;

import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Clause;
import de.uni_freiburg.informatik.ultimate.smtinterpol.dpll.Literal;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ProofNode;
import de.uni_freiburg.informatik.ultimate.smtinterpol.proof.ResolutionNode;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class UnitCollector {
    private Map<Clause, Integer> mCounts;
    private Queue<ResolutionNode.Antecedent> mUnits;
    private final Deque<Clause> mTodo = new ArrayDeque<Clause>();
    private HashMap<Clause, Integer> mSeen;
    private HashMap<Clause, Set<Literal>> mDelUnits;

    public Queue<ResolutionNode.Antecedent> collectUnits(Clause clause, Map<Clause, Integer> map) {
        this.mCounts = map;
        this.mDelUnits = new HashMap();
        this.mUnits = new ArrayDeque<ResolutionNode.Antecedent>();
        this.mSeen = new HashMap();
        this.mTodo.push(clause);
        this.run();
        return this.mUnits;
    }

    private void run() {
        while (!this.mTodo.isEmpty()) {
            ProofNode proofNode;
            Clause clause = this.mTodo.pop();
            if (!this.seen(clause)) continue;
            if (clause.getSize() == 1 && this.mCounts.get(clause) > 1) {
                this.mUnits.add(new ResolutionNode.Antecedent(clause.getLiteral(0), clause));
            }
            if ((proofNode = clause.getProof()).isLeaf()) continue;
            HashSet<Literal> hashSet = null;
            ResolutionNode resolutionNode = (ResolutionNode)proofNode;
            ResolutionNode.Antecedent[] antecedentArray = resolutionNode.getAntecedents();
            int n = antecedentArray.length - 1;
            while (n >= 0) {
                if (antecedentArray[n].mAntecedent.getSize() == 1 && this.mCounts.get(antecedentArray[n].mAntecedent) > 1) {
                    if (hashSet == null) {
                        hashSet = new HashSet<Literal>();
                    }
                    hashSet.add(antecedentArray[n].mPivot);
                }
                this.mTodo.push(antecedentArray[n].mAntecedent);
                --n;
            }
            this.mTodo.push(resolutionNode.getPrimary());
            if (hashSet == null) continue;
            this.mDelUnits.put(clause, hashSet);
        }
    }

    private boolean seen(Clause clause) {
        Integer n = this.mSeen.get(clause);
        int n2 = n == null ? 1 : n + 1;
        this.mSeen.put(clause, n2);
        int n3 = this.mCounts.get(clause);
        assert (n2 <= n3);
        return n3 == n2;
    }

    public Map<Clause, Set<Literal>> getDeletedNodes() {
        return this.mDelUnits;
    }
}

