/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.AutomataOperationCanceledException;
import de.uni_freiburg.informatik.ultimate.automata.AutomatonDefinitionPrinter;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaInclusionStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.INwaOutgoingLetterAndTransitionProvider;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Difference;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.Intersect;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsEmpty;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.IsIncluded;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.AbstractMinimizeNwa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationCheckResultStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.IMinimizationStateFactory;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.MinimizeSevpa;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.operations.minimization.util.TimeoutFlag;
import de.uni_freiburg.informatik.ultimate.automata.util.PartitionBackedSetOfPairs;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collection;
import java.util.Collections;

public final class MinimizeNwaOverapproximation<LETTER, STATE>
extends AbstractMinimizeNwa<LETTER, STATE> {
    public static final int DEFAULT_TIMEOUT = 1000;
    private static final String THE_RESULT_RECOGNIZES_LESS_WORDS_THAN_BEFORE = "The result recognizes less words than before.";
    private final INestedWordAutomaton<LETTER, STATE> mOperand;

    public <SF extends IMinimizationStateFactory<STATE> & INwaInclusionStateFactory<STATE>> MinimizeNwaOverapproximation(AutomataLibraryServices automataLibraryServices, SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) throws AutomataOperationCanceledException {
        this(automataLibraryServices, SF, iNestedWordAutomaton, 1000);
    }

    public <SF extends IMinimizationStateFactory<STATE> & INwaInclusionStateFactory<STATE>> MinimizeNwaOverapproximation(AutomataLibraryServices automataLibraryServices, SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, int n) throws AutomataOperationCanceledException {
        this(automataLibraryServices, SF, iNestedWordAutomaton, (PartitionBackedSetOfPairs<STATE>)null, false, n, Collections.emptyList());
    }

    public <SF extends IMinimizationStateFactory<STATE> & INwaInclusionStateFactory<STATE>> MinimizeNwaOverapproximation(AutomataLibraryServices automataLibraryServices, SF SF, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, PartitionBackedSetOfPairs<STATE> partitionBackedSetOfPairs, boolean bl, int n, Collection<? extends INwaOutgoingLetterAndTransitionProvider<LETTER, STATE>> collection) throws AutomataOperationCanceledException {
        super(automataLibraryServices, SF);
        this.mOperand = iNestedWordAutomaton;
        TimeoutFlag timeoutFlag = new TimeoutFlag(n);
        MinimizeSevpa<LETTER, STATE> minimizeSevpa = new MinimizeSevpa<LETTER, STATE>(automataLibraryServices, SF, iNestedWordAutomaton, partitionBackedSetOfPairs, bl, timeoutFlag, false);
        this.constructResult(minimizeSevpa.getConstructionInterrupted(), (INestedWordAutomaton<LETTER, STATE>)minimizeSevpa.getResult(), collection, SF);
    }

    @Override
    protected INestedWordAutomaton<LETTER, STATE> getOperand() {
        return this.mOperand;
    }

    @Override
    public Pair<Boolean, String> checkResultHelper(IMinimizationCheckResultStateFactory<STATE> iMinimizationCheckResultStateFactory) throws AutomataLibraryException {
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Start testing correctness of " + this.getOperationName()));
        }
        boolean bl = new IsIncluded<LETTER, STATE>(this.mServices, iMinimizationCheckResultStateFactory, this.mOperand, this.getResult()).getResult();
        assert (bl);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)("Finished testing correctness of " + this.getOperationName()));
        }
        if (!bl) {
            AutomatonDefinitionPrinter.writeToFileIfPreferred(this.mServices, this.getOperationName() + "Failed", THE_RESULT_RECOGNIZES_LESS_WORDS_THAN_BEFORE, this.mOperand);
            return new Pair((Object)bl, (Object)THE_RESULT_RECOGNIZES_LESS_WORDS_THAN_BEFORE);
        }
        return new Pair((Object)bl, null);
    }

    private void constructResult(boolean bl, INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Collection<? extends INwaOutgoingLetterAndTransitionProvider<LETTER, STATE>> collection, INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataOperationCanceledException {
        if (!bl || collection.isEmpty() || this.mOperand.size() == iNestedWordAutomaton.size()) {
            this.directResultConstruction(iNestedWordAutomaton);
            return;
        }
        this.minimizeWithDifferenceRefinement(iNestedWordAutomaton, collection, iNwaInclusionStateFactory);
    }

    private void minimizeWithDifferenceRefinement(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton, Collection<? extends INwaOutgoingLetterAndTransitionProvider<LETTER, STATE>> collection, INwaInclusionStateFactory<STATE> iNwaInclusionStateFactory) throws AutomataOperationCanceledException, AssertionError {
        INestedWordAutomaton iNestedWordAutomaton2 = iNestedWordAutomaton;
        for (INwaOutgoingLetterAndTransitionProvider<LETTER, STATE> iNwaOutgoingLetterAndTransitionProvider : collection) {
            Object object;
            try {
                object = new Intersect<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, iNestedWordAutomaton2, iNwaOutgoingLetterAndTransitionProvider).getResult();
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                throw automataOperationCanceledException;
            }
            catch (AutomataLibraryException automataLibraryException) {
                throw new AssertionError((Object)automataLibraryException.getMessage());
            }
            if (new IsEmpty(this.mServices, object).getResult().booleanValue()) continue;
            try {
                iNestedWordAutomaton2 = new Difference<LETTER, STATE>(this.mServices, iNwaInclusionStateFactory, iNestedWordAutomaton2, iNwaOutgoingLetterAndTransitionProvider).getResult();
            }
            catch (AutomataOperationCanceledException automataOperationCanceledException) {
                throw automataOperationCanceledException;
            }
            catch (AutomataLibraryException automataLibraryException) {
                throw new AssertionError((Object)automataLibraryException.getMessage());
            }
        }
        if (iNestedWordAutomaton2.size() >= this.mOperand.size()) {
            if (this.mLogger.isWarnEnabled()) {
                this.mLogger.warn((Object)"Minimization did not decrease the size.");
            }
            this.directResultConstruction(this.mOperand);
        } else {
            this.directResultConstruction(iNestedWordAutomaton2);
        }
    }
}

