/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.Attribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class NamedAttribute
extends Attribute {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(NamedAttribute.class);
    String name;
    Expression[] values;

    public NamedAttribute(ILocation iLocation, String string, Expression[] expressionArray) {
        super(iLocation);
        this.name = string;
        this.values = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid NamedAttribute: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("NamedAttribute").append('[');
        stringBuffer.append(this.name);
        stringBuffer.append(',');
        if (this.values == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            int n = 0;
            while (n < this.values.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.values[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public String getName() {
        return this.name;
    }

    public Expression[] getValues() {
        return this.values;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.values != null) {
            list.addAll(Arrays.asList(this.values));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Attribute)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this) && this.values != null) {
            Expression[] expressionArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                expression.accept(generatedBoogieAstVisitor);
                ++n2;
            }
        }
    }

    @Override
    public Attribute accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Attribute attribute = generatedBoogieAstTransformer.transform(this);
        if (attribute != this) {
            return attribute;
        }
        boolean bl = false;
        ArrayList<Expression> arrayList = new ArrayList<Expression>();
        if (this.values != null) {
            Expression[] expressionArray = this.values;
            int n = this.values.length;
            int n2 = 0;
            while (n2 < n) {
                Expression expression = expressionArray[n2];
                Expression expression2 = expression.accept(generatedBoogieAstTransformer);
                bl = bl || expression2 != expression;
                arrayList.add(expression2);
                ++n2;
            }
        }
        if (bl) {
            return new NamedAttribute(this.loc, this.name, arrayList.toArray(new Expression[0]));
        }
        return this;
    }
}

