/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.reachingdefinitions.paralleldfg;

import de.uni_freiburg.informatik.ultimate.core.lib.models.ModifiableLabeledEdgesMultigraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import java.util.Map;
import java.util.Set;

public class ParallelDataflowgraph<T>
extends ModifiableLabeledEdgesMultigraph<ParallelDataflowgraph<T>, IProgramVar> {
    private static final long serialVersionUID = 1L;
    private Map<String, Set<IcfgLocation>> mLocations;
    private final T mNodeLabel;

    public ParallelDataflowgraph(T t, Map<String, Set<IcfgLocation>> map) {
        this.mNodeLabel = t;
        this.setLocations(map);
    }

    public Boolean compare(T t, Map<String, Set<IcfgLocation>> map) {
        if (t == this.mNodeLabel && map.equals(this.mLocations)) {
            return true;
        }
        return false;
    }

    public Boolean compare(ParallelDataflowgraph<T> parallelDataflowgraph) {
        if (parallelDataflowgraph.getNodeLabel() == this.mNodeLabel && parallelDataflowgraph.getLocations().equals(this.mLocations)) {
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Statement: ");
        if (this.mNodeLabel == null) {
            stringBuilder.append("no statement").append(" Locations: ");
        } else {
            stringBuilder.append(this.mNodeLabel.toString()).append(" Locations: ");
        }
        for (Map.Entry<String, Set<IcfgLocation>> entry : this.mLocations.entrySet()) {
            stringBuilder.append(entry.getKey()).append(entry.getValue().toString());
        }
        return stringBuilder.toString();
    }

    public T getNodeLabel() {
        return this.mNodeLabel;
    }

    public Map<String, Set<IcfgLocation>> getLocations() {
        return this.mLocations;
    }

    public Set<IcfgLocation> getLocations(String string) {
        return this.mLocations.get(string);
    }

    private void setLocations(Map<String, Set<IcfgLocation>> map) {
        this.mLocations = map;
    }
}

