/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck;

import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;

public class TraceCheckReasonUnknown {
    private static final String SMTINTERPOL_NONLINEAR_ARITHMETIC_MESSAGE = "Unsupported non-linear arithmetic";
    private static final String SMTINTERPOL_ROUNDINGMODE_MESSAGE = "Unsupported internal sort: RoundingMode";
    private static final String SMTINTERPOL_CONST_FINITE_MESSAGE = "Const is only supported for infinite index sort";
    private static final String CVC4_NONLINEAR_ARITHMETIC_MESSAGE_PREFIX = "A non-linear fact";
    private static final String CVC4_CONST_ARRAY_WRITE_CHAIN_CONNECTION_MESSAGE = "Array theory solver does not yet support write-chains connecting two different constant arrays";
    private final Reason mReason;
    private final Exception mException;
    private final ExceptionHandlingCategory mExceptionHandlingCategory;

    public TraceCheckReasonUnknown(Reason reason, Exception exception, ExceptionHandlingCategory exceptionHandlingCategory) {
        this.mReason = reason;
        this.mException = exception;
        this.mExceptionHandlingCategory = exceptionHandlingCategory;
    }

    public Reason getReason() {
        return this.mReason;
    }

    public Exception getException() {
        return this.mException;
    }

    public ExceptionHandlingCategory getExceptionHandlingCategory() {
        return this.mExceptionHandlingCategory;
    }

    public static TraceCheckReasonUnknown constructReasonUnknown(SMTLIBException sMTLIBException) {
        ExceptionHandlingCategory exceptionHandlingCategory;
        Reason reason;
        String string = sMTLIBException.getMessage();
        if (string == null) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionHandlingCategory = ExceptionHandlingCategory.UNKNOWN;
        } else if (string.equals(SMTINTERPOL_NONLINEAR_ARITHMETIC_MESSAGE)) {
            reason = Reason.UNSUPPORTED_NON_LINEAR_ARITHMETIC;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.equals(CVC4_CONST_ARRAY_WRITE_CHAIN_CONNECTION_MESSAGE)) {
            reason = Reason.UNSUPPORTED_CONST_ARRAY_WRITE_CHAINS;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.startsWith("Cannot handle literal")) {
            reason = Reason.UNSUPPORTED_QUANTIFIERS;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_DEPENDING;
        } else if (string.startsWith(CVC4_NONLINEAR_ARITHMETIC_MESSAGE_PREFIX)) {
            reason = Reason.UNSUPPORTED_NON_LINEAR_ARITHMETIC;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.endsWith("Connection to SMT solver broken")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_DEPENDING;
        } else if (string.startsWith("External (MP /opt/bin/mathsat -theory.fp.to_bv_overflow_mode=1 -theory.fp.minmax_zero_mode=4 -theory.bv.div_by_zero_mode=1 -unsat_core_generation=3") && string.endsWith("with exit command (exit)) Received EOF on stdin. No stderr output.")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.equals("Invalid model")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.endsWith("Received EOF on stdin. No stderr output.")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_DEPENDING;
        } else if (string.contains("Received EOF on stdin. stderr output:")) {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_THROW;
        } else if (string.startsWith("Logic does not allow numerals")) {
            reason = Reason.SOLVER_CRASH_WRONG_USAGE;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.startsWith("Timeout exceeded")) {
            reason = Reason.SOLVER_RESPONSE_TIMEOUT;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.startsWith("ERROR: bvadd takes exactly 2 arguments")) {
            reason = Reason.ULTIMATE_VIOLATES_SMT_LIB_STANDARD_AND_SOLVER_COMPLAINS;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.equals(SMTINTERPOL_ROUNDINGMODE_MESSAGE)) {
            reason = Reason.UNSUPPORTED_ROUNDINGMODE;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.equals(SMTINTERPOL_CONST_FINITE_MESSAGE)) {
            reason = Reason.UNSUPPORTED_FINITE_CONST_ARRAYS;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.contains("unknown symbol: roundNearestTiesToAway")) {
            reason = Reason.MATHSAT_ROUNDINGMODE;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else if (string.contains("unknown symbol: fp.rem")) {
            reason = Reason.MATHSAT_REMAINDER;
            exceptionHandlingCategory = ExceptionHandlingCategory.KNOWN_IGNORE;
        } else {
            reason = Reason.SOLVER_CRASH_OTHER;
            exceptionHandlingCategory = ExceptionHandlingCategory.UNKNOWN;
        }
        return new TraceCheckReasonUnknown(reason, (Exception)((Object)sMTLIBException), exceptionHandlingCategory);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append((Object)this.getReason());
        if (this.getException() != null) {
            stringBuilder.append(": ").append(this.getException().getMessage());
        }
        return stringBuilder.toString();
    }

    public static enum ExceptionHandlingCategory {
        KNOWN_IGNORE,
        KNOWN_DEPENDING,
        KNOWN_THROW,
        UNKNOWN;


        public boolean throwException(RefinementStrategyExceptionBlacklist refinementStrategyExceptionBlacklist) {
            switch (refinementStrategyExceptionBlacklist) {
                case ALL: {
                    return true;
                }
                case DEPENDING: {
                    return this == UNKNOWN || this == KNOWN_THROW || this == KNOWN_DEPENDING;
                }
                case UNKNOWN: {
                    return this == UNKNOWN || this == KNOWN_THROW;
                }
                case NONE: {
                    return false;
                }
            }
            throw new IllegalArgumentException("Unknown category specification: " + String.valueOf((Object)refinementStrategyExceptionBlacklist));
        }
    }

    public static enum Reason {
        SOLVER_RESPONSE_TIMEOUT,
        SOLVER_RESPONSE_OTHER,
        ULTIMATE_TIMEOUT,
        UNSUPPORTED_NON_LINEAR_ARITHMETIC,
        UNSUPPORTED_CONST_ARRAY_WRITE_CHAINS,
        UNSUPPORTED_QUANTIFIERS,
        SOLVER_CRASH_WRONG_USAGE,
        SOLVER_CRASH_OTHER,
        ULTIMATE_VIOLATES_SMT_LIB_STANDARD_AND_SOLVER_COMPLAINS,
        UNSUPPORTED_ROUNDINGMODE,
        UNSUPPORTED_FINITE_CONST_ARRAYS,
        MATHSAT_ROUNDINGMODE,
        MATHSAT_REMAINDER;

    }

    public static enum RefinementStrategyExceptionBlacklist {
        NONE,
        UNKNOWN,
        DEPENDING,
        ALL;

    }
}

