/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction;

import de.uni_freiburg.informatik.ultimate.lib.tracecheckerutils.CoverageAnalysis;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarLoopStatisticsDefinitions;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.CegarStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsAggregator;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsData;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsGeneratorWithStopwatches;
import java.util.Collection;

public class CegarLoopStatisticsGenerator
extends StatisticsGeneratorWithStopwatches
implements IStatisticsDataProvider {
    private final StatisticsData mReuseStats = new StatisticsData();
    private final StatisticsAggregator mEcData = new StatisticsAggregator();
    private final StatisticsData mPredicateUnifierData = new StatisticsData();
    private final StatisticsData mTcData = new StatisticsData();
    private final StatisticsData mTiData = new StatisticsData();
    private final StatisticsData mAmData = new StatisticsData();
    private final StatisticsData mHoareAnnotationData = new StatisticsData();
    private final StatisticsData mInterpolantConsolidationBenchmarks = new StatisticsData();
    private final StatisticsData mPathInvariantsStatistics = new StatisticsData();
    private final StatisticsData mRefinementEngineStatistics = new StatisticsData();
    private final StatisticsData mConComCheckerStatistics = new StatisticsData();
    private int mIterations = 0;
    private CegarStatisticsType.SizeIterationPair mBiggestAbstraction = new CegarStatisticsType.SizeIterationPair(-1, -1);
    private CoverageAnalysis.BackwardCoveringInformation mBCI = new CoverageAnalysis.BackwardCoveringInformation(0, 0);
    private int mTraceHistogramMaximum = 0;
    private int mInterpolantAutomatonStates = 0;
    private int mPathProgramHistogramMaximum = 0;

    public Collection<String> getKeys() {
        return this.getBenchmarkType().getKeys();
    }

    public void addReuseStats(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mReuseStats.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addEdgeCheckerData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mEcData.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addPredicateUnifierData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mPredicateUnifierData.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addTraceCheckData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mTcData.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addRefinementEngineStatistics(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mRefinementEngineStatistics.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addTotalInterpolationData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mTiData.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addBackwardCoveringInformation(CoverageAnalysis.BackwardCoveringInformation backwardCoveringInformation) {
        this.mBCI = new CoverageAnalysis.BackwardCoveringInformation(this.mBCI, backwardCoveringInformation);
    }

    public void announceNextIteration() {
        ++this.mIterations;
    }

    public void addAutomataMinimizationData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mAmData.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addHoareAnnotationData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mHoareAnnotationData.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public void addConComCheckerData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.mConComCheckerStatistics.aggregateBenchmarkData(iStatisticsDataProvider);
    }

    public boolean reportAbstractionSize(int n, int n2) {
        if (n > this.mBiggestAbstraction.getSize()) {
            this.mBiggestAbstraction = new CegarStatisticsType.SizeIterationPair(n, n2);
            return true;
        }
        return false;
    }

    public void reportTraceHistogramMaximum(int n) {
        if (n > this.mTraceHistogramMaximum) {
            this.mTraceHistogramMaximum = n;
        }
    }

    public void reportPathProgramHistogramMaximum(int n) {
        if (n > this.mPathProgramHistogramMaximum) {
            this.mPathProgramHistogramMaximum = n;
        }
    }

    public void reportInterpolantAutomatonStates(int n) {
        this.mInterpolantAutomatonStates += n;
    }

    public Object getValue(String string) {
        Object object;
        CegarLoopStatisticsDefinitions cegarLoopStatisticsDefinitions = CegarLoopStatisticsDefinitions.valueOf(string);
        switch (cegarLoopStatisticsDefinitions) {
            case OverallTime: 
            case EmptinessCheckTime: 
            case AutomataDifference: 
            case DeadEndRemovalTime: 
            case HoareAnnotationTime: 
            case InitialAbstractionConstructionTime: 
            case BasicInterpolantAutomatonTime: 
            case DumpTime: {
                try {
                    object = this.getElapsedTime(string);
                    break;
                }
                catch (StatisticsGeneratorWithStopwatches.StopwatchStillRunningException stopwatchStillRunningException) {
                    throw new AssertionError((Object)("clock still running: " + string));
                }
            }
            case HoareTripleCheckerStatistics: {
                object = this.mEcData;
                break;
            }
            case ReuseStatistics: {
                object = this.mReuseStats;
                break;
            }
            case PredicateUnifierStatistics: {
                object = this.mPredicateUnifierData;
                break;
            }
            case traceCheckStatistics: {
                object = this.mTcData;
                break;
            }
            case InterpolantConsolidationStatistics: {
                object = this.mInterpolantConsolidationBenchmarks;
                break;
            }
            case PathInvariantsStatistics: {
                object = this.mPathInvariantsStatistics;
                break;
            }
            case TotalInterpolationStatistics: {
                object = this.mTiData;
                break;
            }
            case OverallIterations: {
                object = this.mIterations;
                break;
            }
            case TraceHistogramMax: {
                object = this.mTraceHistogramMaximum;
                break;
            }
            case PathProgramHistogramMax: {
                object = this.mPathProgramHistogramMaximum;
                break;
            }
            case BiggestAbstraction: {
                object = this.mBiggestAbstraction;
                break;
            }
            case InterpolantAutomatonStates: {
                object = this.mInterpolantAutomatonStates;
                break;
            }
            case InterpolantCoveringCapability: {
                object = this.mBCI;
                break;
            }
            case AutomataMinimizationStatistics: {
                object = this.mAmData;
                break;
            }
            case HoareAnnotationStatistics: {
                object = this.mHoareAnnotationData;
                break;
            }
            case RefinementEngineStatistics: {
                object = this.mRefinementEngineStatistics;
                break;
            }
            case ConComCheckerStatistics: {
                object = this.mConComCheckerStatistics;
                break;
            }
            default: {
                throw new MatchException(null, null);
            }
        }
        return object;
    }

    public IStatisticsType getBenchmarkType() {
        return CegarStatisticsType.getInstance();
    }

    public String[] getStopwatches() {
        return new String[]{CegarLoopStatisticsDefinitions.OverallTime.toString(), CegarLoopStatisticsDefinitions.EmptinessCheckTime.toString(), CegarLoopStatisticsDefinitions.AutomataDifference.toString(), CegarLoopStatisticsDefinitions.DeadEndRemovalTime.toString(), CegarLoopStatisticsDefinitions.HoareAnnotationTime.toString(), CegarLoopStatisticsDefinitions.BasicInterpolantAutomatonTime.toString(), CegarLoopStatisticsDefinitions.DumpTime.toString(), CegarLoopStatisticsDefinitions.InitialAbstractionConstructionTime.toString()};
    }
}

