/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lassoranker;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.transformulatransformers.TermException;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public class ModelExtractionUtils {
    public static final long s_randomSeed = 80085L;
    protected static final int s_numof_simultaneous_simplification_tests = 4;

    public static Rational const2Rational(Term term) throws TermException {
        Object object;
        if (term instanceof ApplicationTerm) {
            object = (ApplicationTerm)term;
            if (object.getFunction().getName().equals("+")) {
                return ModelExtractionUtils.const2Rational(object.getParameters()[0]).add(ModelExtractionUtils.const2Rational(object.getParameters()[1]));
            }
            if (object.getFunction().getName().equals("-")) {
                if (object.getParameters().length == 1) {
                    return ModelExtractionUtils.const2Rational(object.getParameters()[0]).mul(Rational.MONE);
                }
                return ModelExtractionUtils.const2Rational(object.getParameters()[0]).sub(ModelExtractionUtils.const2Rational(object.getParameters()[1]));
            }
            if (object.getFunction().getName().equals("*")) {
                return ModelExtractionUtils.const2Rational(object.getParameters()[0]).mul(ModelExtractionUtils.const2Rational(object.getParameters()[1]));
            }
            if (object.getFunction().getName().equals("/")) {
                return ModelExtractionUtils.const2Rational(object.getParameters()[0]).div(ModelExtractionUtils.const2Rational(object.getParameters()[1]));
            }
        }
        if (term instanceof ConstantTerm) {
            object = ((ConstantTerm)term).getValue();
            if (object instanceof BigInteger) {
                return Rational.valueOf((BigInteger)((BigInteger)object), (BigInteger)BigInteger.ONE);
            }
            if (object instanceof BigDecimal) {
                Rational rational;
                BigDecimal bigDecimal = (BigDecimal)object;
                if (bigDecimal.scale() <= 0) {
                    BigInteger bigInteger = bigDecimal.toBigInteger();
                    rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)BigInteger.ONE);
                } else {
                    BigInteger bigInteger = bigDecimal.unscaledValue();
                    BigInteger bigInteger2 = BigInteger.TEN.pow(bigDecimal.scale());
                    rational = Rational.valueOf((BigInteger)bigInteger, (BigInteger)bigInteger2);
                }
                return rational;
            }
            if (object instanceof Rational) {
                return (Rational)object;
            }
            throw new TermException("Unknown value class", term);
        }
        throw new TermException("Unknown term structure", term);
    }

    public static Map<Term, Rational> getValuation(Script script, Collection<Term> collection) throws TermException {
        LinkedHashMap<Term, Rational> linkedHashMap = new LinkedHashMap<Term, Rational>();
        if (!collection.isEmpty()) {
            Map map = script.getValue(collection.toArray(new Term[collection.size()]));
            for (Map.Entry entry : map.entrySet()) {
                linkedHashMap.put((Term)entry.getKey(), ModelExtractionUtils.const2Rational((Term)entry.getValue()));
            }
        }
        return linkedHashMap;
    }

    @Deprecated
    protected int simplifyAssignment(Script script, ArrayList<Term> arrayList, ILogger iLogger) {
        Random random = new Random(80085L);
        Collections.shuffle(arrayList, random);
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < arrayList.size()) {
            Term term = arrayList.get(n3);
            script.push(1);
            script.assertTerm(script.term("=", new Term[]{term, SmtUtils.constructIntValue((Script)script, (BigInteger)BigInteger.ZERO)}));
            Script.LBool lBool = script.checkSat();
            ++n2;
            if (lBool != Script.LBool.SAT) {
                script.pop(1);
                if (n3 == arrayList.size() - 1) {
                    lBool = script.checkSat();
                    ++n2;
                    assert (lBool == Script.LBool.SAT);
                }
            } else {
                ++n;
            }
            ++n3;
        }
        iLogger.info((Object)("Simplification made " + n2 + " calls to the SMT solver."));
        return n;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Term, Rational> getSimplifiedAssignment(Script script, Collection<Term> collection, ILogger iLogger, IUltimateServiceProvider iUltimateServiceProvider) throws TermException {
        void var10_20;
        Random random = new Random(80085L);
        Map<Term, Rational> map = ModelExtractionUtils.getValuation(script, collection);
        HashSet<Term> hashSet = new HashSet<Term>();
        HashSet<Term> hashSet2 = new HashSet<Term>(collection);
        int n = 0;
        int n2 = 0;
        while (true) {
            void var10_16;
            for (Map.Entry<Term, Rational> n5 : map.entrySet()) {
                if (!n5.getValue().equals((Object)Rational.ZERO)) continue;
                hashSet.add(n5.getKey());
                hashSet2.remove(n5.getKey());
            }
            if (hashSet2.size() <= 4) break;
            if (!iUltimateServiceProvider.getProgressMonitorService().continueProcessing()) {
                throw new ToolchainCanceledException(ModelExtractionUtils.class, "simplifying assignment for " + collection.size() + "variables");
            }
            script.push(1);
            for (Term term : hashSet) {
                script.assertTerm(script.term("=", new Term[]{term, Rational.ZERO.toTerm(term.getSort())}));
            }
            boolean bl = false;
            while (var10_16 < 10) {
                Map.Entry<Term, Rational> entry = new ArrayList<Term>(hashSet2);
                Collections.shuffle(entry, random);
                Term[] termArray = new Term[4];
                int n3 = 0;
                while (n3 < 4) {
                    termArray[n3] = script.term("=", new Term[]{(Term)entry.get(n3), Rational.ZERO.toTerm(((Term)entry.get(n3)).getSort())});
                    ++n3;
                }
                script.assertTerm(SmtUtils.or((Script)script, (Term[])termArray));
                ++var10_16;
            }
            ++n;
            Script.LBool term2 = script.checkSat();
            if (term2 == Script.LBool.SAT) {
                map = ModelExtractionUtils.getValuation(script, hashSet2);
            } else if (++n2 > 1) {
                script.pop(1);
                break;
            }
            script.pop(1);
        }
        for (Term term : hashSet) {
            map.put(term, Rational.ZERO);
        }
        iLogger.info((Object)("Simplification made " + n + " calls to the SMT solver."));
        boolean bl = false;
        for (Map.Entry<Term, Rational> entry : map.entrySet()) {
            if (!entry.getValue().equals((Object)Rational.ZERO)) continue;
            ++var10_20;
        }
        iLogger.info((Object)("Setting " + (int)var10_20 + " variables to zero."));
        return map;
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static Map<Term, Rational> getSimplifiedAssignment_TwoMode(Script var0, Collection<Term> var1_1, ILogger var2_2, IUltimateServiceProvider var3_3) throws TermException {
        var4_4 = new HashSet<Term>();
        var5_5 = new HashSet<Term>(var1_1);
        var6_6 = new HashSet<Term>();
        var7_7 = new HashMap<Term, Rational>(ModelExtractionUtils.getValuation(var0, var1_1));
        var8_8 = ModelExtractionUtils.findNewZeros(var7_7, var4_4, var5_5);
        for (Term var9_12 : var8_8) {
            var0.assertTerm(var0.term("=", new Term[]{var9_12, Rational.ZERO.toTerm(var9_12.getSort())}));
        }
        var8_9 = var4_4.size();
        var9_13 = false;
        var10_11 = 1.0;
        var12_14 = 0;
        var13_15 = 0;
        var14_16 = null;
        while (!var5_5.isEmpty()) {
            block25: {
                block23: {
                    block26: {
                        block24: {
                            if (!var3_3.getProgressMonitorService().continueProcessing()) {
                                throw new ToolchainCanceledException(ModelExtractionUtils.class, "simplifying assignment for " + var1_1.size() + "variables");
                            }
                            var15_17 = ModelExtractionUtils.computeSubsetSize(var5_5.size(), var10_11);
                            var16_18 = ModelExtractionUtils.getSubset(var15_17, var5_5);
                            var17_19 = ModelExtractionUtils.constructEqualsZeroTerms(var0, var16_18);
                            var0.push(1);
                            ++var12_14;
                            if (!ModelExtractionUtils.$assertionsDisabled && var16_18.isEmpty()) {
                                throw new AssertionError((Object)"subset too small");
                            }
                            if (var16_18.size() != 1) break block23;
                            if (!ModelExtractionUtils.$assertionsDisabled && var17_19.length != 1) {
                                throw new AssertionError();
                            }
                            var0.assertTerm(var17_19[0]);
                            var18_20 = var0.checkSat();
                            ++var13_15;
                            if (var18_20 != Script.LBool.SAT) break block24;
                            var14_16 = ModelExtractionUtils.getValuation2(var0, var5_5, var6_6);
                            var7_7.putAll(var14_16);
                            for (Script.LBool var19_21 : var16_18) {
                                var5_5.remove(var19_21);
                                var4_4.add((Term)var19_21);
                            }
                            var9_13 = true;
                            var10_11 = 2.0;
                            break block25;
                        }
                        if (var18_20 != Script.LBool.UNSAT) break block26;
                        for (Script.LBool var19_21 : var16_18) {
                            var5_5.remove(var19_21);
                            var6_6.add((Term)var19_21);
                        }
                        var0.pop(1);
                        --var12_14;
                        var14_16 = null;
                        var9_13 = false;
                        var10_11 = 2.0;
                        break block25;
                    }
                    if (var18_20 == Script.LBool.UNKNOWN) {
                        throw new AssertionError((Object)"not yet implemented");
                    }
                    throw new AssertionError((Object)"unknown LBool");
                }
                if (!var9_13) ** GOTO lbl90
                var18_20 = SmtUtils.and((Script)var0, (Term[])var17_19);
                var0.assertTerm((Term)var18_20);
                var19_21 = var0.checkSat();
                ++var13_15;
                if (var19_21 == Script.LBool.SAT) {
                    var14_16 = ModelExtractionUtils.getValuation2(var0, var5_5, var6_6);
                    var7_7.putAll(var14_16);
                    for (Object var20_22 : var16_18) {
                        var5_5.remove(var20_22);
                        var4_4.add((Term)var20_22);
                    }
                    var10_11 = 2.0;
                } else if (var19_21 == Script.LBool.UNSAT) {
                    var0.pop(1);
                    --var12_14;
                    var14_16 = null;
                    var9_13 = false;
                } else {
                    if (var19_21 == Script.LBool.UNKNOWN) {
                        throw new AssertionError((Object)"not yet implemented");
                    }
                    throw new AssertionError((Object)"unknown LBool");
lbl90:
                    // 1 sources

                    var18_20 = SmtUtils.or((Script)var0, (Term[])var17_19);
                    var0.assertTerm((Term)var18_20);
                    var19_21 = var0.checkSat();
                    ++var13_15;
                    if (var19_21 == Script.LBool.SAT) {
                        var14_16 = ModelExtractionUtils.getValuation2(var0, var5_5, var6_6);
                        var7_7.putAll(var14_16);
                        var0.pop(1);
                        --var12_14;
                        var9_13 = true;
                    } else if (var19_21 == Script.LBool.UNSAT) {
                        for (Object var20_22 : var16_18) {
                            var5_5.remove(var20_22);
                            var6_6.add((Term)var20_22);
                        }
                        var0.pop(1);
                        --var12_14;
                        var14_16 = null;
                        var10_11 = 2.0;
                    } else {
                        if (var19_21 == Script.LBool.UNKNOWN) {
                            throw new AssertionError((Object)"not yet implemented");
                        }
                        throw new AssertionError((Object)"unknown LBool");
                    }
                }
            }
            if (var14_16 == null) continue;
            var18_20 = ModelExtractionUtils.findNewZeros(var7_7, var4_4, var5_5);
            var20_22 = var18_20.iterator();
            while (var20_22.hasNext()) {
                var19_21 = (Term)var20_22.next();
                var0.assertTerm(var0.term("=", new Term[]{var19_21, Rational.ZERO.toTerm(var19_21.getSort())}));
            }
        }
        var15_17 = 0;
        while (var15_17 < var12_14) {
            var0.push(1);
            ++var15_17;
        }
        var2_2.info((Object)("Simplification made " + var13_15 + " calls to the SMT solver."));
        var2_2.info((Object)(var8_9 + " out of " + var7_7.size() + " variables were initially zero. Simplification set additionally " + (var4_4.size() - var8_9) + " variables to zero."));
        if (!ModelExtractionUtils.$assertionsDisabled && var4_4.size() + var6_6.size() != var7_7.size()) {
            throw new AssertionError((Object)"wrong number of variables");
        }
        return var7_7;
    }

    private static Map<Term, Rational> getValuation2(Script script, Set<Term> set, Set<Term> set2) throws TermException {
        ArrayList<Term> arrayList = new ArrayList<Term>(set.size() + set2.size());
        arrayList.addAll(set);
        arrayList.addAll(set2);
        return ModelExtractionUtils.getValuation(script, arrayList);
    }

    private static int computeSubsetSize(int n, double d) {
        return (int)Math.ceil((double)n * d / 4.0);
    }

    private static <E> List<E> getSubset(int n, Set<E> set) {
        ArrayList<E> arrayList = new ArrayList<E>();
        int n2 = Math.min(n, set.size());
        Iterator<E> iterator = set.iterator();
        int n3 = 0;
        while (n3 < n2) {
            arrayList.add(iterator.next());
            ++n3;
        }
        return arrayList;
    }

    private static Term[] constructEqualsZeroTerms(Script script, List<Term> list) {
        Term[] termArray = new Term[list.size()];
        Iterator<Term> iterator = list.iterator();
        int n = 0;
        while (n < list.size()) {
            Term term = iterator.next();
            termArray[n] = script.term("=", new Term[]{term, Rational.ZERO.toTerm(term.getSort())});
            ++n;
        }
        return termArray;
    }

    private static List<Term> findNewZeros(Map<Term, Rational> map, Set<Term> set, Set<Term> set2) {
        ArrayList<Term> arrayList = new ArrayList<Term>();
        Iterator<Term> iterator = set2.iterator();
        while (iterator.hasNext()) {
            Term term = iterator.next();
            assert (map.containsKey(term));
            if (!map.get(term).equals((Object)Rational.ZERO)) continue;
            arrayList.add(term);
            set.add(term);
            iterator.remove();
        }
        return arrayList;
    }
}

