/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c;

import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.CPrimitive;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.container.c.ICType;
import de.uni_freiburg.informatik.ultimate.cdt.translation.implementation.result.CDeclaration;
import java.util.Arrays;
import java.util.Objects;
import org.eclipse.cdt.core.dom.ast.IArrayType;
import org.eclipse.cdt.core.dom.ast.IFunction;
import org.eclipse.cdt.core.dom.ast.IFunctionType;
import org.eclipse.cdt.core.dom.ast.IPointerType;
import org.eclipse.cdt.core.dom.ast.ITypedef;
import org.eclipse.cdt.core.dom.ast.IVariable;

public final class CFunction
implements ICType {
    private final ICType mResultType;
    private final CDeclaration[] mParamTypes;
    private final boolean mTakesVarArgs;
    private final VarArgsUsage mVarArgsUsage;

    private CFunction(ICType iCType, CDeclaration[] cDeclarationArray, boolean bl, VarArgsUsage varArgsUsage) {
        this.mResultType = iCType;
        this.mParamTypes = cDeclarationArray;
        this.mTakesVarArgs = bl;
        this.mVarArgsUsage = varArgsUsage;
        assert (this.mVarArgsUsage != VarArgsUsage.USED || this.mTakesVarArgs) : "Cannot use varargs but not have varargs";
        assert (this.mVarArgsUsage == VarArgsUsage.UNUSED || this.mTakesVarArgs) : "Cannot have no varargs and not know about usage";
    }

    private CFunction(ICType iCType, CDeclaration[] cDeclarationArray, boolean bl) {
        this(iCType, cDeclarationArray, bl, bl ? VarArgsUsage.UNKNOWN : VarArgsUsage.UNUSED);
    }

    public static CFunction createDefaultCFunction() {
        return new CFunction(new CPrimitive(CPrimitive.CPrimitives.INT), new CDeclaration[0], false);
    }

    public static CFunction createEmptyCFunction() {
        return new CFunction(null, new CDeclaration[0], false);
    }

    public static CFunction createCFunction(ICType iCType, CDeclaration[] cDeclarationArray, IFunction iFunction) {
        return new CFunction(iCType, cDeclarationArray, iFunction.takesVarArgs());
    }

    /*
     * Unable to fully structure code
     */
    public static CFunction tryCreateCFunction(ICType var0, CDeclaration[] var1_1, ITypedef var2_2) {
        var3_3 = var2_2.getType();
        if (!(var3_3 instanceof IFunctionType)) ** GOTO lbl6
        var4_4 = ((IFunctionType)var3_3).takesVarArgs();
        return new CFunction(var0, var1_1, var4_4);
lbl-1000:
        // 1 sources

        {
            var3_3 = ((IPointerType)var3_3).getType();
lbl6:
            // 2 sources

            ** while (var3_3 instanceof IPointerType)
        }
lbl7:
        // 1 sources

        if (var3_3 instanceof IFunctionType) {
            return new CFunction(var0, var1_1, ((IFunctionType)var3_3).takesVarArgs());
        }
        throw new UnsupportedOperationException("Cannot extract function type from pointer to " + String.valueOf(var3_3));
    }

    /*
     * Unable to fully structure code
     */
    public static CFunction tryCreateCFunction(ICType var0, CDeclaration[] var1_1, IVariable var2_2) {
        block4: {
            var3_3 = var2_2.getType();
            if (var3_3 instanceof IPointerType) ** GOTO lbl13
            if (!(var3_3 instanceof IArrayType)) break block4;
            while (var3_3 instanceof IArrayType) {
                var3_3 = ((IArrayType)var3_3).getType();
            }
            if (!(var3_3 instanceof IPointerType)) {
                throw new UnsupportedOperationException("Cannot extract function type from array of non-pointers " + String.valueOf(var3_3));
            }
            ** GOTO lbl13
        }
        throw new UnsupportedOperationException("Cannot extract function type from variable " + String.valueOf(var3_3));
lbl-1000:
        // 1 sources

        {
            var3_3 = ((IPointerType)var3_3).getType();
lbl13:
            // 3 sources

            ** while (var3_3 instanceof IPointerType)
        }
lbl14:
        // 1 sources

        if (var3_3 instanceof IFunctionType) {
            return new CFunction(var0, var1_1, ((IFunctionType)var3_3).takesVarArgs());
        }
        throw new UnsupportedOperationException("Cannot extract function type from pointer to " + String.valueOf(var3_3));
    }

    public CFunction newParameter(CDeclaration[] cDeclarationArray) {
        return new CFunction(this.getResultType(), cDeclarationArray, this.hasVarArgs(), this.getVarArgsUsage());
    }

    public CFunction newReturnType(ICType iCType) {
        return new CFunction(iCType, this.getParameterTypes(), this.hasVarArgs(), this.getVarArgsUsage());
    }

    public CFunction updateVarArgsUsage(boolean bl) {
        assert (this.hasVarArgs());
        return new CFunction(this.getResultType(), this.getParameterTypes(), this.hasVarArgs(), bl ? VarArgsUsage.USED : VarArgsUsage.UNUSED);
    }

    public ICType getResultType() {
        return this.mResultType;
    }

    public CDeclaration[] getParameterTypes() {
        return this.mParamTypes;
    }

    public boolean hasVarArgs() {
        return this.mTakesVarArgs;
    }

    public VarArgsUsage getVarArgsUsage() {
        return this.mVarArgsUsage;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("((");
        CDeclaration[] cDeclarationArray = this.mParamTypes;
        int n = this.mParamTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CDeclaration cDeclaration = cDeclarationArray[n2];
            CFunction.appendCType(stringBuilder, cDeclaration.getType());
            stringBuilder.append(" ");
            ++n2;
        }
        if (this.mTakesVarArgs) {
            stringBuilder.append("...");
        }
        stringBuilder.append(")");
        stringBuilder.append(" : ");
        CFunction.appendCType(stringBuilder, this.mResultType);
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    private static StringBuilder appendCType(StringBuilder stringBuilder, ICType iCType) {
        if (iCType == null) {
            stringBuilder.append("?");
        } else {
            stringBuilder.append(iCType.toString());
        }
        return stringBuilder;
    }

    public String functionSignatureAsProcedureName() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("##fun~");
        String string = "";
        CDeclaration[] cDeclarationArray = this.mParamTypes;
        int n = this.mParamTypes.length;
        int n2 = 0;
        while (n2 < n) {
            CDeclaration cDeclaration = cDeclarationArray[n2];
            stringBuilder.append(string);
            stringBuilder.append(cDeclaration.getType().getUnderlyingType().toString());
            string = "~X~";
            ++n2;
        }
        if (this.mTakesVarArgs) {
            stringBuilder.append("X~varArgs~");
        }
        stringBuilder.append("~TO~");
        stringBuilder.append(this.mResultType.getUnderlyingType().toString());
        return stringBuilder.toString();
    }

    @Override
    public boolean isAtomic() {
        return false;
    }

    @Override
    public boolean isIncomplete() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.mParamTypes), this.mResultType, this.mTakesVarArgs);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CFunction cFunction = (CFunction)object;
        return Arrays.equals(this.mParamTypes, cFunction.mParamTypes) && Objects.equals(this.mResultType, cFunction.mResultType) && this.mTakesVarArgs == cFunction.mTakesVarArgs;
    }

    public static enum VarArgsUsage {
        USED,
        UNUSED,
        UNKNOWN;

    }
}

