/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.counting;

import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryException;
import de.uni_freiburg.informatik.ultimate.automata.AutomataLibraryServices;
import de.uni_freiburg.informatik.ultimate.automata.IOperation;
import de.uni_freiburg.informatik.ultimate.automata.counting.Counter;
import de.uni_freiburg.informatik.ultimate.automata.counting.CountingAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.counting.Guard;
import de.uni_freiburg.informatik.ultimate.automata.counting.Update;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.NestedWord;
import de.uni_freiburg.informatik.ultimate.automata.statefactory.IStateFactory;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtinterpol.smtlib2.SMTInterpol;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class Acceptance<LETTER, STATE, CRSF extends IStateFactory<STATE>>
implements IOperation<LETTER, STATE, CRSF> {
    private final AutomataLibraryServices mServices;
    private final Script mScript;
    private final ILogger mLogger;
    private final CountingAutomaton<LETTER, STATE> mOperand;
    private final List<LETTER> mWord;
    private final Script.LBool mResult;

    public Acceptance(AutomataLibraryServices automataLibraryServices, CountingAutomaton<LETTER, STATE> countingAutomaton, NestedWord<LETTER> nestedWord) throws AutomataLibraryException {
        this.mServices = automataLibraryServices;
        this.mLogger = this.mServices.getLoggingService().getLogger(this.getClass());
        this.mOperand = countingAutomaton;
        this.mWord = nestedWord.asList();
        this.mScript = new SMTInterpol();
        this.mScript.setLogic(Logics.LIA);
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.startMessage());
        }
        this.mResult = this.computeResult();
        if (this.mLogger.isInfoEnabled()) {
            this.mLogger.info((Object)this.exitMessage());
        }
    }

    private Script.LBool computeResult() {
        ArrayList<ArrayList<Guard>> arrayList = new ArrayList<ArrayList<Guard>>();
        arrayList.add(new ArrayList());
        return this.iterativeAcceptance(this.mOperand, arrayList);
    }

    private Script.LBool iterativeAcceptance(CountingAutomaton<LETTER, STATE> countingAutomaton, ArrayList<ArrayList<Guard>> arrayList) {
        int n = this.mWord.size();
        ArrayList<STATE> arrayList2 = new ArrayList<STATE>(countingAutomaton.getStates());
        Script.LBool lBool = Script.LBool.UNSAT;
        int n2 = 0;
        Term[] termArray = new Term[n + 2];
        ArrayList<Object> arrayList3 = new ArrayList<Object>();
        int n3 = 0;
        while (n3 < n + 2) {
            arrayList3.add(new Object());
            ++n3;
        }
        int[] nArray = new int[n + 2];
        termArray[0] = this.dnfToFormula(arrayList, 0);
        this.mLogger.log(ILogger.LogLevel.INFO, (Object)n);
        this.mLogger.log(ILogger.LogLevel.INFO, (Object)arrayList3.size());
        while (n2 > 0 || nArray[n2] < arrayList2.size()) {
            Object object;
            Term term;
            this.mLogger.log(ILogger.LogLevel.INFO, "entering loop with step = " + n2 + ", trying path #" + (nArray[n2] + 1));
            if (n2 > n) {
                this.mLogger.log(ILogger.LogLevel.INFO, "end of word reached. checking term satisfiability:");
                termArray[n2] = this.mScript.term("and", new Term[]{termArray[n2], this.dnfToFormula(countingAutomaton.getFinalConditions().get(arrayList3.get(n2)).getCondition(), n2)});
                term = this.mScript.quantifier(0, termArray[n2].getFreeVars(), termArray[n2], null);
                this.mLogger.log(ILogger.LogLevel.INFO, (Object)term);
                this.mScript.assertTerm(term);
                object = this.mScript.checkSat();
                this.mScript.resetAssertions();
                if (object == Script.LBool.SAT) {
                    return Script.LBool.SAT;
                }
                if (object == Script.LBool.UNKNOWN) {
                    lBool = Script.LBool.UNKNOWN;
                }
                this.mLogger.log(ILogger.LogLevel.INFO, "term unsatisfiable");
                int n4 = --n2;
                nArray[n4] = nArray[n4] + 1;
                continue;
            }
            if (n2 > 0 && nArray[n2] >= countingAutomaton.getTransitions().get(arrayList3.get(n2)).size()) {
                this.mLogger.log(ILogger.LogLevel.INFO, "only " + countingAutomaton.getTransitions().get(arrayList3.get(n2)).size() + " possible transitions. going back");
                int n5 = --n2;
                nArray[n5] = nArray[n5] + 1;
                continue;
            }
            if (n2 == 0) {
                this.mLogger.log(ILogger.LogLevel.INFO, "choosing initial state: " + String.valueOf(arrayList2.get(nArray[n2])));
                termArray[n2 + 1] = this.mScript.term("and", new Term[]{termArray[n2], this.dnfToFormula(countingAutomaton.getInitialConditions().get(arrayList2.get(nArray[n2])).getCondition(), n2)});
                termArray[n2 + 1] = this.mScript.term("and", new Term[]{termArray[n2 + 1], this.updateToFormula(new ArrayList<Update>(), countingAutomaton.getCounter(), n2)});
                arrayList3.set(n2 + 1, arrayList2.get(nArray[n2]));
                nArray[n2 + 1] = 0;
                ++n2;
                continue;
            }
            this.mLogger.log(ILogger.LogLevel.INFO, "state: " + String.valueOf(arrayList3.get(n2)));
            term = countingAutomaton.getTransitions().get(arrayList3.get(n2)).get(nArray[n2]);
            this.mLogger.log(ILogger.LogLevel.INFO, "checking transition to " + String.valueOf(term.getSucState()));
            object = this.mWord.get(n2 - 1);
            LETTER LETTER = term.getLetter();
            this.mLogger.log(ILogger.LogLevel.INFO, "required letter: '" + String.valueOf(object) + "', letter in transition: '" + String.valueOf(LETTER) + "'");
            if (object.equals(LETTER)) {
                this.mLogger.log(ILogger.LogLevel.INFO, "found transition. going on");
                termArray[n2 + 1] = this.mScript.term("and", new Term[]{termArray[n2], this.dnfToFormula(term.getGuards(), n2), this.updateToFormula(term.getUpdates(), countingAutomaton.getCounter(), n2)});
                arrayList3.set(n2 + 1, term.getSucState());
                nArray[n2 + 1] = 0;
                ++n2;
                continue;
            }
            this.mLogger.log(ILogger.LogLevel.INFO, "transition unavailable");
            int n6 = n2;
            nArray[n6] = nArray[n6] + 1;
        }
        this.mLogger.log(ILogger.LogLevel.INFO, "no more states left");
        return lBool;
    }

    private Term dnfToFormula(ArrayList<ArrayList<Guard>> arrayList, int n) {
        String string = "#" + String.valueOf(n);
        Term term = null;
        for (List list : arrayList) {
            Term term2 = null;
            for (Guard guard : list) {
                Term term3 = null;
                TermVariable termVariable = null;
                Term term4 = null;
                switch (guard.getTermType()) {
                    case TRUE: {
                        term3 = this.mScript.term("true", new Term[0]);
                        break;
                    }
                    case FALSE: {
                        term3 = this.mScript.term("false", new Term[0]);
                        break;
                    }
                    case CONSTANT: {
                        termVariable = this.mScript.variable(guard.getCounterLeft().getCounterName() + string, SmtSortUtils.getIntSort((Script)this.mScript));
                        term4 = this.mScript.numeral(BigInteger.valueOf(guard.getConstant().intValue()));
                        break;
                    }
                    case COUNTER: {
                        termVariable = this.mScript.variable(guard.getCounterLeft().getCounterName() + string, SmtSortUtils.getIntSort((Script)this.mScript));
                        term4 = this.mScript.variable(guard.getCounterRight().getCounterName() + string, SmtSortUtils.getIntSort((Script)this.mScript));
                        break;
                    }
                    case SUM: {
                        termVariable = this.mScript.variable(guard.getCounterLeft().getCounterName() + string, SmtSortUtils.getIntSort((Script)this.mScript));
                        TermVariable termVariable2 = this.mScript.variable(guard.getCounterRight().getCounterName() + string, SmtSortUtils.getIntSort((Script)this.mScript));
                        Term term5 = this.mScript.numeral(BigInteger.valueOf(guard.getConstant().intValue()));
                        term4 = this.mScript.term("+", new Term[]{termVariable2, term5});
                    }
                }
                if (term3 == null) {
                    switch (guard.getRelationSymbol()) {
                        case EQ: {
                            term3 = this.mScript.term("=", new Term[]{termVariable, term4});
                            break;
                        }
                        case DISTINCT: {
                            term3 = this.mScript.term("distinct", new Term[]{termVariable, term4});
                            break;
                        }
                        case GREATER: {
                            term3 = this.mScript.term(">", new Term[]{termVariable, term4});
                            break;
                        }
                        case LESS: {
                            term3 = this.mScript.term("<", new Term[]{termVariable, term4});
                            break;
                        }
                        case GEQ: {
                            term3 = this.mScript.term(">=", new Term[]{termVariable, term4});
                            break;
                        }
                        case LEQ: {
                            term3 = this.mScript.term("<=", new Term[]{termVariable, term4});
                        }
                    }
                }
                term2 = term2 == null ? term3 : this.mScript.term("and", new Term[]{term2, term3});
            }
            if (term2 == null) {
                term2 = this.mScript.term("true", new Term[0]);
            }
            term = term == null ? term2 : this.mScript.term("or", new Term[]{term, term2});
        }
        if (term == null) {
            term = this.mScript.term("false", new Term[0]);
        }
        return term;
    }

    private Term updateToFormula(List<Update> list, List<Counter> list2, int n) {
        TermVariable termVariable;
        TermVariable termVariable2;
        Term term;
        ArrayList<Counter> arrayList = new ArrayList<Counter>(list2);
        Term term2 = null;
        for (Update object : list) {
            term = null;
            termVariable2 = this.mScript.variable(object.getCounterLeft().getCounterName() + "#" + String.valueOf(n + 1), SmtSortUtils.getIntSort((Script)this.mScript));
            arrayList.remove(object.getCounterLeft());
            switch (object.getTermType()) {
                case CONSTANT: {
                    Term term3 = this.mScript.numeral(BigInteger.valueOf(object.getConstant().intValue()));
                    term = this.mScript.term("=", new Term[]{termVariable2, term3});
                    break;
                }
                case COUNTER: {
                    termVariable = this.mScript.variable(object.getCounterRight().getCounterName() + "#" + String.valueOf(n), SmtSortUtils.getIntSort((Script)this.mScript));
                    term = this.mScript.term("=", new Term[]{termVariable2, termVariable});
                    break;
                }
                case SUM: {
                    Term term3 = this.mScript.numeral(BigInteger.valueOf(object.getConstant().intValue()));
                    termVariable = this.mScript.variable(object.getCounterRight().getCounterName() + "#" + String.valueOf(n), SmtSortUtils.getIntSort((Script)this.mScript));
                    Term term4 = this.mScript.term("+", new Term[]{term3, termVariable});
                    term = this.mScript.term("=", new Term[]{termVariable2, term4});
                }
            }
            term2 = term2 == null ? term : this.mScript.term("and", new Term[]{term2, term});
        }
        for (Counter counter : arrayList) {
            termVariable2 = this.mScript.variable(counter.getCounterName() + "#" + String.valueOf(n + 1), SmtSortUtils.getIntSort((Script)this.mScript));
            termVariable = this.mScript.variable(counter.getCounterName() + "#" + String.valueOf(n), SmtSortUtils.getIntSort((Script)this.mScript));
            term = this.mScript.term("=", new Term[]{termVariable2, termVariable});
            term2 = term2 == null ? term : this.mScript.term("and", new Term[]{term2, term});
        }
        return term2;
    }

    @Override
    public Object getResult() {
        return this.mResult;
    }

    @Override
    public boolean checkResult(CRSF CRSF) throws AutomataLibraryException {
        return true;
    }
}

