/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.nestedword;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.IncomingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingCallTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingInternalTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.OutgoingReturnTransition;
import de.uni_freiburg.informatik.ultimate.automata.nestedword.transitions.SummaryReturnTransition;

public class TransitionConsistencyCheck<LETTER, STATE> {
    private final INestedWordAutomaton<LETTER, STATE> mNwa;

    public TransitionConsistencyCheck(INestedWordAutomaton<LETTER, STATE> iNestedWordAutomaton) {
        this.mNwa = iNestedWordAutomaton;
    }

    public boolean consistentForAll() {
        boolean bl = true;
        for (STATE STATE : this.mNwa.getStates()) {
            boolean bl2 = bl = bl && this.consistentForState(STATE);
        }
        return bl;
    }

    private boolean consistentForState(STATE STATE) {
        boolean bl = true;
        for (OutgoingInternalTransition object : this.mNwa.internalSuccessors(STATE)) {
            boolean bl2 = bl = bl && this.internalIn(STATE, object.getLetter(), object.getSucc());
            assert (bl);
        }
        for (IncomingInternalTransition incomingInternalTransition : this.mNwa.internalPredecessors(STATE)) {
            boolean bl3 = bl = bl && this.internalOut(incomingInternalTransition.getPred(), incomingInternalTransition.getLetter(), STATE);
            assert (bl);
        }
        for (OutgoingCallTransition outgoingCallTransition : this.mNwa.callSuccessors(STATE)) {
            boolean bl4 = bl = bl && this.callIn(STATE, outgoingCallTransition.getLetter(), outgoingCallTransition.getSucc());
            assert (bl);
        }
        for (IncomingCallTransition incomingCallTransition : this.mNwa.callPredecessors(STATE)) {
            boolean bl5 = bl = bl && this.callOut(incomingCallTransition.getPred(), incomingCallTransition.getLetter(), STATE);
            assert (bl);
        }
        for (OutgoingReturnTransition outgoingReturnTransition : this.mNwa.returnSuccessors(STATE)) {
            boolean bl6 = bl = bl && this.returnIn(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc());
            assert (bl);
            boolean bl7 = bl = bl && this.returnSummary(STATE, outgoingReturnTransition.getHierPred(), outgoingReturnTransition.getLetter(), outgoingReturnTransition.getSucc());
            assert (bl);
        }
        for (IncomingReturnTransition incomingReturnTransition : this.mNwa.returnPredecessors(STATE)) {
            boolean bl8 = bl = bl && this.returnOut(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred(), incomingReturnTransition.getLetter(), STATE);
            assert (bl);
            boolean bl9 = bl = bl && this.returnSummary(incomingReturnTransition.getLinPred(), incomingReturnTransition.getHierPred(), incomingReturnTransition.getLetter(), STATE);
            assert (bl);
        }
        for (Object object : this.mNwa.getVpAlphabet().getReturnAlphabet()) {
            for (SummaryReturnTransition<Object, STATE> summaryReturnTransition : this.mNwa.summarySuccessors(STATE, object)) {
                boolean bl10 = bl = bl && this.returnIn(summaryReturnTransition.getLinPred(), STATE, summaryReturnTransition.getLetter(), summaryReturnTransition.getSucc());
                assert (bl);
                boolean bl11 = bl = bl && this.returnOut(summaryReturnTransition.getLinPred(), STATE, summaryReturnTransition.getLetter(), summaryReturnTransition.getSucc());
                assert (bl);
            }
        }
        return bl;
    }

    private boolean internalOut(STATE STATE, LETTER LETTER, STATE STATE2) {
        for (OutgoingInternalTransition outgoingInternalTransition : this.mNwa.internalSuccessors(STATE)) {
            boolean bl;
            boolean bl2 = bl = LETTER.equals(outgoingInternalTransition.getLetter()) && STATE2.equals(outgoingInternalTransition.getSucc());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean internalIn(STATE STATE, LETTER LETTER, STATE STATE2) {
        for (IncomingInternalTransition<LETTER, STATE> incomingInternalTransition : this.mNwa.internalPredecessors(STATE2)) {
            boolean bl;
            boolean bl2 = bl = STATE.equals(incomingInternalTransition.getPred()) && LETTER.equals(incomingInternalTransition.getLetter());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean callOut(STATE STATE, LETTER LETTER, STATE STATE2) {
        for (OutgoingCallTransition outgoingCallTransition : this.mNwa.callSuccessors(STATE)) {
            boolean bl;
            boolean bl2 = bl = LETTER.equals(outgoingCallTransition.getLetter()) && STATE2.equals(outgoingCallTransition.getSucc());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean callIn(STATE STATE, LETTER LETTER, STATE STATE2) {
        for (IncomingCallTransition<LETTER, STATE> incomingCallTransition : this.mNwa.callPredecessors(STATE2)) {
            boolean bl;
            boolean bl2 = bl = STATE.equals(incomingCallTransition.getPred()) && LETTER.equals(incomingCallTransition.getLetter());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean returnOut(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        for (OutgoingReturnTransition<LETTER, STATE> outgoingReturnTransition : this.mNwa.returnSuccessors(STATE)) {
            boolean bl;
            boolean bl2 = bl = STATE2.equals(outgoingReturnTransition.getHierPred()) && LETTER.equals(outgoingReturnTransition.getLetter()) && STATE3.equals(outgoingReturnTransition.getSucc());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean returnIn(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        for (IncomingReturnTransition<LETTER, STATE> incomingReturnTransition : this.mNwa.returnPredecessors(STATE3)) {
            boolean bl;
            boolean bl2 = bl = STATE.equals(incomingReturnTransition.getLinPred()) && STATE2.equals(incomingReturnTransition.getHierPred()) && LETTER.equals(incomingReturnTransition.getLetter());
            if (!bl) continue;
            return true;
        }
        return false;
    }

    private boolean returnSummary(STATE STATE, STATE STATE2, LETTER LETTER, STATE STATE3) {
        for (SummaryReturnTransition<LETTER, STATE> summaryReturnTransition : this.mNwa.summarySuccessors(STATE2, LETTER)) {
            boolean bl;
            boolean bl2 = bl = STATE.equals(summaryReturnTransition.getLinPred()) && STATE3.equals(summaryReturnTransition.getSucc());
            if (!bl) continue;
            return true;
        }
        return false;
    }
}

