/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.IRegex;
import de.uni_freiburg.informatik.ultimate.lib.pathexpressions.regex.Star;
import de.uni_freiburg.informatik.ultimate.lib.sifa.DagInterpreter;
import de.uni_freiburg.informatik.ultimate.lib.sifa.StarDagCache;
import de.uni_freiburg.informatik.ultimate.lib.sifa.SymbolicTools;
import de.uni_freiburg.informatik.ultimate.lib.sifa.domain.IDomain;
import de.uni_freiburg.informatik.ultimate.lib.sifa.fluid.IFluid;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.FullOverlay;
import de.uni_freiburg.informatik.ultimate.lib.sifa.regexdag.RegexDag;
import de.uni_freiburg.informatik.ultimate.lib.sifa.statistics.SifaStats;
import de.uni_freiburg.informatik.ultimate.lib.sifa.summarizers.ILoopSummarizer;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;

public class FixpointLoopSummarizer
implements ILoopSummarizer {
    private final SifaStats mStats;
    private final ILogger mLogger;
    private final Supplier<IProgressAwareTimer> mFixpointIterationTimeout;
    private final SymbolicTools mTools;
    private final IDomain mDomain;
    private final IFluid mFluid;
    private final DagInterpreter mDagIpr;
    private final StarDagCache mStarDagCache;
    private final Map<Pair<Star<IIcfgTransition<IcfgLocation>>, IPredicate>, IPredicate> mCache;

    public FixpointLoopSummarizer(SifaStats sifaStats, ILogger iLogger, Supplier<IProgressAwareTimer> supplier, SymbolicTools symbolicTools, IDomain iDomain, IFluid iFluid, DagInterpreter dagInterpreter) {
        this.mStats = sifaStats;
        this.mLogger = iLogger;
        this.mFixpointIterationTimeout = supplier;
        this.mTools = symbolicTools;
        this.mDomain = iDomain;
        this.mFluid = iFluid;
        this.mDagIpr = dagInterpreter;
        this.mStarDagCache = new StarDagCache(sifaStats);
        this.mCache = new HashMap<Pair<Star<IIcfgTransition<IcfgLocation>>, IPredicate>, IPredicate>();
    }

    @Override
    public IPredicate summarize(Star<IIcfgTransition<IcfgLocation>> star, IPredicate iPredicate) {
        this.mStats.start(SifaStats.Key.LOOP_SUMMARIZER_OVERALL_TIME);
        this.mStats.increment(SifaStats.Key.LOOP_SUMMARIZER_APPLICATIONS);
        Pair pair = new Pair(star, (Object)iPredicate);
        IPredicate iPredicate2 = this.mCache.get(pair);
        if (iPredicate2 == null) {
            iPredicate2 = this.summarizeInternal((Pair<Star<IIcfgTransition<IcfgLocation>>, IPredicate>)pair);
            IPredicate iPredicate3 = this.mCache.put((Pair<Star<IIcfgTransition<IcfgLocation>>, IPredicate>)pair, iPredicate2);
            assert (iPredicate3 == null || iPredicate2 == iPredicate3);
        }
        this.mStats.stop(SifaStats.Key.LOOP_SUMMARIZER_OVERALL_TIME);
        return iPredicate2;
    }

    private IPredicate summarizeInternal(Pair<Star<IIcfgTransition<IcfgLocation>>, IPredicate> pair) {
        this.mStats.start(SifaStats.Key.LOOP_SUMMARIZER_NEW_COMPUTATION_TIME);
        this.mStats.increment(SifaStats.Key.LOOP_SUMMARIZER_CACHE_MISSES);
        IProgressAwareTimer iProgressAwareTimer = this.mFixpointIterationTimeout.get();
        IRegex iRegex = ((Star)pair.getFirst()).getInner();
        RegexDag<IIcfgTransition<IcfgLocation>> regexDag = this.mStarDagCache.dagOf((IRegex<IIcfgTransition<IcfgLocation>>)iRegex);
        FullOverlay<IIcfgTransition<IcfgLocation>> fullOverlay = new FullOverlay<IIcfgTransition<IcfgLocation>>();
        IPredicate iPredicate = (IPredicate)pair.getSecond();
        IPredicate iPredicate2 = null;
        while (true) {
            if (!iProgressAwareTimer.continueProcessing()) {
                this.mLogger.warn((Object)"Timeout while computing loop summary. Using TOP as summary.");
                return this.mTools.top();
            }
            this.mStats.increment(SifaStats.Key.LOOP_SUMMARIZER_FIXPOINT_ITERATIONS);
            iPredicate2 = this.mDagIpr.interpretForSingleMarker(regexDag, fullOverlay, iPredicate);
            if (this.mFluid.shallBeAbstracted(iPredicate2)) {
                iPredicate2 = this.mDomain.alpha(iPredicate2);
            }
            IDomain.ResultForAlteredInputs resultForAlteredInputs = this.mDomain.isSubsetEq(iPredicate2, iPredicate);
            iPredicate2 = resultForAlteredInputs.getLhs();
            iPredicate = resultForAlteredInputs.getRhs();
            if (resultForAlteredInputs.isTrueForAbstraction()) break;
            iPredicate = this.mDomain.widen(iPredicate, iPredicate2);
        }
        this.mStats.stop(SifaStats.Key.LOOP_SUMMARIZER_NEW_COMPUTATION_TIME);
        return iPredicate;
    }
}

