/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.lib.results;

import de.uni_freiburg.informatik.ultimate.core.lib.results.NonTerminationArgumentResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;

public class LassoShapedNonTerminationArgument<P extends IElement, E>
extends NonTerminationArgumentResult<P, E> {
    private final IProgramExecution<P, E> mStemExecution;
    private final String mStemExecutionAsString;
    private final IProgramExecution<P, E> mLoopExecution;
    private final String mLoopExecutionAsString;

    public LassoShapedNonTerminationArgument(P p, String string, IBacktranslationService iBacktranslationService, Class<E> clazz, IProgramExecution<P, E> iProgramExecution, IProgramExecution<P, E> iProgramExecution2) {
        super(p, string, iBacktranslationService, clazz);
        this.mStemExecution = iProgramExecution;
        this.mLoopExecution = iProgramExecution2;
        IBacktranslationService.Lasso lasso = iBacktranslationService.translateLassoProgramExecution(new IBacktranslationService.Lasso(this.mStemExecution, this.mLoopExecution));
        this.mStemExecutionAsString = lasso.stem().toString();
        this.mLoopExecutionAsString = lasso.loop().toString();
    }

    public IProgramExecution<P, E> getStemExecution() {
        return this.mStemExecution;
    }

    public IProgramExecution<P, E> getLoopExecution() {
        return this.mLoopExecution;
    }

    @Override
    public String getShortDescription() {
        return "Nontermination argument in form of an infinite program execution.";
    }

    public String getLongDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Nontermination argument in form of an infinite program execution.");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append("Stem:");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append(this.mStemExecutionAsString);
        stringBuilder.append("Loop:");
        stringBuilder.append(CoreUtil.getPlatformLineSeparator());
        stringBuilder.append(this.mLoopExecutionAsString);
        stringBuilder.append("End of lasso representation.");
        return stringBuilder.toString();
    }
}

