/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser;

import com.github.jhoenicke.javacup.runtime.Scanner;
import de.uni_freiburg.informatik.ultimate.core.lib.results.SyntaxErrorResult;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomataDefinitionsAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomataTestFileAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AST.AutomatonAST;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.Activator;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.AutomataScriptLocation;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.Lexer;
import de.uni_freiburg.informatik.ultimate.plugins.source.automatascriptparser.Parser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.print.attribute.standard.Severity;

public class AutomataScriptParserRun {
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final Reader mReader;
    private final String mFilename;
    private final String mFileAbsolutePath;
    private final AutomataTestFileAST mResult;

    public AutomataScriptParserRun(IUltimateServiceProvider iUltimateServiceProvider, ILogger iLogger, Reader reader, String string, String string2) {
        this.mServices = iUltimateServiceProvider;
        this.mLogger = iLogger;
        this.mReader = reader;
        this.mFilename = string;
        this.mFileAbsolutePath = string2;
        this.mResult = this.doParse(this.mReader, this.mFilename, this.mFileAbsolutePath);
    }

    private AutomataTestFileAST doParse(Reader reader, String string, String string2) {
        Lexer lexer = new Lexer(reader);
        Parser parser = new Parser((Scanner)lexer, this.mLogger);
        parser.setFileName(string);
        parser.setFilePath(string2);
        Object object = null;
        try {
            object = parser.parse().value;
        }
        catch (Exception exception) {
            String string3;
            String string4;
            ILocation iLocation = parser.getErrorLocation();
            if (iLocation == null) {
                this.mLogger.debug((Object)"Error without location");
                iLocation = AutomataScriptParserRun.getPseudoLocation();
            }
            if ((string4 = parser.getShortErrorMessage()) == null) {
                string4 = exception.getMessage();
            }
            if ((string3 = parser.getLongErrorMessage()) == null) {
                string3 = exception.getMessage();
            }
            this.reportSyntaxError(Severity.ERROR, string3, string4, iLocation);
            this.mLogger.info((Object)"Parsing aborted.");
            return null;
        }
        this.mLogger.debug((Object)("'" + string + "' successfully parsed"));
        if (object instanceof AutomataTestFileAST) {
            AutomataTestFileAST automataTestFileAST = (AutomataTestFileAST)((Object)object);
            AutomataDefinitionsAST automataDefinitionsAST = automataTestFileAST.getAutomataDefinitions();
            if (parser.containsOtherAutomataFilesToParse()) {
                String string5 = parser.getFilePath().substring(0, parser.getFilePath().lastIndexOf(File.separator) + 1);
                List<AutomatonAST> list = this.parseAutomataDefinitions(parser.getFilesToParse(), string5);
                for (AutomatonAST automatonAST : list) {
                    if (automataDefinitionsAST.hasAutomaton(automatonAST)) {
                        this.mLogger.debug((Object)("Automaton \"" + automatonAST.getName() + "\" was already declared in file \"" + string + "\"."));
                        continue;
                    }
                    automataDefinitionsAST.addAutomaton(automatonAST);
                }
            }
            automataTestFileAST.setAutomataDefinitions(automataDefinitionsAST);
            return (AutomataTestFileAST)((Object)object);
        }
        return null;
    }

    private List<AutomatonAST> parseAutomataDefinitions(List<String> list, String string) {
        ArrayList<AutomatonAST> arrayList = new ArrayList<AutomatonAST>();
        for (String string2 : list) {
            Lexer lexer = null;
            String string3 = this.getFileSeparator(string2);
            File file = null;
            file = string3 != null ? this.openFile(this.adaptFileSeparators(string2, string3), string) : this.openFile(string2, string);
            if (file == null) continue;
            try {
                lexer = new Lexer(new FileReader(file));
            }
            catch (FileNotFoundException fileNotFoundException) {
                this.mLogger.debug((Object)("File \"" + string2 + "\" doesn't exist or couldn't open!"));
                continue;
            }
            Parser parser = new Parser((Scanner)lexer, this.mLogger);
            parser.setFileName(string2);
            parser.setFilePath(string2);
            Object object = null;
            try {
                object = parser.parse().value;
            }
            catch (Exception exception) {
                this.mLogger.debug((Object)("Parsing file \"" + string2 + "\" failed!"));
                continue;
            }
            if (object == null || !(object instanceof AutomataTestFileAST)) continue;
            AutomataTestFileAST automataTestFileAST = (AutomataTestFileAST)((Object)object);
            if (!automataTestFileAST.getAutomataDefinitions().isEmpty()) {
                List<AutomatonAST> list2 = automataTestFileAST.getAutomataDefinitions().getListOfAutomataDefinitions();
                for (AutomatonAST automatonAST : list2) {
                    if (arrayList.contains((Object)automatonAST)) {
                        this.mLogger.debug((Object)("Automaton \"" + automatonAST.getName() + "\" from file \"" + string2 + " already declared in other file."));
                        continue;
                    }
                    arrayList.add(automatonAST);
                }
            }
            this.mLogger.debug((Object)("\"" + string2 + "\" successfully parsed."));
        }
        return arrayList;
    }

    private File openFile(String string, String string2) {
        File file = new File(string);
        if (!file.exists() || !file.canRead()) {
            if (string.startsWith(".." + File.separator)) {
                string2 = string2.substring(0, string2.lastIndexOf(File.separator));
                file = new File((string2 = string2.substring(0, string2.lastIndexOf(File.separator) + 1)) + string.substring(3));
                if (!file.exists() || !file.canRead()) {
                    this.mLogger.debug((Object)("File \"" + string + "\" doesn't exist or couldn't open!"));
                    return null;
                }
                return file;
            }
            file = new File(string2 + string);
            if (!file.exists() || !file.canRead()) {
                this.mLogger.debug((Object)("File \"" + string + "\" doesn't exist or couldn't open!"));
                return null;
            }
            return file;
        }
        return file;
    }

    private String getFileSeparator(String string) {
        if (string.contains("\\")) {
            return "\\";
        }
        if (string.contains("/")) {
            return "/";
        }
        return null;
    }

    private String adaptFileSeparators(String string, String string2) {
        if (!string2.equals(System.getProperty("file.separator"))) {
            return string.replace(string2, System.getProperty("file.separator"));
        }
        return string;
    }

    private void reportSyntaxError(Severity severity, String string, String string2, ILocation iLocation) {
        if (this.mServices == null) {
            throw new IllegalStateException();
        }
        SyntaxErrorResult syntaxErrorResult = new SyntaxErrorResult(Activator.PLUGIN_ID, iLocation, string);
        this.mServices.getResultService().reportResult(Activator.PLUGIN_ID, (IResult)syntaxErrorResult);
        this.mLogger.info((Object)(string2 + " " + string));
    }

    private static ILocation getPseudoLocation() {
        return new AutomataScriptLocation("", 0, 0, 0, 0);
    }

    public AutomataTestFileAST getResult() {
        return this.mResult;
    }
}

