/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender;

import de.uni_freiburg.informatik.ultimate.automata.nestedword.INestedWordAutomaton;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.AbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.interpolantautomata.transitionappender.BasicAbstractInterpolantAutomaton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class NondeterministicInterpolantAutomaton<LETTER extends IAction>
extends BasicAbstractInterpolantAutomaton<LETTER> {
    protected final Set<IPredicate> mNonTrivialPredicates;
    protected final boolean mConservativeSuccessorCandidateSelection;
    protected final boolean mSecondChance;

    public NondeterministicInterpolantAutomaton(IUltimateServiceProvider iUltimateServiceProvider, CfgSmtToolkit cfgSmtToolkit, IHoareTripleChecker iHoareTripleChecker, INestedWordAutomaton<LETTER, IPredicate> iNestedWordAutomaton, IPredicateUnifier iPredicateUnifier, boolean bl, boolean bl2) {
        super(iUltimateServiceProvider, cfgSmtToolkit, iHoareTripleChecker, true, iPredicateUnifier, iNestedWordAutomaton);
        this.mConservativeSuccessorCandidateSelection = bl;
        this.mSecondChance = bl2;
        Set set = iNestedWordAutomaton.getStates();
        assert (SmtUtils.isTrueLiteral((Term)this.mIaTrueState.getFormula()));
        assert (set.contains(this.mIaTrueState));
        assert (SmtUtils.isFalseLiteral((Term)this.mIaFalseState.getFormula()));
        assert (this.isFalsePresent(set));
        this.mNonTrivialPredicates = new HashSet<IPredicate>();
        for (IPredicate iPredicate : set) {
            this.addIfNontrivialPredicate(iPredicate);
            boolean bl3 = iNestedWordAutomaton.isInitial((Object)iPredicate);
            boolean bl4 = iNestedWordAutomaton.isFinal((Object)iPredicate);
            this.mAlreadyConstructedAutomaton.addState(bl3, bl4, (Object)iPredicate);
        }
        this.mLogger.info((Object)this.startMessage());
    }

    @Override
    protected String startMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Constructing nondeterministic interpolant automaton ");
        stringBuilder.append(" with ");
        stringBuilder.append(this.mNonTrivialPredicates.size() + 2);
        stringBuilder.append(" interpolants.");
        return stringBuilder.toString();
    }

    @Override
    protected String switchToReadonlyMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Switched to read-only mode: nondeterministic interpolant automaton has ");
        stringBuilder.append(this.mAlreadyConstructedAutomaton.size()).append(" states. ");
        return stringBuilder.toString();
    }

    @Override
    protected String switchToOnDemandConstructionMessage() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Switched to On-DemandConstruction mode: nondeterministic interpolant automaton has ");
        stringBuilder.append(this.mAlreadyConstructedAutomaton.size()).append(" states. ");
        return stringBuilder.toString();
    }

    @Override
    protected void addOtherSuccessors(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper, Set<IPredicate> set) {
        if (this.mConservativeSuccessorCandidateSelection) {
            if (iPredicate2 == null) {
                var6_6 = Collections.singleton(iPredicate);
            } else {
                var6_6 = new HashSet<IPredicate>(2);
                var6_6.add(iPredicate);
                var6_6.add(iPredicate2);
            }
        } else {
            var6_6 = this.mNonTrivialPredicates;
        }
        for (IPredicate iPredicate3 : this.mNonTrivialPredicates) {
            IncrementalPlicationChecker.Validity validity;
            if (set.contains(iPredicate3) || (validity = successorComputationHelper.computeSuccWithSolver(iPredicate, iPredicate2, LETTER, iPredicate3)) != IncrementalPlicationChecker.Validity.VALID) continue;
            set.add(iPredicate3);
        }
        if (this.mSecondChance) {
            if (set.isEmpty()) {
                set.add(this.mIaTrueState);
            }
        } else {
            if (set.isEmpty() && LETTER instanceof ICallAction) {
                set.add(this.mIaTrueState);
            }
            this.addTargetStateTrueIfStateIsTrue(iPredicate, set);
        }
    }

    protected boolean isFalsePresent(Collection<IPredicate> collection) {
        return collection.contains(this.mIaFalseState);
    }

    protected void addTargetStateTrueIfStateIsTrue(IPredicate iPredicate, Set<IPredicate> set) {
        if (iPredicate == this.mIaTrueState) {
            set.add(this.mIaTrueState);
        }
    }

    @Override
    protected void addInputAutomatonSuccs(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper, Set<IPredicate> set) {
        Collection<IPredicate> collection = successorComputationHelper.getSuccsInterpolantAutomaton(iPredicate, iPredicate2, LETTER);
        this.copyAllButTrue(set, collection);
        Collection<IPredicate> collection2 = successorComputationHelper.getSuccsInterpolantAutomaton(this.mIaTrueState, iPredicate2, LETTER);
        this.copyAllButTrue(set, collection2);
        if (iPredicate2 != null) {
            Collection<IPredicate> collection3 = successorComputationHelper.getSuccsInterpolantAutomaton(iPredicate, this.mIaTrueState, LETTER);
            this.copyAllButTrue(set, collection3);
            Collection<IPredicate> collection4 = successorComputationHelper.getSuccsInterpolantAutomaton(this.mIaTrueState, this.mIaTrueState, LETTER);
            this.copyAllButTrue(set, collection4);
        }
    }

    protected void copyAllButTrue(Set<IPredicate> set, Collection<IPredicate> collection) {
        for (IPredicate iPredicate : collection) {
            if (iPredicate == this.mIaTrueState) continue;
            set.add(iPredicate);
        }
    }

    protected void addIfNontrivialPredicate(IPredicate iPredicate) {
        if (iPredicate != this.mIaTrueState && iPredicate != this.mIaFalseState) {
            this.mNonTrivialPredicates.add(iPredicate);
        }
    }

    @Override
    protected void constructSuccessorsAndTransitions(IPredicate iPredicate, IPredicate iPredicate2, LETTER LETTER, AbstractInterpolantAutomaton.SuccessorComputationHelper successorComputationHelper, ImmutableSet<IPredicate> immutableSet) {
        for (IPredicate iPredicate3 : immutableSet) {
            successorComputationHelper.addTransition(iPredicate, iPredicate2, LETTER, iPredicate3);
        }
        successorComputationHelper.reportSuccsComputed(iPredicate, iPredicate2, LETTER);
    }
}

