/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.strategy;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.QualifiedTracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.tracecheck.TraceCheckReasonUnknown;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IIpTcStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IIpgStrategyModule;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.IRefinementEngine;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.tracehandling.ITraceCheckStrategyModule;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.IIpAbStrategyModule;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.StrategyFactory;
import de.uni_freiburg.informatik.ultimate.plugins.generator.traceabstraction.tracehandling.TraceAbstractionRefinementEngine;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;

public class BasicRefinementStrategy<L extends IIcfgTransition<?>>
implements TraceAbstractionRefinementEngine.ITARefinementStrategy<L> {
    private static final int DEFAULT_INTERPOLANT_THRESHOLD = 2;
    private final ITraceCheckStrategyModule<L, ?>[] mTraceChecks;
    private final IIpgStrategyModule<?, L>[] mInterpolantGenerators;
    private final IIpAbStrategyModule<L> mInterpolantAutomatonBuilder;
    private int mCurrentIndexTraceCheck;
    private int mCurrentIndexInterpolantGenerator;
    private final TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist mBlacklist;
    private final IPredicateUnifier mDefaultPredicateUnifier;

    public BasicRefinementStrategy(StrategyFactory.StrategyModuleFactory strategyModuleFactory, ITraceCheckStrategyModule<L, ?>[] iTraceCheckStrategyModuleArray, IIpgStrategyModule<?, L>[] iIpgStrategyModuleArray, IIpAbStrategyModule<L> iIpAbStrategyModule, TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist refinementStrategyExceptionBlacklist) {
        this.mTraceChecks = Objects.requireNonNull(iTraceCheckStrategyModuleArray);
        this.mInterpolantGenerators = Objects.requireNonNull(iIpgStrategyModuleArray);
        this.mInterpolantAutomatonBuilder = Objects.requireNonNull(iIpAbStrategyModule);
        this.mBlacklist = Objects.requireNonNull(refinementStrategyExceptionBlacklist);
        this.mCurrentIndexTraceCheck = 0;
        this.mCurrentIndexInterpolantGenerator = 0;
        this.mDefaultPredicateUnifier = strategyModuleFactory.getDefaultPredicateUnifier();
    }

    public BasicRefinementStrategy(StrategyFactory.StrategyModuleFactory strategyModuleFactory, StrategyModules<L> strategyModules, TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist refinementStrategyExceptionBlacklist) {
        this(strategyModuleFactory, strategyModules.mTraceChecks, strategyModules.mInterpolantGenerators, strategyModules.mInterpolantAutomatonBuilder, refinementStrategyExceptionBlacklist);
    }

    public BasicRefinementStrategy(StrategyFactory.StrategyModuleFactory strategyModuleFactory, IIpTcStrategyModule<?, L>[] iIpTcStrategyModuleArray, IIpAbStrategyModule<L> iIpAbStrategyModule, TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist refinementStrategyExceptionBlacklist) {
        this(strategyModuleFactory, (ITraceCheckStrategyModule<L, ?>[])iIpTcStrategyModuleArray, (IIpgStrategyModule<?, L>[])iIpTcStrategyModuleArray, iIpAbStrategyModule, refinementStrategyExceptionBlacklist);
    }

    public String getName() {
        return this.getClass().getSimpleName();
    }

    public boolean hasNextFeasilibityCheck() {
        return this.mCurrentIndexTraceCheck < this.mTraceChecks.length;
    }

    public ITraceCheckStrategyModule<L, ?> nextFeasibilityCheck() {
        if (this.mCurrentIndexTraceCheck < this.mTraceChecks.length) {
            return this.mTraceChecks[this.mCurrentIndexTraceCheck++];
        }
        throw new NoSuchElementException();
    }

    public boolean hasNextInterpolantGenerator(List<QualifiedTracePredicates> list, List<QualifiedTracePredicates> list2) {
        if (this.needsMoreInterpolants(list, list2)) {
            return this.mCurrentIndexInterpolantGenerator < this.mInterpolantGenerators.length;
        }
        return false;
    }

    public IIpgStrategyModule<?, L> nextInterpolantGenerator() {
        if (this.mCurrentIndexInterpolantGenerator < this.mInterpolantGenerators.length) {
            return this.mInterpolantGenerators[this.mCurrentIndexInterpolantGenerator++];
        }
        throw new NoSuchElementException();
    }

    @Override
    public IIpAbStrategyModule<L> getInterpolantAutomatonBuilder() {
        return this.mInterpolantAutomatonBuilder;
    }

    public TraceCheckReasonUnknown.RefinementStrategyExceptionBlacklist getExceptionBlacklist() {
        return this.mBlacklist;
    }

    public IHoareTripleChecker getHoareTripleChecker(IRefinementEngine<L, ?> iRefinementEngine) {
        return null;
    }

    public IPredicateUnifier getPredicateUnifier(IRefinementEngine<L, ?> iRefinementEngine) {
        return this.mDefaultPredicateUnifier;
    }

    public List<QualifiedTracePredicates> mergeInterpolants(List<QualifiedTracePredicates> list, List<QualifiedTracePredicates> list2) {
        return DataStructureUtils.concat(list, list2);
    }

    protected boolean needsMoreInterpolants(List<QualifiedTracePredicates> list, List<QualifiedTracePredicates> list2) {
        if (!list.isEmpty()) {
            return false;
        }
        return list2.size() < 2;
    }

    protected ITraceCheckStrategyModule<L, ?>[] getTraceCheckModules() {
        return this.mTraceChecks;
    }

    protected IIpgStrategyModule<?, L>[] getInterpolantGeneratorModules() {
        return this.mInterpolantGenerators;
    }

    protected IIpAbStrategyModule<L> getInterpolantAutomatonBuilderModule() {
        return this.mInterpolantAutomatonBuilder;
    }

    public static final class StrategyModules<L extends IAction> {
        private final ITraceCheckStrategyModule<L, ?>[] mTraceChecks;
        private final IIpgStrategyModule<?, L>[] mInterpolantGenerators;
        private final IIpAbStrategyModule<L> mInterpolantAutomatonBuilder;

        public StrategyModules(ITraceCheckStrategyModule<L, ?>[] iTraceCheckStrategyModuleArray, IIpgStrategyModule<?, L>[] iIpgStrategyModuleArray, IIpAbStrategyModule<L> iIpAbStrategyModule) {
            this.mTraceChecks = iTraceCheckStrategyModuleArray;
            this.mInterpolantAutomatonBuilder = iIpAbStrategyModule;
            this.mInterpolantGenerators = iIpgStrategyModuleArray;
        }
    }
}

