/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.AffineTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.IPolynomialTerm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialTerm;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.NonRecursive;
import de.uni_freiburg.informatik.ultimate.logic.Rational;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.function.Predicate;

public class PolynomialTermTransformer
extends TermTransformer {
    private final Script mScript;
    private final Predicate<Term> mIsPolynomialVariable = term -> term instanceof TermVariable || term instanceof ApplicationTerm;

    public PolynomialTermTransformer(Script script) {
        this.mScript = script;
    }

    protected void convert(Term term) {
        if (!PolynomialTermTransformer.hasSupportedSort(term)) {
            this.inputIsNotPolynomial();
            return;
        }
        Rational rational = SmtUtils.tryToConvertToLiteral(term);
        if (rational != null) {
            AffineTerm affineTerm = AffineTerm.constructConstant(term.getSort(), rational);
            this.setResult(affineTerm);
            return;
        }
        MulDivModRewriter mulDivModRewriter = MulDivModRewriter.forTerm(term);
        if (mulDivModRewriter != null) {
            mulDivModRewriter.run(this);
            return;
        }
        if (PolynomialTermTransformer.isPolynomialFunction(term)) {
            super.convert(term);
            return;
        }
        if (this.mIsPolynomialVariable.test(term)) {
            AffineTerm affineTerm = AffineTerm.constructVariable(term);
            this.setResult(affineTerm);
            return;
        }
        this.inputIsNotPolynomial();
    }

    private void inputIsNotPolynomial() {
        this.setResult(new PolynomialTerm());
    }

    private static boolean hasSupportedSort(Term term) {
        return SmtSortUtils.isNumericSort(term.getSort()) || SmtSortUtils.isBitvecSort(term.getSort());
    }

    private static boolean isPolynomialFunction(Term term) {
        if (term instanceof ApplicationTerm) {
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            return PolynomialTermTransformer.isPolynomialFunctionSymbol(applicationTerm.getFunction().getName());
        }
        return false;
    }

    private static boolean isPolynomialFunctionSymbol(String string) {
        return string.equals("+") || string.equals("-") || string.equals("*") || string.equals("/") || string.equals("bvadd") || string.equals("bvsub") || string.equals("bvmul") || string.equals("div") || string.equals("mod");
    }

    public void convertApplicationTerm(ApplicationTerm applicationTerm, Term[] termArray) {
        assert (PolynomialTermTransformer.isPolynomialFunctionSymbol(applicationTerm.getFunction().getName())) : "We only descended for polynomial functions";
        IPolynomialTerm[] iPolynomialTermArray = PolynomialTermTransformer.castAndCheckForNonPolynomialArguments(termArray);
        if (iPolynomialTermArray == null) {
            this.inputIsNotPolynomial();
            return;
        }
        String string = applicationTerm.getFunction().getName();
        IPolynomialTerm iPolynomialTerm = this.convertArgumentsToFunction(iPolynomialTermArray, string);
        this.castAndSetResult(iPolynomialTerm);
    }

    private IPolynomialTerm convertArgumentsToFunction(IPolynomialTerm[] iPolynomialTermArray, String string) {
        switch (string) {
            case "*": {
                return PolynomialTermTransformer.multiply(iPolynomialTermArray);
            }
            case "bvmul": {
                return PolynomialTermTransformer.multiply(iPolynomialTermArray);
            }
            case "+": {
                return PolynomialTermTransformer.add(iPolynomialTermArray);
            }
            case "bvadd": {
                return PolynomialTermTransformer.add(iPolynomialTermArray);
            }
            case "-": {
                if (iPolynomialTermArray.length == 1) {
                    return PolynomialTermTransformer.negate(iPolynomialTermArray[0]);
                }
                return PolynomialTermTransformer.subtract(iPolynomialTermArray);
            }
            case "bvsub": {
                if (iPolynomialTermArray.length == 1) {
                    return PolynomialTermTransformer.negate(iPolynomialTermArray[0]);
                }
                return PolynomialTermTransformer.subtract(iPolynomialTermArray);
            }
            case "/": 
            case "div": {
                if (iPolynomialTermArray.length == 0) {
                    throw new AssertionError((Object)"Division needs at least one argument");
                }
                return iPolynomialTermArray[0].div(this.mScript, Arrays.copyOfRange(iPolynomialTermArray, 1, iPolynomialTermArray.length));
            }
            case "mod": {
                if (iPolynomialTermArray.length > 2) {
                    throw new AssertionError((Object)"Modulo needs exactly two arguments");
                }
                return iPolynomialTermArray[0].mod(this.mScript, iPolynomialTermArray[1]);
            }
        }
        throw new UnsupportedOperationException("unsupported symbol " + string);
    }

    private void castAndSetResult(IPolynomialTerm iPolynomialTerm) {
        if (iPolynomialTerm instanceof PolynomialTerm) {
            this.setResult((PolynomialTerm)iPolynomialTerm);
            return;
        }
        if (iPolynomialTerm instanceof AffineTerm) {
            this.setResult((AffineTerm)iPolynomialTerm);
            return;
        }
        throw new UnsupportedOperationException("This IPolynomialTerm is instance of no known class.");
    }

    private static IPolynomialTerm multiply(IPolynomialTerm[] iPolynomialTermArray) {
        IPolynomialTerm iPolynomialTerm = PolynomialTermTransformer.multiplyTwoPolynomials(iPolynomialTermArray[0], iPolynomialTermArray[1]);
        int n = 2;
        while (n < iPolynomialTermArray.length) {
            iPolynomialTerm = PolynomialTermTransformer.multiplyTwoPolynomials(iPolynomialTerm, iPolynomialTermArray[n]);
            ++n;
        }
        return iPolynomialTerm;
    }

    private static IPolynomialTerm multiplyTwoPolynomials(IPolynomialTerm iPolynomialTerm, IPolynomialTerm iPolynomialTerm2) {
        if (PolynomialTermTransformer.productWillBePolynomial(iPolynomialTerm, iPolynomialTerm2)) {
            return PolynomialTerm.mulPolynomials(iPolynomialTerm, iPolynomialTerm2);
        }
        return AffineTerm.mulAffineTerms(iPolynomialTerm, iPolynomialTerm2);
    }

    private static boolean productWillBePolynomial(IPolynomialTerm iPolynomialTerm, IPolynomialTerm iPolynomialTerm2) {
        return !iPolynomialTerm.isAffine() || !iPolynomialTerm2.isAffine() || !iPolynomialTerm.isConstant() && !iPolynomialTerm2.isConstant();
    }

    private static IPolynomialTerm add(IPolynomialTerm[] iPolynomialTermArray) {
        if (PolynomialTermTransformer.someTermIsPolynomial(iPolynomialTermArray)) {
            return PolynomialTerm.sum(iPolynomialTermArray);
        }
        return AffineTerm.sum(iPolynomialTermArray);
    }

    private static boolean someTermIsPolynomial(IPolynomialTerm[] iPolynomialTermArray) {
        IPolynomialTerm[] iPolynomialTermArray2 = iPolynomialTermArray;
        int n = iPolynomialTermArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPolynomialTerm iPolynomialTerm = iPolynomialTermArray2[n2];
            if (!iPolynomialTerm.isAffine()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private static IPolynomialTerm negate(IPolynomialTerm iPolynomialTerm) {
        if (iPolynomialTerm.isAffine()) {
            return AffineTerm.mul(iPolynomialTerm, Rational.MONE);
        }
        return PolynomialTerm.mul(iPolynomialTerm, Rational.MONE);
    }

    private static IPolynomialTerm subtract(IPolynomialTerm[] iPolynomialTermArray) {
        assert (iPolynomialTermArray.length > 1);
        IPolynomialTerm[] iPolynomialTermArray2 = new IPolynomialTerm[iPolynomialTermArray.length];
        iPolynomialTermArray2[0] = iPolynomialTermArray[0];
        int n = 1;
        while (n < iPolynomialTermArray2.length) {
            iPolynomialTermArray2[n] = PolynomialTermTransformer.negate(iPolynomialTermArray[n]);
            ++n;
        }
        return PolynomialTermTransformer.add(iPolynomialTermArray2);
    }

    private static IPolynomialTerm[] castAndCheckForNonPolynomialArguments(Term[] termArray) {
        IPolynomialTerm[] iPolynomialTermArray = new IPolynomialTerm[termArray.length];
        int n = 0;
        while (n < iPolynomialTermArray.length) {
            if (termArray[n] instanceof IPolynomialTerm) {
                iPolynomialTermArray[n] = (IPolynomialTerm)termArray[n];
                if (iPolynomialTermArray[n].isErrorTerm()) {
                    return null;
                }
            } else {
                throw new AssertionError();
            }
            ++n;
        }
        return iPolynomialTermArray;
    }

    public static IPolynomialTerm convert(Script script, Term term) {
        IPolynomialTerm iPolynomialTerm;
        if (!PolynomialTermTransformer.hasSupportedSort(term)) {
            iPolynomialTerm = null;
        } else {
            iPolynomialTerm = (IPolynomialTerm)new PolynomialTermTransformer(script).transform(term);
            if (iPolynomialTerm.isErrorTerm()) {
                throw new UnsupportedOperationException("Unknown conversion problem: " + String.valueOf(term));
            }
        }
        return iPolynomialTerm;
    }

    private static class MulDivModRewriter
    implements NonRecursive.Walker {
        private final Term mNumerator;
        private final Term mDivisorFactor;

        private MulDivModRewriter(Term term, Term term2) {
            this.mNumerator = term;
            this.mDivisorFactor = term2;
        }

        public void run(PolynomialTermTransformer polynomialTermTransformer) {
            polynomialTermTransformer.enqueueWalker(this);
            polynomialTermTransformer.pushTerm(this.mDivisorFactor);
            polynomialTermTransformer.pushTerm(this.mNumerator);
        }

        public void walk(NonRecursive nonRecursive) {
            PolynomialTermTransformer polynomialTermTransformer = (PolynomialTermTransformer)nonRecursive;
            Term[] termArray = new Term[]{this.mNumerator, this.mDivisorFactor};
            Term[] termArray2 = polynomialTermTransformer.getConverted(termArray);
            IPolynomialTerm[] iPolynomialTermArray = PolynomialTermTransformer.castAndCheckForNonPolynomialArguments(termArray2);
            if (iPolynomialTermArray == null) {
                polynomialTermTransformer.inputIsNotPolynomial();
                return;
            }
            IPolynomialTerm iPolynomialTerm = PolynomialTermTransformer.subtract(new IPolynomialTerm[]{iPolynomialTermArray[0], iPolynomialTermArray[0].mod(polynomialTermTransformer.mScript, iPolynomialTermArray[1])});
            polynomialTermTransformer.castAndSetResult(iPolynomialTerm);
        }

        public static MulDivModRewriter forTerm(Term term) {
            if (!(term instanceof ApplicationTerm)) {
                return null;
            }
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (!applicationTerm.getFunction().getName().equals("*") || applicationTerm.getParameters().length != 2) {
                return null;
            }
            Term[] termArray = applicationTerm.getParameters();
            MulDivModRewriter mulDivModRewriter = MulDivModRewriter.forTerms(termArray[0], termArray[1]);
            if (mulDivModRewriter == null) {
                return MulDivModRewriter.forTerms(termArray[1], termArray[0]);
            }
            return mulDivModRewriter;
        }

        private static MulDivModRewriter forTerms(Term term, Term term2) {
            if (!(term instanceof ApplicationTerm)) {
                return null;
            }
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            if (!applicationTerm.getFunction().getName().equals("div") || applicationTerm.getParameters().length != 2) {
                return null;
            }
            Term[] termArray = applicationTerm.getParameters();
            if (termArray[1].equals(term2)) {
                return new MulDivModRewriter(termArray[0], term2);
            }
            return null;
        }
    }
}

