/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.DisjunctiveAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ISummaryStorage;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.ITransitionProvider;
import de.uni_freiburg.informatik.ultimate.plugins.analysis.abstractinterpretationv2.algorithm.LoggingHelper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class SummaryMap<STATE extends IAbstractState<STATE>, ACTION, LOCATION>
implements ISummaryStorage<STATE, ACTION, LOCATION> {
    private final Map<String, Set<Summary>> mSummaries;
    private final ITransitionProvider<ACTION, LOCATION> mTransProvider;
    private final ILogger mLogger;

    SummaryMap(ITransitionProvider<ACTION, LOCATION> iTransitionProvider, ILogger iLogger) {
        this.mTransProvider = iTransitionProvider;
        this.mSummaries = new HashMap<String, Set<Summary>>();
        this.mLogger = iLogger;
    }

    @Override
    public DisjunctiveAbstractState<STATE> getSummaryPostState(ACTION ACTION, DisjunctiveAbstractState<STATE> disjunctiveAbstractState) {
        String string = this.mTransProvider.getProcedureName(ACTION);
        Set<Summary> set = this.getSummary(string);
        DisjunctiveAbstractState disjunctiveAbstractState2 = set.stream().filter(summary -> disjunctiveAbstractState.isSubsetOf(summary.getCallPostState()) != IAbstractState.SubsetResult.NONE).findAny().map(summary -> summary.getReturnPreState()).orElse(null);
        return disjunctiveAbstractState2;
    }

    void addSummary(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, ACTION ACTION) {
        Summary summary;
        String string = this.mTransProvider.getProcedureName(ACTION);
        Set<Summary> set = this.getSummary(string);
        if (set.isEmpty()) {
            summary = new Summary(disjunctiveAbstractState, disjunctiveAbstractState2);
            this.logCurrentSummaries("Adding first summary", ACTION, summary);
        } else {
            summary = this.updateSummaries(set, disjunctiveAbstractState, disjunctiveAbstractState2, ACTION);
        }
        set.add(summary);
    }

    private Summary updateSummaries(Set<Summary> set, DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2, ACTION ACTION) {
        Iterator<Summary> iterator = set.iterator();
        while (iterator.hasNext()) {
            Summary summary = iterator.next();
            DisjunctiveAbstractState disjunctiveAbstractState3 = summary.getCallPostState();
            DisjunctiveAbstractState disjunctiveAbstractState4 = summary.getReturnPreState();
            if (disjunctiveAbstractState.isSubsetOf(disjunctiveAbstractState3) == IAbstractState.SubsetResult.NONE) continue;
            DisjunctiveAbstractState disjunctiveAbstractState5 = disjunctiveAbstractState3.union(disjunctiveAbstractState);
            DisjunctiveAbstractState disjunctiveAbstractState6 = disjunctiveAbstractState4.union(disjunctiveAbstractState2);
            iterator.remove();
            Summary summary2 = new Summary(disjunctiveAbstractState5, disjunctiveAbstractState6);
            this.logCurrentSummaries("Del summary", ACTION, summary);
            this.logCurrentSummaries("Add summary", ACTION, summary2);
            return summary2;
        }
        Summary summary = new Summary(disjunctiveAbstractState, disjunctiveAbstractState2);
        this.logCurrentSummaries("Add summary", ACTION, summary);
        return summary;
    }

    private void logCurrentSummaries(String string, ACTION ACTION, Summary summary) {
        if (!this.mLogger.isDebugEnabled()) {
            return;
        }
        assert (summary != null);
        this.mLogger.debug((Object)("       " + string + " " + String.valueOf(LoggingHelper.getHashCodeString(ACTION)) + ": PreCall " + String.valueOf(LoggingHelper.getStateString(summary.getCallPostState())) + " PreReturn " + String.valueOf(LoggingHelper.getStateString(summary.getReturnPreState()))));
    }

    private Set<Summary> getSummary(String string) {
        Set<Summary> set = this.mSummaries.get(string);
        if (set == null) {
            HashSet<Summary> hashSet = new HashSet<Summary>();
            this.mSummaries.put(string, hashSet);
            return hashSet;
        }
        return set;
    }

    public String toString() {
        return this.mSummaries.toString();
    }

    private final class Summary {
        private final DisjunctiveAbstractState<STATE> mCallPostState;
        private final DisjunctiveAbstractState<STATE> mReturnPreState;

        private Summary(DisjunctiveAbstractState<STATE> disjunctiveAbstractState, DisjunctiveAbstractState<STATE> disjunctiveAbstractState2) {
            this.mCallPostState = disjunctiveAbstractState;
            this.mReturnPreState = disjunctiveAbstractState2;
        }

        DisjunctiveAbstractState<STATE> getReturnPreState() {
            return this.mReturnPreState;
        }

        DisjunctiveAbstractState<STATE> getCallPostState() {
            return this.mCallPostState;
        }

        public String toString() {
            return "{CallPost: " + String.valueOf(LoggingHelper.getStateString(this.mCallPostState)) + " ReturnPre: " + String.valueOf(LoggingHelper.getStateString(this.mReturnPreState)) + "}";
        }

        public int hashCode() {
            return Objects.hash(this.mReturnPreState, this.mCallPostState);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            Summary summary = (Summary)object;
            if (this.mReturnPreState == null ? summary.mReturnPreState != null : !this.mReturnPreState.equals(summary.mReturnPreState)) {
                return false;
            }
            return !(this.mCallPostState == null ? summary.mCallPostState != null : !this.mCallPostState.equals(summary.mCallPostState));
        }
    }
}

