/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.automata.partialorder.independence;

import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.DefaultIndependenceCache;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.ISymbolicIndependenceRelation;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceResultAggregator;
import de.uni_freiburg.informatik.ultimate.automata.partialorder.independence.IndependenceStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;

public class CachedIndependenceRelation<S, L>
implements IIndependenceRelation<S, L> {
    private final IIndependenceRelation<S, L> mUnderlying;
    private final IIndependenceCache<S, L> mCache;
    private final CachedIndependenceStatisticsProvider mStatistics;

    public CachedIndependenceRelation(IIndependenceRelation<S, L> iIndependenceRelation) {
        this(iIndependenceRelation, new DefaultIndependenceCache());
    }

    public CachedIndependenceRelation(IIndependenceRelation<S, L> iIndependenceRelation, IIndependenceCache<S, L> iIndependenceCache) {
        this.mUnderlying = iIndependenceRelation;
        this.mCache = iIndependenceCache;
        this.mStatistics = new CachedIndependenceStatisticsProvider();
    }

    public IIndependenceCache<S, L> getCache() {
        return this.mCache;
    }

    @Override
    public boolean isSymmetric() {
        return this.mUnderlying.isSymmetric();
    }

    @Override
    public boolean isConditional() {
        return this.mUnderlying.isConditional();
    }

    @Override
    public IIndependenceRelation.Dependence isIndependent(S s, L l, L l2) {
        IIndependenceRelation.Dependence dependence;
        Object object = this.isConditional() ? s : null;
        IIndependenceRelation.Dependence dependence2 = this.mCache.contains(object, l, l2);
        if (dependence2 != null) {
            this.mStatistics.reportCachedQuery(dependence2, object != null);
            return dependence2;
        }
        if (this.isSymmetric() && (dependence = this.mCache.contains(object, l2, l)) != null) {
            this.mStatistics.reportCachedQuery(dependence, object != null);
            return dependence;
        }
        dependence = this.mUnderlying.isIndependent(object, l, l2);
        this.mCache.cacheResult(object, l, l2, dependence);
        this.mStatistics.reportUncachedQuery(dependence, object != null);
        return dependence;
    }

    @Override
    public ISymbolicIndependenceRelation<L, S> getSymbolicRelation() {
        ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation = this.mUnderlying.getSymbolicRelation();
        if (iSymbolicIndependenceRelation == null) {
            return null;
        }
        return new CachingSymbolicIndependence(iSymbolicIndependenceRelation);
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mStatistics;
    }

    public void removeFromCache(L l) {
        this.mCache.remove(l);
    }

    private final class CachedIndependenceStatisticsProvider
    extends IndependenceStatisticsDataProvider {
        public static final String CACHE_QUERIES = "Cache Queries";
        public static final String CACHE_STATISTICS = "Statistics on independence cache";
        private final IndependenceResultAggregator.Counter mCacheQueries;

        private CachedIndependenceStatisticsProvider() {
            super(CachedIndependenceRelation.class, CachedIndependenceRelation.this.mUnderlying);
            this.mCacheQueries = new IndependenceResultAggregator.Counter();
            this.declareCounter(CACHE_QUERIES, () -> this.mCacheQueries);
            this.forward(CACHE_STATISTICS, CachedIndependenceRelation.this.mCache::getStatistics);
        }

        private void reportCachedQuery(IIndependenceRelation.Dependence dependence, boolean bl) {
            this.reportQuery(dependence, bl);
            this.mCacheQueries.increment(dependence, bl);
        }

        private void reportUncachedQuery(IIndependenceRelation.Dependence dependence, boolean bl) {
            this.reportQuery(dependence, bl);
            this.mCacheQueries.increment(IIndependenceRelation.Dependence.UNKNOWN, bl);
        }
    }

    private final class CachingSymbolicIndependence
    implements ISymbolicIndependenceRelation<L, S> {
        private final ISymbolicIndependenceRelation<L, S> mUnderlyingSymbolic;

        public CachingSymbolicIndependence(ISymbolicIndependenceRelation<L, S> iSymbolicIndependenceRelation) {
            this.mUnderlyingSymbolic = iSymbolicIndependenceRelation;
        }

        @Override
        public S getCommutativityCondition(S s, L l, L l2) {
            Object s2 = this.mUnderlyingSymbolic.getCommutativityCondition(s, l, l2);
            if (s2 != null) {
                assert (CachedIndependenceRelation.this.mUnderlying.isIndependent(s2, l, l2) == IIndependenceRelation.Dependence.INDEPENDENT) : "Generated condition does not guarantee independence";
                CachedIndependenceRelation.this.mCache.cacheResult(s2, l, l2, IIndependenceRelation.Dependence.INDEPENDENT);
            }
            return s2;
        }

        @Override
        public boolean isSymmetric() {
            return this.mUnderlyingSymbolic.isSymmetric();
        }

        @Override
        public boolean isConditional() {
            return this.mUnderlyingSymbolic.isConditional();
        }
    }

    public static interface IIndependenceCache<S, L> {
        public IIndependenceRelation.Dependence contains(S var1, L var2, L var3);

        public void remove(L var1);

        public void cacheResult(S var1, L var2, L var3, IIndependenceRelation.Dependence var4);

        public void mergeIndependencies(L var1, L var2, L var3);

        default public IStatisticsDataProvider getStatistics() {
            return new AbstractStatisticsDataProvider(){};
        }
    }
}

