/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr;

import de.uni_freiburg.informatik.ultimate.core.lib.results.StatisticsResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IIcfgTransformer;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.ILocationFactory;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.IcfgTransformationBacktranslator;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.TransformedIcfgBuilder;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPR;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRBenchmark;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRCore;
import de.uni_freiburg.informatik.ultimate.icfgtransformer.loopacceleration.fastupr.FastUPRDetection;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.util.csv.ICsvProviderProvider;
import java.util.AbstractCollection;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class FastUPRTransformer<INLOC extends IcfgLocation, OUTLOC extends IcfgLocation>
implements IIcfgTransformer<OUTLOC> {
    private final ILogger mLogger;
    private final IIcfg<OUTLOC> mResultIcfg;
    private final ManagedScript mManagedScript;
    private final IcfgTransformationBacktranslator mBacktranslationTracker;
    private final ILocationFactory<INLOC, OUTLOC> mLocationFactory;
    private final IUltimateServiceProvider mServices;
    private final FastUPRReplacementMethod mReplacementMethod;
    private int mLoopFailures = 0;
    private int mLoops = 0;
    private final FastUPRBenchmark mBenchmark = new FastUPRBenchmark();

    public FastUPRTransformer(ILogger iLogger, IIcfg<INLOC> iIcfg, Class<OUTLOC> clazz, ILocationFactory<INLOC, OUTLOC> iLocationFactory, String string, IcfgTransformationBacktranslator icfgTransformationBacktranslator, IUltimateServiceProvider iUltimateServiceProvider, FastUPRReplacementMethod fastUPRReplacementMethod) {
        IIcfg<INLOC> iIcfg2 = Objects.requireNonNull(iIcfg);
        this.mReplacementMethod = fastUPRReplacementMethod;
        this.mLogger = Objects.requireNonNull(iLogger);
        this.mLocationFactory = Objects.requireNonNull(iLocationFactory);
        this.mManagedScript = iIcfg2.getCfgSmtToolkit().getManagedScript();
        this.mBacktranslationTracker = icfgTransformationBacktranslator;
        this.mServices = iUltimateServiceProvider;
        this.mLogger.debug((Object)"Starting fastUPR Transformation");
        this.mResultIcfg = this.transform(iIcfg2, Objects.requireNonNull(string), Objects.requireNonNull(clazz));
        this.mLogger.debug((Object)this.mBenchmark.toString());
        this.mServices.getResultService().reportResult(FastUPR.PLUGIN_ID, (IResult)new StatisticsResult("FastUPR-LoopAcceleration", "FastUPR Benchmark Results:", (ICsvProviderProvider)this.mBenchmark));
    }

    private IIcfg<OUTLOC> transform(IIcfg<INLOC> iIcfg, String string, Class<OUTLOC> clazz) {
        this.mLogger.debug((Object)"Getting List of loop paths ...");
        FastUPRDetection<INLOC> fastUPRDetection = new FastUPRDetection<INLOC>(this.mLogger, iIcfg);
        List<Deque<IcfgEdge>> list = fastUPRDetection.getLoopEdgePaths();
        if (list.isEmpty()) {
            this.mLogger.debug((Object)"No loop paths found");
        } else {
            this.mLogger.debug((Object)("Found " + list.size() + " loop paths"));
            this.mLoops = list.size();
        }
        BasicIcfg basicIcfg = new BasicIcfg(string, iIcfg.getCfgSmtToolkit(), clazz);
        TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder = new TransformedIcfgBuilder<INLOC, OUTLOC>(this.mLogger, this.mLocationFactory, this.mBacktranslationTracker, iIcfg, basicIcfg);
        this.mLogger.debug((Object)"Transforming loops into icfg...");
        this.getLoopIcfg(list, basicIcfg, iIcfg, transformedIcfgBuilder);
        this.mLogger.debug((Object)"Icfg created.");
        return basicIcfg;
    }

    private void getLoopIcfg(List<Deque<IcfgEdge>> list, BasicIcfg<OUTLOC> basicIcfg, IIcfg<INLOC> iIcfg, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder) {
        IcfgEdge icfgEdge;
        IcfgLocation icfgLocation;
        IcfgEdge icfgEdge2;
        IcfgEdge icfgEdge3;
        IcfgLocation icfgLocation2;
        AbstractCollection abstractCollection;
        Object object;
        HashMap<IcfgEdge, LoopEdgeElement> hashMap = new HashMap<IcfgEdge, LoopEdgeElement>();
        for (Deque<IcfgEdge> collection2 : list) {
            Object exception;
            if (collection2 == null || collection2.isEmpty()) continue;
            object = collection2.getFirst();
            this.mBenchmark.startRun((IcfgLocation)object.getSource());
            abstractCollection = new ArrayList();
            icfgLocation2 = null;
            icfgEdge3 = null;
            icfgEdge2 = null;
            icfgLocation = null;
            icfgEdge = null;
            try {
                while (!collection2.isEmpty()) {
                    exception = collection2.getFirst();
                    if (exception.equals(object) && exception.getTransformula().getFormula().toString().equals("true") && ((IcfgLocation)exception.getSource()).getOutgoingEdges().size() == 2) {
                        icfgEdge2 = exception;
                        icfgLocation = ((IcfgLocation)exception.getSource()).getOutgoingEdges().get(0) == exception ? (IcfgEdge)((IcfgLocation)exception.getSource()).getOutgoingEdges().get(1) : (IcfgEdge)((IcfgLocation)exception.getSource()).getOutgoingEdges().get(0);
                        collection2.pop();
                        continue;
                    }
                    if (((IcfgLocation)exception.getSource()).getOutgoingEdges().size() == 2 && ((IcfgEdge)((IcfgLocation)exception.getSource()).getIncomingEdges().get(0)).equals(icfgEdge2)) {
                        icfgEdge = FastUPRTransformer.findLoopExit(exception, (IcfgEdge)icfgLocation);
                        abstractCollection.add(exception.getTransformula());
                        collection2.pop();
                        continue;
                    }
                    if (!exception.equals(object) && ((IcfgLocation)exception.getSource()).getOutgoingEdges().size() > 1) {
                        throw new IllegalArgumentException("Cannot compute nondeterministic paths.");
                    }
                    abstractCollection.add(exception.getTransformula());
                    collection2.pop();
                }
                exception = TransFormulaUtils.sequentialComposition((ILogger)this.mLogger, (IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (boolean)true, (boolean)false, (boolean)false, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (List)((Object)abstractCollection));
                FastUPRCore fastUPRCore = new FastUPRCore((UnmodifiableTransFormula)exception, this.mManagedScript, this.mLogger, this.mServices);
                if (this.mReplacementMethod == FastUPRReplacementMethod.REPLACE_LOOP_EDGE) {
                    icfgLocation2 = fastUPRCore.getResult();
                } else if (this.mReplacementMethod == FastUPRReplacementMethod.REPLACE_EXIT_EDGE) {
                    icfgLocation2 = fastUPRCore.getExitEdgeResult(this.getExitEdgeFormula((IcfgEdge)object));
                }
                if (icfgLocation2 == null) {
                    throw new IllegalArgumentException("FastUPR couldn't compute a loop acceleration.");
                }
                this.mLogger.debug((Object)("Result Formula:" + icfgLocation2.toString()));
                this.mBenchmark.endRun(true);
            }
            catch (Exception exception2) {
                this.mLogger.error((Object)"", (Throwable)exception2);
                object = null;
                ++this.mLoopFailures;
                this.mBenchmark.endRun(false);
            }
            if (object == null) continue;
            hashMap.put((IcfgEdge)object, new LoopEdgeElement(icfgEdge2, (IcfgEdge)object, icfgEdge, (UnmodifiableTransFormula)icfgLocation2, icfgEdge3));
            exception = icfgLocation2.getFormula().toStringDirect();
            this.mLogger.debug((Object)("resultFormula: " + (String)exception));
        }
        this.mLogger.debug((Object)("FastUPR found a total of " + list.size() + " loops and computed accelerated formulas for " + (this.mLoops - this.mLoopFailures) + " loops."));
        Set set = iIcfg.getInitialNodes();
        ArrayDeque arrayDeque = new ArrayDeque(set);
        object = new HashSet();
        this.mLogger.debug((Object)"Starting main transformation loop...");
        abstractCollection = new ArrayDeque();
        while (!arrayDeque.isEmpty()) {
            icfgLocation2 = (IcfgLocation)arrayDeque.removeFirst();
            if (!object.add(icfgLocation2)) continue;
            icfgEdge3 = transformedIcfgBuilder.createNewLocation(icfgLocation2);
            if (this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_LOOP_EDGE)) {
                this.createNewLocations((INLOC)icfgLocation2, (OUTLOC)icfgEdge3, (Set<INLOC>)object, arrayDeque, basicIcfg, transformedIcfgBuilder, (Map<IcfgEdge, LoopEdgeElement>)hashMap, (Deque<IcfgEdge>)((Object)abstractCollection));
                continue;
            }
            if (!this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_EXIT_EDGE)) continue;
            this.createNewLocationsWithReplaceExit((INLOC)icfgLocation2, (OUTLOC)icfgEdge3, (Set<INLOC>)object, basicIcfg, transformedIcfgBuilder, (Map<IcfgEdge, LoopEdgeElement>)hashMap, (Deque<IcfgEdge>)((Object)abstractCollection));
        }
        while (!abstractCollection.isEmpty()) {
            icfgLocation2 = (IcfgEdge)abstractCollection.pop();
            if (icfgLocation2 instanceof IIcfgReturnTransition && !transformedIcfgBuilder.isCorrespondingCallContained((IIcfgReturnTransition)icfgLocation2)) {
                abstractCollection.add(icfgLocation2);
                continue;
            }
            icfgEdge3 = (IcfgLocation)icfgLocation2.getSource();
            icfgEdge2 = transformedIcfgBuilder.createNewLocation((IcfgLocation)icfgEdge3);
            icfgLocation = (IcfgLocation)icfgLocation2.getTarget();
            icfgEdge = transformedIcfgBuilder.createNewLocation(icfgLocation);
            transformedIcfgBuilder.createNewTransition(icfgEdge2, icfgEdge, (IcfgEdge)icfgLocation2);
            if (!object.add(icfgLocation)) continue;
            if (this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_LOOP_EDGE)) {
                this.createNewLocations((INLOC)icfgEdge3, (OUTLOC)icfgEdge2, (Set<INLOC>)object, arrayDeque, basicIcfg, transformedIcfgBuilder, (Map<IcfgEdge, LoopEdgeElement>)hashMap, (Deque<IcfgEdge>)((Object)abstractCollection));
                continue;
            }
            if (!this.mReplacementMethod.equals((Object)FastUPRReplacementMethod.REPLACE_EXIT_EDGE)) continue;
            this.createNewLocationsWithReplaceExit((INLOC)icfgEdge3, (OUTLOC)icfgEdge2, (Set<INLOC>)object, basicIcfg, transformedIcfgBuilder, (Map<IcfgEdge, LoopEdgeElement>)hashMap, (Deque<IcfgEdge>)((Object)abstractCollection));
        }
    }

    private void createNewLocationsUntransformed(INLOC INLOC, OUTLOC OUTLOC, Set<INLOC> set, Deque<INLOC> deque, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder, Deque<IcfgEdge> deque2) {
        for (IcfgEdge icfgEdge : INLOC.getOutgoingEdges()) {
            IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getTarget();
            deque.add(icfgLocation);
            OUTLOC OUTLOC2 = transformedIcfgBuilder.createNewLocation(icfgLocation);
            if (icfgEdge instanceof IIcfgReturnTransition) {
                deque2.add(icfgEdge);
                continue;
            }
            transformedIcfgBuilder.createNewTransition(OUTLOC, OUTLOC2, icfgEdge);
        }
    }

    private static IcfgEdge findLoopExit(IcfgEdge icfgEdge, IcfgEdge icfgEdge2) {
        for (IcfgEdge icfgEdge3 : ((IcfgLocation)icfgEdge.getSource()).getOutgoingEdges()) {
            if (!((IcfgLocation)icfgEdge3.getTarget()).equals((Object)icfgEdge2.getTarget())) continue;
            return icfgEdge3;
        }
        throw new IllegalArgumentException("No exit edge found.");
    }

    private static IcfgEdge getExitEdge(IcfgEdge icfgEdge) {
        IcfgLocation icfgLocation = (IcfgLocation)icfgEdge.getSource();
        if (icfgLocation.getOutgoingEdges().size() != 2) {
            throw new IllegalArgumentException("Exit Edge Merging can only be done if the loop head has two outgoing edges.");
        }
        for (IcfgEdge icfgEdge2 : icfgLocation.getOutgoingEdges()) {
            if (icfgEdge2.equals(icfgEdge)) continue;
            return icfgEdge2;
        }
        throw new IllegalArgumentException("Loop Edge exists twice.");
    }

    private UnmodifiableTransFormula getExitEdgeFormula(IcfgEdge icfgEdge) {
        return FastUPRTransformer.getExitEdge(icfgEdge).getTransformula();
    }

    private void createNewLocations(INLOC INLOC, OUTLOC OUTLOC, Set<INLOC> set, Deque<INLOC> deque, BasicIcfg<OUTLOC> basicIcfg, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder, Map<IcfgEdge, LoopEdgeElement> map, Deque<IcfgEdge> deque2) {
        for (IcfgEdge icfgEdge : INLOC.getOutgoingEdges()) {
            Object object;
            Object object2;
            if (icfgEdge instanceof IIcfgReturnTransition && !transformedIcfgBuilder.isCorrespondingCallContained((IIcfgReturnTransition)icfgEdge)) {
                deque2.add(icfgEdge);
                continue;
            }
            if (map.containsKey(icfgEdge)) {
                object2 = map.get(icfgEdge);
                if (((LoopEdgeElement)object2).getEntryEdge() != null && ((LoopEdgeElement)object2).getExitEdge() != null) {
                    object = transformedIcfgBuilder.createNewInternalTransition(OUTLOC, OUTLOC, map.get(icfgEdge).getFormula(), false);
                    OUTLOC.addOutgoing(object);
                    OUTLOC.addIncoming(object);
                    IcfgLocation icfgLocation = (IcfgLocation)((LoopEdgeElement)object2).getExitEdge().getTarget();
                    OUTLOC OUTLOC2 = transformedIcfgBuilder.createNewLocation(icfgLocation);
                    IcfgEdge icfgEdge2 = transformedIcfgBuilder.createNewTransition(OUTLOC, OUTLOC2, ((LoopEdgeElement)object2).getExitEdge());
                    this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)icfgEdge2, (IIcfgTransition<IcfgLocation>)((LoopEdgeElement)object2).getExitEdge());
                    deque.add(icfgLocation);
                    continue;
                }
                object = transformedIcfgBuilder.createNewInternalTransition(OUTLOC, OUTLOC, map.get(icfgEdge).getFormula(), false);
                this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)object, (IIcfgTransition<IcfgLocation>)icfgEdge);
                continue;
            }
            object2 = (IcfgLocation)icfgEdge.getTarget();
            object = transformedIcfgBuilder.createNewLocation((IcfgLocation)object2);
            transformedIcfgBuilder.createNewTransition(OUTLOC, object, icfgEdge);
            deque.add(object2);
        }
    }

    private void createNewLocationsWithReplaceExit(INLOC INLOC, OUTLOC OUTLOC, Set<INLOC> set, BasicIcfg<OUTLOC> basicIcfg, TransformedIcfgBuilder<INLOC, OUTLOC> transformedIcfgBuilder, Map<IcfgEdge, LoopEdgeElement> map, Deque<IcfgEdge> deque) {
        Object object;
        IcfgEdge icfgEdge;
        for (IcfgEdge icfgEdge2 : map.keySet()) {
            if (!((IcfgLocation)icfgEdge2.getSource()).equals(INLOC)) continue;
            icfgEdge = FastUPRTransformer.getExitEdge(icfgEdge2);
            object = (IcfgLocation)icfgEdge.getTarget();
            OUTLOC OUTLOC2 = transformedIcfgBuilder.createNewLocation((IcfgEdge)object);
            IcfgInternalTransition icfgInternalTransition = transformedIcfgBuilder.createNewInternalTransition((IcfgLocation)OUTLOC, (IcfgLocation)OUTLOC2, map.get(icfgEdge2).getFormula(), false);
            this.mBacktranslationTracker.mapEdges((IIcfgTransition<IcfgLocation>)icfgEdge2, (IIcfgTransition<IcfgLocation>)icfgInternalTransition);
        }
        for (IcfgEdge icfgEdge2 : INLOC.getOutgoingEdges()) {
            if (icfgEdge2 instanceof IIcfgReturnTransition && !transformedIcfgBuilder.isCorrespondingCallContained((IIcfgReturnTransition)icfgEdge2)) {
                deque.add(icfgEdge2);
                continue;
            }
            if (map.containsKey(icfgEdge2)) continue;
            icfgEdge = (IcfgLocation)icfgEdge2.getTarget();
            object = transformedIcfgBuilder.createNewLocation(icfgEdge);
            transformedIcfgBuilder.createNewTransition((IcfgLocation)OUTLOC, (IcfgLocation)object, icfgEdge2);
            if (!set.add(icfgEdge)) continue;
            this.createNewLocationsWithReplaceExit(icfgEdge, object, set, basicIcfg, transformedIcfgBuilder, map, deque);
        }
    }

    @Override
    public IIcfg<OUTLOC> getResult() {
        return this.mResultIcfg;
    }

    public int getSuccessfulAccelerations() {
        return this.mLoops - this.mLoopFailures;
    }

    public int getTotalLoopsFound() {
        return this.mLoops;
    }

    public static enum FastUPRReplacementMethod {
        REPLACE_LOOP_EDGE,
        REPLACE_EXIT_EDGE;

    }

    private static class LoopEdgeElement {
        public final IcfgEdge mEntryEdge;
        public final IcfgEdge mLoopEdge;
        public final IcfgEdge mExitEdge;
        public final UnmodifiableTransFormula mResultFormula;
        public final IcfgEdge mAssertionExit;

        public LoopEdgeElement(IcfgEdge icfgEdge, IcfgEdge icfgEdge2, IcfgEdge icfgEdge3, UnmodifiableTransFormula unmodifiableTransFormula, IcfgEdge icfgEdge4) {
            this.mEntryEdge = icfgEdge;
            this.mLoopEdge = icfgEdge2;
            this.mExitEdge = icfgEdge3;
            this.mResultFormula = unmodifiableTransFormula;
            this.mAssertionExit = icfgEdge4;
        }

        public IcfgEdge getEntryEdge() {
            return this.mEntryEdge;
        }

        public IcfgEdge getLoopEdge() {
            return this.mLoopEdge;
        }

        public UnmodifiableTransFormula getFormula() {
            return this.mResultFormula;
        }

        public IcfgEdge getAssertionExt() {
            return this.mAssertionExit;
        }

        public IcfgEdge getExitEdge() {
            return this.mExitEdge;
        }
    }
}

