/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.boogie.ast;

import de.uni_freiburg.informatik.ultimate.boogie.ast.BoogieASTNode;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Expression;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstTransformer;
import de.uni_freiburg.informatik.ultimate.boogie.ast.GeneratedBoogieAstVisitor;
import de.uni_freiburg.informatik.ultimate.boogie.ast.NamedAttribute;
import de.uni_freiburg.informatik.ultimate.boogie.ast.Statement;
import de.uni_freiburg.informatik.ultimate.boogie.ast.VariableLHS;
import de.uni_freiburg.informatik.ultimate.core.model.models.ILocation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;

public final class CallStatement
extends Statement {
    private static final long serialVersionUID = 1L;
    private static final Predicate<BoogieASTNode> VALIDATOR = BoogieASTNode.VALIDATORS.get(CallStatement.class);
    NamedAttribute[] attributes;
    boolean isForall;
    VariableLHS[] lhs;
    String methodName;
    Expression[] arguments;

    public CallStatement(ILocation iLocation, boolean bl, VariableLHS[] variableLHSArray, String string, Expression[] expressionArray) {
        super(iLocation);
        this.isForall = bl;
        this.lhs = variableLHSArray;
        this.methodName = string;
        this.arguments = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid CallStatement: " + String.valueOf((Object)this);
    }

    public CallStatement(ILocation iLocation, NamedAttribute[] namedAttributeArray, boolean bl, VariableLHS[] variableLHSArray, String string, Expression[] expressionArray) {
        super(iLocation);
        this.attributes = namedAttributeArray;
        this.isForall = bl;
        this.lhs = variableLHSArray;
        this.methodName = string;
        this.arguments = expressionArray;
        assert (VALIDATOR == null || VALIDATOR.test(this)) : "Invalid CallStatement: " + String.valueOf((Object)this);
    }

    @Override
    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("CallStatement").append('[');
        if (this.attributes == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.attributes.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.attributes[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append(this.isForall);
        stringBuffer.append(',');
        if (this.lhs == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.lhs.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.lhs[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        stringBuffer.append(',').append(this.methodName);
        stringBuffer.append(',');
        if (this.arguments == null) {
            stringBuffer.append("null");
        } else {
            stringBuffer.append('[');
            n = 0;
            while (n < this.arguments.length) {
                if (n > 0) {
                    stringBuffer.append(',');
                }
                stringBuffer.append((Object)this.arguments[n]);
                ++n;
            }
            stringBuffer.append(']');
        }
        return stringBuffer.append(']').toString();
    }

    public NamedAttribute[] getAttributes() {
        return this.attributes;
    }

    public boolean isForall() {
        return this.isForall;
    }

    public VariableLHS[] getLhs() {
        return this.lhs;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public Expression[] getArguments() {
        return this.arguments;
    }

    @Override
    public List<BoogieASTNode> getOutgoingNodes() {
        List<BoogieASTNode> list = super.getOutgoingNodes();
        if (this.attributes != null) {
            list.addAll(Arrays.asList(this.attributes));
        }
        if (this.lhs != null) {
            list.addAll(Arrays.asList(this.lhs));
        }
        if (this.arguments != null) {
            list.addAll(Arrays.asList(this.arguments));
        }
        return list;
    }

    @Override
    public void accept(GeneratedBoogieAstVisitor generatedBoogieAstVisitor) {
        if (!generatedBoogieAstVisitor.visit((Statement)this)) {
            return;
        }
        if (generatedBoogieAstVisitor.visit(this)) {
            BoogieASTNode boogieASTNode;
            int n;
            int n2;
            BoogieASTNode[] boogieASTNodeArray;
            if (this.attributes != null) {
                boogieASTNodeArray = this.attributes;
                n2 = this.attributes.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((NamedAttribute)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.lhs != null) {
                boogieASTNodeArray = this.lhs;
                n2 = this.lhs.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((VariableLHS)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
            if (this.arguments != null) {
                boogieASTNodeArray = this.arguments;
                n2 = this.arguments.length;
                n = 0;
                while (n < n2) {
                    boogieASTNode = boogieASTNodeArray[n];
                    ((Expression)boogieASTNode).accept(generatedBoogieAstVisitor);
                    ++n;
                }
            }
        }
    }

    @Override
    public Statement accept(GeneratedBoogieAstTransformer generatedBoogieAstTransformer) {
        Object object;
        Object object2;
        Object object3;
        int n;
        Statement statement = generatedBoogieAstTransformer.transform(this);
        if (statement != this) {
            return statement;
        }
        boolean bl = false;
        ArrayList<VariableLHS[]> arrayList = new ArrayList<VariableLHS[]>();
        if (this.attributes != null) {
            NamedAttribute[] namedAttributeArray = this.attributes;
            n = this.attributes.length;
            int n2 = 0;
            while (n2 < n) {
                object3 = namedAttributeArray[n2];
                object2 = (NamedAttribute)((NamedAttribute)((Object)object3)).accept(generatedBoogieAstTransformer);
                bl = bl || object2 != object3;
                arrayList.add((VariableLHS[])object2);
                ++n2;
            }
        }
        object3 = new ArrayList();
        if (this.lhs != null) {
            object2 = this.lhs;
            int n3 = this.lhs.length;
            n = 0;
            while (n < n3) {
                VariableLHS variableLHS = object2[n];
                object = (VariableLHS)variableLHS.accept(generatedBoogieAstTransformer);
                bl = bl || object != variableLHS;
                ((ArrayList)object3).add(object);
                ++n;
            }
        }
        ArrayList<Expression> arrayList2 = new ArrayList<Expression>();
        if (this.arguments != null) {
            object = this.arguments;
            int n4 = this.arguments.length;
            int n5 = 0;
            while (n5 < n4) {
                Expression expression = object[n5];
                Expression expression2 = expression.accept(generatedBoogieAstTransformer);
                bl = bl || expression2 != expression;
                arrayList2.add(expression2);
                ++n5;
            }
        }
        if (bl) {
            return new CallStatement(this.loc, arrayList.toArray(new NamedAttribute[0]), this.isForall, ((ArrayList)object3).toArray(new VariableLHS[0]), this.methodName, arrayList2.toArray(new Expression[0]));
        }
        return this;
    }
}

