/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.util.statistics;

import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class StatisticsAggregator
extends AbstractStatisticsDataProvider {
    private final Map<String, KeyType> mKeyTypes;
    private final Map<String, Object> mValues;
    private final Set<String> mKnownTypes = new HashSet<String>();

    public StatisticsAggregator() {
        this.mValues = new LinkedHashMap<String, Object>();
        this.mKeyTypes = new HashMap<String, KeyType>();
    }

    public void aggregateBenchmarkData(IStatisticsDataProvider iStatisticsDataProvider) {
        this.aggregateBenchmarkData("", iStatisticsDataProvider);
    }

    public void aggregateBenchmarkData(String string2, IStatisticsDataProvider iStatisticsDataProvider) {
        if (iStatisticsDataProvider instanceof StatisticsAggregator) {
            Object object;
            StatisticsAggregator statisticsAggregator = (StatisticsAggregator)iStatisticsDataProvider;
            this.mKnownTypes.addAll(statisticsAggregator.mKnownTypes);
            for (Map.Entry<String, KeyType> entry : statisticsAggregator.mKeyTypes.entrySet()) {
                object = this.mKeyTypes.put(entry.getKey(), entry.getValue());
                if (object != null && object != entry.getValue()) {
                    throw new UnsupportedOperationException("Conflicting keytypes");
                }
                if (object != null) continue;
                this.declare(entry.getKey(), () -> this.mValues.get(entry.getKey()), entry.getValue());
            }
            for (Map.Entry<String, Object> entry : statisticsAggregator.mValues.entrySet()) {
                object = entry.getKey();
                KeyType keyType = this.mKeyTypes.get(entry.getKey());
                Object object2 = this.mValues.computeIfAbsent((String)object, string -> keyType.createEmpty());
                this.mValues.put((String)object, keyType.aggregate(object2, entry.getValue()));
            }
            return;
        }
        List<Field> list = ReflectionUtil.instanceFields(iStatisticsDataProvider).stream().filter(field -> field.getAnnotation(Statistics.class) != null).collect(Collectors.toList());
        String string3 = string2 + String.valueOf(iStatisticsDataProvider.getClass());
        if (this.mKnownTypes.add(string3)) {
            this.declareTypes(string2, list);
        }
        for (Field field2 : list) {
            Statistics statistics = field2.getAnnotation(Statistics.class);
            String string4 = this.getKey(string2, field2);
            KeyType keyType = statistics.type();
            Object object = ReflectionUtil.access(iStatisticsDataProvider, field2);
            Object object3 = keyType.aggregate(this.mValues.get(string4), keyType.convert(object));
            this.mValues.put(string4, object3);
        }
    }

    private void declareTypes(String string, List<Field> list) {
        for (Field field : list) {
            KeyType keyType;
            Statistics statistics = field.getAnnotation(Statistics.class);
            String string2 = this.getKey(string, field);
            KeyType keyType2 = this.mKeyTypes.put(string2, keyType = statistics.type());
            if (keyType2 != null && keyType2 != keyType) {
                throw new UnsupportedOperationException("Conflicting keytypes");
            }
            this.declare(string2, () -> this.mValues.get(string2), keyType);
            this.mValues.put(string2, keyType.createEmpty());
        }
    }

    private String getKey(String string, Field field) {
        if (string == null || string == "") {
            return ReflectionUtil.fieldPrettyName(field);
        }
        return string + "+" + ReflectionUtil.fieldPrettyName(field);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface Statistics {
        public KeyType type();
    }
}

