/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.core.coreplugin.services;

import de.uni_freiburg.informatik.ultimate.core.coreplugin.services.ProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.IServiceFactory;
import de.uni_freiburg.informatik.ultimate.core.model.IToolchainProgressMonitor;
import de.uni_freiburg.informatik.ultimate.core.model.preferences.IPreferenceProvider;
import de.uni_freiburg.informatik.ultimate.core.model.services.IBacktranslationService;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILoggingService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressAwareTimer;
import de.uni_freiburg.informatik.ultimate.core.model.services.IProgressMonitorService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IResultService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IService;
import de.uni_freiburg.informatik.ultimate.core.model.services.IStorable;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainCancel;
import de.uni_freiburg.informatik.ultimate.core.model.services.IToolchainStorage;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;

public class ProgressMonitorService
implements IStorable,
IProgressMonitorService,
IProgressAwareTimer {
    private static final String STORAGE_KEY = "CancelNotificationService";
    private final IToolchainProgressMonitor mMonitor;
    private final ILogger mLogger;
    private final IToolchainCancel mToolchainCancel;
    private IProgressAwareTimer mTimer;
    private boolean mCancelRequest;

    public ProgressMonitorService(IToolchainProgressMonitor iToolchainProgressMonitor, ILogger iLogger, IToolchainCancel iToolchainCancel) {
        this.mMonitor = Objects.requireNonNull(iToolchainProgressMonitor, "monitor may not be null");
        this.mLogger = Objects.requireNonNull(iLogger, "logger may not be null");
        this.mToolchainCancel = Objects.requireNonNull(iToolchainCancel, "cancel may not be null");
        this.mCancelRequest = false;
    }

    public boolean continueProcessing() {
        boolean bl;
        boolean bl2 = bl = this.mMonitor.isCanceled() || this.mCancelRequest || this.isTimeout();
        if (bl && this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)"Do not continue processing!");
        }
        return !bl;
    }

    private boolean isTimeout() {
        return this.mTimer != null && !this.mTimer.continueProcessing();
    }

    public void setSubtask(String string) {
        this.mMonitor.subTask(string);
    }

    public void setDeadline(long l) {
        if (System.currentTimeMillis() >= l) {
            this.mLogger.warn((Object)String.format("Deadline was set to a date in the past, effectively stopping the toolchain. Is this what you intended? Value of date was %,d", l));
            l = -1L;
        }
        if (this.mTimer != null) {
            this.mLogger.warn((Object)"Replacing all timers with new deadline!");
        }
        this.mTimer = ProgressAwareTimer.createWithDeadline(null, l);
    }

    static ProgressMonitorService getService(IToolchainStorage iToolchainStorage) {
        assert (iToolchainStorage != null);
        return (ProgressMonitorService)iToolchainStorage.getStorable(STORAGE_KEY);
    }

    public static String getServiceKey() {
        return STORAGE_KEY;
    }

    public void destroy() {
        this.mMonitor.done();
    }

    public CountDownLatch cancelToolchain() {
        this.mCancelRequest = true;
        return this.mToolchainCancel.cancelToolchain();
    }

    public IProgressAwareTimer getTimer(long l) {
        return ProgressAwareTimer.createWithTimeout(null, l);
    }

    public IProgressAwareTimer getChildTimer(long l) {
        return ProgressAwareTimer.createWithTimeout(this, l);
    }

    public IProgressAwareTimer getChildTimer(double d) {
        return ProgressAwareTimer.createWithPercentage(this, d);
    }

    public long getDeadline() {
        if (this.mTimer == null) {
            return -1L;
        }
        return this.mTimer.getDeadline();
    }

    public IProgressAwareTimer getParent() {
        if (this.mTimer == null) {
            return null;
        }
        return this.mTimer.getParent();
    }

    public IUltimateServiceProvider registerChildTimer(IUltimateServiceProvider iUltimateServiceProvider, IProgressAwareTimer iProgressAwareTimer) {
        return ProgressMonitorService.registerChildTimer(this, iUltimateServiceProvider, iProgressAwareTimer);
    }

    public long remainingTime() {
        if (this.mTimer == null) {
            return -1L;
        }
        return this.mTimer.remainingTime();
    }

    private static IUltimateServiceProvider registerChildTimer(IProgressMonitorService iProgressMonitorService, IUltimateServiceProvider iUltimateServiceProvider, IProgressAwareTimer iProgressAwareTimer) {
        if (iProgressAwareTimer == null) {
            throw new IllegalArgumentException("Cannot add null timer");
        }
        if (iUltimateServiceProvider == null) {
            throw new IllegalArgumentException("services is null");
        }
        return new UltimateServiceProviderLayer(iUltimateServiceProvider, new ProgressMonitorLayer(iProgressMonitorService, iProgressAwareTimer));
    }

    private static final class ProgressMonitorLayer
    implements IProgressMonitorService {
        private final IProgressMonitorService mParent;
        private final IProgressAwareTimer mTimer;

        public ProgressMonitorLayer(IProgressMonitorService iProgressMonitorService, IProgressAwareTimer iProgressAwareTimer) {
            this.mParent = Objects.requireNonNull(iProgressMonitorService);
            this.mTimer = Objects.requireNonNull(iProgressAwareTimer);
        }

        public CountDownLatch cancelToolchain() {
            return this.mParent.cancelToolchain();
        }

        public long remainingTime() {
            return this.mTimer.remainingTime();
        }

        public IProgressAwareTimer getTimer(long l) {
            return ProgressAwareTimer.createWithTimeout(null, l);
        }

        public IProgressAwareTimer getChildTimer(long l) {
            return ProgressAwareTimer.createWithTimeout((IProgressAwareTimer)this, l);
        }

        public IProgressAwareTimer getChildTimer(double d) {
            return ProgressAwareTimer.createWithPercentage((IProgressAwareTimer)this, d);
        }

        public IProgressAwareTimer getParent() {
            return this.mTimer.getParent();
        }

        public long getDeadline() {
            return this.mTimer.getDeadline();
        }

        public boolean continueProcessing() {
            return this.mParent.continueProcessing() && this.mTimer.continueProcessing();
        }

        public void setSubtask(String string) {
            this.mParent.setSubtask(string);
        }

        public void setDeadline(long l) {
            this.mParent.setDeadline(l);
        }

        public IUltimateServiceProvider registerChildTimer(IUltimateServiceProvider iUltimateServiceProvider, IProgressAwareTimer iProgressAwareTimer) {
            return ProgressMonitorService.registerChildTimer(this, iUltimateServiceProvider, iProgressAwareTimer);
        }
    }

    private static final class UltimateServiceProviderLayer
    implements IUltimateServiceProvider {
        private final IUltimateServiceProvider mParent;
        private final IProgressMonitorService mProgressMonitorService;

        public UltimateServiceProviderLayer(IUltimateServiceProvider iUltimateServiceProvider, IProgressMonitorService iProgressMonitorService) {
            this.mParent = Objects.requireNonNull(iUltimateServiceProvider);
            this.mProgressMonitorService = Objects.requireNonNull(iProgressMonitorService);
        }

        public IUltimateServiceProvider registerPreferenceLayer(Class<?> clazz, String ... stringArray) {
            IUltimateServiceProvider iUltimateServiceProvider = this.mParent.registerPreferenceLayer(clazz, stringArray);
            return new UltimateServiceProviderLayer(iUltimateServiceProvider, this.mProgressMonitorService);
        }

        public IUltimateServiceProvider registerDefaultPreferenceLayer(Class<?> clazz, String ... stringArray) {
            IUltimateServiceProvider iUltimateServiceProvider = this.mParent.registerDefaultPreferenceLayer(clazz, stringArray);
            return new UltimateServiceProviderLayer(iUltimateServiceProvider, this.mProgressMonitorService);
        }

        public IToolchainStorage getStorage() {
            return this.mParent.getStorage();
        }

        public <T extends IService, K extends IServiceFactory<T>> T getServiceInstance(Class<K> clazz) {
            return (T)this.mParent.getServiceInstance(clazz);
        }

        public IResultService getResultService() {
            return this.mParent.getResultService();
        }

        public IProgressMonitorService getProgressMonitorService() {
            return this.mProgressMonitorService;
        }

        public IPreferenceProvider getPreferenceProvider(String string) {
            return this.mParent.getPreferenceProvider(string);
        }

        public ILoggingService getLoggingService() {
            return this.mParent.getLoggingService();
        }

        public IBacktranslationService getBacktranslationService() {
            return this.mParent.getBacktranslationService();
        }
    }
}

